/*
 * Decompiled with CFR 0.152.
 */
package com.zuxelus.gt6orehelper.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.zuxelus.gt6orehelper.nei.OreHelper;
import gregapi.code.ItemStackContainer;
import gregapi.data.CS;
import gregapi.util.ST;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class OreHandler
extends TemplateRecipeHandler {
    public int recipiesPerPage() {
        return 1;
    }

    public String getRecipeName() {
        return I18n.func_135052_a((String)"gt6orehelper.nei.worldgen.name", (Object[])new Object[0]);
    }

    public String getGuiTexture() {
        return null;
    }

    public void loadCraftingRecipes(ItemStack result) {
        String unlocalizedName = result.func_77977_a();
        if (unlocalizedName.startsWith("oredict.ore") || unlocalizedName.startsWith("oredict.oreSmall")) {
            short meta = (short)result.func_77960_j();
            for (OreHelper.OreBedrockWrapper oreBedrockWrapper : OreHelper.mapOreBedrockWrapper.values()) {
                if (meta != oreBedrockWrapper.material.mID) continue;
                this.arecipes.add(new CachedOreRecipe(oreBedrockWrapper.name + oreBedrockWrapper.material.mNameInternal, ST.make((Block)((Block)CS.BlocksGT.oreBedrock), (long)1L, (long)oreBedrockWrapper.material.mID), ST.make((Block)oreBedrockWrapper.flower, (long)1L, (long)oreBedrockWrapper.flowerMeta), 0, 0));
            }
            for (OreHelper.OreSmallWrapper oreSmallWrapper : OreHelper.mapOreSmallWrapper.values()) {
                if (meta != oreSmallWrapper.material.mID) continue;
                this.arecipes.add(new CachedOreRecipe(oreSmallWrapper.name, ST.make((Block)((Block)CS.BlocksGT.oreSmall), (long)1L, (long)oreSmallWrapper.material.mID), 1));
            }
            for (OreHelper.OreLargeWrapper oreLargeWrapper : OreHelper.mapOreLargeWrapper.values()) {
                if (meta != oreLargeWrapper.material.mID && meta != oreLargeWrapper.mBottom.mID && meta != oreLargeWrapper.mBetween.mID && meta != oreLargeWrapper.mSpread.mID) continue;
                this.arecipes.add(new CachedOreRecipe(oreLargeWrapper.name, ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.material.mID), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.mBottom.mID), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.mBetween.mID), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.mSpread.mID), 2));
            }
            for (OreHelper.OreLayerWrapper oreLayerWrapper : OreHelper.mapOreLayerWrapper) {
                if (meta != oreLayerWrapper.material.mID) continue;
                this.arecipes.add(new CachedOreRecipe(oreLayerWrapper.name, ST.make((Block)oreLayerWrapper.stone, (long)1L, (long)0L), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(oreLayerWrapper.stone, 1L, 0L))), (long)1L, (long)oreLayerWrapper.material.mID), 3, oreLayerWrapper.number));
            }
            for (OreHelper.Ore2LayerWrapper ore2LayerWrapper : OreHelper.mapOre2LayerWrapper) {
                if (meta != ore2LayerWrapper.material.mID) continue;
                this.arecipes.add(new CachedOreRecipe(ore2LayerWrapper.name, ST.make((Block)ore2LayerWrapper.stone, (long)1L, (long)0L), ST.make((Block)ore2LayerWrapper.stone2, (long)1L, (long)0L), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(ore2LayerWrapper.stone, 1L, 0L))), (long)1L, (long)ore2LayerWrapper.material.mID), 4, ore2LayerWrapper.number));
            }
        } else if (unlocalizedName.startsWith("gt.stone.") && unlocalizedName.endsWith(".0")) {
            for (OreHelper.OreLayerWrapper oreLayerWrapper : OreHelper.mapOreLayerWrapper) {
                if (result.func_77973_b() != Item.func_150898_a((Block)oreLayerWrapper.stone)) continue;
                this.arecipes.add(new CachedOreRecipe(oreLayerWrapper.name, ST.make((Block)oreLayerWrapper.stone, (long)1L, (long)0L), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(oreLayerWrapper.stone, 1L, 0L))), (long)1L, (long)oreLayerWrapper.material.mID), 3, oreLayerWrapper.number));
            }
            for (OreHelper.Ore2LayerWrapper ore2LayerWrapper : OreHelper.mapOre2LayerWrapper) {
                if (result.func_77973_b() != Item.func_150898_a((Block)ore2LayerWrapper.stone) && result.func_77973_b() != Item.func_150898_a((Block)ore2LayerWrapper.stone2)) continue;
                this.arecipes.add(new CachedOreRecipe(ore2LayerWrapper.name, ST.make((Block)ore2LayerWrapper.stone, (long)1L, (long)0L), ST.make((Block)ore2LayerWrapper.stone2, (long)1L, (long)0L), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(ore2LayerWrapper.stone, 1L, 0L))), (long)1L, (long)ore2LayerWrapper.material.mID), 4, ore2LayerWrapper.number));
            }
        } else if (unlocalizedName.equals("tile.bedrock")) {
            for (OreHelper.OreBedrockWrapper oreBedrockWrapper : OreHelper.mapOreBedrockWrapper.values()) {
                this.arecipes.add(new CachedOreRecipe(oreBedrockWrapper.name + oreBedrockWrapper.material.mNameInternal, ST.make((Block)((Block)CS.BlocksGT.oreBedrock), (long)1L, (long)oreBedrockWrapper.material.mID), ST.make((Block)oreBedrockWrapper.flower, (long)1L, (long)oreBedrockWrapper.flowerMeta), 0, 0));
            }
        } else if (unlocalizedName.equals("tile.hellrock")) {
            this.AddDimRecipes(-1);
        } else if (unlocalizedName.equals("tile.whiteStone")) {
            this.AddDimRecipes(1);
        } else if (unlocalizedName.equals("gt.block.sands.0")) {
            OreHelper.BlockWrapper worldgen = OreHelper.mapBlockWrapper.get("river.magnetite");
            this.arecipes.add(new CachedOreRecipe(worldgen.name, worldgen.block, 5));
        } else if (unlocalizedName.equals("gt.block.diggable.2")) {
            OreHelper.BlockWrapper worldgen = OreHelper.mapBlockWrapper.get("swamp.turf");
            this.arecipes.add(new CachedOreRecipe(worldgen.name, worldgen.block, 5));
        } else if (unlocalizedName.startsWith("gt.block.flower")) {
            short meta = (short)result.func_77960_j();
            for (OreHelper.OreBedrockWrapper oreBedrockWrapper : OreHelper.mapOreBedrockWrapper.values()) {
                if (oreBedrockWrapper.flower == null || meta != oreBedrockWrapper.flowerMeta || !unlocalizedName.startsWith(oreBedrockWrapper.flower.func_149739_a())) continue;
                this.arecipes.add(new CachedOreRecipe(oreBedrockWrapper.name + oreBedrockWrapper.material.mNameInternal, ST.make((Block)((Block)CS.BlocksGT.oreBedrock), (long)1L, (long)oreBedrockWrapper.material.mID), ST.make((Block)oreBedrockWrapper.flower, (long)1L, (long)oreBedrockWrapper.flowerMeta), 0, 0));
            }
        } else {
            super.loadCraftingRecipes(result);
        }
    }

    private void AddDimRecipes(int dim) {
        for (OreHelper.OreSmallWrapper oreSmallWrapper : OreHelper.mapOreSmallWrapper.values()) {
            if (oreSmallWrapper.getWorlds().indexOf(OreHelper.getWorldNameTranslated(dim)) <= -1) continue;
            this.arecipes.add(new CachedOreRecipe(oreSmallWrapper.name, ST.make((Block)((Block)CS.BlocksGT.oreSmall), (long)1L, (long)oreSmallWrapper.material.mID), 1));
        }
        for (OreHelper.OreLargeWrapper oreLargeWrapper : OreHelper.mapOreLargeWrapper.values()) {
            if (oreLargeWrapper.getWorlds().indexOf(OreHelper.getWorldNameTranslated(dim)) <= -1) continue;
            this.arecipes.add(new CachedOreRecipe(oreLargeWrapper.name, ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.material.mID), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.mBottom.mID), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.mBetween.mID), ST.make((Block)((Block)CS.BlocksGT.stoneToNormalOres.get(new ItemStackContainer(Blocks.field_150348_b, 1L, 0L))), (long)1L, (long)oreLargeWrapper.mSpread.mID), 2));
        }
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)11, (int)166, (int)65);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        this.drawExtras(recipe);
    }

    public void drawExtras(int recipe) {
        CachedOreRecipe crecipe = (CachedOreRecipe)((Object)this.arecipes.get(recipe));
        if (crecipe.type == 0) {
            this.drawBedrockExtras(OreHelper.mapOreBedrockWrapper.get(crecipe.name));
        } else if (crecipe.type == 1) {
            this.drawSmallExtras(OreHelper.mapOreSmallWrapper.get(crecipe.name));
        } else if (crecipe.type == 2) {
            this.drawLargeExtras(OreHelper.mapOreLargeWrapper.get(crecipe.name));
        } else if (crecipe.type == 3) {
            this.drawOreLayerExtras(OreHelper.mapOreLayerWrapper.get(crecipe.number));
        } else if (crecipe.type == 4) {
            this.drawOre2LayerExtras(OreHelper.mapOre2LayerWrapper.get(crecipe.number));
        } else if (crecipe.type == 5) {
            this.drawBlockExtras(OreHelper.mapBlockWrapper.get(crecipe.name));
        }
    }

    private void drawBedrockExtras(OreHelper.OreBedrockWrapper oreLayer) {
        GuiDraw.drawString((String)I18n.func_135052_a((String)"gt6orehelper.nei.bedrockOre", (Object[])new Object[0]), (int)2, (int)22, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.oreName", (Object[])new Object[0]) + ": " + oreLayer.materialName), (int)2, (int)44, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.height", (Object[])new Object[0]) + ": 0-6"), (int)2, (int)56, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.probability", (Object[])new Object[0]) + ": 1/" + oreLayer.probability), (int)2, (int)68, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.worlds", (Object[])new Object[0]) + ": "), (int)2, (int)92, (int)0x404040, (boolean)false);
        String worlds = oreLayer.getWorlds();
        if (!this.drawWorldList(worlds, 30)) {
            GuiDraw.drawString((String)oreLayer.getWorlds(), (int)4, (int)104, (int)0x404040, (boolean)false);
        }
    }

    private void drawSmallExtras(OreHelper.OreSmallWrapper oreLayer) {
        GuiDraw.drawString((String)I18n.func_135052_a((String)"gt6orehelper.nei.smallOre", (Object[])new Object[0]), (int)2, (int)22, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.oreName", (Object[])new Object[0]) + ": " + oreLayer.materialName), (int)2, (int)44, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.height", (Object[])new Object[0]) + ": " + oreLayer.worldGenHeightRange), (int)2, (int)56, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.amount", (Object[])new Object[0]) + ": " + oreLayer.amountPerChunk), (int)2, (int)68, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.worlds", (Object[])new Object[0]) + ": "), (int)2, (int)92, (int)0x404040, (boolean)false);
        String worlds = oreLayer.getWorlds();
        if (!this.drawWorldList(worlds, 30)) {
            GuiDraw.drawString((String)worlds, (int)4, (int)104, (int)0x404040, (boolean)false);
        }
    }

    private void drawLargeExtras(OreHelper.OreLargeWrapper oreLayer) {
        int index;
        GuiDraw.drawString((String)I18n.func_135052_a((String)"gt6orehelper.nei.largeOre", (Object[])new Object[0]), (int)2, (int)22, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.height", (Object[])new Object[0]) + ": " + oreLayer.worldGenHeightRange), (int)2, (int)44, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.top", (Object[])new Object[0]) + ": " + oreLayer.materialName), (int)2, (int)56, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.bottom", (Object[])new Object[0]) + ": " + oreLayer.mBottom.getLocal()), (int)2, (int)68, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.between", (Object[])new Object[0]) + ": " + oreLayer.mBetween.getLocal()), (int)2, (int)80, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.spread", (Object[])new Object[0]) + ": " + oreLayer.mSpread.getLocal()), (int)2, (int)92, (int)0x404040, (boolean)false);
        String worlds = oreLayer.getWorlds();
        if (worlds.length() > 32 && (index = worlds.indexOf(",", 20)) > -1) {
            GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.worlds", (Object[])new Object[0]) + ": " + worlds.substring(0, index + 1)), (int)2, (int)104, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)worlds.substring(index + 2), (int)4, (int)116, (int)0x404040, (boolean)false);
            return;
        }
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.worlds", (Object[])new Object[0]) + ": "), (int)2, (int)104, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)worlds, (int)4, (int)116, (int)0x404040, (boolean)false);
    }

    private void drawOreLayerExtras(OreHelper.OreLayerWrapper oreLayer) {
        GuiDraw.drawString((String)I18n.func_135052_a((String)"gt6orehelper.nei.oreLayer", (Object[])new Object[0]), (int)2, (int)22, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.stone", (Object[])new Object[0]) + ": " + oreLayer.stoneMaterialName), (int)2, (int)44, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.oreName", (Object[])new Object[0]) + ": " + oreLayer.materialName), (int)2, (int)56, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.height", (Object[])new Object[0]) + ": " + oreLayer.worldGenHeightRange), (int)2, (int)68, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.chance", (Object[])new Object[0]) + ": 1/" + oreLayer.chance), (int)2, (int)80, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.biomes", (Object[])new Object[0]) + ": "), (int)2, (int)92, (int)0x404040, (boolean)false);
        String worlds = oreLayer.getWorlds();
        if (!this.drawWorldList(worlds, 40)) {
            GuiDraw.drawString((String)worlds, (int)4, (int)104, (int)0x404040, (boolean)false);
        }
    }

    private void drawOre2LayerExtras(OreHelper.Ore2LayerWrapper oreLayer) {
        GuiDraw.drawString((String)I18n.func_135052_a((String)"gt6orehelper.nei.oreLayerBetween", (Object[])new Object[0]), (int)2, (int)22, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.stoneTop", (Object[])new Object[0]) + ": " + oreLayer.stoneMaterialName), (int)2, (int)44, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.stoneBottom", (Object[])new Object[0]) + ": " + oreLayer.stone2MaterialName), (int)2, (int)56, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.oreName", (Object[])new Object[0]) + ": " + oreLayer.materialName), (int)2, (int)68, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.height", (Object[])new Object[0]) + ": " + oreLayer.worldGenHeightRange), (int)2, (int)80, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.chance", (Object[])new Object[0]) + ": 1/" + oreLayer.chance), (int)2, (int)92, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.biomes", (Object[])new Object[0]) + ": "), (int)2, (int)104, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)oreLayer.getWorlds(), (int)4, (int)116, (int)0x404040, (boolean)false);
    }

    private void drawBlockExtras(OreHelper.BlockWrapper oreLayer) {
        GuiDraw.drawString((String)oreLayer.block.func_82833_r(), (int)2, (int)22, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.height", (Object[])new Object[0]) + ": "), (int)2, (int)44, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)oreLayer.worldGenHeightRange, (int)2, (int)56, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.biomes", (Object[])new Object[0]) + ": "), (int)2, (int)68, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)oreLayer.biomes, (int)4, (int)80, (int)0x404040, (boolean)false);
        GuiDraw.drawString((String)(I18n.func_135052_a((String)"gt6orehelper.nei.worlds", (Object[])new Object[0]) + ": "), (int)2, (int)92, (int)0x404040, (boolean)false);
        String worlds = oreLayer.getWorlds();
        if (!this.drawWorldList(worlds, 30)) {
            GuiDraw.drawString((String)worlds, (int)4, (int)104, (int)0x404040, (boolean)false);
        }
    }

    private boolean drawWorldList(String worlds, int length) {
        int index;
        if (worlds.length() > length + 2 && (index = worlds.indexOf(",", length)) > -1) {
            GuiDraw.drawString((String)worlds.substring(0, index + 1), (int)4, (int)104, (int)0x404040, (boolean)false);
            GuiDraw.drawString((String)worlds.substring(index + 2), (int)4, (int)116, (int)0x404040, (boolean)false);
            return true;
        }
        return false;
    }

    public class CachedOreRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public String name;
        public int number;
        public int type;

        public ArrayList<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return null;
        }

        public CachedOreRecipe(String name, ItemStack ore, int type) {
            super((TemplateRecipeHandler)OreHandler.this);
            this.name = name;
            this.type = type;
            this.input = new ArrayList();
            this.input.add(new PositionedStack((Object)ore, 2, 1));
        }

        public CachedOreRecipe(String name, ItemStack ore, ItemStack flower, int type, int num) {
            this(name, ore, type);
            this.number = num;
            if (flower != null) {
                this.input.add(new PositionedStack((Object)flower, 24, 1));
            }
        }

        public CachedOreRecipe(String name, ItemStack ore, ItemStack top, ItemStack bottom, int type, int num) {
            this(name, ore, top, type, num);
            this.input.add(new PositionedStack((Object)bottom, 46, 1));
        }

        public CachedOreRecipe(String name, ItemStack top, ItemStack bottom, ItemStack between, ItemStack spread, int type) {
            this(name, top, type);
            this.input.add(new PositionedStack((Object)bottom, 24, 1));
            this.input.add(new PositionedStack((Object)between, 46, 1));
            this.input.add(new PositionedStack((Object)spread, 68, 1));
        }
    }
}

