/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.worldgen.WorldgenPit;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenTurf
extends WorldgenObject {
    @SafeVarargs
    public WorldgenTurf(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aRandom.nextInt(32) > 0 || this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return false;
        }
        boolean temp = true;
        for (String tName : aBiomeNames) {
            if (!CS.BIOMES_SWAMP.contains(tName)) continue;
            temp = false;
            break;
        }
        if (temp) {
            return false;
        }
        int tX = aMinX - 16;
        int tZ = aMinZ - 16;
        int tUpperBound = WD.waterLevel(aWorld) + 1;
        int tLowerBound = WD.waterLevel(aWorld) - 12;
        for (int i = 0; i < 48; ++i) {
            block2: for (int j = 0; j < 48; ++j) {
                if (!WorldgenPit.SHAPE[i][j]) continue;
                Block tBlock = CS.NB;
                Block tLastBlock = aWorld.func_147439_a(tX + i, 64, tZ + j);
                int tGenerated = 0;
                for (int tY = tUpperBound; tY > tLowerBound && tGenerated < 2; --tY) {
                    block9: {
                        block12: {
                            block11: {
                                block10: {
                                    block8: {
                                        tBlock = aWorld.func_147439_a(tX + i, tY, tZ + j);
                                        if (tBlock != CS.BlocksGT.Diggables || 2 != aWorld.func_72805_g(tX + i, tY, tZ + j)) break block8;
                                        ++tGenerated;
                                        break block9;
                                    }
                                    if (tBlock.func_149662_c()) break block10;
                                    if (tGenerated > 0) {
                                        continue block2;
                                    }
                                    break block9;
                                }
                                if (tBlock != Blocks.field_150346_d) break block11;
                                if (tGenerated > 0 || tLastBlock.func_149688_o() != Material.field_151575_d && tLastBlock.func_149688_o() != Material.field_151572_C) break block12;
                                break block9;
                            }
                            if (tGenerated > 0) {
                                if (tBlock.func_149688_o() != Material.field_151576_e) continue block2;
                            }
                            break block9;
                        }
                        aWorld.func_147465_d(tX + i, tY, tZ + j, (Block)CS.BlocksGT.Diggables, 2, 3);
                        ++tGenerated;
                    }
                    tLastBlock = tBlock;
                }
            }
        }
        return temp;
    }
}

