/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase11AttachmentSmall;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityCrank
extends TileEntityBase11AttachmentSmall
implements ITileEntityEnergy {
    public boolean mActive = false;
    public static IIconContainer sTextureFront = new Textures.BlockIcons.CustomIcon("machines/tools/crank/colored/front");
    public static IIconContainer sTextureFrontSpin = new Textures.BlockIcons.CustomIcon("machines/tools/crank/colored/frontspin");
    public static IIconContainer sOverlayFront = new Textures.BlockIcons.CustomIcon("machines/tools/crank/overlay/front");
    public static IIconContainer sOverlayFrontSpin = new Textures.BlockIcons.CustomIcon("machines/tools/crank/overlay/frontspin");
    private ITexture mTextureFront;
    private ITexture mTextureBacks;
    private ITexture mTextureSides;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.active")) {
            this.mActive = aNBT.func_74767_n("gt.active");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mActive);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact"));
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            boolean oActive = this.mActive;
            this.mActive = false;
            if (oActive) {
                for (EntityPlayer tPlayer : UT.Entities.getPlayersWithLastTarget(this)) {
                    this.mActive = true;
                    if (ITileEntityEnergy.Util.emitEnergyToSide(TD.Energy.RU, this.mFacing, -UT.Code.divup(8L * (long)UT.Entities.pot2Strength(tPlayer), UT.Entities.pot1Weakness(tPlayer)), UT.Entities.pot1Haste(tPlayer), this) > 0L) {
                        UT.Entities.exhaust(tPlayer, 0.025);
                    }
                    tPlayer.func_71038_i();
                }
            }
            if (!this.mActive) {
                ArrayListNoNulls tList = new ArrayListNoNulls();
                this.field_145850_b.func_72938_d(this.field_145851_c, this.field_145849_e).func_76618_a(EntityVillager.class, this.box(), tList, null);
                for (EntityVillager tVillager : tList) {
                    if (UT.Code.roundDown(tVillager.field_70163_u + (double)tVillager.func_70047_e()) != this.field_145848_d || UT.Code.roundDown(tVillager.field_70165_t) != this.field_145851_c || UT.Code.roundDown(tVillager.field_70161_v) != this.field_145849_e) continue;
                    this.mActive = true;
                    ITileEntityEnergy.Util.emitEnergyToSide(TD.Energy.RU, this.mFacing, -UT.Code.divup(8L * (long)UT.Entities.pot2Strength(tVillager), UT.Entities.pot1Weakness(tVillager)), UT.Entities.pot1Haste(tVillager), this);
                    break;
                }
            }
            if (this.mActive != oActive) {
                this.updateClientData();
                this.causeBlockUpdate();
            }
        } else if (this.mActive && WD.random(this, 20, CS.CLIENT_TIME)) {
            UT.Sounds.play("minecart.base", 1, 0.1f, this.getCoords());
        }
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            this.mActive = true;
            this.updateClientData();
            this.causeBlockUpdate();
            UT.Sounds.send("minecart.base", 0.5f, this, false);
        }
        return true;
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        return (byte)(aSide == CS.OPOS[this.mFacing] && this.mActive ? 15 : 0);
    }

    @Override
    public byte isProvidingStrongPower2(byte aSide) {
        return (byte)(aSide == CS.OPOS[this.mFacing] && this.mActive ? 15 : 0);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTextureFront = BlockTextureMulti.get(BlockTextureDefault.get(this.mActive ? sTextureFrontSpin : sTextureFront, this.mRGBa), BlockTextureDefault.get(this.mActive ? sOverlayFrontSpin : sOverlayFront));
        this.mTextureBacks = BlockTextureDefault.get((IIconContainer)(this.mActive ? Textures.BlockIcons.AXLE_COUNTERCLOCKWISE : Textures.BlockIcons.AXLE), this.mRGBa);
        this.mTextureSides = BlockTextureDefault.get((IIconContainer)(this.mActive ? Textures.BlockIcons.AXLE_CLOCKWISE : Textures.BlockIcons.AXLE), this.mRGBa);
        return 2;
    }

    @Override
    public boolean usesRenderPass2(int aRenderPass, boolean[] aShouldSideBeRendered) {
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return this.mFacing == aSide ? this.mTextureBacks : (this.mFacing == CS.OPOS[aSide] ? this.mTextureFront : this.mTextureSides);
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 4 ? 1 : 13) : 2], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 0 ? 1 : 13) : 2], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 2 ? 1 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 5 ? 1 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 1 ? 1 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 3 ? 1 : 13) : 2]);
        }
        return this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 4 ? 0 : 15) : 5], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 0 ? 0 : 15) : 5], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 2 ? 0 : 15) : 5], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 5 ? 0 : 15) : 5], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 1 ? 0 : 15) : 5], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 3 ? 0 : 15) : 5]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 4 ? 0 : 13) : 2], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 0 ? 0 : 13) : 2], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 2 ? 0 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 5 ? 0 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 1 ? 0 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 3 ? 0 : 13) : 2]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 4 ? 0 : 13) : 2], CS.PX_P[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 0 ? 0 : 13) : 2], CS.PX_P[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 2 ? 0 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_X[this.mFacing] ? (this.mFacing == 5 ? 0 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_Y[this.mFacing] ? (this.mFacing == 1 ? 0 : 13) : 2], CS.PX_N[CS.SIDES_AXIS_Z[this.mFacing] ? (this.mFacing == 3 ? 0 : 13) : 2]);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && aEnergyType == TD.Energy.RU;
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return aSide == this.mFacing && aEnergyType == TD.Energy.RU;
    }

    @Override
    public long getEnergyOffered(TagData aEnergyType, byte aSide, long aSize) {
        return this.mActive ? 16L : 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return 16L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return 16L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return 16L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return TD.Energy.RU.AS_LIST;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public byte getDirectionData() {
        return (byte)(this.mFacing & 7 | (this.mActive ? 8 : 0));
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mActive = (aData & 8) != 0;
        this.mFacing = (byte)(aData & 7);
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.crank";
    }
}

