/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.placeables;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.render.BlockTextureCopied;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.notick.TileEntityBase03MultiTileEntities;
import gregapi.util.ST;
import gregapi.util.WD;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class MultiTileEntityStick
extends TileEntityBase03MultiTileEntities
implements IMultiTileEntity.IMTE_CanPlaceSnowLayerOnRemoval,
ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_CanEntityDestroy,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing,
IMultiTileEntity.IMTE_OnNeighborBlockChange,
IMultiTileEntity.IMTE_GetBlockHardness,
IMultiTileEntity.IMTE_IsSideSolid,
IMultiTileEntity.IMTE_GetLightOpacity,
IMultiTileEntity.IMTE_GetExplosionResistance,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetFlammability,
IMultiTileEntity.IMTE_GetFireSpreadSpeed {
    public static final ITexture sWoodTexture = BlockTextureCopied.get(Blocks.field_150364_r, 3, 0);
    public ITexture mTexture = sWoodTexture;
    public float mMinX = CS.PX_P[2];
    public float mMinZ = CS.PX_P[7];
    public float mMaxX = CS.PX_N[2];
    public float mMaxZ = CS.PX_N[7];

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        Random tRandom = WD.random(this);
        if (tRandom.nextInt(1000000) < 500000) {
            this.mMinX = CS.PX_P[tRandom.nextInt(15)];
            this.mMinZ = CS.PX_P[tRandom.nextInt(3)];
            this.mMaxX = this.mMinX + CS.PX_P[2];
            this.mMaxZ = this.mMinZ + CS.PX_P[14];
        } else {
            this.mMinX = CS.PX_P[tRandom.nextInt(3)];
            this.mMinZ = CS.PX_P[tRandom.nextInt(15)];
            this.mMaxX = this.mMinX + CS.PX_P[14];
            this.mMaxZ = this.mMinZ + CS.PX_P[2];
        }
        super.readFromNBT2(aNBT);
    }

    @Override
    public ArrayListNoNulls<ItemStack> getDrops(int aFortune, boolean aSilkTouch) {
        return ST.arraylist(this.getDefaultStick(1 + this.rng(1 + aFortune)));
    }

    @Override
    public boolean onBlockActivated2(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return true;
        }
        ST.give((Entity)aPlayer, this.getDefaultStick(1), true, this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5);
        this.playCollect();
        return this.setToAir();
    }

    @Override
    public void onNeighborBlockChange(World aWorld, Block aBlock) {
        if (this.isServerSide()) {
            if (!this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e).isSideSolid((IBlockAccess)this.field_145850_b, this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, CS.FORGE_DIR[1])) {
                ST.drop(this.field_145850_b, this.getCoords(), this.getDefaultStick(1));
                this.setToAir();
                return;
            }
            for (byte tSide : CS.ALL_SIDES_HORIZONTAL_UP) {
                if (!WD.liquid(this.getBlockAtSide(tSide))) continue;
                ST.drop(this.field_145850_b, this.getCoords(), this.getDefaultStick(1));
                this.setToAir();
                return;
            }
        }
    }

    public ItemStack getDefaultStick(int aAmount) {
        if (this.field_145850_b == null || this.isClientSide()) {
            return IL.Stick.get(aAmount, new Object[0]);
        }
        if (WD.dimAETHER(this.field_145850_b)) {
            return OP.stick.mat(this.rng(3) > 0 ? MT.Skyroot : MT.WOODS.Dead, (long)aAmount);
        }
        if (WD.dimERE(this.field_145850_b)) {
            return OP.stick.mat(this.rng(8) > 0 ? MT.WOODS.Dead : MT.PetrifiedWood, (long)aAmount);
        }
        if (WD.dimBTL(this.field_145850_b)) {
            return OP.stick.mat(this.rng(3) > 0 ? MT.Weedwood : MT.WOODS.Rotten, (long)aAmount);
        }
        if (WD.dimATUM(this.field_145850_b)) {
            return OP.stick.mat(this.rng(4) > 0 ? MT.WOODS.Coconut : MT.WOODS.Dead, (long)aAmount);
        }
        if (WD.dimTROPIC(this.field_145850_b)) {
            return OP.stick.mat(this.rng(2) > 0 ? MT.WOODS.Coconut : MT.WOODS.Mahogany, (long)aAmount);
        }
        if (WD.dimALF(this.field_145850_b)) {
            return OP.stick.mat(this.rng(8) > 0 ? MT.Livingwood : MT.Dreamwood, (long)aAmount);
        }
        if (WD.dimTF(this.field_145850_b)) {
            return this.rng(16) > 0 ? IL.Stick.get(aAmount, new Object[0]) : IL.TF_LiveRoot.get(aAmount, new Object[0]);
        }
        String tBiome = this.field_145850_b.func_72807_a((int)this.field_145851_c, (int)this.field_145849_e).field_76791_y.toLowerCase();
        if (tBiome.contains("rainforest")) {
            return this.getStick(CS.NI, aAmount);
        }
        if (tBiome.contains("firefly")) {
            return this.getStick(CS.NI, aAmount);
        }
        if (tBiome.contains("dark forest")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Towerwood, (long)aAmount), aAmount);
        }
        if (tBiome.contains("silver pine")) {
            return this.getStick(OP.stick.mat(MT.WOODS.SilverPine, (long)aAmount), aAmount);
        }
        if (tBiome.contains("redwood")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Redwood, (long)aAmount), aAmount);
        }
        if (tBiome.contains("cypress")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Cypress, (long)aAmount), aAmount);
        }
        if (tBiome.contains("maple")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Maple, (long)aAmount), aAmount);
        }
        if (tBiome.contains("tropic")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Coconut, (long)aAmount), aAmount);
        }
        if (tBiome.contains("aspen")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Aspen, (long)aAmount), aAmount);
        }
        if (tBiome.contains("autumn")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Autumn, (long)aAmount), aAmount);
        }
        if (tBiome.contains("spruce")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Spruce, (long)aAmount), aAmount);
        }
        if (tBiome.contains("taiga")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Spruce, (long)aAmount), aAmount);
        }
        if (tBiome.contains("boreal")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Spruce, (long)aAmount), aAmount);
        }
        if (tBiome.contains("birch")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Birch, (long)aAmount), aAmount);
        }
        if (tBiome.contains("jungle")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Jungle, (long)aAmount), aAmount);
        }
        if (tBiome.contains("savann")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Acacia, (long)aAmount), aAmount);
        }
        if (tBiome.contains("roofed")) {
            return this.getStick(OP.stick.mat(MT.WOODS.DarkOak, (long)aAmount), aAmount);
        }
        if (tBiome.contains("dark oak")) {
            return this.getStick(OP.stick.mat(MT.WOODS.DarkOak, (long)aAmount), aAmount);
        }
        if (tBiome.contains("oak")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Oak, (long)aAmount), aAmount);
        }
        if (tBiome.contains("alpine")) {
            return OP.stick.mat(MT.WOODS.Frozen, (long)aAmount);
        }
        if (tBiome.contains("pine")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Pine, (long)aAmount), aAmount);
        }
        if (tBiome.contains("fire")) {
            return OP.stick.mat(MT.WOODS.Scorched, (long)aAmount);
        }
        if (tBiome.contains("fir")) {
            return this.getStick(OP.stick.mat(MT.WOODS.Fir, (long)aAmount), aAmount);
        }
        if (tBiome.contains("volcan")) {
            return OP.stick.mat(MT.WOODS.Scorched, (long)aAmount);
        }
        if (tBiome.contains("glacier")) {
            return OP.stick.mat(MT.WOODS.Frozen, (long)aAmount);
        }
        if (tBiome.contains("ice")) {
            return OP.stick.mat(MT.WOODS.Frozen, (long)aAmount);
        }
        if (tBiome.contains("cold")) {
            return OP.stick.mat(MT.WOODS.Frozen, (long)aAmount);
        }
        if (tBiome.contains("snow")) {
            return OP.stick.mat(MT.WOODS.Frozen, (long)aAmount);
        }
        if (tBiome.contains("frost")) {
            return OP.stick.mat(MT.WOODS.Frozen, (long)aAmount);
        }
        if (tBiome.contains("polar")) {
            return OP.stick.mat(MT.WOODS.Frozen, (long)aAmount);
        }
        if (tBiome.contains("swamp")) {
            return OP.stick.mat(MT.WOODS.Mossy, (long)aAmount);
        }
        if (tBiome.contains("marsh")) {
            return OP.stick.mat(MT.WOODS.Mossy, (long)aAmount);
        }
        if (tBiome.contains("moor")) {
            return OP.stick.mat(MT.WOODS.Mossy, (long)aAmount);
        }
        if (tBiome.contains("mire")) {
            return OP.stick.mat(MT.WOODS.Mossy, (long)aAmount);
        }
        if (tBiome.contains("bog")) {
            return OP.stick.mat(MT.WOODS.Mossy, (long)aAmount);
        }
        if (tBiome.contains("mesa")) {
            return OP.stick.mat(MT.WOODS.Dead, (long)aAmount);
        }
        if (tBiome.contains("desert")) {
            return OP.stick.mat(MT.WOODS.Dead, (long)aAmount);
        }
        if (tBiome.contains("sahara")) {
            return OP.stick.mat(MT.WOODS.Dead, (long)aAmount);
        }
        if (tBiome.contains("waste")) {
            return OP.stick.mat(MT.WOODS.Dead, (long)aAmount);
        }
        return this.getStick(CS.NI, aAmount);
    }

    public ItemStack getStick(ItemStack aStack, int aAmount) {
        switch (this.rng(16)) {
            case 0: {
                return OP.stick.mat(MT.WOODS.Dead, (long)aAmount);
            }
            case 1: {
                return OP.stick.mat(MT.WOODS.Mossy, (long)aAmount);
            }
            case 2: {
                return OP.stick.mat(MT.WOODS.Rotten, (long)aAmount);
            }
        }
        return ST.valid(aStack) ? ST.amount(aAmount, aStack) : IL.Stick.get(aAmount, new Object[0]);
    }

    @Override
    public ITexture getTexture(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] || CS.SIDES_TOP_HORIZONTAL[aSide] ? this.mTexture : null;
    }

    @Override
    public int getRenderPasses(Block aBlock, boolean[] aShouldSideBeRendered) {
        if (this.field_145850_b != null && this.hasSnow()) {
            this.mTexture = SNOW_TEXTURE;
            return 2;
        }
        this.mTexture = sWoodTexture;
        return 1;
    }

    @Override
    public boolean setBlockBounds(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        this.box(aBlock, aRenderPass == 0 ? (double)this.mMinX : 0.0, 0.0, aRenderPass == 0 ? (double)this.mMinZ : 0.0, aRenderPass == 0 ? (double)this.mMaxX : 1.0, aRenderPass == 0 ? (double)CS.PX_P[2] : (double)CS.PX_P[1], aRenderPass == 0 ? (double)this.mMaxZ : 1.0);
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, this.mMinX, 0.0, this.mMinZ, this.mMaxX, CS.PX_P[2], this.mMaxZ);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(this.mMinX, 0.0, this.mMinZ, this.mMaxX, CS.PX_P[2], this.mMaxZ);
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return null;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean checkObstruction(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return false;
    }

    @Override
    public boolean canEntityDestroy(Entity aEntity) {
        return !(aEntity instanceof EntityDragon);
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public float getExplosionResistance2() {
        return 0.0f;
    }

    @Override
    public float getBlockHardness() {
        return 0.25f;
    }

    @Override
    public int getFireSpreadSpeed(byte aSide, boolean aDefault) {
        return 300;
    }

    @Override
    public int getFlammability(byte aSide, boolean aDefault) {
        return 300;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.stick";
    }
}

