/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityUnloadable;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase11MultiBlockConverter;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.IFluidHandler;

public abstract class MultiTileEntityLargeTurbine
extends TileEntityBase11MultiBlockConverter
implements IMultiBlockFluidHandler,
IFluidHandler,
ITileEntitySwitchableOnOff {
    public short mTurbineWalls = (short)18022;
    public static final IIconContainer mTextureActive = new Textures.BlockIcons.CustomIcon("machines/multiblockmains/turbine_active");
    public static final IIconContainer mTextureInactive = new Textures.BlockIcons.CustomIcon("machines/multiblockmains/turbine");
    public ITileEntityUnloadable mEmitter = null;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.design")) {
            this.mTurbineWalls = aNBT.func_74765_d("gt.design");
        }
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tMinX = this.field_145851_c - (4 == this.mFacing ? 0 : (5 == this.mFacing ? 3 : 1));
        int tMinY = this.field_145848_d - (0 == this.mFacing ? 0 : (1 == this.mFacing ? 3 : 1));
        int tMinZ = this.field_145849_e - (2 == this.mFacing ? 0 : (3 == this.mFacing ? 3 : 1));
        int tMaxX = this.field_145851_c + (5 == this.mFacing ? 0 : (4 == this.mFacing ? 3 : 1));
        int tMaxY = this.field_145848_d + (1 == this.mFacing ? 0 : (0 == this.mFacing ? 3 : 1));
        int tMaxZ = this.field_145849_e + (3 == this.mFacing ? 0 : (2 == this.mFacing ? 3 : 1));
        int tOutX = this.getOffsetXN(this.mFacing, 3);
        int tOutY = this.getOffsetYN(this.mFacing, 3);
        int tOutZ = this.getOffsetZN(this.mFacing, 3);
        if (this.field_145850_b.func_72899_e(tMinX, tMinY, tMinZ) && this.field_145850_b.func_72899_e(tMaxX, tMaxY, tMaxZ)) {
            this.mEmitter = null;
            boolean tSuccess = true;
            for (int tX = tMinX; tX <= tMaxX; ++tX) {
                for (int tY = tMinY; tY <= tMaxY; ++tY) {
                    for (int tZ = tMinZ; tZ <= tMaxZ; ++tZ) {
                        int tBits = 0;
                        tBits = tX == tOutX && tY == tOutY && tZ == tOutZ ? -2 : (CS.SIDES_AXIS_X[this.mFacing] && tX == this.field_145851_c || CS.SIDES_AXIS_Y[this.mFacing] && tY == this.field_145848_d || CS.SIDES_AXIS_Z[this.mFacing] && tZ == this.field_145849_e ? (tY == tMinY ? -61 : -41) : (tY == tMinY ? -21 : -1));
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX, tY, tZ, this.mTurbineWalls, this.getMultiTileEntityRegistryID(), tX == tOutX && tY == tOutY && tZ == tOutZ ? 3 : 0, tBits, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        return aX >= this.field_145851_c - (4 == this.mFacing ? 0 : (5 == this.mFacing ? 3 : 1)) && aY >= this.field_145848_d - (0 == this.mFacing ? 0 : (1 == this.mFacing ? 3 : 1)) && aZ >= this.field_145849_e - (2 == this.mFacing ? 0 : (3 == this.mFacing ? 3 : 1)) && aX <= this.field_145851_c + (5 == this.mFacing ? 0 : (4 == this.mFacing ? 3 : 1)) && aY <= this.field_145848_d + (1 == this.mFacing ? 0 : (0 == this.mFacing ? 3 : 1)) && aZ <= this.field_145849_e + (3 == this.mFacing ? 0 : (2 == this.mFacing ? 3 : 1));
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return this.mStructureOkay ? 2 : 1;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 1) {
            switch (this.mFacing) {
                case 4: 
                case 5: {
                    return this.box(aBlock, -0.001, -0.999, -0.999, 1.001, 1.999, 1.999);
                }
                case 0: 
                case 1: {
                    return this.box(aBlock, -0.999, -0.001, -0.999, 1.999, 1.001, 1.999);
                }
                case 2: 
                case 3: {
                    return this.box(aBlock, -0.999, -0.999, -0.001, 1.999, 1.999, 1.001);
                }
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aRenderPass == 0 ? super.getTexture2(aBlock, aRenderPass, aSide, aShouldSideBeRendered) : (aSide != this.mFacing ? null : BlockTextureDefault.get(this.mActivity.mState > 0 ? mTextureActive : mTextureInactive));
    }

    @Override
    public TileEntity getEmittingTileEntity() {
        if (this.mEmitter == null || this.mEmitter.isDead()) {
            this.mEmitter = null;
            TileEntity tTileEntity = this.getTileEntityAtSideAndDistance(CS.OPOS[this.mFacing], 3);
            if (tTileEntity instanceof ITileEntityUnloadable) {
                this.mEmitter = (ITileEntityUnloadable)tTileEntity;
            }
        }
        return this.mEmitter == null ? this : (TileEntity)this.mEmitter;
    }

    @Override
    public byte getEmittingSide() {
        return CS.OPOS[this.mFacing];
    }

    @Override
    public boolean isInput(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public boolean isOutput(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_VALID;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return aEmitting && this.mEnergyOUT.isType(aEnergyType);
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }
}

