/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.transformers;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.machines.ITileEntityRunningActively;
import gregapi.tileentity.machines.ITileEntitySwitchableOnOff;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityGearBox
extends TileEntityBase07Paintable
implements ITileEntityEnergy,
ITileEntityRunningActively,
ITileEntitySwitchableOnOff,
IMultiTileEntity.IMTE_GetOreDictItemData,
IMultiTileEntity.IMTE_AddToolTips {
    public boolean mJammed = false;
    public boolean mUsedGear = false;
    public boolean mGearsWork = false;
    public long mMaxThroughPut = 64L;
    public long mCurrentSpeed = 0L;
    public long mCurrentPower = 0L;
    public long mTransferredLast = 0L;
    public short mAxleGear = 0;
    public byte mInputtedSides = 0;
    public byte oInputtedSides = 0;
    public byte mOrder = 0;
    public byte mRotationData = 0;
    public byte oRotationData = 0;
    public byte mIgnorePower = 0;
    public ITexture mTextureGearA;
    public ITexture mTextureAxleGearA;
    public ITexture mTextureGearB;
    public ITexture mTextureAxleGearB;
    public ITexture mTexture;
    public ITexture mTextureAxle;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.stopped")) {
            this.mJammed = aNBT.func_74767_n("gt.stopped");
        }
        if (aNBT.func_74764_b("gt.connection")) {
            this.mAxleGear = UT.Code.unsignB(aNBT.func_74771_c("gt.connection"));
        }
        if (aNBT.func_74764_b("gt.input")) {
            this.mMaxThroughPut = aNBT.func_74763_f("gt.input");
        }
        this.mGearsWork = this.checkGears();
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.stopped", this.mJammed);
        aNBT.func_74774_a("gt.connection", (byte)this.mAxleGear);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        aNBT.func_74774_a("gt.connection", (byte)this.mAxleGear);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (!this.mGearsWork) {
            aList.add(LH.Chat.BLINKING_RED + LH.get("gt.tooltip.gearbox.custom.1"));
        }
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.axle.stats.speed") + this.mMaxThroughPut + " " + TD.Energy.RU.getLocalisedNameShort());
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.gearbox.custom.2"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.tooltip.gearbox.custom.3"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("wrench")) {
            if (CS.SIDES_INVALID[aSide]) {
                return 0L;
            }
            byte tSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (CS.FACE_CONNECTED[tSide][this.mAxleGear & 0x3F]) {
                this.mAxleGear = (short)(this.mAxleGear & ~CS.B[tSide]);
                ItemStack tGear = OP.gearGt.mat(this.mMaterial, 1L);
                if (!ST.add(aPlayer, tGear)) {
                    ST.place(this.getWorld(), this.getOffset(tSide, 1), tGear);
                }
                this.mJammed = false;
                this.mGearsWork = this.checkGears();
                this.updateClientData();
                this.causeBlockUpdate();
                return 10000L;
            }
            if (UT.Entities.hasInfiniteItems(aPlayer)) {
                this.mAxleGear = (short)(this.mAxleGear | CS.B[tSide]);
                this.mJammed = false;
                this.mGearsWork = this.checkGears();
                this.updateClientData();
                this.causeBlockUpdate();
                return 10000L;
            }
            if (aPlayerInventory != null) {
                int j = aPlayerInventory.func_70302_i_();
                for (int i = 0; i < j; ++i) {
                    OreDictItemData tData = OM.data(aPlayerInventory.func_70301_a(i));
                    if (tData == null || tData.mPrefix != OP.gearGt || tData.mMaterial == null || tData.mMaterial.mMaterial != this.mMaterial && !this.mMaterial.mToThis.contains(tData.mMaterial.mMaterial)) continue;
                    if (aPlayer == null) {
                        aPlayerInventory.func_70298_a(i, 1);
                    } else {
                        ST.use(aPlayer, true, aPlayerInventory.func_70301_a(i));
                    }
                    this.mAxleGear = (short)(this.mAxleGear | CS.B[tSide]);
                    this.mJammed = false;
                    this.mGearsWork = this.checkGears();
                    this.updateClientData();
                    this.causeBlockUpdate();
                    return 10000L;
                }
            }
            if (aChatReturn != null) {
                aChatReturn.add("You dont have a Gear of the corresponding Material in your Inventory!");
            }
            return 0L;
        }
        if (aTool.equals("monkeywrench")) {
            if (CS.SIDES_INVALID[aSide]) {
                return 0L;
            }
            byte tSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            if (CS.SIDES_AXIS_X[tSide]) {
                this.mAxleGear = (this.mAxleGear >>> 6 & 3) != 1 ? (short)((byte)(this.mAxleGear & 0x3F | 0x40)) : (short)(this.mAxleGear & 0x3F);
            }
            if (CS.SIDES_AXIS_Y[tSide]) {
                this.mAxleGear = (this.mAxleGear >>> 6 & 3) != 2 ? (short)((byte)(this.mAxleGear & 0x3F | 0x80)) : (short)(this.mAxleGear & 0x3F);
            }
            if (CS.SIDES_AXIS_Z[tSide]) {
                this.mAxleGear = (this.mAxleGear >>> 6 & 3) != 3 ? (short)((byte)(this.mAxleGear & 0x3F | 0xC0)) : (short)(this.mAxleGear & 0x3F);
            }
            this.mJammed = false;
            this.mGearsWork = this.checkGears();
            this.updateClientData();
            this.causeBlockUpdate();
            return 10000L;
        }
        if (aTool.equals("softhammer")) {
            this.mJammed = !this.mJammed;
            this.mGearsWork = this.checkGears();
            this.updateClientData();
            this.causeBlockUpdate();
            return 10000L;
        }
        if (aTool.equals("tachometer")) {
            if (aChatReturn != null) {
                if (CS.FACE_CONNECTED[0][this.mAxleGear & 0x3F] || CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][0]) {
                    aChatReturn.add(CS.FACE_CONNECTED[0][this.mInputtedSides] ? "Accepts from Bottom" : "Emits to Bottom");
                }
                if (CS.FACE_CONNECTED[1][this.mAxleGear & 0x3F] || CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][1]) {
                    aChatReturn.add(CS.FACE_CONNECTED[1][this.mInputtedSides] ? "Accepts from Top" : "Emits to Top");
                }
                if (CS.FACE_CONNECTED[2][this.mAxleGear & 0x3F] || CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][2]) {
                    aChatReturn.add(CS.FACE_CONNECTED[2][this.mInputtedSides] ? "Accepts from North" : "Emits to North");
                }
                if (CS.FACE_CONNECTED[3][this.mAxleGear & 0x3F] || CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][3]) {
                    aChatReturn.add(CS.FACE_CONNECTED[3][this.mInputtedSides] ? "Accepts from South" : "Emits to South");
                }
                if (CS.FACE_CONNECTED[4][this.mAxleGear & 0x3F] || CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][4]) {
                    aChatReturn.add(CS.FACE_CONNECTED[4][this.mInputtedSides] ? "Accepts from West" : "Emits to West");
                }
                if (CS.FACE_CONNECTED[5][this.mAxleGear & 0x3F] || CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][5]) {
                    aChatReturn.add(CS.FACE_CONNECTED[5][this.mInputtedSides] ? "Accepts from East" : "Emits to East");
                }
                aChatReturn.add(this.mTransferredLast + " RU/t");
            }
            return 1L;
        }
        if (aTool.equals("magnifyingglass")) {
            this.mGearsWork = this.checkGears();
            if (aChatReturn != null) {
                aChatReturn.add(this.mGearsWork ? (this.mJammed ? "Gears interlocked properly, but they are jammed!" : "Gears interlocked properly.") : "Gears interlocked improperly!");
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (this.mJammed || !this.mGearsWork) {
                this.mCurrentPower = 0L;
            }
            this.mTransferredLast = Math.abs(this.mCurrentPower * this.mCurrentSpeed);
            if (this.mUsedGear && this.mCurrentPower > 0L) {
                boolean temp = true;
                while (temp) {
                    temp = false;
                    long tUsable = Math.max(1L, this.mCurrentPower / 3L);
                    for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                        long tUsed;
                        byte tSide = (byte)((this.mOrder + i) % 6);
                        if (CS.FACE_CONNECTED[tSide][this.mInputtedSides]) continue;
                        if (CS.FACE_CONNECTED[tSide][this.mAxleGear & 0x3F]) {
                            tUsed = ITileEntityEnergy.Util.insertEnergyInto(TD.Energy.RU, (this.mRotationData & CS.B[tSide]) != 0 ? this.mCurrentSpeed : -this.mCurrentSpeed, tUsable, this, this.getAdjacentTileEntity(tSide));
                            if (tUsed <= 0L) continue;
                            this.mCurrentPower -= tUsed;
                            if (this.mCurrentPower <= 0L) {
                                temp = false;
                                break;
                            }
                            temp = true;
                            continue;
                        }
                        if (!CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][tSide] || !CS.FACE_CONNECTED[CS.OPOS[tSide]][this.mAxleGear & 0x3F] || (tUsed = ITileEntityEnergy.Util.insertEnergyInto(TD.Energy.RU, (this.mRotationData & CS.B[CS.OPOS[tSide]]) == 0 ? this.mCurrentSpeed : -this.mCurrentSpeed, tUsable, this, this.getAdjacentTileEntity(tSide))) <= 0L) continue;
                        this.mCurrentPower -= tUsed;
                        if (this.mCurrentPower <= 0L) {
                            temp = false;
                            break;
                        }
                        temp = true;
                    }
                    if ((this.mOrder = (byte)(this.mOrder + 1)) < 6) continue;
                    this.mOrder = 0;
                }
            }
            this.mTransferredLast -= Math.abs(this.mCurrentPower * this.mCurrentSpeed);
            if (!this.mUsedGear) {
                this.mRotationData = (byte)(this.mRotationData & ~CS.B[6]);
            }
            this.oInputtedSides = this.mInputtedSides;
            this.mInputtedSides = 0;
            this.mUsedGear = false;
        } else if ((this.mRotationData & CS.B[6]) != 0 && WD.random(this, 20, CS.CLIENT_TIME)) {
            UT.Sounds.play("minecart.base", 1, 0.1f, this.getCoords());
        }
    }

    public byte getRotations(byte aSide, boolean aNegative) {
        if (!this.mGearsWork) {
            return 0;
        }
        byte rRotationData = (byte)(aNegative ? CS.B[aSide] : 0);
        if (CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][aSide]) {
            if (!aNegative) {
                rRotationData = (byte)(rRotationData | CS.B[CS.OPOS[aSide]]);
            }
            if (CS.FACE_CONNECTED[aSide][this.mAxleGear & 0x3F]) {
                if (!aNegative) {
                    for (byte tSide : CS.ALL_SIDES_VALID_BUT_AXIS[aSide]) {
                        if (!CS.FACE_CONNECTED[tSide][this.mAxleGear & 0x3F]) continue;
                        rRotationData = (byte)(rRotationData | CS.B[tSide]);
                    }
                }
                return (byte)(rRotationData & this.mAxleGear & 0x3F | CS.B[6]);
            }
            if (CS.FACE_CONNECTED[CS.OPOS[aSide]][this.mAxleGear & 0x3F]) {
                if (aNegative) {
                    for (byte tSide : CS.ALL_SIDES_VALID_BUT_AXIS[aSide]) {
                        if (!CS.FACE_CONNECTED[tSide][this.mAxleGear & 0x3F]) continue;
                        rRotationData = (byte)(rRotationData | CS.B[tSide]);
                    }
                }
                return (byte)(rRotationData & this.mAxleGear & 0x3F | CS.B[6]);
            }
            CS.ERR.print("Something went wrong with the free Axle inside the Gearbox at " + this.getCoords() + " receiving power from Side: " + aSide);
            return this.mRotationData;
        }
        if (CS.FACE_CONNECTED[aSide][this.mAxleGear & 0x3F]) {
            if (aNegative) {
                rRotationData = (byte)(rRotationData | CS.B[CS.OPOS[aSide]]);
            }
            if (!aNegative) {
                for (byte tSide : CS.ALL_SIDES_VALID_BUT_AXIS[aSide]) {
                    if (!CS.FACE_CONNECTED[tSide][this.mAxleGear & 0x3F]) continue;
                    rRotationData = (byte)(rRotationData | CS.B[tSide]);
                }
            }
            return (byte)(rRotationData & this.mAxleGear & 0x3F | CS.B[6]);
        }
        CS.ERR.print("Something went wrong with the Gearbox at " + this.getCoords() + " receiving power from Side: " + aSide + " even though there is neither a Gear nor an Axle at that Side");
        return this.mRotationData;
    }

    public boolean checkGears() {
        this.mIgnorePower = 0;
        this.mCurrentPower = 0L;
        this.mCurrentSpeed = 0L;
        switch (CS.FACE_CONNECTION_COUNT[this.mAxleGear & 0x3F]) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                if ((this.mAxleGear & 0x30) != 48 && (this.mAxleGear & 3) != 3 && (this.mAxleGear & 0xC) != 12) {
                    return true;
                }
                switch (this.mAxleGear >>> 6 & 3) {
                    case 1: {
                        return (this.mAxleGear & 0x30) != 0;
                    }
                    case 2: {
                        return (this.mAxleGear & 3) != 0;
                    }
                    case 3: {
                        return (this.mAxleGear & 0xC) != 0;
                    }
                }
                return false;
            }
            case 3: 
            case 4: {
                switch (this.mAxleGear >>> 6 & 3) {
                    case 1: {
                        if ((this.mAxleGear & 0x30) != 48) break;
                        return false;
                    }
                    case 2: {
                        if ((this.mAxleGear & 3) != 3) break;
                        return false;
                    }
                    case 3: {
                        if ((this.mAxleGear & 0xC) != 12) break;
                        return false;
                    }
                }
                int tAxisUsed = 0;
                if ((this.mAxleGear & 0x30) != 0) {
                    tAxisUsed = (byte)(tAxisUsed + 1);
                }
                if ((this.mAxleGear & 3) != 0) {
                    tAxisUsed = (byte)(tAxisUsed + 1);
                }
                if ((this.mAxleGear & 0xC) != 0) {
                    tAxisUsed = (byte)(tAxisUsed + 1);
                }
                return tAxisUsed < 3;
            }
        }
        return false;
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return this.mRotationData != this.oRotationData || super.onTickCheck(aTimer);
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oRotationData = this.mRotationData;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mRotationData = aData;
    }

    @Override
    public byte getVisualData() {
        return this.mRotationData;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getVisualData(), (byte)this.mAxleGear) : this.getClientDataPacketByte(aSendAll, this.getVisualData());
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mAxleGear = UT.Code.unsignB(aData[4]);
        return super.receiveDataByteArray(aData, aNetworkHandler);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        this.mTexture = BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.GEARBOX, this.mRGBa);
        this.mTextureAxle = BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.GEARBOX_AXLE, this.mRGBa);
        this.mTextureGearA = BlockTextureMulti.get(this.mTexture, BlockTextureDefault.get((IIconContainer)((this.mRotationData & CS.B[6]) == 0 ? Textures.BlockIcons.GEAR : Textures.BlockIcons.GEAR_CLOCKWISE), this.mRGBa));
        this.mTextureAxleGearA = BlockTextureMulti.get(this.mTextureAxle, BlockTextureDefault.get((IIconContainer)((this.mRotationData & CS.B[6]) == 0 ? Textures.BlockIcons.GEAR : Textures.BlockIcons.GEAR_CLOCKWISE), this.mRGBa));
        this.mTextureGearB = BlockTextureMulti.get(this.mTexture, BlockTextureDefault.get((IIconContainer)((this.mRotationData & CS.B[6]) == 0 ? Textures.BlockIcons.GEAR : Textures.BlockIcons.GEAR_COUNTERCLOCKWISE), this.mRGBa));
        this.mTextureAxleGearB = BlockTextureMulti.get(this.mTextureAxle, BlockTextureDefault.get((IIconContainer)((this.mRotationData & CS.B[6]) == 0 ? Textures.BlockIcons.GEAR : Textures.BlockIcons.GEAR_COUNTERCLOCKWISE), this.mRGBa));
        return 1;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? (CS.FACE_CONNECTED[aSide][this.mAxleGear & 0x3F] ? (CS.FACE_CONNECTED[aSide][this.mRotationData & 0x3F] ? (CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][aSide] ? this.mTextureAxleGearA : this.mTextureGearA) : (CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][aSide] ? this.mTextureAxleGearB : this.mTextureGearB)) : (CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][aSide] ? this.mTextureAxle : this.mTexture)) : null;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSpeed, long aPower, boolean aDoInject) {
        if (!this.isEnergyType(aEnergyType, aSide, false)) {
            return 0L;
        }
        if (!CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][aSide] && !CS.FACE_CONNECTED[aSide][this.mAxleGear & 0x3F]) {
            return 0L;
        }
        if (!aDoInject) {
            return this.mIgnorePower == 0 ? aPower : 0L;
        }
        this.mInputtedSides = (byte)(this.mInputtedSides | CS.B[aSide]);
        long tSpeed = Math.abs(aSpeed);
        if (tSpeed > this.mMaxThroughPut) {
            if (this.mTimer < 10L) {
                return aPower;
            }
            UT.Sounds.send("random.break", this, false);
            byte tCount = CS.FACE_CONNECTION_COUNT[this.mAxleGear & 0x3F];
            if (tCount > 0) {
                ST.drop(this.getWorld(), this.getCoords(), OP.scrapGt.mat(this.mMaterial, (long)(9 + this.rng(27))));
                if (tCount > 1) {
                    ST.drop(this.getWorld(), this.getCoords(), OP.gearGt.mat(this.mMaterial, (long)(tCount - 1)));
                }
            }
            this.mAxleGear = 0;
            this.updateClientData();
            this.mGearsWork = this.checkGears();
            return aPower;
        }
        if (CS.AXIS_XYZ[this.mAxleGear >>> 6 & 3][aSide] && !CS.FACE_CONNECTED[aSide][this.mAxleGear & 0x3F] && !CS.FACE_CONNECTED[CS.OPOS[aSide]][this.mAxleGear & 0x3F]) {
            return ITileEntityEnergy.Util.insertEnergyInto(TD.Energy.RU, aSpeed, aPower, this, this.getAdjacentTileEntity(CS.OPOS[aSide]));
        }
        if (!this.mGearsWork) {
            return aPower;
        }
        if (this.mUsedGear) {
            byte tRotationData = this.getRotations(aSide, aSpeed < 0L);
            if (tRotationData != this.mRotationData) {
                UT.Sounds.send("random.break", this, false);
                this.mRotationData = 0;
                this.mJammed = true;
                return aPower;
            }
            if (this.mIgnorePower != 0) {
                return 0L;
            }
            this.mCurrentSpeed = Math.min(tSpeed, this.mCurrentSpeed);
            this.mCurrentPower += aPower;
            return aPower;
        }
        this.mRotationData = this.getRotations(aSide, aSpeed < 0L);
        if (this.mRotationData != 0) {
            this.mUsedGear = true;
            this.mIgnorePower = this.mCurrentPower > 0L ? (byte)(this.mIgnorePower + 1) : (byte)0;
            if (this.mIgnorePower != 0) {
                return 0L;
            }
            this.mCurrentSpeed = tSpeed;
            this.mCurrentPower = aPower;
            return aPower;
        }
        return 0L;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return TD.Energy.RU == aEnergyType;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return (aTheoretical || !this.mJammed) && super.isEnergyAcceptingFrom(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public boolean isEnergyEmittingTo(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return super.isEnergyEmittingTo(aEnergyType, aSide, aTheoretical);
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, byte aSide) {
        return this.mMaxThroughPut / 2L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, byte aSide) {
        return this.mMaxThroughPut;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 0L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return this.mMaxThroughPut / 2L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return this.mMaxThroughPut;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return TD.Energy.RU.AS_LIST;
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return super.isUsingWrenchingOverlay(aStack, aSide) || CS.ToolsGT.contains("wrench", aStack) || CS.ToolsGT.contains("monkeywrench", aStack);
    }

    @Override
    public boolean isConnectedWrenchingOverlay(ItemStack aStack, byte aSide) {
        return CS.FACE_CONNECTED[aSide][this.mAxleGear & 0x3F];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mGearsWork;
    }

    @Override
    public boolean getStateRunningPassively() {
        return (this.mRotationData & CS.B[6]) != 0 || (this.oRotationData & CS.B[6]) != 0;
    }

    @Override
    public boolean getStateRunningActively() {
        return (this.mRotationData & CS.B[6]) != 0 || (this.oRotationData & CS.B[6]) != 0;
    }

    @Override
    public boolean setStateOnOff(boolean aOnOff) {
        this.mJammed = !aOnOff;
        return !this.mJammed;
    }

    @Override
    public boolean getStateOnOff() {
        return !this.mJammed;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.gearbox.custom";
    }

    @Override
    public List<OreDictItemData> getOreDictItemData(List<OreDictItemData> aList) {
        if (CS.FACE_CONNECTION_COUNT[this.mAxleGear & 0x3F] > 0) {
            aList.add(new OreDictItemData(this.mMaterial, OP.gearGt.mAmount * (long)CS.FACE_CONNECTION_COUNT[this.mAxleGear & 0x3F], new OreDictMaterialStack[0]));
        }
        return aList;
    }

    static {
        LH.add("gt.tooltip.gearbox.custom.1", "Gears are interlocked wrongly!");
        LH.add("gt.tooltip.gearbox.custom.2", "Use Wrench to mount Gears from your Inventory");
        LH.add("gt.tooltip.gearbox.custom.3", "Use Monkeywrench to change Axle Direction");
    }
}

