/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.energy.converters;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.fluid.FluidTankGT;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.energy.TileEntityBase11Motor;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityTurbineSteam
extends TileEntityBase11Motor
implements IFluidHandler {
    public FluidTankGT mTank = new FluidTankGT();
    public long mSteamCounter = 0L;
    public long mEnergyProducedNextTick = 0L;
    public static final int STEAM_PER_WATER = 200;
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/colored/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/colored/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay/side")};
    public static IIconContainer[] sOverlaysActiveLS = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_ls/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_ls/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_ls/side")};
    public static IIconContainer[] sOverlaysActiveLF = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_lf/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_lf/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_lf/side")};
    public static IIconContainer[] sOverlaysActiveRS = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rs/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rs/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rs/side")};
    public static IIconContainer[] sOverlaysActiveRF = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rf/front"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rf/back"), new Textures.BlockIcons.CustomIcon("machines/turbines/rotation_steam/overlay_active_rf/side")};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.energy.su")) {
            this.mSteamCounter = aNBT.func_74763_f("gt.energy.su");
        }
        if (aNBT.func_74764_b("gt.output.su")) {
            this.mEnergyProducedNextTick = aNBT.func_74763_f("gt.output.su");
        }
        this.mTank.readFromNBT(aNBT, "gt.tank.0");
        this.mTank.setCapacity(this.mConverter.mEnergyIN.mMax * 4L);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy.su", this.mSteamCounter);
        UT.NBT.setNumber(aNBT, "gt.output.su", this.mEnergyProducedNextTick);
        this.mTank.writeToNBT(aNBT, "gt.tank.0");
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.emits.used.steam") + " (" + LH.get("gt.lang.face.sides") + ", 80%)");
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            return CS.GarbageGT.trash(this.mTank);
        }
        return 0L;
    }

    @Override
    public void doConversion(long aTimer) {
        if (this.mEnergyProducedNextTick > 0L) {
            this.mStorage.mEnergy += this.mEnergyProducedNextTick;
            this.mEnergyProducedNextTick = 0L;
        } else if (this.mTank.has(this.getEnergySizeInputMin(this.mConverter.mEnergyIN.mType, (byte)6) * 2L)) {
            long tSteam = this.mTank.amount();
            this.mSteamCounter += tSteam;
            this.mStorage.mEnergy += tSteam / (long)CS.STEAM_PER_EU;
            this.mEnergyProducedNextTick += tSteam / (long)CS.STEAM_PER_EU;
            this.mTank.setEmpty();
            if (this.mSteamCounter >= 200L) {
                FluidStack tDistilledWater = FL.DistW.make(this.mSteamCounter / 200L);
                for (byte tDir : CS.FACING_SIDES[this.mFacing]) {
                    tDistilledWater.amount = (int)((long)tDistilledWater.amount - FL.fill(this.getAdjacentTank(tDir), tDistilledWater.copy(), true));
                    if (tDistilledWater.amount <= 0) break;
                }
                CS.GarbageGT.trash(tDistilledWater);
                this.mSteamCounter %= 200L;
            }
        }
        super.doConversion(aTimer);
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.ALONG_AXIS[aSide][this.mFacing] ? 0.5f : 0.25f;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return true;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return true;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return true;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return this.isInput(aSide) && !this.mStopped && FL.steam(aFluidToFill) ? this.mTank : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return null;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.isOutput(aSide) ? null : this.mTank.AS_ARRAY;
    }

    @Override
    public void onWalkOver2(EntityLivingBase aEntity) {
        if (CS.SIDES_TOP[this.mFacing] && this.mActivity.mState > 0) {
            aEntity.field_70177_z = aEntity.field_70177_z + (float)((this.mCounterClockwise ? -5 : 5) * (this.mConverter.mFast ? 2 : 1));
            aEntity.field_70759_as = aEntity.field_70759_as + (float)((this.mCounterClockwise ? -5 : 5) * (this.mConverter.mFast ? 2 : 1));
        }
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        int aIndex = aSide == this.mFacing ? 0 : (aSide == CS.OPOS[this.mFacing] ? 1 : 2);
        ITexture[] iTextureArray = new ITexture[2];
        iTextureArray[0] = BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa);
        iTextureArray[1] = BlockTextureDefault.get((this.mActivity.mState > 0 ? (this.mCounterClockwise ? (this.mConverter.mFast ? sOverlaysActiveLF : sOverlaysActiveLS) : (this.mConverter.mFast ? sOverlaysActiveRF : sOverlaysActiveRS)) : sOverlays)[aIndex]);
        return BlockTextureMulti.get(iTextureArray);
    }

    @Override
    public boolean isInput(byte aSide) {
        return aSide == CS.OPOS[this.mFacing];
    }

    @Override
    public boolean isOutput(byte aSide) {
        return aSide == this.mFacing;
    }

    @Override
    public String getLocalisedInputSide() {
        return LH.get("gt.lang.face.back");
    }

    @Override
    public String getLocalisedOutputSide() {
        return LH.get("gt.lang.face.front");
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.turbines.rotation_steam";
    }
}

