/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.tileentity.ITileEntityRemoteActivateable;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;

public class Behavior_Remote
extends IBehavior.AbstractBehaviorDefault {
    public static final IBehavior<MultiItem> INSTANCE = new Behavior_Remote();

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        ChunkCoordinates tCoords;
        if (aWorld.field_72995_K || aPlayer == null || !aPlayer.func_70093_af() || !aPlayer.func_82247_a(aX, aY, aZ, (int)aSide, aStack)) {
            return false;
        }
        NBTTagCompound aNBT = UT.NBT.getNBT(aStack);
        ArrayListNoNulls<ChunkCoordinates> tList = Behavior_Remote.getCoords(aNBT, aWorld.field_73011_w.field_76574_g);
        if (tList.contains(tCoords = new ChunkCoordinates(aX, aY, aZ))) {
            UT.Entities.sendchat((Object)aPlayer, "Coordinates removed!");
            UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 1.0f, aWorld, tCoords);
            tList.remove(tCoords);
        } else if (tList.size() >= 64) {
            UT.Entities.sendchat((Object)aPlayer, "Cant hold more than 64 Coordinates per Dimension!");
            UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 0.5f, aWorld, tCoords);
        } else {
            TileEntity tTileEntity = WD.te(aWorld, tCoords, false);
            if (tTileEntity instanceof ITileEntityRemoteActivateable) {
                UT.Entities.sendchat((Object)aPlayer, "Coordinates added!");
                UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 1.0f, aWorld, tCoords);
                tList.add(tCoords);
            } else {
                UT.Entities.sendchat((Object)aPlayer, "This cannot be added!");
                UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 0.5f, aWorld, tCoords);
            }
        }
        Behavior_Remote.setCoords(aNBT, aWorld.field_73011_w.field_76574_g, tList);
        UT.NBT.set(aStack, aNBT);
        return true;
    }

    @Override
    public ItemStack onItemRightClick(MultiItem aItem, ItemStack aStack, World aWorld, EntityPlayer aPlayer) {
        if (aWorld.field_72995_K || aPlayer.func_70093_af() || !aStack.func_77942_o()) {
            return aStack;
        }
        ArrayListNoNulls<ChunkCoordinates> tToBeKept = new ArrayListNoNulls<ChunkCoordinates>();
        for (ChunkCoordinates tCoords : Behavior_Remote.getCoords(aStack.func_77978_p(), aWorld.field_73011_w.field_76574_g)) {
            if (Math.abs((double)tCoords.field_71574_a - aPlayer.field_70165_t) <= 128.0 && Math.abs((double)tCoords.field_71572_b - aPlayer.field_70163_u) <= 128.0 && Math.abs((double)tCoords.field_71573_c - aPlayer.field_70161_v) <= 128.0) {
                TileEntity tTileEntity = WD.te(aWorld, tCoords, false);
                if (!(tTileEntity instanceof ITileEntityRemoteActivateable) || !((ITileEntityRemoteActivateable)tTileEntity).remoteActivate()) continue;
                tToBeKept.add(tCoords);
                continue;
            }
            tToBeKept.add(tCoords);
        }
        Behavior_Remote.setCoords(aStack.func_77978_p(), aWorld.field_73011_w.field_76574_g, tToBeKept);
        UT.Sounds.send("random.click", (Entity)aPlayer);
        return aStack;
    }

    public static boolean addCoords(ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        NBTTagCompound aNBT = UT.NBT.getNBT(aStack);
        ArrayListNoNulls<ChunkCoordinates> tList = Behavior_Remote.getCoords(aNBT, aWorld.field_73011_w.field_76574_g);
        if (tList.size() >= 64) {
            return false;
        }
        ChunkCoordinates tCoords = new ChunkCoordinates(aX, aY, aZ);
        if (tList.contains(tCoords)) {
            return true;
        }
        TileEntity tTileEntity = WD.te(aWorld, tCoords, false);
        if (tTileEntity instanceof ITileEntityRemoteActivateable) {
            UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 1.0f, aWorld, tCoords);
            tList.add(tCoords);
            Behavior_Remote.setCoords(aNBT, aWorld.field_73011_w.field_76574_g, tList);
            UT.NBT.set(aStack, aNBT);
            return true;
        }
        UT.Sounds.send(CS.SFX.GT_BEEP, 0.5f, 0.5f, aWorld, tCoords);
        return false;
    }

    public static ArrayListNoNulls<ChunkCoordinates> getCoords(NBTTagCompound aNBT, int aDimension) {
        ArrayListNoNulls<ChunkCoordinates> rList = new ArrayListNoNulls<ChunkCoordinates>();
        if (aNBT == null) {
            return rList;
        }
        NBTTagCompound tNBT = aNBT.func_74775_l("gt.remote.dim." + aDimension);
        if (tNBT.func_82582_d()) {
            return rList;
        }
        int i = -1;
        while (tNBT.func_74764_b("c" + ++i)) {
            rList.add(new ChunkCoordinates(tNBT.func_74762_e("x" + i), tNBT.func_74762_e("y" + i), tNBT.func_74762_e("z" + i)));
        }
        return rList;
    }

    public static void setCoords(NBTTagCompound aNBT, int aDimension, ArrayListNoNulls<ChunkCoordinates> aList) {
        if (aList.isEmpty()) {
            aNBT.func_82580_o("gt.remote.dim." + aDimension);
        } else {
            NBTTagCompound tNBT = UT.NBT.make();
            int j = aList.size();
            for (int i = 0; i < j; ++i) {
                ChunkCoordinates tCoords = (ChunkCoordinates)aList.get(i);
                UT.NBT.setBoolean(tNBT, "c" + i, true);
                UT.NBT.setNumber(tNBT, "x" + i, tCoords.field_71574_a);
                UT.NBT.setNumber(tNBT, "y" + i, tCoords.field_71572_b);
                UT.NBT.setNumber(tNBT, "z" + i, tCoords.field_71573_c);
            }
            aNBT.func_74782_a("gt.remote.dim." + aDimension, (NBTBase)tNBT);
        }
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.remote"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.remote", "Activates up to 64 Blocks within a Range of 128m");
    }
}

