/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.code.ArrayListNoNulls;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.TD;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import gregapi.util.WD;
import ic2.api.crops.ICropTile;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class Behavior_Cropnalyzer
extends IBehavior.AbstractBehaviorDefault {
    public static final Behavior_Cropnalyzer INSTANCE = new Behavior_Cropnalyzer();

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aPlayer instanceof EntityPlayerMP) {
            ArrayListNoNulls<String> tList = new ArrayListNoNulls<String>();
            long tUsedEnergy = this.getCropScan(tList, aWorld, aX, aY, aZ);
            if (tUsedEnergy <= 0L) {
                return false;
            }
            if (aItem.useEnergy(TD.Energy.EU, aStack, tUsedEnergy, (EntityLivingBase)aPlayer, (IInventory)aPlayer.field_71071_by, aWorld, aX, aY, aZ, true)) {
                UT.Entities.sendchat((Object)aPlayer, tList, false);
            }
            return true;
        }
        UT.Sounds.play(CS.SFX.IC_SCANNER, 20, 1.0f, aX, aY, aZ);
        return aPlayer instanceof EntityPlayerMP;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.cropnalyzer"));
        return aList;
    }

    public long getCropScan(ArrayList<String> aList, World aWorld, int aX, int aY, int aZ) {
        if (aList == null || !MD.IC2.mLoaded) {
            return 0L;
        }
        ArrayListNoNulls<String> rList = new ArrayListNoNulls<String>();
        long rEUAmount = 0L;
        TileEntity tTileEntity = WD.te(aWorld, aX, aY, aZ, true);
        if (tTileEntity instanceof ICropTile) {
            ((ArrayList)rList).add("--- X: " + aX + " Y: " + aY + " Z: " + aZ + " ---");
            if (((ICropTile)tTileEntity).getScanLevel() < 4) {
                rEUAmount = CS.V[6];
                ((ICropTile)tTileEntity).setScanLevel((byte)4);
            } else {
                rEUAmount = CS.V[3];
            }
            ((ArrayList)rList).add("Type -- Name: " + LH.get(((ICropTile)tTileEntity).getCrop().displayName()) + "   Growth: " + ((ICropTile)tTileEntity).getGrowth() + "   Gain: " + ((ICropTile)tTileEntity).getGain() + "   Resistance: " + ((ICropTile)tTileEntity).getResistance());
            ((ArrayList)rList).add("Plant -- Fertilizer: " + ((ICropTile)tTileEntity).getNutrientStorage() + "   Water: " + ((ICropTile)tTileEntity).getHydrationStorage() + "   Weed-Ex: " + ((ICropTile)tTileEntity).getWeedExStorage());
            ((ArrayList)rList).add("Environment -- Nutrients: " + ((ICropTile)tTileEntity).getNutrients() + "   Humidity: " + ((ICropTile)tTileEntity).getHumidity() + "   Air-Quality: " + ((ICropTile)tTileEntity).getAirQuality());
            String tString = "";
            for (String tAttribute : ((ICropTile)tTileEntity).getCrop().attributes()) {
                tString = tString + ", " + tAttribute;
            }
            ((ArrayList)rList).add("Attributes:" + tString.replaceFirst(",", ""));
            ((ArrayList)rList).add("Discovered by: " + ((ICropTile)tTileEntity).getCrop().discoveredBy());
        }
        aList.addAll(rList);
        return rEUAmount;
    }

    static {
        LH.add("gt.behaviour.cropnalyzer", "Can scan Crops in World");
    }
}

