/*
 * Decompiled with CFR 0.152.
 */
package gregtech.items.behaviors;

import gregapi.code.TagData;
import gregapi.data.TD;
import gregapi.item.IItemProjectile;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import gregtech.entities.projectiles.EntityArrow_Material;
import net.minecraft.block.BlockDispenser;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class Behavior_Arrow
extends IBehavior.AbstractBehaviorDefault {
    public static Behavior_Arrow DEFAULT_WOODEN = new Behavior_Arrow(EntityArrow_Material.class, 1.0f, 6.0f);
    public static Behavior_Arrow DEFAULT_PLASTIC = new Behavior_Arrow(EntityArrow_Material.class, 1.5f, 6.0f);
    private final int mLevel;
    private final Enchantment mEnchantment;
    private final float mSpeedMultiplier;
    private final float mPrecision;
    private final Class<? extends EntityArrow_Material> mArrow;

    public Behavior_Arrow(Class<? extends EntityArrow_Material> aArrow, float aSpeed, float aPrecision) {
        this(aArrow, aSpeed, aPrecision, null, 0);
    }

    public Behavior_Arrow(Class<? extends EntityArrow_Material> aArrow, float aSpeed, float aPrecision, Enchantment aEnchantment, int aLevel) {
        this.mArrow = aArrow;
        this.mSpeedMultiplier = aSpeed;
        this.mPrecision = aPrecision;
        this.mEnchantment = aEnchantment;
        this.mLevel = aLevel;
    }

    @Override
    public boolean onLeftClickEntity(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, Entity aEntity) {
        if (aEntity instanceof EntityLivingBase) {
            UT.Enchantments.applyBullshitA((EntityLivingBase)aEntity, (Entity)aPlayer, aStack);
            UT.Enchantments.applyBullshitB((EntityLivingBase)aPlayer, aEntity, aStack);
            if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                --aStack.field_77994_a;
            }
            if (aStack.field_77994_a <= 0) {
                aPlayer.func_71028_bD();
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean isItemStackUsable(MultiItem aItem, ItemStack aStack) {
        NBTTagCompound tNBT;
        if (this.mEnchantment != null && this.mLevel > 0 && !(tNBT = UT.NBT.getNBT(aStack)).func_74767_n("gt.u")) {
            tNBT.func_74757_a("gt.u", true);
            UT.NBT.set(aStack, tNBT);
            UT.NBT.addEnchantment(aStack, this.mEnchantment, this.mLevel);
        }
        return true;
    }

    @Override
    public boolean canDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
        return true;
    }

    @Override
    public ItemStack onDispense(MultiItem aItem, IBlockSource aSource, ItemStack aStack) {
        World aWorld = aSource.func_82618_k();
        IPosition tPosition = BlockDispenser.func_149939_a((IBlockSource)aSource);
        EnumFacing tFacing = BlockDispenser.func_149937_b((int)aSource.func_82620_h());
        IItemProjectile.EntityProjectile tEntityArrow = this.getProjectile(aItem, TD.Projectiles.ARROW, aStack, aWorld, tPosition.func_82615_a(), tPosition.func_82617_b(), tPosition.func_82616_c());
        if (tEntityArrow != null) {
            tEntityArrow.func_70186_c(tFacing.func_82601_c(), (float)tFacing.func_96559_d() + 0.1f, tFacing.func_82599_e(), this.mSpeedMultiplier * 1.1f, this.mPrecision);
            tEntityArrow.setProjectileStack(aStack);
            tEntityArrow.field_70251_a = 1;
            aWorld.func_72838_d((Entity)tEntityArrow);
            if (aStack.field_77994_a < 100) {
                --aStack.field_77994_a;
            }
            return aStack;
        }
        return super.onDispense(aItem, aSource, aStack);
    }

    @Override
    public boolean hasProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack) {
        return aProjectileType == TD.Projectiles.ARROW;
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, double aX, double aY, double aZ) {
        if (!this.hasProjectile(aItem, aProjectileType, aStack)) {
            return null;
        }
        EntityArrow_Material rArrow = (EntityArrow_Material)((Object)UT.Reflection.callConstructor(this.mArrow.getName(), -1, null, true, aWorld, aX, aY, aZ));
        rArrow.setProjectileStack(aStack);
        return rArrow;
    }

    @Override
    public IItemProjectile.EntityProjectile getProjectile(MultiItem aItem, TagData aProjectileType, ItemStack aStack, World aWorld, EntityLivingBase aEntity, float aSpeed) {
        if (!this.hasProjectile(aItem, aProjectileType, aStack)) {
            return null;
        }
        EntityArrow_Material rArrow = (EntityArrow_Material)((Object)UT.Reflection.callConstructor(this.mArrow.getName(), -1, null, true, aWorld, aEntity, Float.valueOf(this.mSpeedMultiplier * aSpeed)));
        rArrow.setProjectileStack(aStack);
        return rArrow;
    }
}

