/*
 * Decompiled with CFR 0.152.
 */
package gregtech.entities.ai;

import gregapi.data.CS;
import gregapi.util.ST;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIBetterAttackOnCollide
extends EntityAIBase {
    public World mWorld;
    public PathEntity mPath;
    public Class<?> mTargetClass;
    public EntityCreature mCreature;
    public int mAttackCoolDown;
    public int mPathCoolDown;
    public int mFailedPathFindingPenalty;
    public double mX;
    public double mY;
    public double mZ;
    public double mSpeedToTarget;
    public boolean mLastingMemory;

    public EntityAIBetterAttackOnCollide(EntityAIAttackOnCollide orig) {
        this.mTargetClass = orig.field_75444_h;
        this.mCreature = orig.field_75441_b;
        this.mWorld = this.mCreature.field_70170_p;
        this.mSpeedToTarget = orig.field_75440_e;
        this.mLastingMemory = orig.field_75437_f;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.mCreature.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.mTargetClass != null && !this.mTargetClass.isAssignableFrom(entitylivingbase.getClass())) {
            return false;
        }
        if (--this.mPathCoolDown <= 0) {
            this.mPath = this.mCreature.func_70661_as().func_75494_a((Entity)entitylivingbase);
            this.mPathCoolDown = 4 + this.mCreature.func_70681_au().nextInt(7);
            return this.mPath != null;
        }
        return true;
    }

    public boolean func_75253_b() {
        EntityLivingBase tTarget = this.mCreature.func_70638_az();
        return tTarget != null && tTarget.func_70089_S() && (!this.mLastingMemory ? !this.mCreature.func_70661_as().func_75500_f() : this.mCreature.func_110176_b(MathHelper.func_76128_c((double)tTarget.field_70165_t), MathHelper.func_76128_c((double)tTarget.field_70163_u), MathHelper.func_76128_c((double)tTarget.field_70161_v)));
    }

    public void func_75249_e() {
        this.mCreature.func_70661_as().func_75484_a(this.mPath, this.mSpeedToTarget);
        this.mPathCoolDown = 0;
    }

    public void func_75251_c() {
        this.mCreature.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase tTarget = this.mCreature.func_70638_az();
        this.mCreature.func_70671_ap().func_75651_a((Entity)tTarget, 30.0f, 30.0f);
        double tTargetDistance = this.mCreature.func_70092_e(tTarget.field_70165_t, tTarget.field_70121_D.field_72338_b, tTarget.field_70161_v);
        double tLookRadius = this.mCreature.field_70130_N * this.mCreature.field_70130_N * 4.0f + tTarget.field_70130_N;
        --this.mPathCoolDown;
        if ((this.mLastingMemory || this.mCreature.func_70635_at().func_75522_a((Entity)tTarget)) && this.mPathCoolDown <= 0 && (this.mX == 0.0 && this.mY == 0.0 && this.mZ == 0.0 || tTarget.func_70092_e(this.mX, this.mY, this.mZ) >= 1.0 || this.mCreature.func_70681_au().nextFloat() < 0.05f)) {
            PathPoint tPathPoint;
            this.mX = tTarget.field_70165_t;
            this.mY = tTarget.field_70121_D.field_72338_b;
            this.mZ = tTarget.field_70161_v;
            this.mPathCoolDown = this.mFailedPathFindingPenalty + 4 + this.mCreature.func_70681_au().nextInt(7);
            this.mFailedPathFindingPenalty = this.mCreature.func_70661_as().func_75505_d() != null ? ((tPathPoint = this.mCreature.func_70661_as().func_75505_d().func_75870_c()) != null && tTarget.func_70092_e((double)tPathPoint.field_75839_a, (double)tPathPoint.field_75837_b, (double)tPathPoint.field_75838_c) < 1.0 ? 0 : (this.mFailedPathFindingPenalty += 10)) : (this.mFailedPathFindingPenalty += 10);
            if (tTargetDistance > 1024.0) {
                this.mPathCoolDown += 10;
            } else if (tTargetDistance > 256.0) {
                this.mPathCoolDown += 5;
            }
            if (!this.mCreature.func_70661_as().func_75497_a((Entity)tTarget, this.mSpeedToTarget)) {
                this.mPathCoolDown += 15;
            }
        }
        this.mAttackCoolDown = Math.max(this.mAttackCoolDown - 1, 0);
        if (tTargetDistance <= tLookRadius && this.mAttackCoolDown <= 0) {
            this.mAttackCoolDown = 5;
            boolean tAttacking = true;
            ItemStack tHeld = ST.valisize(this.mCreature.func_70694_bm());
            if (tHeld != null) {
                this.mCreature.func_71038_i();
                if (CS.ZOMBIES_IGNITE_HELD_TNT && ST.equal_(tHeld, Blocks.field_150335_W)) {
                    this.mAttackCoolDown = 20;
                    tAttacking = false;
                    if (--tHeld.field_77994_a <= 0) {
                        this.mCreature.func_70062_b(0, CS.NI);
                    }
                    if (!this.mWorld.field_72995_K) {
                        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(this.mWorld, this.mCreature.field_70165_t, this.mCreature.field_70163_u, this.mCreature.field_70161_v, (EntityLivingBase)this.mCreature);
                        this.mWorld.func_72838_d((Entity)entitytntprimed);
                        this.mWorld.func_72956_a((Entity)entitytntprimed, "game.tnt.primed", 1.0f, 1.0f);
                    }
                } else if (CS.ZOMBIES_DIG_WITH_TOOLS) {
                    // empty if block
                }
            }
            if (tAttacking) {
                this.mCreature.func_70652_k((Entity)tTarget);
            }
        }
    }
}

