/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen.dungeon;

import gregapi.block.IBlockPlacable;
import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.OP;
import gregapi.fluid.FluidTankGT;
import gregapi.oredict.OreDictMaterial;
import gregapi.random.WorldAndCoords;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.worldgen.dungeon.WorldgenDungeonGT;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFlowerPot;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;

public class DungeonData
extends WorldAndCoords {
    public final MultiTileEntityRegistry mMTERegistryGT;
    public final BlockStones mPrimary;
    public final BlockStones mSecondary;
    public final byte mColor;
    public final byte mColorInversed;
    public final byte[][] mRoomLayout;
    public final int mRoomX;
    public final int mRoomZ;
    public final int mConnectionCount;
    public final long[] mKeyIDs;
    public final ItemStack[] mKeyStacks;
    public final boolean[] mGeneratedKeys;
    public final HashSetNoNulls<ChunkCoordinates> mLightUpdateCoords;
    public final HashSetNoNulls<TagData> mTags;
    public final WorldgenDungeonGT mStructure;
    public final NBTTagCompound mCoin;
    public final Random mRandom;

    public DungeonData(World aWorld, int aX, int aY, int aZ, WorldgenDungeonGT aStructure, BlockStones aPrimaryBlock, BlockStones aSecondaryBlock, MultiTileEntityRegistry aRegistry, HashSetNoNulls<ChunkCoordinates> aLightUpdateCoords, HashSetNoNulls<TagData> aTags, long[] aKeyIDs, ItemStack[] aKeyStacks, boolean[] aGeneratedKeys, byte[][] aRoomLayout, int aRoomX, int aRoomZ, int aConnectionCount, int aColor, Random aRandom, NBTTagCompound aCoin) {
        super(aWorld, aX, aY, aZ);
        this.mStructure = aStructure;
        this.mPrimary = aPrimaryBlock;
        this.mSecondary = aSecondaryBlock;
        this.mMTERegistryGT = aRegistry;
        this.mRoomLayout = aRoomLayout;
        this.mRoomX = aRoomX;
        this.mRoomZ = aRoomZ;
        this.mConnectionCount = aConnectionCount;
        this.mKeyIDs = aKeyIDs;
        this.mKeyStacks = aKeyStacks;
        this.mGeneratedKeys = aGeneratedKeys;
        this.mLightUpdateCoords = aLightUpdateCoords;
        this.mTags = aTags;
        this.mColor = UT.Code.bind4(aColor);
        this.mColorInversed = UT.Code.bind4(15 - aColor);
        this.mCoin = aCoin;
        this.mRandom = aRandom;
    }

    public int next(int aNumber) {
        return this.mRandom.nextInt(aNumber);
    }

    public int nextStack() {
        return 1 + this.mRandom.nextInt(64);
    }

    public int nextMetaA() {
        return this.next1in3() ? this.mColor : this.next(16);
    }

    public int nextMetaB() {
        return this.next1in3() ? this.mColorInversed : this.next(16);
    }

    public boolean next1in2() {
        return this.mRandom.nextBoolean();
    }

    public boolean next1in3() {
        return this.next(3) < 1;
    }

    public boolean next1in4() {
        return this.next(4) < 1;
    }

    public boolean next1in5() {
        return this.next(5) < 1;
    }

    public boolean next1in6() {
        return this.next(6) < 1;
    }

    public boolean next1in7() {
        return this.next(7) < 1;
    }

    public boolean next1in8() {
        return this.next(8) < 1;
    }

    public boolean next1in9() {
        return this.next(9) < 1;
    }

    public boolean next2in3() {
        return this.next(3) < 2;
    }

    public boolean next2in5() {
        return this.next(5) < 2;
    }

    public boolean next2in7() {
        return this.next(7) < 2;
    }

    public boolean next2in9() {
        return this.next(9) < 2;
    }

    public boolean next3in4() {
        return this.next(4) < 3;
    }

    public boolean next3in5() {
        return this.next(5) < 3;
    }

    public boolean next3in7() {
        return this.next(7) < 3;
    }

    public boolean next3in8() {
        return this.next(8) < 3;
    }

    public boolean next4in5() {
        return this.next(5) < 4;
    }

    public boolean next4in7() {
        return this.next(7) < 4;
    }

    public boolean next4in9() {
        return this.next(9) < 4;
    }

    public boolean next5in6() {
        return this.next(6) < 5;
    }

    public boolean next5in7() {
        return this.next(7) < 5;
    }

    public boolean next5in8() {
        return this.next(8) < 5;
    }

    public boolean next5in9() {
        return this.next(9) < 5;
    }

    public boolean next6in7() {
        return this.next(7) < 6;
    }

    public boolean next7in8() {
        return this.next(8) < 7;
    }

    public boolean next7in9() {
        return this.next(9) < 7;
    }

    public boolean next8in9() {
        return this.next(9) < 8;
    }

    public boolean bricks(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 3 + this.next(3), 2);
    }

    public boolean cobbles(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 1 + this.next(2), 2);
    }

    public boolean cobble(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 1, 2);
    }

    public boolean mossycobble(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 2, 2);
    }

    public boolean brick(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 3, 2);
    }

    public boolean redstoned(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 9, 3);
    }

    public boolean cracked(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 4, 2);
    }

    public boolean mossy(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 5, 2);
    }

    public boolean chiseled(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 6, 2);
    }

    public boolean tiles(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 10, 2);
    }

    public boolean smalltiles(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 11, 2);
    }

    public boolean smallbricks(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 12, 2);
    }

    public boolean smooth(int aX, int aY, int aZ, Block aPrimary, Block aSecondary) {
        return this.set(aX, aY, aZ, aY == 2 ? aSecondary : aPrimary, 7, 2);
    }

    public boolean bricks(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 3 + this.next(3), 2);
    }

    public boolean cobbles(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 1 + this.next(2), 2);
    }

    public boolean cobble(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 1, 2);
    }

    public boolean mossycobble(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 2, 2);
    }

    public boolean brick(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 3, 2);
    }

    public boolean redstoned(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 9, 3);
    }

    public boolean cracked(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 4, 2);
    }

    public boolean mossy(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 5, 2);
    }

    public boolean chiseled(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 6, 2);
    }

    public boolean tiles(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 10, 2);
    }

    public boolean smalltiles(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 11, 2);
    }

    public boolean smallbricks(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 12, 2);
    }

    public boolean smooth(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, aY == 2 ? this.mSecondary : this.mPrimary, 7, 2);
    }

    public boolean air(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, CS.NB, 0, 2);
    }

    public boolean glass(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, CS.BlocksGT.Glass, (int)this.mColor, 2);
    }

    public boolean glassglow(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, CS.BlocksGT.GlowGlass, (int)this.mColor, 2);
    }

    public boolean colored(int aX, int aY, int aZ) {
        return this.set(aX, aY, aZ, CS.BlocksGT.Concrete, (int)this.mColor, 2);
    }

    public boolean lamp(int aX, int aY, int aZ, Block aPrimary, Block aSecondary, int aGenerateRedstoneBrick) {
        this.mLightUpdateCoords.add(new ChunkCoordinates(this.mX + aX, this.mY + aY, this.mZ + aZ));
        if (aGenerateRedstoneBrick != 0) {
            this.redstoned(aX, aY + aGenerateRedstoneBrick, aZ);
        }
        return this.set(aX, aY, aZ, aGenerateRedstoneBrick == 0 ? Blocks.field_150379_bu : Blocks.field_150374_bv, 0, 2);
    }

    public boolean lamp(int aX, int aY, int aZ, int aGenerateRedstoneBrick) {
        this.mLightUpdateCoords.add(new ChunkCoordinates(this.mX + aX, this.mY + aY, this.mZ + aZ));
        if (aGenerateRedstoneBrick != 0) {
            this.redstoned(aX, aY + aGenerateRedstoneBrick, aZ);
        }
        return this.set(aX, aY, aZ, aGenerateRedstoneBrick == 0 ? Blocks.field_150379_bu : Blocks.field_150374_bv, 0, 2);
    }

    public boolean coins(int aX, int aY, int aZ) {
        for (int i = 0; i < 16; ++i) {
            this.mCoin.func_74774_a("gt.coin.stacksize." + i, (byte)(this.next1in3() ? this.next(8) : 0));
        }
        this.mCoin.func_74774_a("gt.coin.stacksize." + this.next(16), (byte)(1 + this.next(8)));
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)32700, this.mCoin, true, true);
    }

    public boolean set(int aX, int aY, int aZ, long aMeta) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, null, true, true);
    }

    public boolean set(int aX, int aY, int aZ, byte aSide, long aMeta) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, null, true, true);
    }

    public boolean set(int aX, int aY, int aZ, long aMeta, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, null, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean set(int aX, int aY, int aZ, byte aSide, long aMeta, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, null, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean set(int aX, int aY, int aZ, long aMeta, NBTTagCompound aNBT) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, aNBT, true, true);
    }

    public boolean set(int aX, int aY, int aZ, byte aSide, long aMeta, NBTTagCompound aNBT) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, aNBT, true, true);
    }

    public boolean set(int aX, int aY, int aZ, long aMeta, NBTTagCompound aNBT, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, aNBT, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean set(int aX, int aY, int aZ, byte aSide, long aMeta, NBTTagCompound aNBT, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return this.mMTERegistryGT.mBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, aNBT, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, long[] aMetas) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMetas[this.next(aMetas.length)], null, true, true);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, OreDictMaterial ... aMaterials) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, aMaterials[this.next((int)aMaterials.length)].mID, null, true, true);
    }

    public boolean set(IBlockPlacable[] aBlocks, int aX, int aY, int aZ, long[] aMetas) {
        return aBlocks[this.next(aBlocks.length)].placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMetas[this.next(aMetas.length)], null, true, true);
    }

    public boolean set(IBlockPlacable[] aBlocks, int aX, int aY, int aZ, OreDictMaterial ... aMaterials) {
        return aBlocks[this.next(aBlocks.length)].placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, aMaterials[this.next((int)aMaterials.length)].mID, null, true, true);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, long aMeta) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, null, true, true);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, byte aSide, long aMeta) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, null, true, true);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, long aMeta, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, null, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, byte aSide, long aMeta, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, null, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, long aMeta, NBTTagCompound aNBT) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, aNBT, true, true);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, byte aSide, long aMeta, NBTTagCompound aNBT) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, aNBT, true, true);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, long aMeta, NBTTagCompound aNBT, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, (byte)6, (short)aMeta, aNBT, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean set(IBlockPlacable aBlock, int aX, int aY, int aZ, byte aSide, long aMeta, NBTTagCompound aNBT, boolean aCauseBlockUpdates, boolean aForcePlacement) {
        return aBlock.placeBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, aSide, (short)aMeta, aNBT, aCauseBlockUpdates, aForcePlacement);
    }

    public boolean obsidian(int aX, int aY, int aZ, boolean aGravity) {
        return this.set(aX, aY, aZ, Blocks.field_150343_Z, 0, IL.NeLi_Obsidian.exists() ? IL.NeLi_Obsidian.block() : IL.NePl_Obsidian.block(), 0, IL.EtFu_Obsidian.block(), 0, !aGravity ? Blocks.field_150343_Z : (IL.RC_Crushed_Obsidian.exists() ? IL.RC_Crushed_Obsidian.block() : (IL.HBM_Crushed_Obsidian.exists() ? IL.HBM_Crushed_Obsidian.block() : Blocks.field_150343_Z)), aGravity && IL.RC_Crushed_Obsidian.exists() ? 4 : 0);
    }

    public boolean flower(int aX, int aY, int aZ) {
        return this.flower(aX, aY, aZ, false, false);
    }

    public boolean flower(int aX, int aY, int aZ, boolean aGrassOnly, boolean aVanillaOnly) {
        if (CS.BlocksGT.FlowersA != null) {
            if (aGrassOnly || CS.BlocksGT.FlowersB == null) {
                if (this.next1in2()) {
                    return this.set(aX, aY, aZ, (Block)CS.BlocksGT.FlowersA, this.next(CS.BlocksGT.FlowersA.maxMeta()), 2);
                }
            } else {
                switch (this.next(3)) {
                    case 0: {
                        return this.set(aX, aY, aZ, (Block)CS.BlocksGT.FlowersA, this.next(CS.BlocksGT.FlowersA.maxMeta()), 2);
                    }
                    case 1: {
                        return this.set(aX, aY, aZ, (Block)CS.BlocksGT.FlowersB, this.next(CS.BlocksGT.FlowersB.maxMeta()), 2);
                    }
                }
            }
        }
        int tIndex = this.next(CS.BlocksGT.FLOWER_TILES.length);
        return this.set(aX, aY, aZ, CS.BlocksGT.FLOWER_TILES[tIndex], (int)CS.BlocksGT.FLOWER_METAS[tIndex], 2);
    }

    public boolean ingots_or_plates(int aX, int aY, int aZ, long aStackSize, OreDictMaterial ... aMaterials) {
        ItemStack aIngot = OP.ingot.mat(aMaterials[this.next(aMaterials.length)], aStackSize <= 0L ? (long)this.nextStack() : (long)UT.Code.bindStack(aStackSize));
        ItemStack aPlate = OP.plate.mat(aMaterials[this.next(aMaterials.length)], aStackSize <= 0L ? (long)this.nextStack() : (long)UT.Code.bindStack(aStackSize));
        if (ST.valid(aIngot)) {
            return ST.valid(aPlate) && this.next1in2() ? this.set(aX, aY, aZ, 32085L, ST.save("gt.value", aPlate)) : this.set(aX, aY, aZ, 32084L, ST.save("gt.value", aIngot));
        }
        return ST.valid(aPlate) && this.set(aX, aY, aZ, 32085L, ST.save("gt.value", aPlate));
    }

    public boolean ingots(int aX, int aY, int aZ, long aStackSize, OreDictMaterial ... aMaterials) {
        ItemStack aStack = OP.ingot.mat(aMaterials[this.next(aMaterials.length)], aStackSize <= 0L ? (long)this.nextStack() : (long)UT.Code.bindStack(aStackSize));
        return ST.valid(aStack) && this.set(aX, aY, aZ, 32084L, ST.save("gt.value", aStack));
    }

    public boolean plates(int aX, int aY, int aZ, long aStackSize, OreDictMaterial ... aMaterials) {
        ItemStack aStack = OP.plate.mat(aMaterials[this.next(aMaterials.length)], aStackSize <= 0L ? (long)this.nextStack() : (long)UT.Code.bindStack(aStackSize));
        return ST.valid(aStack) && this.set(aX, aY, aZ, 32085L, ST.save("gt.value", aStack));
    }

    public boolean gemplates(int aX, int aY, int aZ, long aStackSize, OreDictMaterial ... aMaterials) {
        ItemStack aStack = OP.plateGem.mat(aMaterials[this.next(aMaterials.length)], aStackSize <= 0L ? (long)this.nextStack() : (long)UT.Code.bindStack(aStackSize));
        return ST.valid(aStack) && this.set(aX, aY, aZ, 32086L, ST.save("gt.value", aStack));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, new Object[0]));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String aLootFront) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", aLootFront));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String aLootFront, NBTTagList aInventory) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", aLootFront, "gt.invlist", aInventory));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String aLootFront, String aLootBack) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", aLootFront, "gt.dungeonloot.back", aLootBack));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String aLootFront, String aLootBack, NBTTagList aInventory) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", aLootFront, "gt.dungeonloot.back", aLootBack, "gt.invlist", aInventory));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String[] aLootFront) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", UT.Code.select("strongholdLibrary", aLootFront)));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String[] aLootFront, NBTTagList aInventory) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", UT.Code.select("strongholdLibrary", aLootFront), "gt.invlist", aInventory));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String[] aLootFront, String[] aLootBack) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", UT.Code.select("strongholdLibrary", aLootFront), "gt.dungeonloot.back", UT.Code.select("strongholdLibrary", aLootBack)));
    }

    public boolean shelf(int aX, int aY, int aZ, long aMeta, byte aFacing, String[] aLootFront, String[] aLootBack, NBTTagList aInventory) {
        return this.set(aX, aY, aZ, aMeta, UT.NBT.make("gt.facing", (Object)aFacing, "gt.dungeonloot.front", UT.Code.select("strongholdLibrary", aLootFront), "gt.dungeonloot.back", UT.Code.select("strongholdLibrary", aLootBack), "gt.invlist", aInventory));
    }

    public boolean zpm(int aX, int aY, int aZ) {
        return this.zpm(aX, aY, aZ, this.next2in3());
    }

    public boolean zpm(int aX, int aY, int aZ, boolean aActive) {
        return this.mStructure.mZPM && this.set(aX, aY, aZ, 14999L, UT.NBT.make("gt.active.energy", (Object)aActive, new Object[0]));
    }

    public boolean cup(int aX, int aY, int aZ, FL aFluid) {
        return this.set(aX, aY, aZ, 32739L, FluidTankGT.writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYES_INT[this.mColor], "gt.painted", true), "gt.tank", aFluid == null ? null : aFluid.make(250L)));
    }

    public boolean cup(int aX, int aY, int aZ, Fluid aFluid) {
        return this.set(aX, aY, aZ, 32739L, FluidTankGT.writeToNBT(UT.NBT.make("gt.color", (Object)CS.DYES_INT[this.mColor], "gt.painted", true), "gt.tank", FL.make(aFluid, 250L)));
    }

    public boolean cup(int aX, int aY, int aZ, FL aFluid, Block aBlock, int aMeta) {
        if (aBlock != CS.NB && aBlock != null && this.next1in2()) {
            return this.set(aX, aY, aZ, aBlock, aMeta, 2);
        }
        return this.cup(aX, aY, aZ, aFluid);
    }

    public boolean cup(int aX, int aY, int aZ, Fluid aFluid, Block aBlock, int aMeta) {
        if (aBlock != CS.NB && aBlock != null && this.next1in2()) {
            return this.set(aX, aY, aZ, aBlock, aMeta, 2);
        }
        return this.cup(aX, aY, aZ, aFluid);
    }

    public boolean pot(int aX, int aY, int aZ) {
        int tIndex = this.next(CS.BlocksGT.POT_FLOWER_TILES.length);
        this.set(aX, aY, aZ, Blocks.field_150457_bL, 0, 2);
        TileEntity tTileEntity = this.mWorld.func_147438_o(this.mX + aX, this.mY + aY, this.mZ + aZ);
        if (tTileEntity instanceof TileEntityFlowerPot) {
            if (this.next1in2()) {
                ((TileEntityFlowerPot)tTileEntity).func_145964_a(ST.item(CS.BlocksGT.POT_FLOWER_TILES[tIndex]), (int)CS.BlocksGT.POT_FLOWER_METAS[tIndex]);
            } else if (this.next1in2()) {
                ((TileEntityFlowerPot)tTileEntity).func_145964_a(ST.item((Block)CS.BlocksGT.FlowersA), this.next(CS.BlocksGT.FlowersA.maxMeta()));
            } else {
                ((TileEntityFlowerPot)tTileEntity).func_145964_a(ST.item((Block)CS.BlocksGT.FlowersB), this.next(CS.BlocksGT.FlowersB.maxMeta()));
            }
        }
        return true;
    }

    public boolean pot(int aX, int aY, int aZ, Block aBlock, int aMeta) {
        if (aBlock != CS.NB && aBlock != null && this.next1in2()) {
            return this.set(aX, aY, aZ, aBlock, aMeta, 2);
        }
        return this.pot(aX, aY, aZ);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock) {
        return this.mWorld.func_147465_d(this.mX + aX, this.mY + aY, this.mZ + aZ, aBlock, 0, 2);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock, int aMeta) {
        return this.mWorld.func_147465_d(this.mX + aX, this.mY + aY, this.mZ + aZ, aBlock, aMeta, 2);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags) {
        return this.mWorld.func_147465_d(this.mX + aX, this.mY + aY, this.mZ + aZ, aBlock, aMeta, aFlags);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock, int aMeta, int aFlags, int aRotationCount) {
        if (!this.set(aX, aY, aZ, aBlock, aMeta, aFlags)) {
            return false;
        }
        while (aRotationCount-- > 0) {
            aBlock.rotateBlock(this.mWorld, this.mX + aX, this.mY + aY, this.mZ + aZ, CS.FORGE_DIR[1]);
        }
        return true;
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock1, int aMeta1, Block aBlock2, int aMeta2) {
        return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock2, aMeta2, 2);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock1, int aMeta1, Block aBlock2, int aMeta2, int aFlags) {
        if (aBlock1 == CS.NB || aBlock1 == null) {
            return this.set(aX, aY, aZ, aBlock2, aMeta2, aFlags);
        }
        if (aBlock2 == CS.NB || aBlock2 == null) {
            return this.set(aX, aY, aZ, aBlock1, aMeta1, aFlags);
        }
        switch (this.next(2)) {
            case 0: {
                return this.set(aX, aY, aZ, aBlock1, aMeta1, aFlags);
            }
        }
        return this.set(aX, aY, aZ, aBlock2, aMeta2, aFlags);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock1, int aMeta1, Block aBlock2, int aMeta2, Block aBlock3, int aMeta3) {
        return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock2, aMeta2, aBlock3, aMeta3, 2);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock1, int aMeta1, Block aBlock2, int aMeta2, Block aBlock3, int aMeta3, int aFlags) {
        if (aBlock1 == CS.NB || aBlock1 == null) {
            return this.set(aX, aY, aZ, aBlock2, aMeta2, aBlock3, aMeta3, aFlags);
        }
        if (aBlock2 == CS.NB || aBlock2 == null) {
            return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock3, aMeta3, aFlags);
        }
        if (aBlock3 == CS.NB || aBlock3 == null) {
            return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock2, aMeta2, aFlags);
        }
        switch (this.next(3)) {
            case 0: {
                return this.set(aX, aY, aZ, aBlock1, aMeta1, aFlags);
            }
            case 1: {
                return this.set(aX, aY, aZ, aBlock2, aMeta2, aFlags);
            }
        }
        return this.set(aX, aY, aZ, aBlock3, aMeta3, aFlags);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock1, int aMeta1, Block aBlock2, int aMeta2, Block aBlock3, int aMeta3, Block aBlock4, int aMeta4) {
        return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock2, aMeta2, aBlock3, aMeta3, aBlock4, aMeta4, 2);
    }

    public boolean set(int aX, int aY, int aZ, Block aBlock1, int aMeta1, Block aBlock2, int aMeta2, Block aBlock3, int aMeta3, Block aBlock4, int aMeta4, int aFlags) {
        if (aBlock1 == CS.NB || aBlock1 == null) {
            return this.set(aX, aY, aZ, aBlock2, aMeta2, aBlock3, aMeta3, aBlock4, aMeta4, aFlags);
        }
        if (aBlock2 == CS.NB || aBlock2 == null) {
            return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock3, aMeta3, aBlock4, aMeta4, aFlags);
        }
        if (aBlock3 == CS.NB || aBlock3 == null) {
            return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock2, aMeta2, aBlock4, aMeta4, aFlags);
        }
        if (aBlock4 == CS.NB || aBlock4 == null) {
            return this.set(aX, aY, aZ, aBlock1, aMeta1, aBlock2, aMeta2, aBlock3, aMeta3, aFlags);
        }
        switch (this.next(4)) {
            case 0: {
                return this.set(aX, aY, aZ, aBlock1, aMeta1, aFlags);
            }
            case 1: {
                return this.set(aX, aY, aZ, aBlock2, aMeta2, aFlags);
            }
            case 2: {
                return this.set(aX, aY, aZ, aBlock3, aMeta3, aFlags);
            }
        }
        return this.set(aX, aY, aZ, aBlock4, aMeta4, aFlags);
    }
}

