/*
 * Decompiled with CFR 0.152.
 */
package gregapi.wooddict;

import gregapi.code.HashSetNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.render.IconContainerCopied;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.wooddict.BeamEntry;
import gregapi.wooddict.WoodDictionary;
import gregapi.wooddict.WoodEntry;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;

public class PlankEntry {
    public final Set<WoodEntry> mWoodEntries = new HashSetNoNulls<WoodEntry>();
    public final Set<BeamEntry> mBeamEntries = new HashSetNoNulls<BeamEntry>();
    public ItemStack mPlank;
    public ItemStack mSlab;
    public ItemStack mStair;
    public ItemStack mStick;
    public OreDictMaterial mMaterialPlank = MT.Wood;
    public int mPlankIndex;
    public int mStickCountHand = 1;
    public int mStickCountSaw = 2;
    public int mStickCountLathe = 2;

    public PlankEntry(ItemStack aPlank) {
        this(aPlank, -1);
    }

    public PlankEntry(ItemStack aPlank, int aPlankIndex) {
        this(aPlank, IL.Plank_Slab.get(1L, ST.make((Block)Blocks.field_150376_bx, 1L, 0L)), aPlankIndex);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab) {
        this(aPlank, aSlab, -1);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, int aPlankIndex) {
        this(aPlank, aSlab, IL.Plank_Stairs.get(1L, ST.make(Blocks.field_150476_ad, 1L, 0L)), aPlankIndex);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, ItemStack aStair) {
        this(aPlank, aSlab, aStair, -1);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, ItemStack aStair, int aPlankIndex) {
        this(aPlank, aSlab, aStair, MT.Wood, aPlankIndex);
    }

    public PlankEntry(ItemStack aPlank, OreDictMaterial aMaterialPlank) {
        this(aPlank, aMaterialPlank, -1);
    }

    public PlankEntry(ItemStack aPlank, OreDictMaterial aMaterialPlank, int aPlankIndex) {
        this(aPlank, IL.Plank_Slab.get(1L, ST.make((Block)Blocks.field_150376_bx, 1L, 0L)), aMaterialPlank, aPlankIndex, aMaterialPlank == MT.Wood ? IL.Stick.get(1L, new Object[0]) : OP.stick.mat(aMaterialPlank, 1L));
    }

    public PlankEntry(ItemStack aPlank, OreDictMaterial aMaterialPlank, int aPlankIndex, ItemStack aStick) {
        this(aPlank, IL.Plank_Slab.get(1L, ST.make((Block)Blocks.field_150376_bx, 1L, 0L)), aMaterialPlank, aPlankIndex, aStick);
    }

    public PlankEntry(ItemStack aPlank, OreDictMaterial aMaterialPlank, int aPlankIndex, ItemStack aStick, int aStickCountHand, int aStickCountSaw, int aStickCountLathe) {
        this(aPlank, IL.Plank_Slab.get(1L, ST.make((Block)Blocks.field_150376_bx, 1L, 0L)), aMaterialPlank, aPlankIndex, aStick, aStickCountHand, aStickCountSaw, aStickCountLathe);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, OreDictMaterial aMaterialPlank) {
        this(aPlank, aSlab, aMaterialPlank, -1);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, OreDictMaterial aMaterialPlank, int aPlankIndex) {
        this(aPlank, aSlab, aMaterialPlank, aPlankIndex, aMaterialPlank == MT.Wood ? IL.Stick.get(1L, new Object[0]) : OP.stick.mat(aMaterialPlank, 1L));
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, OreDictMaterial aMaterialPlank, int aPlankIndex, ItemStack aStick) {
        this(aPlank, aSlab, aMaterialPlank, aPlankIndex, aStick, 1, 2, 2);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, OreDictMaterial aMaterialPlank, int aPlankIndex, ItemStack aStick, int aStickCountHand, int aStickCountSaw, int aStickCountLathe) {
        this(aPlank, aSlab, IL.Plank_Stairs.get(1L, ST.make(Blocks.field_150476_ad, 1L, 0L)), aMaterialPlank, aPlankIndex, aStick, aStickCountHand, aStickCountSaw, aStickCountLathe);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, ItemStack aStair, OreDictMaterial aMaterialPlank) {
        this(aPlank, aSlab, aStair, aMaterialPlank, -1);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, ItemStack aStair, OreDictMaterial aMaterialPlank, int aPlankIndex) {
        this(aPlank, aSlab, aStair, aMaterialPlank, aPlankIndex, aMaterialPlank == MT.Wood ? IL.Stick.get(1L, new Object[0]) : OP.stick.mat(aMaterialPlank, 1L));
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, ItemStack aStair, OreDictMaterial aMaterialPlank, int aPlankIndex, ItemStack aStick) {
        this(aPlank, aSlab, aStair, aMaterialPlank, aPlankIndex, aStick, 1, 2, 2);
    }

    public PlankEntry(ItemStack aPlank, ItemStack aSlab, ItemStack aStair, OreDictMaterial aMaterialPlank, int aPlankIndex, ItemStack aStick, int aStickCountHand, int aStickCountSaw, int aStickCountLathe) {
        int i;
        if (ST.invalid(aPlank)) {
            return;
        }
        this.mPlank = ST.amount(1L, aPlank);
        this.mStair = ST.amount(1L, aStair);
        this.mSlab = ST.amount(1L, aSlab);
        this.mStick = ST.amount(1L, aStick);
        this.mStickCountHand = aStickCountHand;
        this.mStickCountSaw = aStickCountSaw;
        this.mStickCountLathe = aStickCountLathe;
        this.mMaterialPlank = aMaterialPlank;
        this.mPlankIndex = aPlankIndex;
        if (this.mPlankIndex < 0 || this.mPlankIndex >= CS.PlankData.PLANK_ENTRIES.length) {
            this.mPlankIndex = 0;
        } else if (CS.PlankData.PLANK_ENTRIES[this.mPlankIndex] == null) {
            CS.PlankData.PLANK_ENTRIES[this.mPlankIndex] = this;
            CS.PlankData.PLANKS[this.mPlankIndex] = ST.amount(1L, this.mPlank);
            CS.PlankData.PLANK_ICONS[this.mPlankIndex] = new IconContainerCopied(ST.block(this.mPlank), ST.meta_(this.mPlank), 6L);
        }
        if (ST.valid(this.mPlank) && !WoodDictionary.PLANKS.containsKey(new ItemStackContainer(this.mPlank))) {
            if (ST.meta(this.mPlank) == Short.MAX_VALUE) {
                for (i = 0; i < 16; ++i) {
                    ItemStack tPlank = ST.copyMeta(i, this.mPlank);
                    if (!OM.materialcontained(tPlank, true, MT.Wood, MT.WoodRubber, ANY.Wood)) continue;
                    OreDictManager.INSTANCE.setItemData_(tPlank, new OreDictItemData(this.mMaterialPlank, 648648000L, new OreDictMaterialStack[0]));
                }
            }
            if (OM.materialcontained(this.mPlank, true, MT.Wood, MT.WoodRubber, ANY.Wood)) {
                OreDictManager.INSTANCE.setItemData_(this.mPlank, new OreDictItemData(this.mMaterialPlank, 648648000L, new OreDictMaterialStack[0]));
            }
            WoodDictionary.PLANKS_ANY.put(this.mPlank, this);
            WoodDictionary.PLANKS.put(this.mPlank, this);
            WoodDictionary.LIST_PLANKS_ANY.add(this);
            WoodDictionary.LIST_PLANKS.add(this);
            WoodDictionary.IGNORED_OREDICT_REGISTRATIONS.add(ST.item_(this.mPlank));
        }
        if (ST.valid(this.mStair) && !WoodDictionary.STAIRS.containsKey(new ItemStackContainer(this.mStair))) {
            if (ST.meta(this.mStair) == Short.MAX_VALUE) {
                for (i = 0; i < 16; ++i) {
                    ItemStack tStair = ST.copyMeta(i, this.mStair);
                    if (!OM.materialcontained(tStair, true, MT.Wood, MT.WoodRubber, ANY.Wood)) continue;
                    OreDictManager.INSTANCE.setItemData_(tStair, new OreDictItemData(this.mMaterialPlank, 486486000L, new OreDictMaterialStack[0]));
                }
            }
            if (OM.materialcontained(this.mStair, true, MT.Wood, MT.WoodRubber, ANY.Wood)) {
                OreDictManager.INSTANCE.setItemData_(this.mStair, new OreDictItemData(this.mMaterialPlank, 486486000L, new OreDictMaterialStack[0]));
            }
            WoodDictionary.PLANKS_ANY.put(this.mStair, this);
            WoodDictionary.STAIRS.put(this.mStair, this);
            WoodDictionary.LIST_PLANKS_ANY.add(this);
            WoodDictionary.LIST_STAIRS.add(this);
            WoodDictionary.IGNORED_OREDICT_REGISTRATIONS.add(ST.item_(this.mStair));
        }
        if (ST.valid(this.mSlab) && !WoodDictionary.SLABS.containsKey(new ItemStackContainer(this.mSlab))) {
            if (ST.meta(this.mSlab) == Short.MAX_VALUE) {
                for (i = 0; i < 16; ++i) {
                    ItemStack tSlab = ST.copyMeta(i, this.mSlab);
                    if (!OM.materialcontained(tSlab, true, MT.Wood, MT.WoodRubber, ANY.Wood)) continue;
                    OreDictManager.INSTANCE.setItemData_(tSlab, new OreDictItemData(this.mMaterialPlank, 324324000L, new OreDictMaterialStack[0]));
                }
            }
            if (OM.materialcontained(this.mSlab, true, MT.Wood, MT.WoodRubber, ANY.Wood)) {
                OreDictManager.INSTANCE.setItemData_(this.mSlab, new OreDictItemData(this.mMaterialPlank, 324324000L, new OreDictMaterialStack[0]));
            }
            WoodDictionary.PLANKS_ANY.put(this.mSlab, this);
            WoodDictionary.SLABS.put(this.mSlab, this);
            WoodDictionary.LIST_PLANKS_ANY.add(this);
            WoodDictionary.LIST_SLABS.add(this);
            WoodDictionary.IGNORED_OREDICT_REGISTRATIONS.add(ST.item_(this.mSlab));
        }
    }
}

