/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.OP;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.connectors.MultiTileEntityWireRedstoneInsulated;
import gregapi.util.UT;
import net.minecraft.nbt.NBTTagCompound;

public class MultiTileEntityWireRedstone
extends MultiTileEntityWireRedstoneInsulated
implements IMultiTileEntity.IMTE_GetLightValue {
    public byte mState = 0;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.func_74764_b("gt.state")) {
            this.mState = aNBT.func_74771_c("gt.state");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mState != 0) {
            aNBT.func_74774_a("gt.state", this.mState);
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        byte tOldState = this.mState;
        this.mState = UT.Code.bind4(UT.Code.divup(this.mRedstone, Integer.MAX_VALUE));
        if (tOldState != this.mState) {
            if (this.mIsGlowing) {
                this.updateLightValue();
            }
            return true;
        }
        return super.onTickCheck(aTimer);
    }

    @Override
    public void setVisualData(byte aData) {
        if (aData != this.mState) {
            this.mState = aData;
            if (this.mIsGlowing) {
                this.updateLightValue();
            }
        }
    }

    @Override
    public byte getVisualData() {
        return this.mState;
    }

    @Override
    public int getLightOpacity() {
        return this.mIsGlowing ? 0 : super.getLightOpacity();
    }

    @Override
    public int getLightValue() {
        return this.mIsGlowing ? this.mState : (byte)0;
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexSide(aSide, aConnections, aDiameter, aRenderPass), this.mState > 0, this.mRGBa);
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mState > 0, this.mRGBa);
    }

    @Override
    public ITexture getTextureCFoam(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.CFOAM_FRESH, this.mRGBa, this.mIsGlowing && this.mState > 0);
    }

    @Override
    public ITexture getTextureCFoamDry(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.CFOAM_HARDENED, this.mRGBa, this.mIsGlowing && this.mState > 0);
    }

    @Override
    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.wire.redstone";
    }
}

