/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;

public class RecipeMapFluidCanner
extends Recipe.RecipeMap {
    public RecipeMapFluidCanner(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal, aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
        this.mMaxFluidOutputSize = 128000;
        this.mMaxFluidInputSize = 128000;
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aInputs.length <= 0 || rRecipe != null || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        for (ItemStack tInput : aInputs) {
            if (!ST.valid(tInput)) continue;
            FluidStack tFluid = FL.getFluid(tInput, true);
            if (tFluid != null) {
                return FL.invalid(tFluid) ? null : new Recipe(false, false, false, ST.array(ST.amount(1L, tInput)), ST.array(ST.container(tInput, true)), null, null, CS.ZL_FS, FL.array(tFluid), Math.max(tFluid.amount / 64, 16), 16L, 0L);
            }
            if (aFluids == null || aFluids.length <= 0 || !FL.valid(aFluids[0])) continue;
            if ((MD.GC.mLoaded || MD.GC_GALAXYSPACE.mLoaded) && CS.FluidsGT.LIQUID_OXYGEN.contains(FL.regName(aFluids[0])) && (IL.GC_OxyTank_1.equal(tInput, true, true) || IL.GC_OxyTank_2.equal(tInput, true, true) || IL.GC_OxyTank_3.equal(tInput, true, true) || IL.GC_OxyTank_4.equal(tInput, true, true) || IL.GC_OxyTank_5.equal(tInput, true, true) || IL.GC_OxyTank_6.equal(tInput, true, true) || IL.GC_OxyTank_7.equal(tInput, true, true) || IL.GC_OxyTank_Env.equal(tInput, true, true))) {
                short tMeta = ST.meta_(tInput);
                return new Recipe(false, false, false, ST.array(ST.amount(1L, tInput)), ST.array(ST.copyAmountAndMeta(1L, 0L, tInput)), null, null, FL.array(tMeta <= 0 ? CS.NF : FL.amount(aFluids[0], UT.Code.units(tMeta, 2700L, 250L, true))), CS.ZL_FS, tMeta <= 0 ? 1L : 64L, 16L, 0L);
            }
            ItemStack tOutput = FL.fill(aFluids[0], tInput, false, true, false, false);
            tFluid = FL.getFluid(tOutput, true);
            if (tFluid == null) continue;
            return new Recipe(false, false, false, ST.array(ST.amount(1L, tInput)), ST.array(tOutput), null, null, FL.array(tFluid), CS.ZL_FS, Math.max(tFluid.amount / 64, 16), 16L, 0L);
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return aStack != null && (super.containsInput(aStack, aTileEntity, aSpecialSlot) || aStack.func_77973_b() instanceof IFluidContainerItem && ((IFluidContainerItem)aStack.func_77973_b()).getCapacity(aStack) > 0);
    }

    @Override
    public boolean containsInput(FluidStack aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return true;
    }

    @Override
    public boolean containsInput(Fluid aFluid, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return true;
    }
}

