/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachment;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.IFluidHandler;

public class CoverVent
extends AbstractCoverAttachment {
    public static final ITexture sTextureSides = BlockTextureDefault.get("machines/covers/vent/sides");
    public static final ITexture sTextureFront = BlockTextureDefault.get("machines/covers/vent/front");
    public static final ITexture sTextureBack = BlockTextureDefault.get("machines/covers/vent/back");

    @Override
    public boolean interceptCoverPlacement(byte aCoverSide, CoverData aData, Entity aPlayer) {
        return !aData.mTileEntity.canTick() || !(aData.mTileEntity instanceof IFluidHandler);
    }

    @Override
    public void onTickPre(byte aSide, CoverData aData, long aTimer, boolean aIsServerSide, boolean aReceivedBlockUpdate, boolean aReceivedInventoryUpdate) {
        if (aIsServerSide && !aData.mStopped && aData.mTileEntity instanceof IFluidHandler && CS.SERVER_TIME % 360L == (long)(30 + 60 * aSide) && WD.collectable_air(aData.mTileEntity.getWorld(), aData.mTileEntity.getOffsetX(aSide), aData.mTileEntity.getOffsetY(aSide), aData.mTileEntity.getOffsetZ(aSide))) {
            switch (aData.mTileEntity.getWorld().field_73011_w.field_76574_g) {
                case 0: {
                    FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aSide], FL.Air.make(256000L), true);
                    return;
                }
                case -1: {
                    FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aSide], FL.Air_Nether.make(256000L), true);
                    return;
                }
                case 1: {
                    FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aSide], FL.Air_End.make(256000L), true);
                    return;
                }
            }
            String tBiome = aData.mTileEntity.getBiome((int)aData.mTileEntity.getOffsetX((byte)aSide), (int)aData.mTileEntity.getOffsetZ((byte)aSide)).field_76791_y;
            if (CS.BIOMES_SPACE.contains(tBiome)) {
                return;
            }
            if (CS.BIOMES_END.contains(tBiome)) {
                FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aSide], FL.Air_End.make(256000L), true);
                return;
            }
            if (CS.BIOMES_NETHER.contains(tBiome)) {
                FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aSide], FL.Air_Nether.make(256000L), true);
                return;
            }
            FL.fill_((IFluidHandler)aData.mTileEntity, CS.ALL_SIDES_THIS_AND_ANY[aSide], FL.Air.make(256000L), true);
        }
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        if (MD.GC.mLoaded) {
            aList.add(LH.Chat.ORANGE + "Doesn't work on other Planets!");
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.controlcover.to.toggle"));
    }

    @Override
    public boolean isOpaque(byte aSide, CoverData aData) {
        return true;
    }

    @Override
    public boolean showsConnectorFront(byte aCoverSide, CoverData aData) {
        return false;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aSide, CoverData aData) {
        return sTextureFront;
    }

    @Override
    public ITexture getCoverTextureAttachment(byte aSide, CoverData aData, byte aTextureSide) {
        return aSide == aTextureSide ? sTextureFront : (aSide == CS.OPOS[aTextureSide] ? sTextureBack : sTextureSides);
    }

    @Override
    public ITexture getCoverTextureHolder(byte aSide, CoverData aData, byte aTextureSide) {
        return sTextureSides;
    }
}

