/*
 * Decompiled with CFR 0.152.
 */
package gregapi.cover.covers;

import gregapi.cover.CoverData;
import gregapi.cover.covers.AbstractCoverAttachmentLogistics;
import gregapi.data.FL;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.render.BlockTextureDefault;
import gregapi.render.ITexture;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class CoverLogisticsFluidImport
extends AbstractCoverAttachmentLogistics {
    public static final CoverLogisticsFluidImport INSTANCE = new CoverLogisticsFluidImport();
    public static final ITexture sTexture = BlockTextureDefault.get("machines/covers/logistics/fluid/import");

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        FluidStack tFluid = FL.load(aStack.func_77978_p(), "gt.filter.fluid");
        if (tFluid != null && tFluid.getFluid() != null) {
            aList.add(LH.Chat.CYAN + FL.name(tFluid, true));
        }
        aList.add(LH.Chat.ORANGE + "Not NBT sensitive!");
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
    }

    @Override
    public long onToolClick(byte aCoverSide, CoverData aData, String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("softhammer")) {
            if (aData.mNBTs[aCoverSide] != null) {
                aData.mNBTs[aCoverSide].func_82580_o("gt.filter.fluid");
            }
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (aData.mNBTs[aCoverSide] == null) {
                    aChatReturn.add("No Filter Set! (Priority: " + aData.mValues[aCoverSide] + ")");
                    aData.mNBTs[aCoverSide] = null;
                } else {
                    FluidStack tFluid = FL.load(aData.mNBTs[aCoverSide], "gt.filter.fluid");
                    if (tFluid == null) {
                        aChatReturn.add("No Filter Set! (Priority: " + aData.mValues[aCoverSide] + ")");
                        aData.mNBTs[aCoverSide] = null;
                    } else {
                        aChatReturn.add("Imports: " + LH.Chat.CYAN + tFluid.getFluid().getName() + " (Priority: " + aData.mValues[aCoverSide] + ")");
                    }
                }
            }
            return 1L;
        }
        return super.onToolClick(aCoverSide, aData, aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSideClicked, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onCoverClickedRight(byte aCoverSide, CoverData aData, Entity aPlayer, byte aSideClicked, float aHitX, float aHitY, float aHitZ) {
        ItemStack tStack;
        if (aPlayer instanceof EntityPlayer && aData.mTileEntity.isServerSide() && (aData.mNBTs[aCoverSide] == null || !aData.mNBTs[aCoverSide].func_74764_b("gt.filter.fluid")) && ST.valid(tStack = ((EntityPlayer)aPlayer).func_71045_bC())) {
            OreDictItemData tData;
            FluidStack tFluid = FL.getFluid(tStack, true);
            if (tFluid == null && (tData = OM.anyassociation_(tStack)) != null && tData.mPrefix.contains(TD.Prefix.IS_CONTAINER) && !tData.mPrefix.contains(TD.Prefix.IS_CRATE)) {
                tFluid = tData.mMaterial.mMaterial.fluid(648648000L, true);
            }
            if (FL.valid(tFluid)) {
                aData.mNBTs[aCoverSide] = FL.save(null, "gt.filter.fluid", tFluid);
                UT.Sounds.send("random.click", aData.mTileEntity);
                UT.Entities.sendchat((Object)aPlayer, "Imports: " + LH.Chat.CYAN + tFluid.getFluid().getName());
            }
        }
        return true;
    }

    @Override
    public ITexture getCoverTextureSurface(byte aCoverSide, CoverData aData) {
        return sTexture;
    }
}

