/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.item.bumble.IItemBumbleBee;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenHives
extends WorldgenObject {
    @SafeVarargs
    public WorldgenHives(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return false;
        }
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry("gt.multitileentity");
        if (tRegistry == null) {
            return false;
        }
        int tX = aMinX + aRandom.nextInt(16);
        int tY = 0;
        int tZ = aMinZ + aRandom.nextInt(16);
        int tCount = 0;
        boolean rResult = false;
        switch (aDimType) {
            case 66: {
                tY = 16 + aRandom.nextInt(96);
                if (!IL.ERE_Umberstone.equal(WD.block((IBlockAccess)aWorld, tX, tY, tZ))) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, CS.DYE_INT_Brown, aRandom.nextBoolean() ? 500 : 0, aRandom) || rResult;
            }
            case 20: {
                tY = 16 + aRandom.nextInt(96);
                if (!IL.BTL_Betweenstone.equal(WD.block((IBlockAccess)aWorld, tX, tY, tZ))) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, CS.DYE_INT_Green, aRandom.nextBoolean() ? 500 : 0, aRandom) || rResult;
            }
            case 17: {
                tY = 16 + aRandom.nextInt(64);
                if (!IL.ATUM_Limestone.equal(WD.block((IBlockAccess)aWorld, tX, tY, tZ))) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, CS.DYE_INT_Yellow, 900, aRandom) || rResult;
            }
            case -33: 
            case -2: {
                tY = 16 + aRandom.nextInt(96);
                if (WD.block((IBlockAccess)aWorld, tX, tY, tZ) != Blocks.netherrack) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, CS.DYE_INT_LightGray, 500, aRandom) || rResult;
            }
            case 6: {
                tY = 16 + aRandom.nextInt(96);
                if (WD.block((IBlockAccess)aWorld, tX, tY, tZ).getMaterial() == Material.ground) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, CS.DYE_INT_Cyan, 0, aRandom) || rResult;
            }
            case -1: {
                tY = 16 + aRandom.nextInt(WD.bedrock(aWorld, tX, 255, tZ) ? 224 : 96);
                if (WD.block((IBlockAccess)aWorld, tX, tY, tZ) != Blocks.netherrack) {
                    return rResult;
                }
                for (byte tSide : CS.ALL_SIDES_VALID) {
                    if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                        return rResult;
                    }
                    if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                    ++tCount;
                }
                return tCount == 5 && this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, 0xAA0000, 300, aRandom) || rResult;
            }
            case 1: {
                if (aRandom.nextInt(3) > 0) {
                    return false;
                }
                for (tY = 16; tY < 128; ++tY) {
                    if (WD.block((IBlockAccess)aWorld, tX, tY, tZ) != Blocks.end_stone) continue;
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                            return rResult;
                        }
                        if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                        ++tCount;
                    }
                    if (tCount == 5) {
                        rResult = this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, 43690, 400, aRandom) || rResult;
                        break;
                    }
                    tCount = 0;
                }
                return rResult;
            }
            case -127: 
            case -6: 
            case 0: 
            case 7: 
            case 105: 
            case 0x7FFFFFFF: {
                for (tY = 8; tY < 28; ++tY) {
                    Block tBlock = WD.block((IBlockAccess)aWorld, tX, tY, tZ);
                    if (tBlock.getMaterial() != Material.rock || !WD.opq(tBlock) || !WD.stone(tBlock, WD.meta((IBlockAccess)aWorld, tX, tY, tZ))) continue;
                    for (byte tSide : CS.ALL_SIDES_VALID) {
                        if (WD.liquid(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide])) {
                            tCount = 0;
                            break;
                        }
                        if (!WD.opq(aWorld, tX + CS.OFFX[tSide], tY + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], false, true)) continue;
                        ++tCount;
                    }
                    if (tCount == 5) {
                        rResult = this.placeHive(tRegistry, aDimType, aWorld, tX, tY, tZ, CS.DYE_INT_LightGray, 500, aRandom);
                        break;
                    }
                    tCount = 0;
                }
                int n = tY = aWorld.provider.hasNoSky ? 80 : aWorld.getHeight() - 50;
                while (tY > 2) {
                    Block tContact = aWorld.getBlock(tX, tY, tZ);
                    if (tContact.getMaterial().isLiquid()) {
                        return rResult;
                    }
                    if (tContact instanceof BlockStones && WD.meta((IBlockAccess)aWorld, tX, tY, tZ) != 0) {
                        return rResult;
                    }
                    if (tContact.isOpaqueCube() && !tContact.isLeaves((IBlockAccess)aWorld, tX, tY, tZ) && !tContact.isWood((IBlockAccess)aWorld, tX, tY, tZ) && tContact.getMaterial() != Material.ice && tContact.getMaterial() != Material.wood && tContact.getMaterial() != Material.leaves) {
                        for (byte tSide : CS.ALL_SIDES_HORIZONTAL_DOWN) {
                            Block tBlock = aWorld.getBlock(tX + CS.OFFX[tSide], tY - 1 + CS.OFFY[tSide], tZ + CS.OFFZ[tSide]);
                            if (WD.hasCollide(aWorld, tX + CS.OFFX[tSide], tY - 1 + CS.OFFY[tSide], tZ + CS.OFFZ[tSide], tBlock)) continue;
                            if (tBlock == Blocks.water || tBlock == Blocks.flowing_water || tBlock instanceof BlockWaterlike) {
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_LightBlue, 100, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_MAGICAL.contains(tName) || aDimType == 105 && !aRandom.nextBoolean()) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Purple, 200, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_VOLCANIC.contains(tName)) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Black, 300, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_END.contains(tName)) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, 43690, 400, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_NETHER.contains(tName)) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, 0xAA0000, 300, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_SHROOM.contains(tName)) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Pink, 800, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_OCEAN_BEACH.contains(tName) && !CS.BIOMES_LAKE.contains(tName)) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_LightBlue, 100, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_JUNGLE.contains(tName)) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Green, 600, aRandom) || rResult;
                            }
                            for (String tName : aBiomeNames) {
                                if (!CS.BIOMES_FROZEN.contains(tName)) continue;
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_White, 700, aRandom) || rResult;
                            }
                            if (tContact == Blocks.mycelium) {
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Pink, 800, aRandom) || rResult;
                            }
                            if (tContact == Blocks.sand && aWorld.getBlockMetadata(tX, tY, tZ) == 1) {
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Red, 900, aRandom) || rResult;
                            }
                            if (tContact == Blocks.sandstone || tContact.getMaterial() == Material.sand) {
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Yellow, 900, aRandom) || rResult;
                            }
                            if (tContact == Blocks.gravel || tContact.getMaterial() == Material.rock) {
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_LightGray, 500, aRandom) || rResult;
                            }
                            if (tContact == Blocks.grass || tContact.getMaterial() == Material.grass) {
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, 0xFFDD99, 0, aRandom) || rResult;
                            }
                            if (tContact == Blocks.dirt || tContact.getMaterial() == Material.ground) {
                                return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Brown, 0, aRandom) || rResult;
                            }
                            return this.placeHive(tRegistry, aDimType, aWorld, tX, tY - 1, tZ, CS.DYE_INT_Purple, 200, aRandom) || rResult;
                        }
                        return rResult;
                    }
                    --tY;
                }
                return rResult;
            }
        }
        return rResult;
    }

    public boolean placeHive(MultiTileEntityRegistry aRegistry, int aDimType, World aWorld, int aX, int aY, int aZ, int aColor, int aSpeciesID, Random aRandom) {
        NBTTagCompound aBumbleTag = aDimType == 0 ? IItemBumbleBee.Util.getBumbleGenes(WD.envTemp(aWorld, aX, aY, aZ), aWorld.getBiomeGenForCoords(aX, aZ), !aWorld.provider.hasNoSky && aWorld.getPrecipitationHeight(aX, aZ) <= aY + 5, aRandom) : IItemBumbleBee.Util.getBumbleGenes(WD.envTemp(aWorld, aX, aY, aZ), aWorld.getBiomeGenForCoords(aX, aZ), !aWorld.provider.hasNoSky && aWorld.getPrecipitationHeight(aX, aZ) <= aY + 5, aWorld.isDaytime(), !aWorld.isDaytime(), aRandom);
        return aRegistry.mBlock.placeBlock(aWorld, aX, aY, aZ, (byte)6, (short)32755, UT.NBT.make("gt.color", (Object)aColor, "gt.invlist", UT.NBT.makeInv(((IItemBumbleBee)((Object)CS.ItemsGT.BUMBLEBEES)).bumbleProductStack(CS.NI, (short)aSpeciesID, UT.Code.units(IItemBumbleBee.Util.getWorkForce(aBumbleTag), 10000L, 10L, true), 0), IItemBumbleBee.Util.setBumbleTag(ST.make(CS.ItemsGT.BUMBLEBEES, 1L, (long)(aSpeciesID + 1)), aBumbleTag), IItemBumbleBee.Util.setBumbleTag(ST.make(CS.ItemsGT.BUMBLEBEES, IItemBumbleBee.Util.getOffspring(aBumbleTag), (long)aSpeciesID), aBumbleTag)), "gt.painted", true), false, true);
    }
}

