/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.data.CS;
import gregapi.data.MT;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.worldgen.NoiseGenerator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenDeepOcean
extends WorldgenObject {
    @SafeVarargs
    public WorldgenDeepOcean(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (!aBiomeNames.contains(BiomeGenBase.deepOcean.biomeName)) {
            return false;
        }
        int i = 3 + aRandom.nextInt(9);
        int j = 30 + aRandom.nextInt(9);
        int k = 3 + aRandom.nextInt(9);
        int m = 0;
        int n = 0;
        if (WD.anywater(aChunk.getBlock(i, j, k))) {
            int l;
            switch (new NoiseGenerator(aWorld).get(aMinX + 8, 32.0f, aMinZ + 8, 16)) {
                default: {
                    return false;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: {
                    return false;
                }
                case 12: 
                case 13: {
                    int l2;
                    for (l2 = 8; l2 < 11; ++l2) {
                        WD.set(aChunk, i, j + l2, k, CS.BlocksGT.PrismarineDark, 0L);
                        WD.set(aChunk, i, j - l2, k, CS.BlocksGT.PrismarineDark, 0L);
                        if (aRandom.nextInt(8) != 0) continue;
                        CS.BlocksGT.ores_normal[14].placeBlock(aWorld, aMinX + i + m, j + l2, aMinZ + k + n, (byte)6, MT.OREMATS.Garnierite.mID, null, false, true);
                    }
                    for (l2 = 5; l2 < 8; ++l2) {
                        for (m = -1; m <= 1; ++m) {
                            for (n = -1; n <= 1; ++n) {
                                WD.set(aChunk, i + m, j + l2, k + n, CS.BlocksGT.PrismarineDark, 0L);
                                WD.set(aChunk, i + m, j - l2, k + n, CS.BlocksGT.PrismarineDark, 0L);
                                if (aRandom.nextInt(8) != 0) continue;
                                CS.BlocksGT.ores_normal[14].placeBlock(aWorld, aMinX + i + m, j + l2, aMinZ + k + n, (byte)6, MT.OREMATS.Garnierite.mID, null, false, true);
                            }
                        }
                    }
                    for (l2 = 2; l2 < 5; ++l2) {
                        for (m = -2; m <= 2; ++m) {
                            for (n = -2; n <= 2; ++n) {
                                WD.set(aChunk, i + m, j + l2, k + n, CS.BlocksGT.PrismarineDark, 0L);
                                WD.set(aChunk, i + m, j - l2, k + n, CS.BlocksGT.PrismarineDark, 0L);
                                if (aRandom.nextInt(8) != 0) continue;
                                CS.BlocksGT.ores_normal[14].placeBlock(aWorld, aMinX + i + m, j + l2, aMinZ + k + n, (byte)6, MT.OREMATS.Garnierite.mID, null, false, true);
                            }
                        }
                    }
                    for (l2 = 0; l2 < 2; ++l2) {
                        for (m = -3; m <= 3; ++m) {
                            for (n = -3; n <= 3; ++n) {
                                WD.set(aChunk, i + m, j + l2, k + n, CS.BlocksGT.PrismarineDark, 0L);
                                WD.set(aChunk, i + m, j - l2, k + n, CS.BlocksGT.PrismarineDark, 0L);
                                if (aRandom.nextInt(8) != 0) continue;
                                CS.BlocksGT.ores_normal[14].placeBlock(aWorld, aMinX + i + m, j + l2, aMinZ + k + n, (byte)6, MT.OREMATS.Garnierite.mID, null, false, true);
                            }
                        }
                    }
                    return true;
                }
                case 14: 
                case 15: 
            }
            for (l = 8; l < 11; ++l) {
                WD.set(aChunk, i, j + l, k, CS.BlocksGT.PrismarineLight, 0L);
                WD.set(aChunk, i, j - l, k, CS.BlocksGT.PrismarineLight, 0L);
                if (aRandom.nextInt(8) != 0) continue;
                CS.BlocksGT.ores_normal[13].placeBlock(aWorld, aMinX + i + m, j + l, aMinZ + k + n, (byte)6, MT.MnO2.mID, null, false, true);
            }
            for (l = 5; l < 8; ++l) {
                for (m = -1; m <= 1; ++m) {
                    for (n = -1; n <= 1; ++n) {
                        WD.set(aChunk, i + m, j + l, k + n, CS.BlocksGT.PrismarineLight, 0L);
                        WD.set(aChunk, i + m, j - l, k + n, CS.BlocksGT.PrismarineLight, 0L);
                        if (aRandom.nextInt(8) != 0) continue;
                        CS.BlocksGT.ores_normal[13].placeBlock(aWorld, aMinX + i + m, j + l, aMinZ + k + n, (byte)6, MT.MnO2.mID, null, false, true);
                    }
                }
            }
            for (l = 2; l < 5; ++l) {
                for (m = -2; m <= 2; ++m) {
                    for (n = -2; n <= 2; ++n) {
                        WD.set(aChunk, i + m, j + l, k + n, CS.BlocksGT.PrismarineLight, 0L);
                        WD.set(aChunk, i + m, j - l, k + n, CS.BlocksGT.PrismarineLight, 0L);
                        if (aRandom.nextInt(8) != 0) continue;
                        CS.BlocksGT.ores_normal[13].placeBlock(aWorld, aMinX + i + m, j + l, aMinZ + k + n, (byte)6, MT.MnO2.mID, null, false, true);
                    }
                }
            }
            for (l = 0; l < 2; ++l) {
                for (m = -3; m <= 3; ++m) {
                    for (n = -3; n <= 3; ++n) {
                        WD.set(aChunk, i + m, j + l, k + n, CS.BlocksGT.PrismarineLight, 0L);
                        WD.set(aChunk, i + m, j - l, k + n, CS.BlocksGT.PrismarineLight, 0L);
                        if (aRandom.nextInt(8) != 0) continue;
                        CS.BlocksGT.ores_normal[13].placeBlock(aWorld, aMinX + i + m, j + l, aMinZ + k + n, (byte)6, MT.MnO2.mID, null, false, true);
                    }
                }
            }
            return true;
        }
        return false;
    }
}

