/*
 * Decompiled with CFR 0.152.
 */
package gregtech.worldgen;

import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregtech.worldgen.NoiseGenerator;
import gregtech.worldgen.WorldgenPit;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class WorldgenBlackSand
extends WorldgenObject {
    @SafeVarargs
    public WorldgenBlackSand(String aName, boolean aDefault, List<WorldgenObject> ... aLists) {
        super(aName, aDefault, aLists);
    }

    @Override
    public boolean generate(World aWorld, Chunk aChunk, int aDimType, int aMinX, int aMinZ, int aMaxX, int aMaxZ, Random aRandom, BiomeGenBase[][] aBiomes, Set<String> aBiomeNames) {
        if (aRandom.nextInt(64) > 0 || this.checkForMajorWorldgen(aWorld, aMinX, aMinZ, aMaxX, aMaxZ)) {
            return false;
        }
        for (String string : aBiomeNames) {
            if (!CS.BIOMES_OCEAN_BEACH.contains(string) && !CS.BIOMES_SWAMP.contains(string)) continue;
            return false;
        }
        boolean temp = true;
        for (String tName : aBiomeNames) {
            if (!CS.BIOMES_RIVER.contains(tName)) continue;
            temp = false;
            break;
        }
        if (temp) {
            return false;
        }
        int n = aMinX - 16;
        int tZ = aMinZ - 16;
        int tUpperBound = WD.waterLevel(aWorld) + 1;
        int tLowerBound = WD.waterLevel(aWorld) - 12;
        int aMeta = new NoiseGenerator(aWorld).get(aMinX / 4, 360.0f, aMinZ / 4, 3);
        for (int i = 0; i < 48; ++i) {
            block3: for (int j = 0; j < 48; ++j) {
                if (!WorldgenPit.SHAPE[i][j]) continue;
                Block tBlock = CS.NB;
                Block tLastBlock = WD.block((IBlockAccess)aWorld, n + i, tUpperBound + 1, tZ + j);
                int tGenerated = 0;
                for (int tY = tUpperBound; tY >= tLowerBound && tGenerated < 2; --tY) {
                    block10: {
                        block13: {
                            block12: {
                                byte tMeta;
                                block11: {
                                    block9: {
                                        tBlock = WD.block((IBlockAccess)aWorld, n + i, tY, tZ + j);
                                        tMeta = WD.meta((IBlockAccess)aWorld, n + i, tY, tZ + j);
                                        if (tBlock != CS.BlocksGT.Sands || tMeta != aMeta) break block9;
                                        ++tGenerated;
                                        break block10;
                                    }
                                    if (tBlock.isOpaqueCube()) break block11;
                                    if (tGenerated > 0) {
                                        continue block3;
                                    }
                                    break block10;
                                }
                                if ((tBlock != Blocks.dirt || tMeta >= 2) && tBlock != Blocks.gravel && tBlock != Blocks.sand && tBlock != Blocks.clay && tBlock != CS.BlocksGT.oreSmallGravel && tBlock != CS.BlocksGT.oreGravel && tBlock != CS.BlocksGT.oreSmallSand && tBlock != CS.BlocksGT.oreSand && tBlock != CS.BlocksGT.oreSmallRedSand && tBlock != CS.BlocksGT.oreRedSand) break block12;
                                if (tGenerated > 0 || tLastBlock.getMaterial() != Material.wood && tLastBlock.getMaterial() != Material.gourd) break block13;
                                break block10;
                            }
                            if (tGenerated > 0) {
                                if (tBlock.getMaterial() != Material.rock) continue block3;
                            }
                            break block10;
                        }
                        aWorld.setBlock(n + i, tY, tZ + j, (Block)CS.BlocksGT.Sands, aMeta, 3);
                        ++tGenerated;
                    }
                    tLastBlock = tBlock;
                }
            }
        }
        return temp;
    }
}

