/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tools;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.old.Textures;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.tileentity.machines.ITileEntityAnvil;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregtech.tileentity.placeables.MultiTileEntityCoin;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityMoldCoinage
extends TileEntityBase07Paintable
implements ITileEntityAnvil,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_SyncDataShort {
    protected boolean mIsUnique = false;
    protected short mDisplayedMetal = (short)-1;
    protected short oDisplayedMetal = (short)-1;
    protected boolean[][][] mShape = new boolean[2][16][16];
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/bottom");
    public static IIconContainer sTextureSide = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/side");
    public static IIconContainer sTextureHole = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/colored/hole");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/bottom");
    public static IIconContainer sOverlaySide = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/side");
    public static IIconContainer sOverlayHole = new Textures.BlockIcons.CustomIcon("machines/tools/mold_coinage/overlay/hole");
    private ITexture mTextureHole;
    private ITexture[] mTextureSides = new ITexture[3];
    private ITexture mTextureContent;
    private static final int[] ACCESSIBLE_SLOTS = new int[]{0};

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        int i;
        super.readFromNBT2(aNBT);
        for (i = 0; i < this.mShape[0].length; ++i) {
            this.mShape[0][i] = UT.Code.getBitsS(aNBT.getShort("gt.coin.shape.0." + i));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            this.mShape[1][i] = UT.Code.getBitsS(aNBT.getShort("gt.coin.shape.1." + i));
        }
        this.mIsUnique = aNBT.getBoolean("gt.coin.unique");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        int i;
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.coin.unique", this.mIsUnique);
        for (i = 0; i < this.mShape[0].length; ++i) {
            aNBT.setShort("gt.coin.shape.0." + i, (short)UT.Code.getBits(this.mShape[0][i]));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            aNBT.setShort("gt.coin.shape.1." + i, (short)UT.Code.getBits(this.mShape[1][i]));
        }
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        int i;
        UT.NBT.setBoolean(aNBT, "gt.coin.unique", this.mIsUnique);
        for (i = 0; i < this.mShape[0].length; ++i) {
            aNBT.setShort("gt.coin.shape.0." + i, (short)UT.Code.getBits(this.mShape[0][i]));
        }
        for (i = 0; i < this.mShape[1].length; ++i) {
            aNBT.setShort("gt.coin.shape.1." + i, (short)UT.Code.getBits(this.mShape[1][i]));
        }
        return aNBT;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mold.coinage"));
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.recipes.mold.select") + " (Doesn't work right now)");
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.nogui.rightclick.interact") + " (" + LH.get("gt.lang.face.top") + ")");
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        if (aIsServerSide) {
            if (ST.invalid(this.slot(0))) {
                this.mDisplayedMetal = 0;
            } else {
                OreDictItemData tData = OM.data_(this.slot(0));
                if (tData != null && tData.mMaterial != null) {
                    this.mDisplayedMetal = tData.mMaterial.mMaterial.mID;
                }
            }
        }
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide() && CS.SIDES_TOP_HORIZONTAL[aSide]) {
            ItemStack tOutputStack = this.slot(0);
            ItemStack aStack = aPlayer.getCurrentEquippedItem();
            if (tOutputStack == null) {
                OreDictItemData tData = OM.anyassociation(aStack);
                if (tData != null && tData.mPrefix == OP.plateTiny) {
                    if (!UT.Entities.hasInfiniteItems(aPlayer)) {
                        --aStack.stackSize;
                    }
                    this.slot(0, ST.amount(1L, aStack));
                    UT.Sounds.send("random.click", this, false);
                    return true;
                }
            } else if (ST.add((Entity)aPlayer, tOutputStack, false)) {
                this.slotKill(0);
            }
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        }
        if (aTool.equals("hammer") && CS.SIDES_TOP[aSide]) {
            if (aRemainingDurability >= 2000L) {
                OreDictItemData tData = OM.anyassociation(this.slot(0));
                if (tData != null && tData.mPrefix == OP.plateTiny) {
                    this.slot(0, MultiTileEntityCoin.getCoin(this.slot((int)0).stackSize, tData.mMaterial.mMaterial, this.mIsUnique, this.mShape));
                    return 2000L;
                }
                return 0L;
            }
            UT.Sounds.send("random.break", this, false);
            return aRemainingDurability;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.mDisplayedMetal != this.oDisplayedMetal;
    }

    @Override
    public void onTickResetChecks(long aTimer, boolean aIsServerSide) {
        super.onTickResetChecks(aTimer, aIsServerSide);
        this.oDisplayedMetal = this.mDisplayedMetal;
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        if (aSendAll) {
            return this.getClientDataPacketByteArray(true, UT.Code.toByteS(this.mDisplayedMetal, 0), UT.Code.toByteS(this.mDisplayedMetal, 1), (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa));
        }
        return this.getClientDataPacketShort(false, this.mDisplayedMetal);
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedMetal = UT.Code.combine(aData[0], aData[1]);
        if (aData.length >= 5) {
            this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[2]), UT.Code.unsignB(aData[3]), UT.Code.unsignB(aData[4])});
        }
        return true;
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        this.mDisplayedMetal = aData;
        return true;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return 7;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0) {
            this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[4], CS.PX_N[0]);
            return true;
        }
        if (aRenderPass == 1) {
            this.box(aBlock, CS.PX_P[4], CS.PX_P[12], CS.PX_P[4], CS.PX_N[4], CS.PX_N[2], CS.PX_N[4]);
            return true;
        }
        if (aRenderPass == 2) {
            this.box(aBlock, CS.PX_P[5], CS.PX_P[11], CS.PX_P[5], CS.PX_N[5], CS.PX_N[3], CS.PX_N[5]);
            return true;
        }
        if (aRenderPass == 3) {
            this.box(aBlock, CS.PX_P[11], CS.PX_P[12], CS.PX_P[5], CS.PX_N[5], CS.PX_N[2], CS.PX_N[5]);
            return true;
        }
        if (aRenderPass == 4) {
            this.box(aBlock, CS.PX_P[5], CS.PX_P[12], CS.PX_P[11], CS.PX_N[5], CS.PX_N[2], CS.PX_N[5]);
            return true;
        }
        if (aRenderPass == 5) {
            this.box(aBlock, CS.PX_P[5], CS.PX_P[12], CS.PX_P[5], CS.PX_N[11], CS.PX_N[2], CS.PX_N[5]);
            return true;
        }
        if (aRenderPass == 6) {
            this.box(aBlock, CS.PX_P[5], CS.PX_P[12], CS.PX_P[5], CS.PX_N[5], CS.PX_N[2], CS.PX_N[11]);
            return true;
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (aRenderPass == 0 && aSide == 0) {
            boolean tGlow = this.mMaterial.contains(TD.Properties.GLOWING);
            this.mTextureHole = BlockTextureMulti.get(BlockTextureDefault.get(sTextureHole, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayHole));
            this.mTextureSides[0] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayBottom));
            this.mTextureSides[1] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlayTop));
            this.mTextureSides[2] = BlockTextureMulti.get(BlockTextureDefault.get(sTextureSide, this.mRGBa, false, tGlow, false, false), BlockTextureDefault.get(sOverlaySide));
            if (this.mDisplayedMetal != 0 && UT.Code.exists(this.mDisplayedMetal, OreDictMaterial.MATERIAL_ARRAY)) {
                OreDictMaterial tMaterial = OreDictMaterial.MATERIAL_ARRAY[this.mDisplayedMetal];
                this.mTextureContent = BlockTextureDefault.get(tMaterial, OP.blockSolid);
            } else {
                this.mTextureContent = null;
            }
        }
        if (aRenderPass == 1) {
            return CS.SIDES_TOP[aSide] ? this.mTextureHole : this.mTextureSides[CS.FACES_TBS[aSide]];
        }
        if (aRenderPass == 2) {
            return this.mTextureContent;
        }
        if (aRenderPass == 3) {
            return aSide == 4 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        if (aRenderPass == 4) {
            return aSide == 2 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        if (aRenderPass == 5) {
            return aSide == 5 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        if (aRenderPass == 6) {
            return aSide == 3 ? this.mTextureSides[CS.FACES_TBS[aSide]] : null;
        }
        return this.mTextureSides[CS.FACES_TBS[aSide]];
    }

    @Override
    public boolean isAnvil(byte aSide) {
        return CS.SIDES_TOP[aSide];
    }

    @Override
    public int getLightOpacity() {
        return 3;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[4], CS.PX_N[0]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[4], CS.PX_N[0]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[0], CS.PX_P[0], CS.PX_P[0], CS.PX_N[0], CS.PX_N[4], CS.PX_N[0]);
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 1.0f : 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_TOP[aSide] ? CS.PX_N[4] : 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return CS.SIDES_BOTTOM[aSide];
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int getInventoryStackLimit() {
        return 1;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        OreDictItemData tData = OM.anyassociation(aStack);
        return tData != null && tData.mPrefix == OP.plateTiny;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        OreDictItemData tData = OM.anyassociation(this.slot(aSlot));
        return tData == null || tData.mPrefix != OP.plateTiny;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.mold.coins";
    }
}

