/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.tanks;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureFluid;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityTapFillable;
import gregapi.tileentity.tank.TileEntityBase10FluidContainerSyncSmall;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class MultiTileEntityMeasuringPot
extends TileEntityBase10FluidContainerSyncSmall
implements ITileEntityTapFillable,
IMultiTileEntity.IMTE_IgnorePlayerCollisionWhenPlacing {
    public long mCapacity = 1000L;
    public static IIconContainer sTextureSides = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/colored/sides");
    public static IIconContainer sTextureInsides = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/colored/insides");
    public static IIconContainer sTextureTop = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/colored/top");
    public static IIconContainer sTextureBottom = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/colored/bottom");
    public static IIconContainer sOverlaySides = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/overlay/sides");
    public static IIconContainer sOverlayInsides = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/overlay/insides");
    public static IIconContainer sOverlayTop = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/overlay/top");
    public static IIconContainer sOverlayBottom = new Textures.BlockIcons.CustomIcon("machines/tanks/measuring_pot/overlay/bottom");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mCapacity = this.mTank.capacity();
        if (aNBT.hasKey("gt.mode")) {
            this.mTank.setCapacity(aNBT.getLong("gt.mode"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        if (this.mCapacity != this.mTank.capacity()) {
            UT.NBT.setNumber(aNBT, "gt.mode", this.mTank.capacity());
        }
        super.writeToNBT2(aNBT);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.mCapacity != this.mTank.capacity()) {
            UT.NBT.setNumber(aNBT, "gt.mode", this.mTank.capacity());
        }
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        super.addToolTips(aList, aStack, aF3_H);
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.nogui.rightclick.tank.limit"));
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer.getCurrentEquippedItem() == null && CS.SIDES_HORIZONTAL[aSide]) {
            if (this.isClientSide()) {
                return true;
            }
            if (aHitY > CS.PX_P[4]) {
                if (aHitY > CS.PX_P[6]) {
                    this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() + (long)(aPlayer.isSneaking() ? 5 : 50)));
                } else {
                    this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() + (long)(aPlayer.isSneaking() ? 1 : 10)));
                }
            } else if (aHitY > CS.PX_P[2]) {
                this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() - (long)(aPlayer.isSneaking() ? 1 : 10)));
            } else {
                this.mTank.setCapacity(UT.Code.bind(1L, this.mCapacity, this.mTank.capacity() - (long)(aPlayer.isSneaking() ? 5 : 50)));
            }
            UT.Entities.sendchat((Object)aPlayer, "Limit: " + this.mTank.capacity() + "L");
            return true;
        }
        return super.onBlockActivated3(aPlayer, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return this.mTank.isEmpty() ? 5 : 6;
    }

    @Override
    public boolean setBlockBounds2(Block aBlock, int aRenderPass, boolean[] aShouldSideBeRendered) {
        switch (aRenderPass) {
            case 0: {
                this.box(aBlock, CS.PX_P[4], CS.PX_P[1], CS.PX_P[5], CS.PX_N[11], CS.PX_N[8], CS.PX_N[5]);
                return true;
            }
            case 1: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[1], CS.PX_P[4], CS.PX_N[5], CS.PX_N[8], CS.PX_N[11]);
                return true;
            }
            case 2: {
                this.box(aBlock, CS.PX_P[11], CS.PX_P[1], CS.PX_P[5], CS.PX_N[4], CS.PX_N[8], CS.PX_N[5]);
                return true;
            }
            case 3: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[1], CS.PX_P[11], CS.PX_N[5], CS.PX_N[8], CS.PX_N[4]);
                return true;
            }
            case 4: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[5], CS.PX_N[5], CS.PX_N[15], CS.PX_N[5]);
                return true;
            }
            case 5: {
                this.box(aBlock, CS.PX_P[5], CS.PX_P[0], CS.PX_P[5], CS.PX_N[5], CS.PX_N[9], CS.PX_N[5]);
                return true;
            }
        }
        return false;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        switch (aSide) {
            case 4: {
                return aRenderPass == 2 ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayInsides)) : BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlaySides));
            }
            case 5: {
                return aRenderPass == 0 ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayInsides)) : BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlaySides));
            }
            case 2: {
                return aRenderPass == 3 ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayInsides)) : BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlaySides));
            }
            case 3: {
                return aRenderPass == 1 ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureInsides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayInsides)) : BlockTextureMulti.get(BlockTextureDefault.get(sTextureSides, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlaySides));
            }
            case 0: {
                return aRenderPass != 4 || aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sTextureBottom, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayBottom)) : null;
            }
            case 1: {
                return aRenderPass == 5 ? BlockTextureFluid.get(this.mTank) : BlockTextureMulti.get(BlockTextureDefault.get(sTextureTop, this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlayTop));
            }
        }
        return null;
    }

    @Override
    public AxisAlignedBB getCollisionBoundingBoxFromPool() {
        return this.box(CS.PX_P[4], CS.PX_P[0], CS.PX_P[4], CS.PX_N[4], CS.PX_N[8], CS.PX_N[4]);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBoxFromPool() {
        return this.box(CS.PX_P[4], CS.PX_P[0], CS.PX_P[4], CS.PX_N[4], CS.PX_N[8], CS.PX_N[4]);
    }

    @Override
    public void setBlockBoundsBasedOnState(Block aBlock) {
        this.box(aBlock, CS.PX_P[4], CS.PX_P[0], CS.PX_P[4], CS.PX_N[4], CS.PX_N[8], CS.PX_N[4]);
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return CS.SIDES_VERTICAL[aSide] ? 0.0f : CS.PX_P[4];
    }

    @Override
    public boolean canWaterCrops() {
        return true;
    }

    @Override
    public boolean canPickUpFluids() {
        return true;
    }

    @Override
    public boolean canFillWithRain() {
        return true;
    }

    @Override
    public boolean ignorePlayerCollisionWhenPlacing() {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.measuring.pot";
    }
}

