/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.tileentity.multiblocks.MultiTileEntityTank;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.FluidStack;

public abstract class MultiTileEntityTank5x5x5
extends MultiTileEntityTank {
    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.tank5x5x5.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.tank5x5x5.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.tank5x5x5.3"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing, 2);
        if (this.worldObj.blockExists(tX - 2, tY = this.getOffsetYN(this.mFacing, 2), (tZ = this.getOffsetZN(this.mFacing, 2)) - 2) && this.worldObj.blockExists(tX + 2, tY, tZ - 2) && this.worldObj.blockExists(tX - 2, tY, tZ + 2) && this.worldObj.blockExists(tX + 2, tY, tZ + 2)) {
            boolean tSuccess = true;
            for (int i = -2; i <= 2; ++i) {
                for (int j = -2; j <= 2; ++j) {
                    for (int k = -2; k <= 2; ++k) {
                        if (i * i <= 1 && j * j <= 1 && k * k <= 1) {
                            if (this.getAir(tX + i, tY + j, tZ + k)) {
                                this.worldObj.setBlockToAir(tX + i, tY + j, tZ + k);
                                continue;
                            }
                            tSuccess = false;
                            continue;
                        }
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, this.mTankWalls, this.getMultiTileEntityRegistryID(), 0, -13, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing, 2);
        int tY = this.getOffsetYN(this.mFacing, 2);
        int tZ = this.getOffsetZN(this.mFacing, 2);
        return aX >= tX - 2 && aY >= tY - 2 && aZ >= tZ - 2 && aX <= tX + 2 && aY <= tY + 2 && aZ <= tZ + 2;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        FluidStack tFluid;
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && this.checkStructure(false) && (tFluid = this.mTank.getFluid()) != null && tFluid.amount > 0) {
            if (FL.temperature(this.mTank) >= this.mMaterial.mMeltingPoint && this.meltdown()) {
                return;
            }
            if (!this.mMagicProof && FL.magic(tFluid)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
                int tX = this.getOffsetXN(this.mFacing, 2);
                int tY = this.getOffsetYN(this.mFacing, 2);
                int tZ = this.getOffsetZN(this.mFacing, 2);
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        for (int k = -2; k <= 2; ++k) {
                            if (this.rng(3) != 0) continue;
                            WD.set(this.worldObj, tX + i, tY + j, tZ + k, FL.gas(tFluid) ? IL.TC_Flux_Gas.block() : IL.TC_Flux_Goo.block(), IL.TC_Flux_Goo.exists() ? 7L : 0L, 3L);
                        }
                    }
                }
                WD.set(this.worldObj, this.xCoord, this.yCoord, this.zCoord, FL.gas(tFluid) ? IL.TC_Flux_Gas.block() : IL.TC_Flux_Goo.block(), IL.TC_Flux_Goo.exists() ? 7L : 0L, 3L);
                return;
            }
            if (!this.mAcidProof && FL.acid(this.mTank)) {
                UT.Sounds.send("random.fizz", this, false);
                CS.GarbageGT.trash(this.mTank);
                int tX = this.getOffsetXN(this.mFacing, 2);
                int tY = this.getOffsetYN(this.mFacing, 2);
                int tZ = this.getOffsetZN(this.mFacing, 2);
                for (int i = -2; i <= 2; ++i) {
                    for (int j = -2; j <= 2; ++j) {
                        for (int k = -2; k <= 2; ++k) {
                            if (this.rng(3) != 0) continue;
                            this.worldObj.setBlockToAir(tX + i, tY + j, tZ + k);
                        }
                    }
                }
                this.setToAir();
                return;
            }
            if (!this.mPlasmaProof && FL.plasma(this.mTank)) {
                CS.GarbageGT.trash(this.mTank);
                UT.Sounds.send("random.fizz", this, false);
            } else if (!this.mGasProof && FL.gas(this.mTank)) {
                CS.GarbageGT.trash(this.mTank);
                UT.Sounds.send("random.fizz", this, false);
            } else if (!this.allowFluid(tFluid)) {
                CS.GarbageGT.trash(this.mTank);
                UT.Sounds.send("random.fizz", this, false);
            } else if ((CS.SIDES_HORIZONTAL[this.mFacing] || FL.gas(this.mTank) || (FL.lighter(this.mTank) ? CS.SIDES_TOP : CS.SIDES_BOTTOM)[this.mFacing]) && FL.move(this.mTank, this.getAdjacentTileEntity(this.mFacing)) > 0L) {
                this.updateInventory();
            }
        }
    }

    public boolean meltdown() {
        int tX = this.getOffsetXN(this.mFacing, 2);
        int tY = this.getOffsetYN(this.mFacing, 2);
        int tZ = this.getOffsetZN(this.mFacing, 2);
        for (int i = -2; i <= 2; ++i) {
            for (int j = -2; j <= 2; ++j) {
                for (int k = -2; k <= 2; ++k) {
                    WD.burn(this.worldObj, tX + i, tY + j, tZ + k, false, false);
                    if (this.rng(4) != 0) continue;
                    this.worldObj.setBlock(tX + i, tY + j, tZ + k, (Block)Blocks.fire, 0, 3);
                }
            }
        }
        CS.GarbageGT.trash(this.mTank);
        this.setToFire();
        return true;
    }

    static {
        LH.add("gt.tooltip.multiblock.tank5x5x5.1", "5x5x5 Hollow of the corresponding Walls made of this Material");
        LH.add("gt.tooltip.multiblock.tank5x5x5.2", "This Block centered on Side/Top/Bottom and facing outwards");
        LH.add("gt.tooltip.multiblock.tank5x5x5.3", "Auto-Emits Fluids from the Main Block if not against Gravity");
    }
}

