/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.data.LH;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockMachine;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.IFluidHandler;

public class MultiTileEntityCokeOven
extends TileEntityBase10MultiBlockMachine {
    public DelegatorTileEntity<IFluidHandler> mFluidOutputTarget = null;

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        int tZ;
        int tY;
        int tX = this.getOffsetXN(this.mFacing);
        if (this.worldObj.blockExists(tX - 1, tY = this.getOffsetYN(this.mFacing), (tZ = this.getOffsetZN(this.mFacing)) - 1) && this.worldObj.blockExists(tX + 1, tY, tZ - 1) && this.worldObj.blockExists(tX - 1, tY, tZ + 1) && this.worldObj.blockExists(tX + 1, tY, tZ + 1)) {
            boolean tSuccess = true;
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    for (int k = -1; k <= 1; ++k) {
                        if (i == 0 && j == 0 && k == 0) {
                            if (this.getAir(tX + i, tY + j, tZ + k)) {
                                this.worldObj.setBlockToAir(tX + i, tY + j, tZ + k);
                                continue;
                            }
                            tSuccess = false;
                            continue;
                        }
                        if (ITileEntityMultiBlockController.Util.checkAndSetTarget(this, tX + i, tY + j, tZ + k, 18000, this.getMultiTileEntityRegistryID(), 0, -64, aCoordinates, aPlayer, aInventory)) continue;
                        tSuccess = false;
                    }
                }
            }
            return tSuccess;
        }
        return this.mStructureOkay;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.cokeoven.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.cokeoven.2"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        int tX = this.getOffsetXN(this.mFacing);
        int tY = this.getOffsetYN(this.mFacing);
        int tZ = this.getOffsetZN(this.mFacing);
        return aX >= tX - 1 && aY >= tY - 1 && aZ >= tZ - 1 && aX <= tX + 1 && aY <= tY + 1 && aZ <= tZ + 1;
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getFluidOutputTarget(byte aSide, Fluid aOutput) {
        if (this.mFluidOutputTarget != null && this.mFluidOutputTarget.exists()) {
            return this.mFluidOutputTarget;
        }
        if (aOutput != null) {
            int tX = this.getOffsetXN(this.mFacing);
            int tY = this.getOffsetYN(this.mFacing) - 2;
            int tZ = this.getOffsetZN(this.mFacing);
            for (int i = -1; i <= 1; ++i) {
                for (int j = -1; j <= 1; ++j) {
                    DelegatorTileEntity<TileEntity> tTarget = WD.te(this.worldObj, tX + i, tY, tZ + j, (byte)1, false);
                    if (!(tTarget.mTileEntity instanceof IFluidHandler) || !((IFluidHandler)tTarget.mTileEntity).canFill(tTarget.getForgeSideOfTileEntity(), aOutput)) continue;
                    this.mFluidOutputTarget = new DelegatorTileEntity<IFluidHandler>((IFluidHandler)tTarget.mTileEntity, tTarget);
                    return this.mFluidOutputTarget;
                }
            }
        }
        this.mFluidOutputTarget = null;
        return null;
    }

    @Override
    public DelegatorTileEntity<IInventory> getItemInputTarget(byte aSide) {
        return null;
    }

    @Override
    public DelegatorTileEntity<TileEntity> getItemOutputTarget(byte aSide) {
        return null;
    }

    @Override
    public DelegatorTileEntity<IFluidHandler> getFluidInputTarget(byte aSide) {
        return null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.cokeoven";
    }

    static {
        LH.add("gt.tooltip.multiblock.cokeoven.1", "3x3x3 Hollow of 25 Fire Bricks filled with Air");
        LH.add("gt.tooltip.multiblock.cokeoven.2", "Main Block centered on Side and facing outwards");
    }
}

