/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.multiblocks;

import gregapi.block.IBlockPlacable;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.ItemStackContainer;
import gregapi.code.TagData;
import gregapi.data.ANY;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.LH;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.fluid.FluidTankGT;
import gregapi.oredict.OreDictMaterial;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.tileentity.energy.ITileEntityEnergy;
import gregapi.tileentity.energy.ITileEntityEnergyDataCapacitor;
import gregapi.tileentity.machines.ITileEntityRunningPossible;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.ITileEntityMultiBlockController;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.tileentity.multiblocks.TileEntityBase10MultiBlockBase;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregapi.worldgen.StoneLayer;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class MultiTileEntityBedrockDrill
extends TileEntityBase10MultiBlockBase
implements ITileEntityEnergy,
ITileEntityEnergyDataCapacitor,
IMultiBlockEnergy,
IMultiBlockFluidHandler,
IFluidHandler,
ITileEntityRunningPossible {
    public long mEnergy = 0L;
    public int mType = this.rng(CS.BlocksGT.stones.length + (IL.EtFu_Deepslate_Cobble.exists() ? 2 : 1));
    public TagData mEnergyTypeAccepted = TD.Energy.RU;
    public FluidTankGT mTank = new FluidTankGT(16000L);
    public final List<OreDictMaterial> mList = new ArrayListNoNulls<OreDictMaterial>();
    private static final int[] ACCESSIBLE_SLOTS;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mEnergy = aNBT.getLong("gt.energy");
        this.mType = aNBT.getInteger("gt.value");
        if (aNBT.hasKey("gt.energy.accepted")) {
            this.mEnergyTypeAccepted = TagData.createTagData(aNBT.getString("gt.energy.accepted"));
        }
        this.mTank.readFromNBT(aNBT, "gt.tank.0");
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setNumber(aNBT, "gt.value", this.mType);
        this.mTank.writeToNBT(aNBT, "gt.tank.0");
    }

    @Override
    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        if (this.yCoord < 5) {
            return false;
        }
        this.mList.clear();
        boolean tSuccess = true;
        boolean tBedrock = true;
        boolean tOverride = false;
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                OreDictMaterialStack tMaterial;
                Block tBlock = this.getBlockOffset(i, -5, j);
                if (tBlock == CS.BlocksGT.oreBedrock) {
                    tMaterial = CS.BlocksGT.oreBedrock.getMaterialAtSide((IBlockAccess)this.worldObj, this.xCoord + i, this.yCoord - 5, this.zCoord + j, (byte)1);
                    this.mList.add(tMaterial.mMaterial);
                    this.mList.add(tMaterial.mMaterial);
                } else if (tBlock == CS.BlocksGT.oreSmallBedrock) {
                    tMaterial = CS.BlocksGT.oreSmallBedrock.getMaterialAtSide((IBlockAccess)this.worldObj, this.xCoord + i, this.yCoord - 5, this.zCoord + j, (byte)1);
                    this.mList.add(tMaterial.mMaterial);
                } else if (IL.HBM_Bedrock_Coltan.equal(tBlock)) {
                    this.mList.add(MT.OREMATS.Coltan);
                    this.mList.add(MT.OREMATS.Coltan);
                    this.mList.add(MT.OREMATS.Columbite);
                    this.mList.add(MT.OREMATS.Tantalite);
                    tOverride = true;
                } else if (IL.HBM_Bedrock_Oil.equal(tBlock)) {
                    this.mList.add(MT.Oilshale);
                    tOverride = true;
                } else if (!WD.bedrock(tBlock)) {
                    tBedrock = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, -4, j, 18103, this.getMultiTileEntityRegistryID(), 0, -1, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, -3, j, 18026, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, -2, j, 18026, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (i == 0 != (j == 0)) {
                    if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, -1, j, 18026, this.getMultiTileEntityRegistryID(), 3, -3, aCoordinates, aPlayer, aInventory)) {
                        tSuccess = false;
                    }
                } else if (!ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, -1, j, 18026, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) {
                    tSuccess = false;
                }
                if (ITileEntityMultiBlockController.Util.checkAndSetTargetOffset(this, i, 0, j, 18026, this.getMultiTileEntityRegistryID(), 0, -9, aCoordinates, aPlayer, aInventory)) continue;
                tSuccess = false;
            }
        }
        return tSuccess && (tBedrock || tOverride);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.structure") + ":");
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.bedrockdrill.1"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.bedrockdrill.2"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.bedrockdrill.3"));
        aList.add(LH.Chat.WHITE + LH.get("gt.tooltip.multiblock.bedrockdrill.4"));
        if (IL.HBM_Bedrock_Coltan.exists() || IL.HBM_Bedrock_Oil.exists()) {
            aList.add(LH.Chat.BLINKING_CYAN + LH.get("gt.tooltip.multiblock.bedrockdrill.5"));
        }
        aList.add(LH.Chat.GREEN + LH.get("gt.lang.energy.input") + ": " + LH.Chat.WHITE + "1024 to 4096 " + this.mEnergyTypeAccepted.getLocalisedChatNameShort() + LH.Chat.WHITE + "/t (up to 32768 " + this.mEnergyTypeAccepted.getLocalisedChatNameShort() + LH.Chat.WHITE + "/t total)");
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public boolean isInsideStructure(int aX, int aY, int aZ) {
        return aX >= this.xCoord - 1 && aY >= this.yCoord - 5 && aZ >= this.zCoord - 1 && aX <= this.xCoord + 1 && aY <= this.yCoord && aZ <= this.zCoord + 1;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            if (this.slotHas(0)) {
                ST.move(this.delegator((byte)1), this.getAdjacentInventory((byte)1));
            }
            if (this.mEnergy >= 32768L && !this.slotHas(0) && this.checkStructure(false) && this.mTank.drainAll(100L)) {
                int tSelector;
                this.mEnergy -= 32768L;
                if (this.rng(1000) == 0) {
                    this.mType = this.rng(CS.BlocksGT.stones.length + (IL.EtFu_Deepslate_Cobble.exists() ? 2 : 1));
                }
                if ((tSelector = this.rng(128)) < this.mList.size()) {
                    OreDictMaterial tMaterial;
                    OreDictMaterial oreDictMaterial = tMaterial = this.rng(32) == 0 ? UT.Code.select(this.mList.get(tSelector), this.mList.get((int)tSelector).mByProducts) : this.mList.get(tSelector);
                    if (tMaterial == ANY.Hexorium || ANY.Hexorium.mToThis.contains(tMaterial)) {
                        switch (this.rng(20)) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: 
                            case 9: {
                                tMaterial = MT.HexoriumWhite;
                                break;
                            }
                            case 10: 
                            case 11: 
                            case 12: 
                            case 13: 
                            case 14: 
                            case 15: 
                            case 16: {
                                tMaterial = MT.HexoriumBlack;
                                break;
                            }
                            case 17: {
                                tMaterial = MT.HexoriumRed;
                                break;
                            }
                            case 18: {
                                tMaterial = MT.HexoriumGreen;
                                break;
                            }
                            case 19: {
                                tMaterial = MT.HexoriumBlue;
                            }
                        }
                    }
                    if (this.worldObj.provider.dimensionId == -1) {
                        this.slot(0, ST.make((Block)CS.BlocksGT.oreBrokenNetherrack, 1L, (long)tMaterial.mID));
                    } else if (!WD.dimTF(this.worldObj)) {
                        if (WD.dimERE(this.worldObj)) {
                            IBlockPlacable tBlock = CS.BlocksGT.stoneToBrokenOres.get(new ItemStackContainer(IL.ERE_Umberstone.get(1L, new Object[0])));
                            this.slot(0, ST.make((Block)(tBlock instanceof Block ? tBlock : CS.BlocksGT.oreBroken), 1L, (long)tMaterial.mID));
                        } else if (WD.dimATUM(this.worldObj)) {
                            IBlockPlacable tBlock = CS.BlocksGT.stoneToBrokenOres.get(new ItemStackContainer(IL.ATUM_Limestone.get(1L, new Object[0])));
                            this.slot(0, ST.make((Block)(tBlock instanceof Block ? tBlock : CS.BlocksGT.oreBroken), 1L, (long)tMaterial.mID));
                        } else if (WD.dimBTL(this.worldObj)) {
                            IBlockPlacable tBlock = CS.BlocksGT.stoneToBrokenOres.get(new ItemStackContainer((this.mType % 2 == 0 ? IL.BTL_Pitstone : IL.BTL_Betweenstone).get(1L, new Object[0])));
                            this.slot(0, ST.make((Block)(tBlock instanceof Block ? tBlock : CS.BlocksGT.oreBroken), 1L, (long)tMaterial.mID));
                        } else if (this.mType < CS.BlocksGT.stones.length) {
                            this.slot(0, ST.make((Block)CS.BlocksGT.ores_broken[this.mType], 1L, (long)tMaterial.mID));
                        }
                    }
                    if (ST.invalid(this.slot(0)) && this.mType % 2 == 0 && IL.EtFu_Deepslate_Cobble.exists()) {
                        this.slot(0, ST.make((Block)StoneLayer.DEEPSLATE.mOreBroken, 1L, (long)tMaterial.mID));
                    }
                    if (ST.invalid(this.slot(0))) {
                        this.slot(0, ST.make((Block)CS.BlocksGT.oreBroken, 1L, (long)tMaterial.mID));
                    }
                } else {
                    if (this.rng(1000) == 0) {
                        this.slot(0, OP.dust.mat(MT.Bedrock, 1L));
                    } else if (this.worldObj.provider.dimensionId == -1) {
                        this.slot(0, ST.make(Blocks.netherrack, 1L, 0L));
                    } else if (WD.dimTF(this.worldObj)) {
                        switch (this.mType) {
                            case 0: {
                                this.slot(0, ST.make(Blocks.obsidian, 1L, 0L));
                                break;
                            }
                            case 1: {
                                this.slot(0, OP.blockDust.mat(MT.STONES.Mazestone, 1L));
                                break;
                            }
                            case 2: {
                                this.slot(0, IL.TF_Trollsteinn.get(1L, new Object[0]));
                                break;
                            }
                            case 3: {
                                this.slot(0, OP.blockDust.mat(MT.STONES.Castlerock, 1L));
                                break;
                            }
                            case 4: {
                                this.slot(0, IL.TF_Deadrock.get(1L, new Object[0]));
                            }
                        }
                    } else if (WD.dimERE(this.worldObj)) {
                        this.slot(0, IL.ERE_Umbercobble.get(1L, new Object[0]));
                    } else if (WD.dimATUM(this.worldObj)) {
                        this.slot(0, IL.ATUM_Limecobble.get(1L, new Object[0]));
                    } else if (WD.dimBTL(this.worldObj)) {
                        if (this.mType == 0) {
                            this.slot(0, OP.blockDust.mat(MT.STONES.Templerock, 1L));
                        } else {
                            switch (this.mType % 4) {
                                case 0: {
                                    this.slot(0, IL.BTL_Cragrock.get(1L, new Object[0]));
                                    break;
                                }
                                case 1: {
                                    this.slot(0, IL.BTL_Limestone.get(1L, new Object[0]));
                                    break;
                                }
                                case 2: {
                                    this.slot(0, IL.BTL_Pitstone.get(1L, new Object[0]));
                                    break;
                                }
                                case 3: {
                                    this.slot(0, IL.BTL_Betweenstone.get(1L, new Object[0]));
                                }
                            }
                        }
                    } else if (this.mType < CS.BlocksGT.stones.length) {
                        this.slot(0, ST.make(CS.BlocksGT.stones[this.mType], 1L, 1L));
                    }
                    if (ST.invalid(this.slot(0)) && this.mType % 2 == 0 && IL.EtFu_Deepslate_Cobble.exists()) {
                        this.slot(0, IL.EtFu_Deepslate_Cobble.get(1L, new Object[0]));
                    }
                    if (ST.invalid(this.slot(0))) {
                        this.slot(0, ST.make(Blocks.cobblestone, 1L, 0L));
                    }
                }
            }
        }
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("plunger")) {
            return CS.GarbageGT.trash(this.mTank);
        }
        return 0L;
    }

    @Override
    public void onMagnifyingGlass2(List<String> aChatReturn) {
        aChatReturn.add(this.mTank.content("WARNING: NO LUBRICANT!!!"));
    }

    @Override
    public byte getDefaultSide() {
        return 1;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_TOP;
    }

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        if (this.mEnergy > 40000L) {
            return 0L;
        }
        aSize = Math.abs(aSize);
        if (!aDoInject) {
            return aAmount;
        }
        if (aSize > this.getEnergySizeInputMax(aEnergyType, aSide)) {
            this.explode(6.0);
            return aAmount;
        }
        this.mEnergy += aAmount * aSize;
        return aAmount;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting && aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public boolean isEnergyAcceptingFrom(TagData aEnergyType, byte aSide, boolean aTheoretical) {
        return this.isEnergyType(aEnergyType, aSide, false);
    }

    @Override
    public boolean isEnergyCapacitorType(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted;
    }

    @Override
    public long getEnergyDemanded(TagData aEnergyType, byte aSide, long aSize) {
        return 4096L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return 2048L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 1024L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return 4096L;
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, byte aSide) {
        return aEnergyType == this.mEnergyTypeAccepted ? 40000L : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    public Collection<TagData> getEnergyCapacitorTypes(byte aSide) {
        return this.mEnergyTypeAccepted.AS_LIST;
    }

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return CS.FluidsGT.LUBRICANT.contains(aFluidToFill.getFluid().getName()) ? this.mTank : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.mTank;
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.mTank.AS_ARRAY;
    }

    @Override
    protected IFluidTank getFluidTankFillable2(byte aSide, FluidStack aFluidToFill) {
        return CS.FluidsGT.LUBRICANT.contains(aFluidToFill.getFluid().getName()) ? this.mTank : null;
    }

    @Override
    protected IFluidTank getFluidTankDrainable2(byte aSide, FluidStack aFluidToDrain) {
        return this.mTank;
    }

    @Override
    protected IFluidTank[] getFluidTanks2(byte aSide) {
        return this.mTank.AS_ARRAY;
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[1];
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return true;
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return true;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.multiblock.drill.bedrock";
    }

    @Override
    public boolean getStateRunningPossible() {
        return this.mStructureOkay && this.mTank.has(100L);
    }

    static {
        LH.add("gt.tooltip.multiblock.bedrockdrill.1", "3x3 Base of Bedrock Mining Drill Heads centered ontop Bedrock Ores");
        LH.add("gt.tooltip.multiblock.bedrockdrill.2", "Full 3x4x3 of Dense Titanium Walls ontop");
        LH.add("gt.tooltip.multiblock.bedrockdrill.3", "Main top-center inside the Titanium Tower facing upwards");
        LH.add("gt.tooltip.multiblock.bedrockdrill.4", "Requires Lubricant, Power and a 3x3 place on Bedrock(-Ore) to mine");
        LH.add("gt.tooltip.multiblock.bedrockdrill.5", "Also works on HBM's Bedrock Ores, even if it's not a full 3x3 of Bedrock");
        ACCESSIBLE_SLOTS = new int[]{0};
    }
}

