/*
 * Decompiled with CFR 0.152.
 */
package gregtech.tileentity.inventories;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.energy.ITileEntityEnergyElectricityAcceptor;
import gregapi.tileentity.energy.ITileEntityEnergyFluxHandler;
import gregapi.util.UT;
import gregtech.tileentity.inventories.MultiTileEntityLocker;
import java.util.Collection;
import net.minecraft.block.Block;

public class MultiTileEntityLockerCharging
extends MultiTileEntityLocker
implements ITileEntityEnergyElectricityAcceptor,
ITileEntityEnergyFluxHandler {
    public static IIconContainer[] sColoreds = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lockers/charging/colored/bottom"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/colored/top"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/colored/front"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/colored/back"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/colored/side")};
    public static IIconContainer[] sOverlays = new IIconContainer[]{new Textures.BlockIcons.CustomIcon("machines/lockers/charging/overlay/bottom"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/overlay/top"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/overlay/front"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/overlay/back"), new Textures.BlockIcons.CustomIcon("machines/lockers/charging/overlay/side")};

    @Override
    public long doInject(TagData aEnergyType, byte aSide, long aSize, long aAmount, boolean aDoInject) {
        long rReturn = 0L;
        for (int i = 0; i < 4; ++i) {
            if (!this.slotHas(i)) continue;
            rReturn += IItemEnergy.Utility.inject(aEnergyType, this.slot(i), aSize, aAmount - rReturn, this, this.getWorld(), this.getX(), this.getY(), this.getZ(), aDoInject);
        }
        return rReturn;
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, byte aSide, boolean aEmitting) {
        return !aEmitting;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, byte aSide) {
        return 1L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, byte aSide) {
        return Long.MAX_VALUE;
    }

    @Override
    public Collection<TagData> getEnergyTypes(byte aSide) {
        return TD.Energy.ALL;
    }

    @Override
    public boolean getStateRunningPassively() {
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public boolean getStateRunningPossible() {
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public boolean getStateRunningActively() {
        for (int i = 0; i < 4; ++i) {
            if (IItemEnergy.Utility.full(this.slot(i), true)) continue;
            return false;
        }
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public boolean getStateRunningSuccessfully() {
        for (int i = 0; i < 4; ++i) {
            if (IItemEnergy.Utility.full(this.slot(i), true)) continue;
            return false;
        }
        return UT.Code.containsSomething(this.getInventory());
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        if (!aShouldSideBeRendered[aSide]) {
            return null;
        }
        byte aIndex = aSide < 2 ? aSide : (aSide == this.mFacing ? (byte)2 : (aSide == CS.OPOS[this.mFacing] ? (byte)3 : 4));
        return BlockTextureMulti.get(BlockTextureDefault.get(sColoreds[aIndex], this.mRGBa, this.mMaterial.contains(TD.Properties.GLOWING)), BlockTextureDefault.get(sOverlays[aIndex]));
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.locker.charging";
    }
}

