/*
 * Decompiled with CFR 0.152.
 */
package gregtech.entities.ai;

import gregapi.data.CS;
import gregapi.util.ST;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathEntity;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;

public class EntityAIBetterAttackOnCollide
extends EntityAIBase {
    public World mWorld;
    public PathEntity mPath;
    public Class<?> mTargetClass;
    public EntityCreature mCreature;
    public int mAttackCoolDown;
    public int mPathCoolDown;
    public int mFailedPathFindingPenalty;
    public double mX;
    public double mY;
    public double mZ;
    public double mSpeedToTarget;
    public boolean mLastingMemory;

    public EntityAIBetterAttackOnCollide(EntityAIAttackOnCollide orig) {
        this.mTargetClass = orig.classTarget;
        this.mCreature = orig.attacker;
        this.mWorld = this.mCreature.worldObj;
        this.mSpeedToTarget = orig.speedTowardsTarget;
        this.mLastingMemory = orig.longMemory;
        this.setMutexBits(3);
    }

    public boolean shouldExecute() {
        EntityLivingBase entitylivingbase = this.mCreature.getAttackTarget();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.isEntityAlive()) {
            return false;
        }
        if (this.mTargetClass != null && !this.mTargetClass.isAssignableFrom(entitylivingbase.getClass())) {
            return false;
        }
        if (--this.mPathCoolDown <= 0) {
            this.mPath = this.mCreature.getNavigator().getPathToEntityLiving((Entity)entitylivingbase);
            this.mPathCoolDown = 4 + this.mCreature.getRNG().nextInt(7);
            return this.mPath != null;
        }
        return true;
    }

    public boolean continueExecuting() {
        EntityLivingBase tTarget = this.mCreature.getAttackTarget();
        return tTarget != null && tTarget.isEntityAlive() && (!this.mLastingMemory ? !this.mCreature.getNavigator().noPath() : this.mCreature.isWithinHomeDistance(MathHelper.floor_double((double)tTarget.posX), MathHelper.floor_double((double)tTarget.posY), MathHelper.floor_double((double)tTarget.posZ)));
    }

    public void startExecuting() {
        this.mCreature.getNavigator().setPath(this.mPath, this.mSpeedToTarget);
        this.mPathCoolDown = 0;
    }

    public void resetTask() {
        this.mCreature.getNavigator().clearPathEntity();
    }

    public void updateTask() {
        EntityLivingBase tTarget = this.mCreature.getAttackTarget();
        this.mCreature.getLookHelper().setLookPositionWithEntity((Entity)tTarget, 30.0f, 30.0f);
        double tTargetDistance = this.mCreature.getDistanceSq(tTarget.posX, tTarget.boundingBox.minY, tTarget.posZ);
        double tLookRadius = this.mCreature.width * this.mCreature.width * 4.0f + tTarget.width;
        --this.mPathCoolDown;
        if ((this.mLastingMemory || this.mCreature.getEntitySenses().canSee((Entity)tTarget)) && this.mPathCoolDown <= 0 && (this.mX == 0.0 && this.mY == 0.0 && this.mZ == 0.0 || tTarget.getDistanceSq(this.mX, this.mY, this.mZ) >= 1.0 || this.mCreature.getRNG().nextFloat() < 0.05f)) {
            PathPoint tPathPoint;
            this.mX = tTarget.posX;
            this.mY = tTarget.boundingBox.minY;
            this.mZ = tTarget.posZ;
            this.mPathCoolDown = this.mFailedPathFindingPenalty + 4 + this.mCreature.getRNG().nextInt(7);
            this.mFailedPathFindingPenalty = this.mCreature.getNavigator().getPath() != null ? ((tPathPoint = this.mCreature.getNavigator().getPath().getFinalPathPoint()) != null && tTarget.getDistanceSq((double)tPathPoint.xCoord, (double)tPathPoint.yCoord, (double)tPathPoint.zCoord) < 1.0 ? 0 : (this.mFailedPathFindingPenalty += 10)) : (this.mFailedPathFindingPenalty += 10);
            if (tTargetDistance > 1024.0) {
                this.mPathCoolDown += 10;
            } else if (tTargetDistance > 256.0) {
                this.mPathCoolDown += 5;
            }
            if (!this.mCreature.getNavigator().tryMoveToEntityLiving((Entity)tTarget, this.mSpeedToTarget)) {
                this.mPathCoolDown += 15;
            }
        }
        this.mAttackCoolDown = Math.max(this.mAttackCoolDown - 1, 0);
        if (tTargetDistance <= tLookRadius && this.mAttackCoolDown <= 0) {
            this.mAttackCoolDown = 5;
            boolean tAttacking = true;
            ItemStack tHeld = ST.valisize(this.mCreature.getHeldItem());
            if (tHeld != null) {
                this.mCreature.swingItem();
                if (CS.ZOMBIES_IGNITE_HELD_TNT && ST.equal_(tHeld, Blocks.tnt)) {
                    this.mAttackCoolDown = 20;
                    tAttacking = false;
                    if (--tHeld.stackSize <= 0) {
                        this.mCreature.setCurrentItemOrArmor(0, CS.NI);
                    }
                    if (!this.mWorld.isRemote) {
                        EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(this.mWorld, this.mCreature.posX, this.mCreature.posY, this.mCreature.posZ, (EntityLivingBase)this.mCreature);
                        this.mWorld.spawnEntityInWorld((Entity)entitytntprimed);
                        this.mWorld.playSoundAtEntity((Entity)entitytntprimed, "game.tnt.primed", 1.0f, 1.0f);
                    }
                } else if (CS.ZOMBIES_DIG_WITH_TOOLS) {
                    // empty if block
                }
            }
            if (tAttacking) {
                this.mCreature.attackEntityAsMob((Entity)tTarget);
            }
        }
    }
}

