/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks.fluids;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.fluids.BlockWaterlike;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class BlockRiver
extends BlockWaterlike {
    public static boolean PLACEMENT_ALLOWED = false;
    public static boolean FLOWS_OUT = true;

    public BlockRiver(String aName, Fluid aFluid) {
        super(aName, aFluid, FLOWS_OUT, true);
        this.tickRate = 20;
    }

    public void onBlockAdded(World aWorld, int aX, int aY, int aZ) {
        if (PLACEMENT_ALLOWED) {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, 10 + CS.RNGSUS.nextInt(90));
        } else {
            aWorld.setBlockToAir(aX, aY, aZ);
        }
    }

    public void onNeighborBlockChange(World aWorld, int aX, int aY, int aZ, Block aBlock) {
        if (aWorld.getBlock(aX, aY - 1, aZ) == Blocks.grass) {
            aWorld.setBlock(aX, aY - 1, aZ, Blocks.dirt, 1, 2);
        }
        super.onNeighborBlockChange(aWorld, aX, aY, aZ, aBlock);
    }

    public void updateTick(World aWorld, int aX, int aY, int aZ, Random aRandom) {
        PLACEMENT_ALLOWED = true;
        if (aWorld.doChunksNearChunkExist(aX, aY, aZ, 33)) {
            aWorld.func_147451_t(aX, aY, aZ);
            WD.update((IBlockAccess)aWorld, aX, aY, aZ);
            if (aY > 0) {
                if (aWorld.getBlock(aX, aY - 1, aZ) == this) {
                    aWorld.scheduleBlockUpdate(aX, aY - 1, aZ, (Block)this, this.tickRate);
                } else {
                    aWorld.func_147451_t(aX, aY - 1, aZ);
                    WD.update((IBlockAccess)aWorld, aX, aY - 1, aZ);
                }
            }
        } else {
            aWorld.scheduleBlockUpdate(aX, aY, aZ, (Block)this, Math.max(600, this.tickRate));
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (aY <= 0) {
            this.updateFlow(aWorld, aX, aY, aZ, aRandom);
            PLACEMENT_ALLOWED = false;
            return;
        }
        if (WD.meta((IBlockAccess)aWorld, aX, aY, aZ) != 0) {
            int tRiverCounter = 0;
            for (byte tSide : CS.ALL_SIDES_HORIZONTAL) {
                if (WD.block(aWorld, aX, aY, aZ, tSide) != this || WD.meta(aWorld, aX, aY, aZ, tSide) != 0) continue;
                tRiverCounter = (byte)(tRiverCounter + 1);
            }
            if (tRiverCounter >= 2) {
                aWorld.setBlock(aX, aY, aZ, (Block)this, 0, WATER_UPDATE_FLAGS);
            }
        }
        this.updateFlow(aWorld, aX, aY, aZ, aRandom);
        PLACEMENT_ALLOWED = false;
    }

    @Override
    public FluidStack drain(World aWorld, int aX, int aY, int aZ, boolean aDoDrain) {
        if (!this.isSourceBlock((IBlockAccess)aWorld, aX, aY, aZ)) {
            return null;
        }
        if (aDoDrain) {
            aWorld.setBlockToAir(aX, aY, aZ);
        }
        return FL.Water.make(1000L);
    }

    @Override
    public int colorMultiplier(IBlockAccess aWorld, int aX, int aY, int aZ) {
        int rR = 0;
        int rG = 0;
        int rB = 0;
        for (int tX = -1; tX <= 1; ++tX) {
            for (int tZ = -1; tZ <= 1; ++tZ) {
                int tRGB = aWorld.getBiomeGenForCoords(aX + tX, aZ + tZ).getWaterColorMultiplier();
                rR += UT.Code.getR(tRGB);
                rG += UT.Code.getG(tRGB);
                rB += UT.Code.getB(tRGB);
            }
        }
        return UT.Code.getRGBInt(rR / 9, rG / 9, rB / 9);
    }
}

