/*
 * Decompiled with CFR 0.152.
 */
package gregtech.blocks;

import gregapi.block.BlockBaseMeta;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.RM;
import gregapi.old.Textures;
import gregapi.render.IconContainerCopied;
import gregapi.util.CR;
import gregapi.util.ST;
import gregapi.util.WD;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockGrass
extends BlockBaseMeta {
    public static final IconContainerCopied DIRT;

    public BlockGrass(String aUnlocalised) {
        super(null, aUnlocalised, Material.grass, soundTypeGrass, 6L, Textures.BlockIcons.GRASSES_TOP);
        LH.add(this.getUnlocalizedName() + ".0", "Grass");
        LH.add(this.getUnlocalizedName() + ".1", "Grass");
        LH.add(this.getUnlocalizedName() + ".2", "Grass");
        LH.add(this.getUnlocalizedName() + ".3", "Grass");
        LH.add(this.getUnlocalizedName() + ".4", "Grass");
        LH.add(this.getUnlocalizedName() + ".5", "Grass");
        LH.add(this.getUnlocalizedName() + ".6", "Grass");
        LH.add(this.getUnlocalizedName() + ".7", "Grass");
        LH.add(this.getUnlocalizedName() + ".8", "Grass");
        LH.add(this.getUnlocalizedName() + ".9", "Grass");
        LH.add(this.getUnlocalizedName() + ".10", "Grass");
        LH.add(this.getUnlocalizedName() + ".11", "Grass");
        LH.add(this.getUnlocalizedName() + ".12", "Grass");
        LH.add(this.getUnlocalizedName() + ".13", "Grass");
        LH.add(this.getUnlocalizedName() + ".14", "Grass");
        LH.add(this.getUnlocalizedName() + ".15", "Grass");
        CS.BlocksGT.drillableDynamite.add(this);
        CS.BlocksGT.harvestableSpade.add(this);
        CS.BlocksGT.plantableGreens.add(this);
        CS.BlocksGT.plantableTrees.add(this);
        CS.BlocksGT.plantableGrass.add(this);
        RM.generify(ST.make(this, 1L, 32767L), ST.make((Block)Blocks.grass, 1L, 0L));
        CR.shapeless(ST.make((Block)Blocks.grass, 1L, 0L), new Object[]{this});
        CR.shapeless(ST.make(this, 8L, 0L), new Object[]{Blocks.grass, Blocks.grass, Blocks.grass, CS.DYE_OREDICTS[2], Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass});
        CR.shapeless(ST.make(this, 8L, 1L), new Object[]{Blocks.grass, Blocks.grass, Blocks.grass, CS.DYE_OREDICTS[10], Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass});
        CR.shapeless(ST.make(this, 8L, 2L), new Object[]{Blocks.grass, Blocks.grass, Blocks.grass, CS.DYE_OREDICTS[0], Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass});
        CR.shapeless(ST.make(this, 8L, 3L), new Object[]{Blocks.grass, Blocks.grass, Blocks.grass, CS.DYE_OREDICTS[7], Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass});
        CR.shapeless(ST.make(this, 8L, 4L), new Object[]{Blocks.grass, Blocks.grass, Blocks.grass, CS.DYE_OREDICTS[11], Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass});
        CR.shapeless(ST.make(this, 8L, 5L), new Object[]{Blocks.grass, Blocks.grass, Blocks.grass, CS.DYE_OREDICTS[3], Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass, Blocks.grass});
        if (CS.COMPAT_FR != null) {
            CS.COMPAT_FR.addToBackpacks("digger", ST.make(this, 1L, 32767L));
        }
    }

    @Override
    public void addInformation(ItemStack aStack, byte aMeta, EntityPlayer aPlayer, List<String> aList, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.grass.tooltip"));
        aList.add(LH.Chat.GRAY + LH.get("gt.grass.tooltip.spray"));
    }

    @Override
    public boolean canSustainPlant(IBlockAccess aWorld, int aX, int aY, int aZ, ForgeDirection aSide, IPlantable aPlant) {
        EnumPlantType tType = aPlant.getPlantType(aWorld, aX + aSide.offsetX, aY + aSide.offsetY, aZ + aSide.offsetZ);
        return tType == EnumPlantType.Plains || tType == EnumPlantType.Beach && (WD.anywater(aWorld, aX + 1, aY, aZ) || WD.anywater(aWorld, aX - 1, aY, aZ) || WD.anywater(aWorld, aX, aY, aZ + 1) || WD.anywater(aWorld, aX, aY, aZ - 1));
    }

    @Override
    public IIcon getIcon(int aSide, int aMeta) {
        return (CS.SIDES_BOTTOM[aSide] ? DIRT : (CS.SIDES_TOP[aSide] ? Textures.BlockIcons.GRASSES_TOP : Textures.BlockIcons.GRASSES_SIDE)[aMeta % 16]).getIcon(0);
    }

    public ArrayList<ItemStack> getDrops(World aWorld, int aX, int aY, int aZ, int aMeta, int aFortune) {
        return ST.arraylist(ST.make(Blocks.dirt, 1L, 0L));
    }

    @Override
    public boolean doesPistonPush(byte aMeta) {
        return true;
    }

    @Override
    public boolean canCreatureSpawn(byte aMeta) {
        return false;
    }

    @Override
    public boolean isSealable(byte aMeta, byte aSide) {
        return false;
    }

    @Override
    public String getHarvestTool(int aMeta) {
        return "shovel";
    }

    @Override
    public int getHarvestLevel(int aMeta) {
        return 0;
    }

    @Override
    public float getBlockHardness(World aWorld, int aX, int aY, int aZ) {
        return Blocks.grass.getBlockHardness(aWorld, aX, aY, aZ);
    }

    @Override
    public float getExplosionResistance(byte aMeta) {
        return Blocks.grass.getExplosionResistance(null);
    }

    static {
        LH.add("gt.grass.tooltip", "Does not spread, get eaten, change color nor need light");
        LH.add("gt.grass.tooltip.spray", "Spray Paint can also be used to dye Grass!");
        DIRT = new IconContainerCopied(Blocks.dirt, 0L, 0L);
    }
}

