/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.transformers;

import gregtech.asm.GT_ASM;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodNode;

public class Minecraft_IceHarvestMissingHookFix
implements IClassTransformer {
    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!transformedName.equals("net.minecraft.block.BlockIce")) {
            return basicClass;
        }
        ClassNode classNode = GT_ASM.makeNodes(basicClass);
        for (MethodNode m : classNode.methods) {
            if (!m.name.equals("harvestBlock") && (!m.name.equals("a") || !m.desc.equals("(Lahb;Lyz;IIII)V"))) continue;
            GT_ASM.logger.info("Transforming net.minecraft.block.BlockIce.harvestBlock");
            AbstractInsnNode end = m.instructions.getLast();
            while (end.getOpcode() != 1) {
                end = end.getPrevious();
            }
            end = end.getNext();
            AbstractInsnNode start = end.getPrevious();
            while (!(start instanceof FieldInsnNode) || !((FieldInsnNode)start).name.equals("harvesters")) {
                start = start.getPrevious();
            }
            start = start.getPrevious();
            while (!(start instanceof FieldInsnNode) || !((FieldInsnNode)start).name.equals("harvesters")) {
                start = start.getPrevious();
            }
            start = start.getPrevious();
            AbstractInsnNode label = m.instructions.getLast().getPrevious();
            while (!(label instanceof LabelNode)) {
                label = label.getPrevious();
            }
            while (start != end) {
                AbstractInsnNode next = start.getNext();
                m.instructions.remove(start);
                m.instructions.insertBefore(label, start);
                start = next;
            }
            m.instructions.remove(end);
            m.instructions.insertBefore(label, end);
        }
        return GT_ASM.writeByteArraySelfReferenceFixup(classNode);
    }
}

