/*
 * Decompiled with CFR 0.152.
 */
package gregtech;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregapi.GT_API;
import gregapi.api.Abstract_Mod;
import gregapi.api.Abstract_Proxy;
import gregapi.block.IBlockToolable;
import gregapi.block.metatype.BlockStones;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ArrayListNoNulls;
import gregapi.code.HashSetNoNulls;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import gregtech.blocks.fluids.BlockWaterlike;
import gregtech.entities.Override_Drops;
import gregtech.entities.ai.EntityAIBetterAttackOnCollide;
import gregtech.entities.projectiles.EntityArrow_Material;
import gregtech.tileentity.misc.MultiTileEntityCertificate;
import java.util.EnumSet;
import java.util.Scanner;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackOnCollide;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.util.MovingObjectPosition;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.terraingen.BiomeEvent;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.fluids.Fluid;

public abstract class GT_Proxy
extends Abstract_Proxy {
    public final HashSetNoNulls<String> mSupporterListSilver = new HashSetNoNulls();
    public final HashSetNoNulls<String> mSupporterListGold = new HashSetNoNulls();
    public String mMessage = "";
    public boolean mDisableVanillaOres = true;
    public boolean mDisableVanillaLakes = true;
    public boolean mVersionOutdated = false;
    public int mSkeletonsShootGTArrows = 16;
    public int mFlintChance = 30;
    private static final EnumSet<OreGenEvent.GenerateMinable.EventType> PREVENTED_ORES = EnumSet.of(OreGenEvent.GenerateMinable.EventType.COAL, new OreGenEvent.GenerateMinable.EventType[]{OreGenEvent.GenerateMinable.EventType.IRON, OreGenEvent.GenerateMinable.EventType.GOLD, OreGenEvent.GenerateMinable.EventType.DIAMOND, OreGenEvent.GenerateMinable.EventType.REDSTONE, OreGenEvent.GenerateMinable.EventType.LAPIS, OreGenEvent.GenerateMinable.EventType.QUARTZ});
    private static final HashSetNoNulls<String> CHECKED_PLAYERS = new HashSetNoNulls();

    public GT_Proxy() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.ORE_GEN_BUS.register((Object)this);
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    @Override
    public void onProxyBeforePreInit(Abstract_Mod aMod, FMLPreInitializationEvent aEvent) {
        Scanner tScanner;
        super.onProxyBeforePreInit(aMod, aEvent);
        try {
            tScanner = new Scanner(this.getClass().getResourceAsStream("/supporterlist.txt"));
            while (tScanner.hasNextLine()) {
                this.mSupporterListSilver.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        try {
            tScanner = new Scanner(this.getClass().getResourceAsStream("/supporterlistgold.txt"));
            while (tScanner.hasNextLine()) {
                this.mSupporterListGold.add(tScanner.nextLine().toLowerCase());
            }
            tScanner.close();
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        this.mSupporterListSilver.removeAll(this.mSupporterListGold);
    }

    @SubscribeEvent
    public void onClientConnectedToServerEvent(FMLNetworkEvent.ClientConnectedToServerEvent aEvent) {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEndermanTeleportEvent(EnderTeleportEvent aEvent) {
        if (aEvent.entityLiving instanceof EntityEnderman && aEvent.entityLiving.getActivePotionEffect(Potion.weakness) != null) {
            aEvent.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onOreGenEvent(OreGenEvent.GenerateMinable aEvent) {
        if (this.mDisableVanillaOres && !WD.dimTF(aEvent.world) && PREVENTED_ORES.contains(aEvent.type)) {
            aEvent.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTerrainGenEvent(DecorateBiomeEvent.Decorate aEvent) {
        if (aEvent.world.provider.dimensionId == 0) {
            String tClassName;
            if (MD.RTG.mLoaded && ("WorldProviderSurfaceRTG".equalsIgnoreCase(tClassName = UT.Reflection.getLowercaseClass(aEvent.world.provider.terrainType)) || "WorldTypeRTG".equalsIgnoreCase(tClassName))) {
                return;
            }
            if (CS.GENERATE_STREETS && (UT.Code.inside(-48L, 47L, aEvent.chunkX) || UT.Code.inside(-48L, 47L, aEvent.chunkZ))) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
            if (CS.GENERATE_BIOMES && UT.Code.inside(-96L, 95L, aEvent.chunkX) && UT.Code.inside(-96L, 95L, aEvent.chunkZ)) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onTerrainGenEvent(PopulateChunkEvent.Populate aEvent) {
        if (aEvent.world.provider.dimensionId == 0) {
            String tClassName;
            if (this.mDisableVanillaLakes && (aEvent.type == PopulateChunkEvent.Populate.EventType.LAKE || aEvent.type == PopulateChunkEvent.Populate.EventType.LAVA)) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
            if (MD.RTG.mLoaded && ("WorldProviderSurfaceRTG".equalsIgnoreCase(tClassName = UT.Reflection.getLowercaseClass(aEvent.world.provider.terrainType)) || "WorldTypeRTG".equalsIgnoreCase(tClassName))) {
                return;
            }
            if (CS.GENERATE_STREETS && (UT.Code.inside(-48L, 47L, aEvent.chunkX) || UT.Code.inside(-48L, 47L, aEvent.chunkZ))) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
            if (CS.GENERATE_BIOMES && UT.Code.inside(-96L, 95L, aEvent.chunkX) && UT.Code.inside(-96L, 95L, aEvent.chunkZ)) {
                aEvent.setResult(Event.Result.DENY);
                return;
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGetVillageBlockIDEvent(BiomeEvent.GetVillageBlockID aEvent) {
        if (aEvent.original == Blocks.cobblestone) {
            aEvent.replacement = aEvent.biome == null ? CS.BlocksGT.Andesite : CS.BlocksGT.stones[(aEvent.biome.biomeID + 6) % CS.BlocksGT.stones.length];
            aEvent.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onGetVillageBlockMetaEvent(BiomeEvent.GetVillageBlockMeta aEvent) {
        if (aEvent.original == Blocks.cobblestone || aEvent.original instanceof BlockStones) {
            aEvent.replacement = 12;
            aEvent.setResult(Event.Result.DENY);
        }
        if (aEvent.original == Blocks.sandstone) {
            aEvent.replacement = 2;
            aEvent.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteraction(PlayerInteractEvent aEvent) {
        ItemStack aStack;
        if (aEvent.entityPlayer == null || aEvent.entityPlayer.worldObj == null || aEvent.action == null || aEvent.world.provider == null) {
            return;
        }
        String aName = aEvent.entityPlayer.getCommandSenderName();
        String aNameLowercase = aName.toLowerCase();
        if (!aEvent.world.isRemote && CHECKED_PLAYERS.add(aName) && (this.mSupporterListSilver.contains(aEvent.entityPlayer.getUniqueID().toString()) || this.mSupporterListGold.contains(aEvent.entityPlayer.getUniqueID().toString()) || this.mSupporterListSilver.contains(aNameLowercase) || this.mSupporterListGold.contains(aNameLowercase)) && !MultiTileEntityCertificate.ALREADY_RECEIVED.contains(aNameLowercase) && ST.give((Entity)aEvent.entityPlayer, MultiTileEntityCertificate.getCertificate(1, aName), false)) {
            MultiTileEntityCertificate.ALREADY_RECEIVED.add(aNameLowercase);
            UT.Entities.sendchat((Object)aEvent.entityPlayer, CS.CHAT_GREG + "Thank you, " + aName + ", for Supporting GregTech! Here, have a Certificate. ;)");
        }
        if ((aStack = aEvent.entityPlayer.getCurrentEquippedItem()) != null && aStack.stackSize > 0) {
            if (aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_AIR) {
                if (aStack.getItem() == Items.glass_bottle) {
                    aEvent.setCanceled(true);
                    if (aEvent.world.isRemote) {
                        GT_API.api_proxy.sendUseItemPacket(aEvent.entityPlayer, aEvent.world, aStack);
                        return;
                    }
                    MovingObjectPosition tTarget = WD.getMOP(aEvent.world, aEvent.entityPlayer, true);
                    if (tTarget == null || tTarget.typeOfHit != MovingObjectPosition.MovingObjectType.BLOCK || !aEvent.world.canMineBlock(aEvent.entityPlayer, tTarget.blockX, tTarget.blockY, tTarget.blockZ) || !aEvent.entityPlayer.canPlayerEdit(tTarget.blockX, tTarget.blockY, tTarget.blockZ, tTarget.sideHit, aStack)) {
                        return;
                    }
                    Block tBlock = aEvent.world.getBlock(tTarget.blockX, tTarget.blockY, tTarget.blockZ);
                    if (tBlock == Blocks.water || tBlock == Blocks.flowing_water) {
                        if (aEvent.world.getBlockMetadata(tTarget.blockX, tTarget.blockY, tTarget.blockZ) != 0) {
                            return;
                        }
                        for (int i = 0; i < 3 && aStack.stackSize > 0; ++i) {
                            if (aStack.stackSize == 1) {
                                aEvent.entityPlayer.inventory.mainInventory[aEvent.entityPlayer.inventory.currentItem] = ST.make((Item)Items.potionitem, 1L, 0L);
                                continue;
                            }
                            ST.use((Entity)aEvent.entityPlayer, aStack);
                            ST.give((Entity)aEvent.entityPlayer, ST.make((Item)Items.potionitem, 1L, 0L), false);
                        }
                        if (!WD.infiniteWater(aEvent.world, tTarget.blockX, tTarget.blockY, tTarget.blockZ)) {
                            aEvent.world.setBlockToAir(tTarget.blockX, tTarget.blockY, tTarget.blockZ);
                        }
                        ST.update((Entity)aEvent.entityPlayer);
                        return;
                    }
                    if (tBlock == CS.BlocksGT.River || WD.waterstream(tBlock)) {
                        ItemStack tStack = FL.Water.fill(aStack);
                        if (tStack == null) {
                            return;
                        }
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        ST.give((Entity)aEvent.entityPlayer, tStack, false);
                        return;
                    }
                    if (tBlock == CS.BlocksGT.Ocean) {
                        ItemStack tStack = FL.Ocean.fill(aStack);
                        if (tStack == null) {
                            return;
                        }
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        ST.give((Entity)aEvent.entityPlayer, tStack, false);
                        return;
                    }
                    if (tBlock == CS.BlocksGT.Swamp) {
                        ItemStack tStack = FL.Dirty_Water.fill(aStack);
                        if (tStack == null) {
                            return;
                        }
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        ST.give((Entity)aEvent.entityPlayer, tStack, false);
                        return;
                    }
                    return;
                }
                if (aStack.getItem() == Items.bucket) {
                    Block tBlock;
                    MovingObjectPosition tTarget = WD.getMOP(aEvent.world, aEvent.entityPlayer, true);
                    if (tTarget != null && tTarget.typeOfHit == MovingObjectPosition.MovingObjectType.BLOCK && (tBlock = aEvent.world.getBlock(tTarget.blockX, tTarget.blockY, tTarget.blockZ)) instanceof BlockWaterlike && tBlock != CS.BlocksGT.River) {
                        aEvent.setCanceled(true);
                    }
                    return;
                }
            }
            if (aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
                OreDictItemData tData;
                if (IL.ERE_Spray_Repellant.equal(aStack, true, true)) {
                    if (!aEvent.world.isRemote && aStack.getItem().onItemUse(aStack, aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, aEvent.face, 0.5f, 0.5f, 0.5f)) {
                        aEvent.setCanceled(true);
                        ST.give((Entity)aEvent.entityPlayer, IL.Spray_Empty.get(1L, new Object[0]), aEvent.world, aEvent.x, aEvent.y, aEvent.z);
                        return;
                    }
                } else if (aStack.getItem() == Items.flint_and_steel) {
                    if (!aEvent.world.isRemote && !UT.Entities.hasInfiniteItems(aEvent.entityPlayer) && CS.RNGSUS.nextInt(100) >= this.mFlintChance) {
                        aEvent.setCanceled(true);
                        aStack.damageItem(1, (EntityLivingBase)aEvent.entityPlayer);
                        if (aStack.getItemDamage() >= aStack.getMaxDamage()) {
                            ST.use((Entity)aEvent.entityPlayer, aStack);
                        }
                        return;
                    }
                    ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
                    long tDamage = IBlockToolable.Util.onToolClick("igniter", aStack.getItemDamage() * 10000, 1L, (Entity)aEvent.entityPlayer, tChatReturn, (IInventory)aEvent.entityPlayer.inventory, aEvent.entityPlayer.isSneaking(), aStack, aEvent.world, (byte)aEvent.face, aEvent.x, aEvent.y, aEvent.z, 0.5f, 0.5f, 0.5f);
                    UT.Entities.sendchat((Object)aEvent.entityPlayer, tChatReturn, false);
                    if (tDamage > 0L) {
                        aEvent.setCanceled(true);
                        UT.Sounds.send("fire.ignite", aEvent.world, aEvent.x, aEvent.y, aEvent.z);
                        if (!UT.Entities.hasInfiniteItems(aEvent.entityPlayer)) {
                            aStack.damageItem(UT.Code.bindInt(UT.Code.units(tDamage, 10000L, 1L, true)), (EntityLivingBase)aEvent.entityPlayer);
                            if (aStack.getItemDamage() >= aStack.getMaxDamage()) {
                                ST.use((Entity)aEvent.entityPlayer, aStack);
                            }
                        }
                        return;
                    }
                } else if (IL.Food_Toast_Sliced.equal(aStack, false, true) || IL.Food_Toasted_Sliced.equal(aStack, false, true)) {
                    int tUsed = Math.min(16, aStack.stackSize);
                    if (!aEvent.world.isRemote && aEvent.entityPlayer.isSneaking() && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32105, ST.save("sandwich.0", ST.amount(tUsed, aStack))).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, tUsed);
                        aEvent.setCanceled(true);
                    }
                } else if (aStack.getItem() == Items.stick || IL.Stick.equal(aStack) || OM.is("stickAnyNormalWood", aStack)) {
                    if (!aEvent.world.isRemote && aEvent.entityPlayer.isSneaking() && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32073).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        aEvent.setCanceled(true);
                    }
                } else if (aStack.getItem() == Items.flint) {
                    if (!aEvent.world.isRemote && aEvent.entityPlayer.isSneaking() && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32074, ST.save("gt.value", ST.amount(1L, aStack))).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        aEvent.setCanceled(true);
                    }
                } else if (!aEvent.world.isRemote && aEvent.entityPlayer.isSneaking() && ST.block(aStack) == CS.NB && (tData = OM.anyassociation_(aStack)) != null) {
                    if ((tData.mPrefix == OP.rockGt || tData.mPrefix == OP.oreRaw) && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32074, ST.save("gt.value", ST.amount(1L, aStack))).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.ingot && (!MD.BOTA.mLoaded || tData.mMaterial.mMaterial.mOriginalMod != MD.BOTA || Blocks.beacon != aEvent.world.getBlock(aEvent.x, aEvent.y, aEvent.z)) && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32084, ST.save("gt.value", aStack)).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.stackSize);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.plate && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32085, ST.save("gt.value", aStack)).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.stackSize);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.plateGem && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32086, ST.save("gt.value", aStack)).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.stackSize);
                        aEvent.setCanceled(true);
                    }
                    if (tData.mPrefix == OP.scrapGt && MultiTileEntityRegistry.getRegistry("gt.multitileentity").getItem(32103, ST.save("gt.value", aStack)).tryPlaceItemIntoWorld(aEvent.entityPlayer, aEvent.world, aEvent.x, aEvent.y, aEvent.z, (int)((byte)aEvent.face), 0.5f, 0.5f, 0.5f)) {
                        ST.use((Entity)aEvent.entityPlayer, aStack, aStack.stackSize);
                        aEvent.setCanceled(true);
                    }
                }
            }
        } else if (aEvent.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && aEvent.entityPlayer.isBurning()) {
            ArrayListNoNulls<String> tChatReturn = new ArrayListNoNulls<String>();
            long tDamage = IBlockToolable.Util.onToolClick("igniter", Long.MAX_VALUE, 1L, (Entity)aEvent.entityPlayer, tChatReturn, (IInventory)aEvent.entityPlayer.inventory, aEvent.entityPlayer.isSneaking(), CS.NI, aEvent.world, (byte)aEvent.face, aEvent.x, aEvent.y, aEvent.z, 0.5f, 0.5f, 0.5f);
            UT.Entities.sendchat((Object)aEvent.entityPlayer, tChatReturn, false);
            if (tDamage > 0L) {
                UT.Sounds.send("fire.ignite", aEvent.world, aEvent.x, aEvent.y, aEvent.z);
                aEvent.setCanceled(true);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntitySpawningEvent(EntityJoinWorldEvent aEvent) {
        if (aEvent.entity == null) {
            return;
        }
        if (aEvent.entity instanceof EntityLiving) {
            EntityAITasks tTasks = ((EntityLiving)aEvent.entity).tasks;
            if (tTasks != null) {
                if (aEvent.entity instanceof EntityVillager) {
                    tTasks.addTask(3, (EntityAIBase)new EntityAITempt((EntityCreature)aEvent.entity, 0.6, Items.emerald, false));
                }
                if (aEvent.entity instanceof EntityOcelot && CS.ItemsGT.CANS != null) {
                    tTasks.addTask(3, (EntityAIBase)new EntityAITempt((EntityCreature)aEvent.entity, 0.6, (Item)CS.ItemsGT.CANS, true));
                }
                if (aEvent.entity instanceof EntityZombie) {
                    for (int i = 0; i < tTasks.taskEntries.size(); ++i) {
                        EntityAITasks.EntityAITaskEntry tEntry = (EntityAITasks.EntityAITaskEntry)tTasks.taskEntries.get(i);
                        if (tEntry.action.getClass() != EntityAIAttackOnCollide.class) continue;
                        tEntry.action = new EntityAIBetterAttackOnCollide((EntityAIAttackOnCollide)tEntry.action);
                    }
                }
            }
            if (!aEvent.entity.worldObj.isRemote && !aEvent.entity.getEntityData().hasKey("gt.spawned")) {
                if (aEvent.entity instanceof EntityZombie && !((EntityZombie)aEvent.entity).isChild() && ST.invalid(((EntityZombie)aEvent.entity).getEquipmentInSlot(0))) {
                    if (CS.ZOMBIES_HOLD_TNT && CS.RNGSUS.nextInt(250) == 0) {
                        ((EntityZombie)aEvent.entity).setCurrentItemOrArmor(0, ST.make(Blocks.tnt, (long)(1 + CS.RNGSUS.nextInt(2)), 0L));
                    } else if (CS.ZOMBIES_HOLD_PICKAXES && CS.RNGSUS.nextInt(100) == 0) {
                        ((EntityZombie)aEvent.entity).setCurrentItemOrArmor(0, ST.make(Items.iron_pickaxe, 1L, Items.iron_pickaxe.getMaxDamage() < 5 ? 0L : (long)(1 + CS.RNGSUS.nextInt(Items.iron_pickaxe.getMaxDamage() - 2))));
                    }
                }
                aEvent.entity.getEntityData().setBoolean("gt.spawned", true);
            }
            return;
        }
        if (aEvent.entity.worldObj.isRemote) {
            return;
        }
        if (this.mSkeletonsShootGTArrows > 0 && aEvent.entity.getClass() == EntityArrow.class && CS.RNGSUS.nextInt(this.mSkeletonsShootGTArrows) == 0 && ((EntityArrow)aEvent.entity).shootingEntity instanceof EntitySkeleton) {
            OreDictMaterial tMaterial = MT.Craponite;
            switch (CS.RNGSUS.nextInt(10)) {
                case 0: {
                    tMaterial = MT.Steel;
                    break;
                }
                case 1: {
                    tMaterial = MT.AnnealedCopper;
                    break;
                }
                case 2: {
                    tMaterial = MT.AstralSilver;
                    break;
                }
                case 3: {
                    tMaterial = MT.BismuthBronze;
                    break;
                }
                case 4: {
                    tMaterial = MT.Pt;
                    break;
                }
                case 5: {
                    tMaterial = MT.Netherite;
                    break;
                }
                case 6: {
                    tMaterial = MT.Efrine;
                    break;
                }
                case 7: {
                    tMaterial = MT.Rubber;
                    break;
                }
                case 8: {
                    tMaterial = MT.DamascusSteel;
                    break;
                }
                case 9: {
                    tMaterial = MT.Craponite;
                }
            }
            ItemStack tArrow = OP.arrowGtWood.mat(tMaterial, 1L);
            if (ST.valid(tArrow)) {
                aEvent.entity.worldObj.spawnEntityInWorld((Entity)new EntityArrow_Material((EntityArrow)aEvent.entity, tArrow));
                aEvent.entity.setDead();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onEntityLivingDropsEventEvent(LivingDropsEvent aEvent) {
        if (aEvent.entity.worldObj.isRemote || aEvent.entityLiving == null) {
            return;
        }
        Override_Drops.handleDrops(aEvent.entityLiving, UT.Reflection.getLowercaseClass(aEvent.entityLiving), aEvent.drops, aEvent.source, aEvent.lootingLevel, aEvent.entityLiving.isBurning(), aEvent.recentlyHit);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onEntityLivingFallEvent(LivingFallEvent aEvent) {
        if (!aEvent.entity.worldObj.isRemote && aEvent.entity instanceof EntityPlayer && (ST.equal(((EntityPlayer)aEvent.entity).getCurrentEquippedItem(), (Item)CS.ToolsGT.sMetaTool, 64L) || ST.equal(((EntityPlayer)aEvent.entity).getCurrentEquippedItem(), (Item)CS.ToolsGT.sMetaTool, 1012L))) {
            aEvent.distance *= 2.0f;
        }
    }

    @SafeVarargs
    public final Fluid addAutogeneratedLiquid(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createLiquid(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedLiquid(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createPlasma(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedGas(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createGas(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedGas(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createGas(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedMolten(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createMolten(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedMolten(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createMolten(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedVapor(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createVapour(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedVaporized(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createVapour(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedPlasma(OreDictMaterial aMaterial, Set<String> ... aFluidList) {
        return FL.createPlasma(aMaterial, aFluidList);
    }

    @SafeVarargs
    public final Fluid addAutogeneratedPlasma(OreDictMaterial aMaterial, IIconContainer aTexture, Set<String> ... aFluidList) {
        return FL.createPlasma(aMaterial, aTexture, aFluidList);
    }

    @SafeVarargs
    public final Fluid addFluid(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, Set<String> ... aFluidList) {
        return FL.create(aName, aLocalized, aMaterial, aState, aAmountPerUnit, aTemperatureK, aFluidList);
    }

    @SafeVarargs
    public final Fluid addFluid(String aName, String aLocalized, OreDictMaterial aMaterial, int aState, long aAmountPerUnit, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, Set<String> ... aFluidList) {
        return FL.create(aName, aLocalized, aMaterial, aState, aAmountPerUnit, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aFluidList);
    }

    @SafeVarargs
    public final Fluid addFluid(String aName, IIconContainer aTexture, String aLocalized, OreDictMaterial aMaterial, short[] aRGBa, int aState, long aAmountPerUnit, long aTemperatureK, ItemStack aFullContainer, ItemStack aEmptyContainer, int aFluidAmount, Set<String> ... aFluidList) {
        return FL.create(aName, aTexture, aLocalized, aMaterial, aRGBa, aState, aAmountPerUnit, aTemperatureK, aFullContainer, aEmptyContainer, aFluidAmount, aFluidList);
    }
}

