/*
 * Decompiled with CFR 0.152.
 */
package gregapi.worldgen;

import gregapi.code.ArrayListNoNulls;
import gregapi.code.BiomeNameSet;
import gregapi.data.CS;
import gregapi.util.WD;
import gregapi.worldgen.WorldgenObject;
import gregapi.worldgen.WorldgenOresLarge;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;

public class GT6WorldGenerator {
    private static final List<Runnable> LIST = new ArrayListNoNulls<Runnable>();
    private static boolean LOCK = false;
    public static boolean PFAA = false;
    public static boolean TFC = false;

    public static void generate(World aWorld, int aX, int aZ, boolean aGalactiCraft) {
        switch (aWorld.provider.dimensionId) {
            case -2147483648: {
                return;
            }
            case 0: {
                GT6WorldGenerator.generate(new WorldGenContainer(TFC ? CS.GEN_TFC : (PFAA ? CS.GEN_PFAA : (CS.GENERATE_STONE ? CS.GEN_GT : CS.GEN_OVERWORLD)), (List<WorldgenObject>)(TFC ? CS.ORE_TFC : (PFAA ? CS.ORE_PFAA : (CS.GENERATE_STONE ? null : CS.ORE_OVERWORLD))), 0, aWorld, aX, aZ));
                return;
            }
            case -1: {
                GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_NETHER, CS.ORE_NETHER, -1, aWorld, aX, aZ));
                return;
            }
            case 1: {
                GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_END, CS.ORE_END, 1, aWorld, aX, aZ));
                return;
            }
        }
        if (WD.dimENVM(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GENERATE_STONE ? CS.GEN_ENVM_GT : CS.GEN_ENVM, CS.GENERATE_STONE ? null : CS.ORE_ENVM, -2, aWorld, aX, aZ));
            return;
        }
        if (WD.dimA97(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GENERATE_STONE ? CS.GEN_A97_GT : CS.GEN_A97, CS.GENERATE_STONE ? null : CS.ORE_A97, -6, aWorld, aX, aZ));
            return;
        }
        if (WD.dimCW2AquaCavern(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GENERATE_STONE ? CS.GEN_CW2_AquaCavern_GT : CS.GEN_CW2_AquaCavern, CS.GENERATE_STONE ? null : CS.ORE_CW2_AquaCavern, -32, aWorld, aX, aZ));
            return;
        }
        if (WD.dimCW2Caveland(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GENERATE_STONE ? CS.GEN_CW2_Caveland_GT : CS.GEN_CW2_Caveland, CS.GENERATE_STONE ? null : CS.ORE_CW2_Caveland, -33, aWorld, aX, aZ));
            return;
        }
        if (WD.dimCW2Cavenia(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GENERATE_STONE ? CS.GEN_CW2_Cavenia_GT : CS.GEN_CW2_Cavenia, CS.GENERATE_STONE ? null : CS.ORE_CW2_Cavenia, -34, aWorld, aX, aZ));
            return;
        }
        if (WD.dimCW2Cavern(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GENERATE_STONE ? CS.GEN_CW2_Cavern_GT : CS.GEN_CW2_Cavern, CS.GENERATE_STONE ? null : CS.ORE_CW2_Cavern, -31, aWorld, aX, aZ));
            return;
        }
        if (WD.dimCW2Caveworld(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GENERATE_STONE ? CS.GEN_CW2_Caveworld_GT : CS.GEN_CW2_Caveworld, CS.GENERATE_STONE ? null : CS.ORE_CW2_Caveworld, -30, aWorld, aX, aZ));
            return;
        }
        if (WD.dimMYST(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(TFC ? CS.GEN_TFC : (PFAA ? CS.GEN_PFAA : (CS.GENERATE_STONE ? CS.GEN_GT : CS.GEN_OVERWORLD)), (List<WorldgenObject>)(TFC ? CS.ORE_TFC : (PFAA ? CS.ORE_PFAA : (CS.GENERATE_STONE ? null : CS.ORE_OVERWORLD))), 0, aWorld, aX, aZ));
            return;
        }
        if (WD.dimWTCH(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(TFC ? CS.GEN_TFC : (PFAA ? CS.GEN_PFAA : (CS.GENERATE_STONE ? CS.GEN_GT : CS.GEN_OVERWORLD)), (List<WorldgenObject>)(TFC ? CS.ORE_TFC : (PFAA ? CS.ORE_PFAA : (CS.GENERATE_STONE ? null : CS.ORE_OVERWORLD))), 0, aWorld, aX, aZ));
            return;
        }
        if (WD.dimTF(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_TWILIGHT, CS.ORE_TWILIGHT, 7, aWorld, aX, aZ));
            return;
        }
        if (WD.dimAETHER(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_AETHER, CS.ORE_AETHER, 6, aWorld, aX, aZ));
            return;
        }
        if (WD.dimERE(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_EREBUS, CS.ORE_EREBUS, 66, aWorld, aX, aZ));
            return;
        }
        if (WD.dimBTL(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_BETWEENLANDS, CS.ORE_BETWEENLANDS, 20, aWorld, aX, aZ));
            return;
        }
        if (WD.dimATUM(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_ATUM, CS.ORE_ATUM, 17, aWorld, aX, aZ));
            return;
        }
        if (WD.dimALF(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_ALFHEIM, CS.ORE_ALFHEIM, 105, aWorld, aX, aZ));
            return;
        }
        if (WD.dimDD(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_DEEPDARK, CS.ORE_DEEPDARK, -100, aWorld, aX, aZ));
            return;
        }
        if (WD.dimTROPIC(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_TROPICS, CS.ORE_TROPICS, -127, aWorld, aX, aZ));
            return;
        }
        if (WD.dimCANDY(aWorld)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_CANDY, CS.ORE_CANDY, 23, aWorld, aX, aZ));
            return;
        }
        BiomeGenBase aBiome = aWorld.getBiomeGenForCoords(aX + 7, aZ + 7);
        if (aBiome == null || CS.BIOMES_VOID.contains(aBiome.biomeName)) {
            return;
        }
        if (CS.BIOMES_EREBUS.contains(aBiome.biomeName)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_EREBUS, CS.ORE_EREBUS, 66, aWorld, aX, aZ));
            return;
        }
        if (CS.BIOMES_MOON.contains(aBiome.biomeName)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_MOON, CS.ORE_MOON, 2, aWorld, aX, aZ));
            return;
        }
        if (CS.BIOMES_MARS.contains(aBiome.biomeName)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_MARS, CS.ORE_MARS, 3, aWorld, aX, aZ));
            return;
        }
        if (CS.BIOMES_ASTEROIDS.contains(aBiome.biomeName)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_ASTEROIDS, CS.ORE_ASTEROIDS, 4, aWorld, aX, aZ));
            return;
        }
        if (aGalactiCraft || CS.BIOMES_SPACE.contains(aBiome.biomeName)) {
            GT6WorldGenerator.generate(new WorldGenContainer(CS.GEN_PLANETS, CS.ORE_PLANETS, 5, aWorld, aX, aZ));
            return;
        }
    }

    public static void generate(WorldGenContainer aWorldgen) {
        LIST.add(aWorldgen);
        if (!LOCK) {
            LOCK = true;
            while (!LIST.isEmpty()) {
                LIST.remove(LIST.size() - 1).run();
            }
            LOCK = false;
        }
    }

    public static class WorldGenContainer
    implements Runnable {
        public final int mMinX;
        public final int mMinZ;
        public final int mMaxX;
        public final int mMaxZ;
        public final int mDimType;
        public final World mWorld;
        public final Random mRandom;
        public final List<WorldgenObject> mGenNormal;
        public final List<WorldgenObject> mGenLargeOres;

        public WorldGenContainer(List<WorldgenObject> aGenNormal, List<WorldgenObject> aGenLargeOres, int aDimType, World aWorld, int aX, int aZ) {
            this.mMinX = aX;
            this.mMinZ = aZ;
            this.mMaxX = aX + 15;
            this.mMaxZ = aZ + 15;
            this.mDimType = aDimType;
            this.mWorld = aWorld;
            this.mGenNormal = aGenNormal;
            this.mGenLargeOres = aGenLargeOres;
            this.mRandom = WD.random(aWorld, (long)aX, (long)aZ);
        }

        @Override
        public void run() {
            if (!this.mGenNormal.isEmpty()) {
                Chunk tChunk = this.mWorld.getChunkFromBlockCoords(this.mMinX + 7, this.mMinZ + 7);
                if (tChunk == null) {
                    return;
                }
                BiomeGenBase[][] tBiomes = new BiomeGenBase[16][16];
                BiomeNameSet tBiomeNames = new BiomeNameSet(new Object[0]);
                for (int i = 0; i < 16; ++i) {
                    for (int j = 0; j < 16; ++j) {
                        tBiomes[i][j] = tChunk.getBiomeGenForWorldCoords(i, j, this.mWorld.provider.worldChunkMgr);
                        if (tBiomes[i][j] == null) {
                            tBiomes[i][j] = this.mDimType == -1 ? BiomeGenBase.hell : (this.mDimType == 1 ? BiomeGenBase.sky : BiomeGenBase.plains);
                            continue;
                        }
                        tBiomeNames.add(tBiomes[i][j].biomeName);
                    }
                }
                CS.GENERATING_SPECIAL = false;
                for (WorldgenObject tWorldGen : this.mGenNormal) {
                    tWorldGen.reset(this.mWorld, tChunk, this.mDimType, this.mMinX, this.mMinZ, this.mMaxX, this.mMaxZ, this.mRandom, tBiomes, tBiomeNames);
                }
                for (WorldgenObject tWorldGen : this.mGenNormal) {
                    if (!tWorldGen.enabled(this.mWorld, this.mDimType)) continue;
                    try {
                        tWorldGen.generate(this.mWorld, tChunk, this.mDimType, this.mMinX, this.mMinZ, this.mMaxX, this.mMaxZ, this.mRandom, tBiomes, tBiomeNames);
                    }
                    catch (Throwable e) {
                        e.printStackTrace(CS.ERR);
                    }
                    if (tChunk.lastSaveTime != Long.MAX_VALUE) continue;
                    tChunk.isModified = false;
                    tChunk.hasEntities = false;
                    throw new RuntimeException("A corrupted Chunk was found while generating at (X: " + this.mMinX + " Z: " + this.mMinZ + "), please try loading the World again to see if this specific Chunk consistently corrupts, and >>>ONLY<<< if it does so, please report this to Greg.");
                }
                if (this.mGenLargeOres != null && !this.mGenLargeOres.isEmpty()) {
                    int tMaxWeight = 0;
                    ArrayListNoNulls<WorldgenOresLarge> tList = new ArrayListNoNulls<WorldgenOresLarge>();
                    for (WorldgenObject tWorldGen : this.mGenLargeOres) {
                        if (!tWorldGen.enabled(this.mWorld, this.mDimType)) continue;
                        tMaxWeight += ((WorldgenOresLarge)tWorldGen).mWeight;
                        tList.add((WorldgenOresLarge)tWorldGen);
                    }
                    if (tMaxWeight > 0 && !tList.isEmpty()) {
                        for (int tX = -32; tX <= 32; tX += 16) {
                            block10: for (int tZ = -32; tZ <= 32; tZ += 16) {
                                int tChunkX = this.mMinX + tX;
                                int tChunkZ = this.mMinZ + tZ;
                                if (((tChunkX >> 4) + 0x18000000) % 3 != 1 || ((tChunkZ >> 4) + 0x18000000) % 3 != 1) continue;
                                Random aRandom = WD.random(this.mWorld, (long)tChunkX, (long)tChunkZ);
                                int tRandomWeight = aRandom.nextInt(tMaxWeight);
                                for (WorldgenOresLarge tWorldGen : tList) {
                                    if ((tRandomWeight -= tWorldGen.mWeight) > 0) continue;
                                    try {
                                        tWorldGen.generate(this.mWorld, tChunk, this.mMinX, this.mMinZ, this.mMaxX, this.mMaxZ, tChunkX, tChunkZ, this.mRandom);
                                    }
                                    catch (Throwable e) {
                                        e.printStackTrace(CS.ERR);
                                    }
                                    continue block10;
                                }
                            }
                        }
                    }
                }
                for (EntityItem tEntity : this.mWorld.getEntitiesWithinAABB(EntityItem.class, AxisAlignedBB.getBoundingBox((double)(this.mMinX - 32), (double)0.0, (double)(this.mMinZ - 32), (double)(this.mMinX + 48), (double)256.0, (double)(this.mMinZ + 48)))) {
                    tEntity.setDead();
                }
                Arrays.fill(tChunk.precipitationHeightMap, -999);
                tChunk.isModified = true;
            }
        }
    }
}

