/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.multiblocks;

import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.MultiTileEntityBasicMachine;
import gregapi.tileentity.multiblocks.IMultiBlockEnergy;
import gregapi.tileentity.multiblocks.IMultiBlockFluidHandler;
import gregapi.tileentity.multiblocks.IMultiBlockInventory;
import gregapi.tileentity.multiblocks.MultiTileEntityMultiBlockPart;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public abstract class TileEntityBase10MultiBlockMachine
extends MultiTileEntityBasicMachine
implements IMultiBlockFluidHandler,
IMultiBlockInventory,
IMultiBlockEnergy {
    public boolean mStructureChanged = false;
    public boolean mStructureOkay = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.state.str")) {
            this.mStructureOkay = aNBT.getBoolean("gt.state.str");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.state.str", this.mStructureOkay);
    }

    @Override
    public long onToolClickMultiBlock(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ, ChunkCoordinates aFrom) {
        if (aTool.equals("builderwand")) {
            if (this.isClientSide()) {
                return 0L;
            }
            this.checkStructure2(aFrom, aPlayer, aPlayerInventory);
            this.checkStructure(true);
            return 10L;
        }
        return this.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aTool.equals("builderwand")) {
            if (this.isClientSide()) {
                return 0L;
            }
            this.checkStructure2(this.getCoords(), aPlayer, aPlayerInventory);
            this.checkStructure(true);
            return 10L;
        }
        return super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
    }

    @Override
    public void onMagnifyingGlass(List<String> aChatReturn) {
        super.onMagnifyingGlass(aChatReturn);
        if (this.checkStructure(false)) {
            this.onMagnifyingGlass2(aChatReturn);
        } else if (this.checkStructure(true)) {
            aChatReturn.add("Structure did form just now!");
        } else {
            aChatReturn.add("Structure did not form!");
        }
    }

    public void onMagnifyingGlass2(List<String> aChatReturn) {
        aChatReturn.add("Structure is formed already!");
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        if (this.refreshStructureOnActiveStateChange() && (this.mActive != this.oActive || this.mRunning != this.oRunning)) {
            this.checkStructure(true);
        }
        return super.onTickCheck(aTimer);
    }

    @Override
    public boolean checkStructure(boolean aForceReset) {
        if (this.isClientSide()) {
            return this.mStructureOkay;
        }
        if ((this.mStructureChanged || aForceReset) && this.mStructureOkay != this.checkStructure2(null, null, null)) {
            this.mStructureOkay = !this.mStructureOkay;
            this.updateClientData();
        }
        this.mStructureChanged = false;
        return this.mStructureOkay;
    }

    @Override
    public void addToolTipsSided(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (this.mEnergyTypeAccepted != TD.Energy.TU) {
            LH.addEnergyToolTips(this, aList, this.mEnergyTypeAccepted, null, null, null);
        }
    }

    @Override
    public void onFacingChange(byte aPreviousFacing) {
        this.onStructureChange();
    }

    @Override
    public final byte getDirectionData() {
        return (byte)(this.mFacing & 7 | (this.mStructureOkay ? 8 : 0));
    }

    @Override
    public final void setDirectionData(byte aData) {
        this.mFacing = (byte)(aData & 7);
        this.mStructureOkay = (aData & 8) != 0;
    }

    @Override
    public void updateAdjacentToggleableEnergySources() {
    }

    @Override
    public boolean doDefaultStructuralChecks() {
        return true;
    }

    @Override
    public void onStructureChange() {
        this.mStructureChanged = true;
    }

    public boolean checkStructure2(ChunkCoordinates aCoordinates, Entity aPlayer, IInventory aInventory) {
        return this.checkStructure2();
    }

    @Deprecated
    public boolean checkStructure2() {
        return true;
    }

    public boolean refreshStructureOnActiveStateChange() {
        return false;
    }

    @Override
    public abstract DelegatorTileEntity<IInventory> getItemInputTarget(byte var1);

    @Override
    public abstract DelegatorTileEntity<TileEntity> getItemOutputTarget(byte var1);

    @Override
    public abstract DelegatorTileEntity<IFluidHandler> getFluidInputTarget(byte var1);

    @Override
    public abstract DelegatorTileEntity<IFluidHandler> getFluidOutputTarget(byte var1, Fluid var2);

    @Override
    public abstract String getTileEntityName();

    @Override
    protected IFluidTank getFluidTankFillable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToFill) {
        return this.getFluidTankFillable2(aSide, aFluidToFill);
    }

    @Override
    protected IFluidTank getFluidTankDrainable(MultiTileEntityMultiBlockPart aPart, byte aSide, FluidStack aFluidToDrain) {
        return this.getFluidTankDrainable2(aSide, aFluidToDrain);
    }

    @Override
    protected IFluidTank[] getFluidTanks(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getFluidTanks2(aSide);
    }

    @Override
    public int[] getAccessibleSlotsFromSide(MultiTileEntityMultiBlockPart aPart, byte aSide) {
        return this.getAccessibleSlotsFromSide2(aSide);
    }

    @Override
    public boolean canInsertItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canInsertItem2(aSlot, aStack, aSide);
    }

    @Override
    public boolean canExtractItem(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack, byte aSide) {
        return this.canExtractItem2(aSlot, aStack, aSide);
    }

    @Override
    public int getSizeInventory(MultiTileEntityMultiBlockPart aPart) {
        return this.getSizeInventory();
    }

    @Override
    public ItemStack getStackInSlot(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.getStackInSlot(aSlot);
    }

    @Override
    public ItemStack decrStackSize(MultiTileEntityMultiBlockPart aPart, int aSlot, int aDecrement) {
        return this.decrStackSize(aSlot, aDecrement);
    }

    @Override
    public ItemStack getStackInSlotOnClosing(MultiTileEntityMultiBlockPart aPart, int aSlot) {
        return this.getStackInSlotOnClosing(aSlot);
    }

    @Override
    public void setInventorySlotContents(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        this.setInventorySlotContents(aSlot, aStack);
    }

    @Override
    public String getInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.getInventoryName();
    }

    @Override
    public boolean hasCustomInventoryName(MultiTileEntityMultiBlockPart aPart) {
        return this.hasCustomInventoryName();
    }

    @Override
    public int getInventoryStackLimit(MultiTileEntityMultiBlockPart aPart) {
        return this.getInventoryStackLimit();
    }

    @Override
    public void markDirty(MultiTileEntityMultiBlockPart aPart) {
        this.markDirty();
    }

    @Override
    public boolean isUseableByPlayer(MultiTileEntityMultiBlockPart aPart, EntityPlayer aPlayer) {
        return this.isUseableByPlayer(aPlayer);
    }

    @Override
    public void openInventory(MultiTileEntityMultiBlockPart aPart) {
        this.openInventory();
    }

    @Override
    public void closeInventory(MultiTileEntityMultiBlockPart aPart) {
        this.closeInventory();
    }

    @Override
    public boolean isItemValidForSlot(MultiTileEntityMultiBlockPart aPart, int aSlot, ItemStack aStack) {
        return this.isItemValidForSlot(aSlot, aStack);
    }
}

