/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.misc;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.tileentity.ITileEntityTreeHole;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class MultiTileEntityTreeHole
extends TileEntityBase09FacingSingle
implements ITileEntityTreeHole,
IMultiTileEntity.IMTE_IsWood {
    public boolean mHasResin = false;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.active")) {
            this.mHasResin = aNBT.getBoolean("gt.active");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setBoolean(aNBT, "gt.active", this.mHasResin);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setBoolean(aNBT, "gt.active", this.mHasResin);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing) {
            return false;
        }
        ItemStack aStack = aPlayer.getCurrentEquippedItem();
        if (aStack != null && aStack.getItem() instanceof ItemBlock) {
            return false;
        }
        if (this.isServerSide() && this.hasResin(aSide)) {
            ItemStack tResin = this.getResinItem(aSide);
            ItemStack tStack = FL.fill(this.getResinFluid(aSide), ST.amount(1L, aStack), true, true, true, true);
            if ((tStack != null || tResin != null) && this.extractResin(aSide)) {
                if (tResin != null) {
                    ST.give((Entity)aPlayer, tResin, true);
                }
                assert (aStack != null);
                if (tStack != null) {
                    --aStack.stackSize;
                    ST.give((Entity)aPlayer, tStack, true);
                }
            }
            return true;
        }
        return true;
    }

    @Override
    public boolean unpaint() {
        return false;
    }

    @Override
    public boolean isPainted() {
        return false;
    }

    @Override
    public boolean paint(int aRGB) {
        return false;
    }

    @Override
    public int getPaint() {
        return 0xFFFFFF;
    }

    @Override
    public boolean canRecolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean canDecolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public boolean recolorItem(ItemStack aStack, int aRGB) {
        return false;
    }

    @Override
    public boolean decolorItem(ItemStack aStack) {
        return false;
    }

    @Override
    public String getFacingTool() {
        return null;
    }

    @Override
    public byte getDirectionData() {
        return (byte)(this.mFacing & 7 | (this.mHasResin ? 8 : 0));
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mHasResin = (aData & 8) != 0;
        this.mFacing = (byte)(aData & 7);
    }

    @Override
    public boolean isWood() {
        return true;
    }

    @Override
    public boolean hasResin(byte aSide) {
        return aSide == this.mFacing && this.mHasResin;
    }

    @Override
    public boolean extractResin(byte aSide) {
        if (!this.hasResin(aSide)) {
            return false;
        }
        this.mHasResin = false;
        this.updateClientData();
        return true;
    }

    @Override
    public float getExplosionResistance2() {
        return CS.BlocksGT.LogA.getExplosionResistance((byte)0);
    }

    @Override
    public int getFireSpreadSpeed(byte aSide, boolean aDefault) {
        return 300;
    }

    @Override
    public int getFlammability(byte aSide, boolean aDefault) {
        return 300;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public byte getDefaultSide() {
        return 5;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean isUsingWrenchingOverlay(ItemStack aStack, byte aSide) {
        return false;
    }

    @Override
    public boolean showInCreative() {
        return false;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }
}

