/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.inventories;

import cpw.mods.fml.client.registry.ClientRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.network.INetworkHandler;
import gregapi.network.IPacket;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictManager;
import gregapi.oredict.OreDictPrefix;
import gregapi.render.RenderHelper;
import gregapi.tileentity.ITileEntityAdjacentInventoryUpdatable;
import gregapi.tileentity.ITileEntityConnectedInventory;
import gregapi.tileentity.base.TileEntityBase09FacingSingle;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.logistics.ITileEntityLogisticsSemiFilteredItem;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.Explosion;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.fluids.Fluid;
import org.lwjgl.opengl.GL11;

public abstract class MultiTileEntityMassStorage
extends TileEntityBase09FacingSingle
implements ITileEntityConnectedInventory,
ITileEntityLogisticsSemiFilteredItem,
ITileEntityProgress,
ITileEntityAdjacentInventoryUpdatable,
IMultiTileEntity.IMTE_GetMaxStackSize,
IMultiTileEntity.IMTE_SyncDataInteger,
IMultiTileEntity.IMTE_SyncDataShort,
IMultiTileEntity.IMTE_OnRegistrationFirstClient {
    public int oStacksize = 0;
    public int mMaxStorage = 1000000;
    public long mPartialUnits = 0L;
    public byte mMode = 0;
    private ItemStackSet<ItemStackContainer> mLogisticsCache = null;
    public static final int[] ACCESSIBLE_SLOTS;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        this.mMode = aNBT.getByte("gt.mode");
        if (aNBT.hasKey("gt.capacity")) {
            this.mMaxStorage = aNBT.getInteger("gt.capacity");
        }
        if (aNBT.hasKey("gt.input")) {
            this.mPartialUnits = aNBT.getLong("gt.input");
        }
        if (aNBT.hasKey("gt.state")) {
            this.slot(1, ST.load(aNBT, "gt.state"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.mode", this.mMode);
        UT.NBT.setNumber(aNBT, "gt.input", this.mPartialUnits);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        if (this.isClientSide() && this.slotHas(1)) {
            aNBT.setTag("display", (NBTBase)UT.NBT.makeString(aNBT.getCompoundTag("display"), "Name", this.slot(1).getDisplayName()));
        }
        UT.NBT.setNumber(aNBT, "gt.mode", this.mMode);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (this.slotHas(1)) {
            aList.add(LH.Chat.YELLOW + this.slot(1).getDisplayName() + LH.Chat.GRAY + ": " + LH.Chat.WHITE + this.slot((int)1).stackSize);
        }
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.massstorage.tooltip.1") + UT.Code.makeString(this.mMaxStorage));
        aList.add(LH.Chat.CYAN + LH.get("gt.multitileentity.massstorage.tooltip.2"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.pincers.to.take"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.cutter.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.screwdriver.to.toggle"));
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.monkey.wrench.to.toggle.auto.outputs"));
        if ((this.mMode & CS.B[3]) == 0) {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.soft.hammer.to.reset"));
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.tape"));
        } else {
            aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.untape"));
        }
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.magnifyingglass.to.detail"));
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L) {
            return rReturn;
        }
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals("pincers")) {
            int j;
            if ((this.mMode & CS.B[3]) != 0) {
                return 0L;
            }
            long rCount = 0L;
            if (this.mPartialUnits > 0L) {
                ST.give(aPlayer, this.getPartialStack(), this.worldObj, this.xCoord + CS.OFFX[this.mFacing], this.yCoord, this.zCoord + CS.OFFZ[this.mFacing]);
                this.mPartialUnits = 0L;
                rCount += 10L;
            }
            if (this.slotHas(0)) {
                for (j = 9; j < 36; ++j) {
                    rCount += (long)ST.move((IInventory)this, aPlayerInventory, 0, j);
                    if (!this.slotHas(0)) break;
                }
            }
            if (this.slotHas(1)) {
                for (j = 9; j < 36; ++j) {
                    rCount += (long)ST.move((IInventory)this, aPlayerInventory, 0, j);
                    if (!this.slotHas(1)) break;
                }
            }
            if (rCount <= 0L) {
                return 1L;
            }
            UT.Sounds.send("random.pop", this, false);
            ST.update(aPlayer);
            this.updateClientData();
            this.updateInventory();
            return rCount;
        }
        if (aTool.equals("softhammer")) {
            if ((this.mMode & CS.B[3]) != 0) {
                return 0L;
            }
            if (this.slotHas(0)) {
                ST.place(this.worldObj, (double)(this.xCoord + CS.OFFX[this.mFacing]) + 0.5, (double)(this.yCoord + CS.OFFY[this.mFacing]) + 0.5, (double)(this.zCoord + CS.OFFZ[this.mFacing]) + 0.5, ST.copy(this.slot(0)));
                this.slotKill(0);
                this.updateInventory();
                return 10000L;
            }
            if (this.slotHas(1)) {
                for (int i = 0; i < 128 && this.slot((int)1).stackSize > Math.max(1, this.slot(1).getMaxStackSize()); ++i) {
                    ST.place(this.worldObj, (double)(this.xCoord + CS.OFFX[this.mFacing]) + 0.5, (double)(this.yCoord + CS.OFFY[this.mFacing]) + 0.5, (double)(this.zCoord + CS.OFFZ[this.mFacing]) + 0.5, ST.amount(Math.max(1, this.slot(1).getMaxStackSize()), this.slot(1)));
                    this.slot((int)1).stackSize -= Math.max(1, this.slot(1).getMaxStackSize());
                }
                if (this.mPartialUnits > 0L) {
                    ST.drop(this.worldObj, this.getCoords(), this.getPartialStack());
                    this.mPartialUnits = 0L;
                }
                if (this.slot((int)1).stackSize > 0) {
                    if (this.slot((int)1).stackSize <= Math.max(1, this.slot(1).getMaxStackSize())) {
                        ST.place(this.worldObj, (double)(this.xCoord + CS.OFFX[this.mFacing]) + 0.5, (double)(this.yCoord + CS.OFFY[this.mFacing]) + 0.5, (double)(this.zCoord + CS.OFFZ[this.mFacing]) + 0.5, ST.copy(this.slot(1)));
                        this.slotKill(1);
                        this.updateClientData();
                    }
                } else {
                    this.slotKill(1);
                    this.updateClientData();
                }
                this.updateInventory();
                return 2000L;
            }
        }
        if (aTool.equals("ducttape")) {
            if ((this.mMode & CS.B[3]) != 0 || !this.slotHas(1)) {
                return 0L;
            }
            if ((long)this.slot((int)1).stackSize > aRemainingDurability) {
                aChatReturn.add("Not enough Tape left to contain the Items!");
                return 0L;
            }
            this.mMode = (byte)(this.mMode | CS.B[3]);
            this.updateClientData();
            this.updateInventory();
            return Math.max(100, this.slot((int)1).stackSize);
        }
        if (aTool.equals("scissors") || aTool.equals("knife")) {
            if ((this.mMode & CS.B[3]) == 0) {
                return 0L;
            }
            this.mMode = (byte)(this.mMode & ~CS.B[3]);
            this.updateClientData();
            this.updateInventory();
            return 1000L;
        }
        if (aTool.equals("cutter")) {
            this.mMode = (byte)(this.mMode ^ CS.B[2]);
            aChatReturn.add((this.mMode & CS.B[2]) == 0 ? "Won't emit Overflow" : "Will emit Overflow to Inventories below");
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("screwdriver")) {
            this.mMode = (byte)(this.mMode ^ CS.B[1]);
            aChatReturn.add((this.mMode & CS.B[1]) == 0 ? "Filter stays when empty" : "Filter resets when empty");
            if (!this.allowZeroStacks(1)) {
                this.slotNull(1);
            }
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("monkeywrench")) {
            this.mMode = (byte)(this.mMode ^ CS.B[0]);
            aChatReturn.add((this.mMode & CS.B[0]) == 0 ? "Won't fill Inventories below" : "Will fill Inventories below");
            this.updateClientData();
            this.updateInventory();
            return 10000L;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                if (this.slotHas(1)) {
                    aChatReturn.add("Contains: " + this.slot((int)1).stackSize + " " + this.slot(1).getDisplayName());
                } else {
                    aChatReturn.add("Storage is empty");
                }
                aChatReturn.add((this.mMode & CS.B[0]) == 0 ? "Won't fill Inventories below" : "Will fill Inventories below");
                aChatReturn.add((this.mMode & CS.B[1]) == 0 ? "Filter stays when empty" : "Filter resets when empty");
                aChatReturn.add((this.mMode & CS.B[2]) == 0 ? "Won't emit Overflow" : "Will emit Overflow to Inventories below");
                if ((this.mMode & CS.B[3]) != 0) {
                    aChatReturn.add("Will keep content when harvested.");
                }
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public boolean onBlockActivated3(EntityPlayer aPlayer, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aSide != this.mFacing || (this.mMode & CS.B[3]) != 0 || this.isCovered(aSide)) {
            return false;
        }
        float[] tCoords = UT.Code.getFacingCoordsClicked(aSide, aHitX, aHitY, aHitZ);
        if (tCoords[0] < CS.PX_P[1] || tCoords[0] > CS.PX_N[1] || tCoords[1] < CS.PX_P[1] || tCoords[1] > CS.PX_N[1]) {
            return false;
        }
        if (this.isServerSide() && aPlayer != null) {
            this.updatePartialContent();
            ItemStack aStack = aPlayer.getCurrentEquippedItem();
            if (this.slotHas(1)) {
                int tAmount = 0;
                if (tCoords[1] >= CS.PX_P[6] && tCoords[1] <= CS.PX_P[8]) {
                    if (tCoords[0] >= CS.PX_P[1] && tCoords[0] <= CS.PX_P[3]) {
                        tAmount = 8;
                    }
                    if (tCoords[0] >= CS.PX_N[3] && tCoords[0] <= CS.PX_N[1]) {
                        tAmount = 64;
                    }
                }
                if (tCoords[1] >= CS.PX_P[9] && tCoords[1] <= CS.PX_P[11]) {
                    if (tCoords[0] >= CS.PX_P[1] && tCoords[0] <= CS.PX_P[3]) {
                        tAmount = 4;
                    }
                    if (tCoords[0] >= CS.PX_N[3] && tCoords[0] <= CS.PX_N[1]) {
                        tAmount = 32;
                    }
                }
                if (tCoords[1] >= CS.PX_P[12] && tCoords[1] <= CS.PX_P[14]) {
                    if (tCoords[0] >= CS.PX_P[1] && tCoords[0] <= CS.PX_P[3]) {
                        tAmount = 1;
                    }
                    if (tCoords[0] >= CS.PX_N[3] && tCoords[0] <= CS.PX_N[1]) {
                        tAmount = 16;
                    }
                }
                if (tCoords[1] >= CS.PX_P[6] && tCoords[0] >= CS.PX_P[4] && tCoords[0] <= CS.PX_N[4]) {
                    tAmount = -1;
                }
                if (tAmount > 0) {
                    if ((tAmount = Math.min(tAmount, this.slot((int)1).stackSize)) > 0) {
                        this.slot((int)1).stackSize -= tAmount;
                        while (tAmount > 0) {
                            ItemStack tStack = ST.amount(Math.min(tAmount, Math.max(1, this.slot(1).getMaxStackSize())), this.slot(1));
                            tAmount -= tStack.stackSize;
                            ST.place(this.worldObj, (double)this.getOffsetX(this.mFacing) + 0.5, (double)this.getOffsetY(this.mFacing) + 0.5, (double)this.getOffsetZ(this.mFacing) + 0.5, tStack);
                        }
                        this.updateInventory();
                        this.playCollect();
                    }
                } else if (ST.valid(aStack)) {
                    ItemStack tStack = this.insertItems(aStack, true);
                    if (tStack == null) {
                        aStack.stackSize = 0;
                        this.playCollect();
                    } else if (tStack.stackSize < aStack.stackSize) {
                        aStack.stackSize = tStack.stackSize;
                        this.playCollect();
                    }
                } else if (tAmount == -1) {
                    boolean temp = false;
                    for (int i = 0; i < aPlayer.inventory.mainInventory.length; ++i) {
                        if (aPlayer.inventory.mainInventory[i] == null || !this.allowInsertion(aPlayer.inventory.mainInventory[i])) continue;
                        ItemStack tStack = this.insertItems(aPlayer.inventory.mainInventory[i], false);
                        if (tStack == null) {
                            temp = true;
                            aPlayer.inventory.mainInventory[i] = null;
                            continue;
                        }
                        if (tStack.stackSize >= aPlayer.inventory.mainInventory[i].stackSize) break;
                        temp = true;
                        aPlayer.inventory.mainInventory[i] = tStack;
                    }
                    if (temp) {
                        ST.update((Entity)aPlayer);
                        this.playCollect();
                    }
                }
                if ((this.mMode & CS.B[1]) != 0 && this.mPartialUnits <= 0L && this.slotNull(1)) {
                    this.updateClientData();
                    this.updateInventory();
                }
            } else if (ST.valid(aStack)) {
                ItemStack tStack = this.insertItems(aStack, true);
                if (tStack == null) {
                    aStack.stackSize = 0;
                    this.playCollect();
                } else if (tStack.stackSize < aStack.stackSize) {
                    aStack.stackSize = tStack.stackSize;
                    this.playCollect();
                }
            }
            this.updatePartialContent();
        }
        return true;
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide && (this.mMode & CS.B[3]) == 0) {
            if (!this.slotNull(0)) {
                this.slot(0, this.insertItems(this.slot(0), false));
            }
            boolean temp = false;
            if ((this.mInventoryChanged || aTimer % 100L == 0L) && this.slotHas(1)) {
                if ((this.mMode & CS.B[0]) != 0 && this.slot((int)1).stackSize > 0) {
                    if (ST.move(this.delegator((byte)0), this.getAdjacentInventory((byte)0)) > 0) {
                        temp = true;
                    }
                } else if ((this.mMode & CS.B[2]) != 0 && this.slot((int)1).stackSize > this.mMaxStorage) {
                    this.emitOverflow();
                }
            }
            if (this.mInventoryChanged || temp) {
                for (byte tSide : CS.ALL_SIDES_BUT_BOTTOM) {
                    DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(tSide);
                    if (!(tDelegator.mTileEntity instanceof ITileEntityAdjacentInventoryUpdatable)) continue;
                    ((ITileEntityAdjacentInventoryUpdatable)tDelegator.mTileEntity).adjacentInventoryUpdated(tDelegator.mSideOfTileEntity, this);
                }
            }
        }
    }

    @Override
    public boolean onTickCheck(long aTimer) {
        return super.onTickCheck(aTimer) || this.isFaceVisible() && (this.slotHas(1) ? this.slot((int)1).stackSize != this.oStacksize && (Math.abs(this.slot((int)1).stackSize - this.oStacksize) > 64 ? CS.SERVER_TIME % 5L == 0L : CS.SYNC_SECOND) : this.oStacksize != 0);
    }

    @Override
    public void onTickChecked(long aTimer) {
        super.onTickChecked(aTimer);
        this.oStacksize = this.slotHas(1) ? this.slot((int)1).stackSize : 0;
    }

    @Override
    public void setInventorySlotContents(int aSlot, ItemStack aStack) {
        if (aSlot == 0) {
            this.slot(aSlot, this.insertItems(OM.get(aStack), false));
        }
        if (aSlot == 1 && this.slotHas(aSlot)) {
            this.decrStackSize(aSlot, aStack == null ? this.slot((int)aSlot).stackSize : this.slot((int)aSlot).stackSize - aStack.stackSize);
        }
    }

    public int getMaxContent() {
        return (this.mMode & CS.B[2]) != 0 ? this.mMaxStorage + 256 : this.mMaxStorage;
    }

    public ItemStack insertItems(ItemStack aStack, boolean aCheckForNEI) {
        if (ST.invalid(aStack) || (this.mMode & CS.B[3]) != 0) {
            return aStack;
        }
        if (!this.slotHas(1)) {
            this.mLogisticsCache = null;
            if (aCheckForNEI && aStack.stackSize == 111) {
                this.slot(1, ST.amount(this.mMaxStorage, aStack));
                this.mPartialUnits = 0L;
                this.updateClientData();
                this.updateInventory();
                return aStack;
            }
            this.slot(1, ST.copy(aStack));
            this.updateClientData();
            this.updateInventory();
            if ((this.mMode & CS.B[2]) != 0 && aStack.stackSize > this.mMaxStorage) {
                this.emitOverflow();
            }
            return null;
        }
        int tMaxStorage = this.getMaxContent();
        ItemStack tContent = this.slot(1);
        if (tContent.stackSize >= tMaxStorage) {
            return aStack;
        }
        if (ST.equal(aStack, tContent)) {
            if (aCheckForNEI && aStack.stackSize == 111) {
                tContent.stackSize = this.mMaxStorage;
                this.mPartialUnits = 0L;
                this.updateInventory();
                return aStack;
            }
            ItemStack rStack = null;
            if (aStack.stackSize + tContent.stackSize > tMaxStorage) {
                rStack = ST.amount(aStack.stackSize + tContent.stackSize - tMaxStorage, aStack);
            }
            tContent.stackSize = Math.min(tMaxStorage, tContent.stackSize + aStack.stackSize);
            this.updateInventory();
            if ((this.mMode & CS.B[2]) != 0 && tContent.stackSize > this.mMaxStorage) {
                this.emitOverflow();
            }
            return rStack;
        }
        if (this.updatePartialContent(this.getUnitAmount(aStack) * (long)aStack.stackSize)) {
            if ((this.mMode & CS.B[2]) != 0 && tContent.stackSize > this.mMaxStorage) {
                this.emitOverflow();
            }
            return null;
        }
        return aStack;
    }

    public void emitOverflow() {
        DelegatorTileEntity<IInventory> tTileEntity = this.getAdjacentInventory((byte)0);
        while (this.slotHas(1) && this.slot((int)1).stackSize > this.mMaxStorage) {
            byte tToBeMoved = UT.Code.bindStack(this.slot((int)1).stackSize - this.mMaxStorage);
            if (ST.move(this.delegator((byte)0), tTileEntity, null, false, false, false, true, tToBeMoved, 1, tToBeMoved, 1) > 0) continue;
            break;
        }
    }

    @Override
    public ItemStackSet<ItemStackContainer> getLogisticsFilter(byte aSide) {
        block42: {
            OreDictItemData tData;
            block51: {
                block50: {
                    block49: {
                        block48: {
                            block47: {
                                block46: {
                                    block45: {
                                        block44: {
                                            block43: {
                                                if (!this.slotHas(1)) {
                                                    this.mLogisticsCache = null;
                                                    return null;
                                                }
                                                if (this.mLogisticsCache != null) {
                                                    return this.mLogisticsCache;
                                                }
                                                this.mLogisticsCache = ST.hashset(this.slot(1));
                                                tData = OM.data_(this.slot(1));
                                                if (tData == null || !tData.validData()) break block42;
                                                if (!tData.mPrefix.contains(TD.Prefix.DUST_BASED)) break block43;
                                                for (ItemStack tStack : OreDictManager.getOres(OP.blockDust, tData.mMaterial, false)) {
                                                    this.mLogisticsCache.add(tStack);
                                                }
                                                for (ItemStack tStack : OreDictManager.getOres(OP.dust, tData.mMaterial, false)) {
                                                    this.mLogisticsCache.add(tStack);
                                                }
                                                for (ItemStack tStack : OreDictManager.getOres(OP.dustSmall, tData.mMaterial, false)) {
                                                    this.mLogisticsCache.add(tStack);
                                                }
                                                for (ItemStack tStack : OreDictManager.getOres(OP.dustTiny, tData.mMaterial, false)) {
                                                    this.mLogisticsCache.add(tStack);
                                                }
                                                for (ItemStack tStack : OreDictManager.getOres(OP.dustDiv72, tData.mMaterial, false)) {
                                                    this.mLogisticsCache.add(tStack);
                                                }
                                                break block42;
                                            }
                                            if (!tData.mPrefix.contains(TD.Prefix.INGOT_BASED)) break block44;
                                            for (ItemStack tStack : OreDictManager.getOres(OP.blockIngot, tData.mMaterial, false)) {
                                                this.mLogisticsCache.add(tStack);
                                            }
                                            for (ItemStack tStack : OreDictManager.getOres(OP.ingot, tData.mMaterial, false)) {
                                                this.mLogisticsCache.add(tStack);
                                            }
                                            for (ItemStack tStack : OreDictManager.getOres(OP.billet, tData.mMaterial, false)) {
                                                this.mLogisticsCache.add(tStack);
                                            }
                                            for (ItemStack tStack : OreDictManager.getOres(OP.chunkGt, tData.mMaterial, false)) {
                                                this.mLogisticsCache.add(tStack);
                                            }
                                            for (ItemStack tStack : OreDictManager.getOres(OP.nugget, tData.mMaterial, false)) {
                                                this.mLogisticsCache.add(tStack);
                                            }
                                            break block42;
                                        }
                                        if (!tData.mPrefix.contains(TD.Prefix.WIRE_BASED)) break block45;
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt01, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt02, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt03, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt04, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt05, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt06, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt07, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt08, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt09, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt10, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt11, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt12, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt13, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt14, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt15, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        for (ItemStack tStack : OreDictManager.getOres(OP.wireGt16, tData.mMaterial, false)) {
                                            this.mLogisticsCache.add(tStack);
                                        }
                                        break block42;
                                    }
                                    if (tData.mPrefix != OP.gem && tData.mPrefix != OP.blockGem) break block46;
                                    for (ItemStack tStack : OreDictManager.getOres(OP.gem, tData.mMaterial, false)) {
                                        this.mLogisticsCache.add(tStack);
                                    }
                                    for (ItemStack tStack : OreDictManager.getOres(OP.blockGem, tData.mMaterial, false)) {
                                        this.mLogisticsCache.add(tStack);
                                    }
                                    break block42;
                                }
                                if (tData.mPrefix != OP.plate && tData.mPrefix != OP.blockPlate) break block47;
                                for (ItemStack tStack : OreDictManager.getOres(OP.plate, tData.mMaterial, false)) {
                                    this.mLogisticsCache.add(tStack);
                                }
                                for (ItemStack tStack : OreDictManager.getOres(OP.blockPlate, tData.mMaterial, false)) {
                                    this.mLogisticsCache.add(tStack);
                                }
                                break block42;
                            }
                            if (tData.mPrefix != OP.plateGem && tData.mPrefix != OP.blockPlateGem) break block48;
                            for (ItemStack tStack : OreDictManager.getOres(OP.plateGem, tData.mMaterial, false)) {
                                this.mLogisticsCache.add(tStack);
                            }
                            for (ItemStack tStack : OreDictManager.getOres(OP.blockPlateGem, tData.mMaterial, false)) {
                                this.mLogisticsCache.add(tStack);
                            }
                            break block42;
                        }
                        if (tData.mPrefix != OP.crushed && tData.mPrefix != OP.crushedTiny) break block49;
                        for (ItemStack tStack : OreDictManager.getOres(OP.crushed, tData.mMaterial, false)) {
                            this.mLogisticsCache.add(tStack);
                        }
                        for (ItemStack tStack : OreDictManager.getOres(OP.crushedTiny, tData.mMaterial, false)) {
                            this.mLogisticsCache.add(tStack);
                        }
                        break block42;
                    }
                    if (tData.mPrefix != OP.crushedPurified && tData.mPrefix != OP.crushedPurifiedTiny) break block50;
                    for (ItemStack tStack : OreDictManager.getOres(OP.crushedPurified, tData.mMaterial, false)) {
                        this.mLogisticsCache.add(tStack);
                    }
                    for (ItemStack tStack : OreDictManager.getOres(OP.crushedPurifiedTiny, tData.mMaterial, false)) {
                        this.mLogisticsCache.add(tStack);
                    }
                    break block42;
                }
                if (tData.mPrefix != OP.crushedCentrifuged && tData.mPrefix != OP.crushedCentrifugedTiny) break block51;
                for (ItemStack tStack : OreDictManager.getOres(OP.crushedCentrifuged, tData.mMaterial, false)) {
                    this.mLogisticsCache.add(tStack);
                }
                for (ItemStack tStack : OreDictManager.getOres(OP.crushedCentrifugedTiny, tData.mMaterial, false)) {
                    this.mLogisticsCache.add(tStack);
                }
                break block42;
            }
            if (tData.mPrefix != OP.oreRaw && tData.mPrefix != OP.blockRaw) break block42;
            for (ItemStack tStack : OreDictManager.getOres(OP.oreRaw, tData.mMaterial, false)) {
                this.mLogisticsCache.add(tStack);
            }
            for (ItemStack tStack : OreDictManager.getOres(OP.blockRaw, tData.mMaterial, false)) {
                this.mLogisticsCache.add(tStack);
            }
        }
        return this.mLogisticsCache;
    }

    public boolean canLogistics(byte aSide) {
        return true;
    }

    public int getLogisticsPriorityItem() {
        return this.slotHas(1) ? 2 : 1;
    }

    public int getLogisticsPriorityFluid() {
        return 0;
    }

    public Fluid getLogisticsFilterFluid() {
        return null;
    }

    public ItemStack getLogisticsFilterItem() {
        return null;
    }

    public boolean isFaceVisible() {
        return CS.SIDES_HORIZONTAL[this.mFacing] && (this.mMode & CS.B[3]) == 0 && (!this.hasCovers() || this.mCovers.mBehaviours[this.mFacing] == null || !this.mCovers.mBehaviours[this.mFacing].isOpaque(this.mFacing, this.mCovers));
    }

    @Override
    public IPacket getClientDataPacket(boolean aSendAll) {
        int tStacksize = this.slotHas(1) ? this.slot((int)1).stackSize : -1;
        short tMeta = this.slotHas(1) ? ST.meta_(this.slot(1)) : (short)0;
        short tID = ST.id(this.slot(1));
        return aSendAll ? this.getClientDataPacketByteArray(aSendAll, (byte)UT.Code.getR(this.mRGBa), (byte)UT.Code.getG(this.mRGBa), (byte)UT.Code.getB(this.mRGBa), this.getDirectionData(), this.mMode, UT.Code.toByteS(tID, 0), UT.Code.toByteS(tID, 1), UT.Code.toByteS(tMeta, 0), UT.Code.toByteS(tMeta, 1), UT.Code.toByteI(tStacksize, 0), UT.Code.toByteI(tStacksize, 1), UT.Code.toByteI(tStacksize, 2), UT.Code.toByteI(tStacksize, 3)) : (tStacksize <= Short.MAX_VALUE ? this.getClientDataPacketShort(aSendAll, (short)tStacksize) : this.getClientDataPacketInteger(aSendAll, tStacksize));
    }

    @Override
    public boolean receiveDataByteArray(byte[] aData, INetworkHandler aNetworkHandler) {
        this.mRGBa = UT.Code.getRGBInt(new short[]{UT.Code.unsignB(aData[0]), UT.Code.unsignB(aData[1]), UT.Code.unsignB(aData[2])});
        this.setDirectionData(aData[3]);
        this.mMode = aData[4];
        this.slot(1, ST.make(UT.Code.combine(aData[5], aData[6]), (long)UT.Code.combine(aData[9], aData[10], aData[11], aData[12]), (long)UT.Code.combine(aData[7], aData[8])));
        return true;
    }

    @Override
    public boolean receiveDataInteger(int aData, INetworkHandler aNetworkHandler) {
        if (aData < 0) {
            this.slotKill(1);
        } else if (this.slotHas(1)) {
            this.slot((int)1).stackSize = aData;
        }
        return true;
    }

    @Override
    public boolean receiveDataShort(short aData, INetworkHandler aNetworkHandler) {
        if (aData < 0) {
            this.slotKill(1);
        } else if (this.slotHas(1)) {
            this.slot((int)1).stackSize = aData;
        }
        return true;
    }

    @Override
    public byte getDefaultSide() {
        return 3;
    }

    @Override
    public boolean[] getValidSides() {
        return CS.SIDES_HORIZONTAL;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return aSide != this.mFacing;
    }

    @Override
    public void onExploded(Explosion aExplosion) {
        this.slotKill(1);
        super.onExploded(aExplosion);
    }

    @Override
    public ItemStack[] getDefaultInventory(NBTTagCompound aNBT) {
        return new ItemStack[2];
    }

    @Override
    public int getInventoryStackLimit() {
        return Math.min(this.slotHas(1) ? this.getMaxContent() - this.slot((int)1).stackSize : this.getMaxContent(), 64);
    }

    @Override
    public int[] getAccessibleSlotsFromSide2(byte aSide) {
        return ACCESSIBLE_SLOTS;
    }

    @Override
    public boolean canInsertItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 0 && (this.mMode & CS.B[3]) == 0 && (!CS.SIDES_BOTTOM[aSide] || (this.mMode & CS.B[0]) == 0) && (!this.slotHas(1) || this.slot((int)1).stackSize < this.getMaxContent() && this.allowInsertion(aStack));
    }

    @Override
    public boolean canExtractItem2(int aSlot, ItemStack aStack, byte aSide) {
        return aSlot == 0 || this.slotHas(1) && this.slot((int)1).stackSize > 0 && (this.mMode & CS.B[3]) == 0;
    }

    @Override
    public boolean allowZeroStacks(int aSlot) {
        return aSlot == 1 && ((this.mMode & CS.B[1]) == 0 || this.mPartialUnits > 0L);
    }

    @Override
    public void adjacentInventoryUpdated(byte aSide, IInventory aTileEntity) {
        if (CS.SIDES_BOTTOM[aSide]) {
            this.updateInventory();
        }
    }

    @Override
    public long getAmountOfItemsInConnectedInventory(byte aSide, ItemStack aStack, long aStopCountingAtThisNumber) {
        return this.slotHas(1) && ST.equal(this.slot(1), aStack) ? (long)this.slot((int)1).stackSize : 0L;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return this.slotHas(1) ? (long)this.slot((int)1).stackSize : 0L;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return this.mMaxStorage;
    }

    @Override
    public boolean canDrop(int aSlot) {
        return !this.keepSlot(aSlot);
    }

    @Override
    public boolean keepSlot(int aSlot) {
        return aSlot == 1 && (this.mMode & CS.B[3]) != 0;
    }

    @Override
    public byte getMaxStackSize(ItemStack aStack, byte aDefault) {
        return this.slotHas(1) ? (byte)1 : aDefault;
    }

    @Override
    public boolean breakBlock() {
        if (this.isServerSide() && this.mPartialUnits > 0L) {
            ST.drop(this.worldObj, this.getCoords(), this.getPartialStack());
            this.mPartialUnits = 0L;
        }
        return super.breakBlock();
    }

    @Override
    public int addStackToConnectedInventory(byte aSide, ItemStack aStack, boolean aOnlyAddIfItAlreadyHasItemsOfThatTypeOrIsDedicated) {
        if ((this.mMode & CS.B[3]) != 0) {
            return 0;
        }
        if (!aOnlyAddIfItAlreadyHasItemsOfThatTypeOrIsDedicated || this.slotHas(1)) {
            ItemStack tStack = this.insertItems(aStack, false);
            if (tStack == null) {
                return aStack.stackSize;
            }
            if (tStack.stackSize < aStack.stackSize) {
                return aStack.stackSize - tStack.stackSize;
            }
        }
        return 0;
    }

    @Override
    public int removeStackFromConnectedInventory(byte aSide, ItemStack aStack, boolean aOnlyRemoveIfItCanRemoveAllAtOnce) {
        if ((this.mMode & CS.B[3]) != 0) {
            return 0;
        }
        if (this.slotHas(1) && ST.equal(this.slot(1), aStack)) {
            if (aOnlyRemoveIfItCanRemoveAllAtOnce && this.slot((int)1).stackSize < aStack.stackSize) {
                return 0;
            }
            int tAmount = Math.min(aStack.stackSize, this.slot((int)1).stackSize);
            this.slot((int)1).stackSize -= tAmount;
            if ((this.mMode & CS.B[1]) != 0 && this.mPartialUnits <= 0L && this.slotNull(1)) {
                this.updateClientData();
            }
            this.updateInventory();
            return tAmount;
        }
        return 0;
    }

    public ItemStack getPartialStack() {
        if (this.mPartialUnits <= 0L) {
            return CS.NI;
        }
        OreDictItemData mData = OM.anydata(this.slot(1));
        if (mData == null || !mData.validPrefix()) {
            return CS.NI;
        }
        if (mData.mPrefix.contains(TD.Prefix.DUST_BASED)) {
            return OM.dust(mData.mMaterial.mMaterial, this.mPartialUnits);
        }
        if (mData.mPrefix.contains(TD.Prefix.INGOT_BASED)) {
            return OM.ingot(mData.mMaterial.mMaterial, this.mPartialUnits);
        }
        if (mData.mPrefix.contains(TD.Prefix.WIRE_BASED)) {
            return OP.wireGt01.mat(mData.mMaterial.mMaterial, this.mPartialUnits / OP.wireGt01.mAmount);
        }
        if (mData.mPrefix == OP.gem || mData.mPrefix == OP.blockGem) {
            return OP.gem.mat(mData.mMaterial.mMaterial, this.mPartialUnits / OP.gem.mAmount);
        }
        if (mData.mPrefix == OP.plate || mData.mPrefix == OP.blockPlate) {
            return OP.plate.mat(mData.mMaterial.mMaterial, this.mPartialUnits / OP.plate.mAmount);
        }
        if (mData.mPrefix == OP.plateGem || mData.mPrefix == OP.blockPlateGem) {
            return OP.plateGem.mat(mData.mMaterial.mMaterial, this.mPartialUnits / OP.plateGem.mAmount);
        }
        if (mData.mPrefix == OP.crushed || mData.mPrefix == OP.crushedTiny) {
            return OP.crushedTiny.mat(mData.mMaterial.mMaterial, this.mPartialUnits / OP.crushedTiny.mAmount);
        }
        if (mData.mPrefix == OP.crushedPurified || mData.mPrefix == OP.crushedPurifiedTiny) {
            return OP.crushedPurifiedTiny.mat(mData.mMaterial.mMaterial, this.mPartialUnits / OP.crushedPurifiedTiny.mAmount);
        }
        if (mData.mPrefix == OP.crushedCentrifuged || mData.mPrefix == OP.crushedCentrifugedTiny) {
            return OP.crushedCentrifugedTiny.mat(mData.mMaterial.mMaterial, this.mPartialUnits / OP.crushedCentrifugedTiny.mAmount);
        }
        if (mData.mPrefix == OP.oreRaw || mData.mPrefix == OP.blockRaw) {
            return OP.oreRaw.mat(mData.mMaterial.mMaterial, this.mPartialUnits / 648648000L);
        }
        return CS.NI;
    }

    public long getUnitAmount(OreDictPrefix aPrefix) {
        return aPrefix == OP.oreRaw ? 648648000L : (aPrefix == OP.blockRaw ? 5837832000L : aPrefix.mAmount);
    }

    public long getUnitAmount(ItemStack aStack) {
        OreDictItemData mData = OM.anydata_(this.slot(1));
        OreDictItemData aData = OM.anydata_(aStack);
        if (mData != null && aData != null && mData.validData() && aData.validData() && mData.mMaterial.mMaterial == aData.mMaterial.mMaterial && (!mData.mBlackListed || mData.mMaterial.mMaterial != MT.Glass && MD.MC.owns(this.slot(1))) && this.mPartialUnits < this.getUnitAmount(mData.mPrefix)) {
            if (mData.mPrefix.contains(TD.Prefix.DUST_BASED)) {
                return aData.mPrefix.contains(TD.Prefix.DUST_BASED) ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix.contains(TD.Prefix.INGOT_BASED)) {
                return aData.mPrefix.contains(TD.Prefix.INGOT_BASED) ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix.contains(TD.Prefix.WIRE_BASED)) {
                return aData.mPrefix.contains(TD.Prefix.WIRE_BASED) ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix == OP.gem || mData.mPrefix == OP.blockGem) {
                return aData.mPrefix == OP.gem || aData.mPrefix == OP.blockGem ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix == OP.plate || mData.mPrefix == OP.blockPlate) {
                return aData.mPrefix == OP.plate || aData.mPrefix == OP.blockPlate ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix == OP.plateGem || mData.mPrefix == OP.blockPlateGem) {
                return aData.mPrefix == OP.plateGem || aData.mPrefix == OP.blockPlateGem ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix == OP.crushed || mData.mPrefix == OP.crushedTiny) {
                return aData.mPrefix == OP.crushed || aData.mPrefix == OP.crushedTiny ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix == OP.crushedPurified || mData.mPrefix == OP.crushedPurifiedTiny) {
                return aData.mPrefix == OP.crushedPurified || aData.mPrefix == OP.crushedPurifiedTiny ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix == OP.crushedCentrifuged || mData.mPrefix == OP.crushedCentrifugedTiny) {
                return aData.mPrefix == OP.crushedCentrifuged || aData.mPrefix == OP.crushedCentrifugedTiny ? aData.mPrefix.mAmount : 0L;
            }
            if (mData.mPrefix == OP.oreRaw || mData.mPrefix == OP.blockRaw) {
                return aData.mPrefix == OP.oreRaw ? 648648000L : (aData.mPrefix == OP.blockRaw ? 5837832000L : 0L);
            }
        }
        return 0L;
    }

    public boolean allowInsertion(ItemStack aStack) {
        if ((this.mMode & CS.B[3]) != 0) {
            return false;
        }
        if (ST.equal(this.slot(1), aStack)) {
            return true;
        }
        return this.getUnitAmount(aStack) > 0L;
    }

    public boolean updatePartialContent(long aAmountAdded) {
        if (aAmountAdded <= 0L) {
            return false;
        }
        this.mPartialUnits += aAmountAdded;
        return this.updatePartialContent();
    }

    public boolean updatePartialContent() {
        long tTargetAmount;
        OreDictItemData mData;
        int tMaxStorage = this.getMaxContent();
        ItemStack tContent = this.slot(1);
        if (this.mPartialUnits > 0L && this.slotHas(1) && tContent.stackSize < tMaxStorage && (mData = OM.anydata_(tContent)) != null && mData.validPrefix() && this.mPartialUnits >= (tTargetAmount = this.getUnitAmount(mData.mPrefix))) {
            ItemStack tStack = ST.amount(this.mPartialUnits / tTargetAmount, tContent);
            if (tStack.stackSize > 0) {
                this.mPartialUnits -= tTargetAmount * (long)tStack.stackSize;
                if (tStack.stackSize + tContent.stackSize > tMaxStorage) {
                    this.mPartialUnits += tTargetAmount * (long)(tStack.stackSize + tContent.stackSize - tMaxStorage);
                }
                tContent.stackSize = Math.min(tMaxStorage, tContent.stackSize + tStack.stackSize);
                this.updateInventory();
            }
        }
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegistrationFirstClient(MultiTileEntityRegistry aRegistry, short aID) {
        ClientRegistry.bindTileEntitySpecialRenderer(this.getClass(), (TileEntitySpecialRenderer)MultiTileEntityRendererMassStorage.INSTANCE);
    }

    static {
        LH.add("gt.multitileentity.massstorage.tooltip.1", "Can store Items of one Type, Capacity: ");
        LH.add("gt.multitileentity.massstorage.tooltip.2", "Can be used adjacent to Advanced Crafting Tables");
        ACCESSIBLE_SLOTS = new int[]{0, 1};
    }

    @SideOnly(value=Side.CLIENT)
    public static class MultiTileEntityRendererMassStorage
    extends TileEntitySpecialRenderer {
        public static MultiTileEntityRendererMassStorage INSTANCE = new MultiTileEntityRendererMassStorage();

        public void renderTileEntityAt(TileEntity aTileEntity, double aX, double aY, double aZ, float aPartialTick) {
            if (aTileEntity instanceof MultiTileEntityMassStorage && ((MultiTileEntityMassStorage)aTileEntity).slotHas(1) && ((MultiTileEntityMassStorage)aTileEntity).isFaceVisible()) {
                MultiTileEntityMassStorage tTileEntity = (MultiTileEntityMassStorage)aTileEntity;
                int tTexIndex = GL11.glGetInteger((int)32873);
                GL11.glDisable((int)3042);
                GL11.glDisable((int)2896);
                GL11.glPushMatrix();
                GL11.glTranslated((double)(aX + 0.5 + (double)CS.OFFX[tTileEntity.mFacing] * 0.502 - (double)CS.OFFZ[tTileEntity.mFacing] * 0.25), (double)(aY + 0.625), (double)(aZ + 0.5 + (double)CS.OFFZ[tTileEntity.mFacing] * 0.502 + (double)CS.OFFX[tTileEntity.mFacing] * 0.25));
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glRotatef((float)(CS.COMPASS_FROM_SIDE[tTileEntity.mFacing] * 90), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)0.00390625f, (float)0.00390625f, (float)-1.0E-4f);
                GL11.glScalef((float)8.0f, (float)8.0f, (float)1.0f);
                OpenGlHelper.setLightmapTextureCoords((int)OpenGlHelper.lightmapTexUnit, (float)240.0f, (float)240.0f);
                try {
                    if (!ForgeHooksClient.renderInventoryItem((RenderBlocks)RenderHelper.mRenderBlocks, (TextureManager)Minecraft.getMinecraft().renderEngine, (ItemStack)tTileEntity.slot(1), (boolean)true, (float)0.0f, (float)0.0f, (float)0.0f)) {
                        RenderHelper.renderItemIntoGUI(Minecraft.getMinecraft().fontRenderer, Minecraft.getMinecraft().renderEngine, tTileEntity.slot(1), 0, 0, false);
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace(CS.ERR);
                }
                GL11.glPopMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glAlphaFunc((int)516, (float)0.1f);
                OpenGlHelper.glBlendFunc((int)770, (int)771, (int)1, (int)0);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                GL11.glEnable((int)3008);
                GL11.glBindTexture((int)3553, (int)tTexIndex);
            }
        }
    }
}

