/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityBlockInternal;
import gregapi.block.multitileentity.MultiTileEntityRegistry;
import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.base.TileEntityBase07Paintable;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public abstract class TileEntityBase08Battery
extends TileEntityBase07Paintable
implements ITileEntityQuickObstructionCheck,
IMultiTileEntity.IMTE_SetBlockBoundsBasedOnState,
IMultiTileEntity.IMTE_GetCollisionBoundingBoxFromPool,
IMultiTileEntity.IMTE_GetSelectedBoundingBoxFromPool,
IItemEnergy,
IMultiTileEntity.IMTE_GetMaxStackSize,
IMultiTileEntity.IMTE_OnlyPlaceableWhenSneaking,
IMultiTileEntity.IMTE_AddToolTips {
    public long mEnergy = 0L;
    public long mSizeMin = 0L;
    public long mSizeRec = 0L;
    public long mSizeMax = 0L;
    public long mCapacity = 0L;
    public byte mDisplayedEnergy = 0;
    public TagData mType = TD.Energy.EU;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.input")) {
            this.mSizeRec = aNBT.getLong("gt.input");
        }
        this.mSizeMin = this.mSizeRec / 2L;
        this.mSizeMax = this.mSizeRec * 2L;
        if (this.mSizeMin <= 8L && this.mSizeRec > 0L) {
            this.mSizeMin = 1L;
        }
        if (aNBT.hasKey("gt.input.min")) {
            this.mSizeMin = aNBT.getLong("gt.input.min");
        }
        if (aNBT.hasKey("gt.input.max")) {
            this.mSizeMax = aNBT.getLong("gt.input.max");
        }
        if (aNBT.hasKey("gt.capacity")) {
            this.mCapacity = aNBT.getLong("gt.capacity");
        }
        if (aNBT.hasKey("gt.energy.accepted")) {
            this.mType = TagData.createTagData(aNBT.getString("gt.energy.accepted"));
        }
        if (aNBT.getBoolean("gt.active.energy")) {
            this.mEnergy = this.mCapacity;
        } else if (aNBT.hasKey("gt.energy")) {
            this.mEnergy = aNBT.getLong("gt.energy");
        }
        if (this.mEnergy > this.mCapacity) {
            this.mEnergy = this.mCapacity;
        }
        this.mDisplayedEnergy = (byte)UT.Code.scale(this.mEnergy, this.mCapacity, this.getDisplayScaleMax(), false);
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", false);
        super.writeToNBT2(aNBT);
    }

    @Override
    public NBTTagCompound writeItemNBT2(NBTTagCompound aNBT) {
        UT.NBT.setNumber(aNBT, "gt.energy", this.mEnergy);
        UT.NBT.setBoolean(aNBT, "gt.active.energy", false);
        return super.writeItemNBT2(aNBT);
    }

    @Override
    public ItemStack getPickBlock(MovingObjectPosition aTarget) {
        MultiTileEntityRegistry tRegistry = MultiTileEntityRegistry.getRegistry(this.getMultiTileEntityRegistryID());
        if (tRegistry == null) {
            return null;
        }
        long oEnergy = this.mEnergy;
        this.mEnergy = UT.Code.units(this.mCapacity, this.getDisplayScaleMax(), this.mDisplayedEnergy, true);
        ItemStack rStack = tRegistry.getItem((int)this.getMultiTileEntityID(), this.writeItemNBT(UT.NBT.make()));
        this.mEnergy = oEnergy;
        return rStack;
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        if (this.mCapacity > 0L) {
            aList.add(LH.Chat.WHITE + UT.Code.makeString(Math.min(this.mCapacity, this.mEnergy)) + " / " + UT.Code.makeString(this.mCapacity) + " " + this.mType.getLocalisedChatNameShort() + LH.Chat.WHITE + (this.mSizeMin <= 1L ? " - Size: up to " + this.mSizeMax : " - Size: " + this.mSizeRec));
        }
    }

    @Override
    public boolean getSubItems(MultiTileEntityBlockInternal aBlock, Item aItem, CreativeTabs aTab, List<ItemStack> aList, short aID) {
        if (this.mMaterial.mHidden) {
            return false;
        }
        aList.add(aBlock.mMultiTileEntityRegistry.getItem(aID));
        if (this.mCapacity > 0L) {
            aList.add(this.setEnergyStored(this.mType, aBlock.mMultiTileEntityRegistry.getItem(aID), this.mCapacity));
        }
        return false;
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        long rReturn = super.onToolClick2(aTool, aRemainingDurability, aQuality, aPlayer, aChatReturn, aPlayerInventory, aSneaking, aStack, aSide, aHitX, aHitY, aHitZ);
        if (rReturn > 0L || this.isClientSide()) {
            return rReturn;
        }
        if (aTool.equals("magnifyingglass")) {
            if (aChatReturn != null) {
                aChatReturn.add(UT.Code.makeString(this.mEnergy) + " of " + UT.Code.makeString(this.mCapacity) + " " + this.mType.getLocalisedNameShort());
            }
            return 1L;
        }
        return 0L;
    }

    @Override
    public float getSurfaceSize(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceSizeAttachable(byte aSide) {
        return 0.0f;
    }

    @Override
    public float getSurfaceDistance(byte aSide) {
        return 0.0f;
    }

    @Override
    public boolean isSurfaceSolid(byte aSide) {
        return false;
    }

    @Override
    public boolean isSurfaceOpaque2(byte aSide) {
        return false;
    }

    @Override
    public boolean isSideSolid2(byte aSide) {
        return false;
    }

    @Override
    public boolean allowCovers(byte aSide) {
        return false;
    }

    @Override
    public boolean attachCoversFirst(byte aSide) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    @Override
    public boolean onlyPlaceableWhenSneaking() {
        return true;
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public int getLightOpacity() {
        return 0;
    }

    @Override
    public byte getMaxStackSize(ItemStack aStack, byte aDefault) {
        return this.mEnergy > 0L ? (byte)1 : aDefault;
    }

    @Override
    public byte getVisualData() {
        return this.mDisplayedEnergy;
    }

    @Override
    public void setVisualData(byte aData) {
        this.mDisplayedEnergy = aData;
    }

    public byte getDisplayScaleMax() {
        return 16;
    }

    @Override
    public int getRenderPasses2(Block aBlock, boolean[] aShouldSideBeRendered) {
        return this.mDisplayedEnergy > 0 ? 2 : 1;
    }

    @Override
    public long doEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoInject) {
        long rAmount;
        if (aAmount < 1L || this.mSizeRec < 1L) {
            return 0L;
        }
        if (!this.canEnergyInjection(aEnergyType, aStack, aSize = Math.abs(aSize))) {
            return 0L;
        }
        if (this.mEnergy >= this.mCapacity) {
            return 0L;
        }
        for (rAmount = Math.min(this.mSizeRec, aAmount); rAmount > 1L && this.mEnergy + rAmount * aSize > this.mCapacity; --rAmount) {
        }
        if (aDoInject) {
            this.setEnergyStored(this.mType, aStack, this.mEnergy + rAmount * aSize);
        }
        return rAmount;
    }

    @Override
    public long doEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoExtract) {
        long rAmount;
        if (aAmount < 1L || this.mSizeRec < 1L) {
            return 0L;
        }
        if (!this.canEnergyExtraction(aEnergyType, aStack, aSize = Math.abs(aSize))) {
            return 0L;
        }
        if (this.mEnergy < aSize) {
            return 0L;
        }
        for (rAmount = Math.min(this.mSizeRec, aAmount); rAmount > 1L && this.mEnergy - rAmount * aSize < 0L; --rAmount) {
        }
        if (aDoExtract) {
            this.setEnergyStored(this.mType, aStack, this.mEnergy - rAmount * aSize);
        }
        return rAmount;
    }

    public ItemStack rechargeFromPlayer(TagData aEnergyType, ItemStack aStack, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ) {
        if (CS.COMPAT_EU_ITEM == null || aPlayer == null || aPlayer.worldObj.isRemote || aEnergyType != this.mType || aEnergyType != TD.Energy.EU) {
            return aStack;
        }
        long tMinInput = this.getEnergySizeInputMin(aEnergyType, aStack);
        boolean temp = false;
        try {
            for (int i = 1; i < 5; ++i) {
                if (this.mEnergy >= this.mCapacity) {
                    return aStack;
                }
                ItemStack tArmor = aPlayer.getEquipmentInSlot(i);
                if (tArmor == aStack || ST.invalid(tArmor) || !CS.COMPAT_EU_ITEM.is(tArmor) || CS.VMAX[CS.COMPAT_EU_ITEM.tier(tArmor)] < tMinInput || !CS.COMPAT_EU_ITEM.provider(tArmor)) continue;
                this.setEnergyStored(aEnergyType, aStack, this.mEnergy + CS.COMPAT_EU_ITEM.decharge(tArmor, this.mCapacity - this.mEnergy, true));
                temp = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (temp) {
            ST.update((Entity)aPlayer);
        }
        return aStack;
    }

    @Override
    public boolean useEnergy(TagData aEnergyType, ItemStack aStack, long aEnergyAmount, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoUse) {
        if (aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).capabilities.isCreativeMode) {
            return true;
        }
        if (aEnergyType != this.mType && aEnergyType != null) {
            return false;
        }
        this.rechargeFromPlayer(this.mType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
        if (this.mEnergy >= aEnergyAmount) {
            if (aDoUse) {
                this.setEnergyStored(this.mType, aStack, this.mEnergy - aEnergyAmount);
                this.rechargeFromPlayer(this.mType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
            }
            return true;
        }
        if (aDoUse) {
            this.setEnergyStored(this.mType, aStack, 0L);
            this.rechargeFromPlayer(this.mType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
        }
        return false;
    }

    @Override
    public ItemStack setEnergyStored(TagData aEnergyType, ItemStack aStack, long aAmount) {
        if (aEnergyType != this.mType && aEnergyType != null || ST.size(aStack) <= 0) {
            return aStack;
        }
        this.mEnergy = aAmount;
        UT.NBT.set(aStack, this.writeItemNBT(aStack.hasTagCompound() ? aStack.getTagCompound() : UT.NBT.make()));
        return ST.update_(aStack);
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mEnergy : 0L;
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mCapacity : 0L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSizeMin : 0L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSizeMin : 0L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSizeRec : 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSizeRec : 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSizeMax : 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSizeMax : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(ItemStack aStack) {
        return new HashSetNoNulls<TagData>(false, this.mType);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, ItemStack aStack, boolean aEmitting) {
        return aEnergyType == this.mType || aEnergyType == null;
    }

    @Override
    public boolean canEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize) {
        return (aEnergyType == this.mType || aEnergyType == null) && aStack.stackSize == 1 && aSize <= this.getEnergySizeInputMax(aEnergyType, aStack) && aSize >= this.getEnergySizeInputMin(aEnergyType, aStack);
    }

    @Override
    public boolean canEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize) {
        return (aEnergyType == this.mType || aEnergyType == null) && aStack.stackSize == 1 && aSize <= this.getEnergySizeOutputMax(aEnergyType, aStack) && aSize >= this.getEnergySizeOutputMin(aEnergyType, aStack);
    }
}

