/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.energy;

import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.random.IHasWorldAndCoords;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.energy.EnergyCompat;
import gregapi.util.WD;
import java.util.Collection;
import net.minecraft.tileentity.TileEntity;

public interface ITileEntityEnergy
extends gregapi.tileentity.ITileEntityEnergy {
    @Override
    public boolean isEnergyType(TagData var1, byte var2, boolean var3);

    @Override
    public Collection<TagData> getEnergyTypes(byte var1);

    @Override
    public boolean isEnergyAcceptingFrom(TagData var1, byte var2, boolean var3);

    @Override
    public boolean isEnergyEmittingTo(TagData var1, byte var2, boolean var3);

    @Override
    public long doEnergyInjection(TagData var1, byte var2, long var3, long var5, boolean var7);

    @Override
    public long getEnergyDemanded(TagData var1, byte var2, long var3);

    @Override
    public long doEnergyExtraction(TagData var1, byte var2, long var3, long var5, boolean var7);

    @Override
    public long getEnergyOffered(TagData var1, byte var2, long var3);

    @Override
    public long getEnergySizeInputMin(TagData var1, byte var2);

    @Override
    public long getEnergySizeOutputMin(TagData var1, byte var2);

    @Override
    public long getEnergySizeInputRecommended(TagData var1, byte var2);

    @Override
    public long getEnergySizeOutputRecommended(TagData var1, byte var2);

    @Override
    public long getEnergySizeInputMax(TagData var1, byte var2);

    @Override
    public long getEnergySizeOutputMax(TagData var1, byte var2);

    public static class Util {
        public static final long emitEnergyToNetwork(TagData aEnergyType, long aSize, long aAmount, gregapi.tileentity.ITileEntityEnergy aEmitter) {
            byte tSide;
            long rUsedAmount = 0L;
            byte[] byArray = CS.ALL_SIDES_VALID;
            int n = byArray.length;
            for (int i = 0; !(i >= n || aEmitter.isEnergyEmittingTo(aEnergyType, tSide = byArray[i], false) && aAmount <= (rUsedAmount += Util.emitEnergyToSide(aEnergyType, tSide, aSize, aAmount - rUsedAmount, (TileEntity)aEmitter))); ++i) {
            }
            return rUsedAmount;
        }

        public static final long emitEnergyToSide(TagData aEnergyType, byte aSideOutOf, long aSize, long aAmount, TileEntity aEmitter) {
            DelegatorTileEntity<TileEntity> tDelegator = aEmitter instanceof IHasWorldAndCoords ? ((IHasWorldAndCoords)aEmitter).getAdjacentTileEntity(aSideOutOf) : WD.te(aEmitter.getWorldObj(), aEmitter.xCoord + CS.OFFX[aSideOutOf], aEmitter.yCoord + CS.OFFY[aSideOutOf], aEmitter.zCoord + CS.OFFZ[aSideOutOf], CS.OPOS[aSideOutOf], false);
            return Util.insertEnergyInto(aEnergyType, aSize, aAmount, aEmitter, tDelegator);
        }

        public static final long insertEnergyInto(TagData aEnergyType, byte aSideInto, long aSize, long aAmount, Object aEmitter, TileEntity aReceiver) {
            return aReceiver instanceof ITileEntityEnergy ? ((ITileEntityEnergy)aReceiver).doEnergyInjection(aEnergyType, aSideInto, aSize, aAmount, true) : EnergyCompat.insertEnergyInto(aEnergyType, aSideInto, aSize, aAmount, aEmitter, aReceiver);
        }

        public static final long insertEnergyInto(TagData aEnergyType, long aSize, long aAmount, Object aEmitter, DelegatorTileEntity<TileEntity> aReceiver) {
            return Util.insertEnergyInto(aEnergyType, aReceiver.mSideOfTileEntity, aSize, aAmount, aEmitter, (TileEntity)aReceiver.mTileEntity);
        }
    }
}

