/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.tileentity.ITileEntity;
import gregapi.tileentity.ITileEntityMachineBlockUpdateable;
import gregapi.tileentity.base.TileEntityBase08Directional;
import gregapi.tileentity.connectors.ITileEntityConnector;
import gregapi.tileentity.connectors.ITileEntityRedstoneWire;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.UT;
import gregapi.util.WD;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class TileEntityBase09Connector
extends TileEntityBase08Directional
implements ITileEntityConnector,
IMultiTileEntity.IMTE_OnPlaced,
IMultiTileEntity.IMTE_AddToolTips {
    protected byte mConnections = 0;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.connection")) {
            this.mConnections = (byte)(aNBT.getByte("gt.connection") & 0x3F);
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        UT.NBT.setNumber(aNBT, "gt.connection", this.mConnections);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.DGRAY + LH.get("gt.lang.use.x.to.toggle.connection.pre") + LH.get("gt.lang.tool.name." + this.getFacingTool(), "Unknown") + LH.get("gt.lang.use.x.to.toggle.connection.post"));
    }

    @Override
    public long onToolClick2(String aTool, long aRemainingDurability, long aQuality, Entity aPlayer, List<String> aChatReturn, IInventory aPlayerInventory, boolean aSneaking, ItemStack aStack, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isClientSide()) {
            return 0L;
        }
        if (aTool.equals(this.getFacingTool())) {
            byte aTargetSide = UT.Code.getSideWrenching(aSide, aHitX, aHitY, aHitZ);
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aTargetSide);
            if (tDelegator.mTileEntity instanceof ITileEntity && !((ITileEntity)tDelegator.mTileEntity).allowInteraction(aPlayer)) {
                return 0L;
            }
            return (this.connected(aTargetSide) ? this.disconnect(aTargetSide, true) : this.connect(aTargetSide, true)) ? 10000L : 0L;
        }
        return 0L;
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (this.isServerSide()) {
            aSide = CS.OPOS[aSide];
            DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide);
            if (tDelegator.mTileEntity instanceof ITileEntity && !((ITileEntity)tDelegator.mTileEntity).allowInteraction((Entity)aPlayer)) {
                return true;
            }
            this.connect(aSide, true);
            for (byte tSide : CS.ALL_SIDES_VALID) {
                tDelegator = this.getAdjacentTileEntity(tSide);
                if (!(tDelegator.mTileEntity instanceof ITileEntityConnector) || !CS.SIDES_VALID[tDelegator.mSideOfTileEntity] || !UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), this.getConnectorTypes(tSide)) || !((ITileEntityConnector)tDelegator.mTileEntity).connected(tDelegator.mSideOfTileEntity)) continue;
                this.connect(tSide, true);
            }
        }
        return true;
    }

    @Override
    public byte getDirectionData() {
        return (byte)(this.mConnections & 0x3F);
    }

    @Override
    public void setDirectionData(byte aData) {
        this.mConnections = (byte)(aData & 0x3F);
    }

    public short getFacing() {
        return 0;
    }

    public void setFacing(short aSide) {
    }

    public boolean wrenchCanSetFacing(EntityPlayer aPlayer, int aSide) {
        return false;
    }

    @Override
    public boolean isConnectedWrenchingOverlay(ItemStack aStack, byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public boolean connected(byte aSide) {
        return CS.FACE_CONNECTED[aSide][this.mConnections];
    }

    @Override
    public boolean connect(byte aSide, boolean aNotify) {
        if (CS.SIDES_INVALID[aSide]) {
            return false;
        }
        if (this.connected(aSide)) {
            return true;
        }
        if (this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptConnect(aSide, this.mCovers)) {
            return false;
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide);
        if (tDelegator.mTileEntity instanceof ITileEntityConnector) {
            if (tDelegator.mTileEntity instanceof ITileEntityCoverable && ((ITileEntityCoverable)tDelegator.mTileEntity).getCoverData() != null && ((ITileEntityCoverable)tDelegator.mTileEntity).getCoverData().mBehaviours[tDelegator.mSideOfTileEntity] != null && ((ITileEntityCoverable)tDelegator.mTileEntity).getCoverData().mBehaviours[tDelegator.mSideOfTileEntity].interceptConnect(tDelegator.mSideOfTileEntity, ((ITileEntityCoverable)tDelegator.mTileEntity).getCoverData())) {
                return false;
            }
            if (CS.SIDES_VALID[tDelegator.mSideOfTileEntity] && UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), this.getConnectorTypes(aSide))) {
                byte oConnections = this.mConnections;
                this.mConnections = (byte)(this.mConnections | CS.SBIT[aSide]);
                this.updateClientData();
                this.causeBlockUpdate();
                this.onConnectionChange(oConnections);
                this.checkCoverValidity();
                this.doEnetUpdate();
                if (aNotify) {
                    ((ITileEntityConnector)tDelegator.mTileEntity).connect(tDelegator.mSideOfTileEntity, false);
                }
                if (this.hasMultiBlockMachineRelevantData()) {
                    ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this, false);
                }
                return true;
            }
            if (this instanceof ITileEntityRedstoneWire) {
                byte oConnections = this.mConnections;
                this.mConnections = (byte)(this.mConnections | CS.SBIT[aSide]);
                this.updateClientData();
                this.causeBlockUpdate();
                this.onConnectionChange(oConnections);
                this.checkCoverValidity();
                this.doEnetUpdate();
                if (this.hasMultiBlockMachineRelevantData()) {
                    ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this, false);
                }
                return true;
            }
        } else if (WD.air(tDelegator.mWorld, tDelegator.mX, tDelegator.mY, tDelegator.mZ) || WD.liquid(tDelegator.mWorld, tDelegator.mX, tDelegator.mY, tDelegator.mZ) || this.canConnect(aSide, tDelegator)) {
            byte oConnections = this.mConnections;
            this.mConnections = (byte)(this.mConnections | CS.SBIT[aSide]);
            this.updateClientData();
            this.causeBlockUpdate();
            this.onConnectionChange(oConnections);
            this.checkCoverValidity();
            this.doEnetUpdate();
            if (this.hasMultiBlockMachineRelevantData()) {
                ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this, false);
            }
            return true;
        }
        return this.connected(aSide);
    }

    @Override
    public boolean disconnect(byte aSide, boolean aNotify) {
        if (CS.SIDES_INVALID[aSide]) {
            return false;
        }
        if (!this.connected(aSide)) {
            return true;
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide);
        if (this.hasCovers() && this.mCovers.mBehaviours[aSide] != null && this.mCovers.mBehaviours[aSide].interceptDisconnect(aSide, this.mCovers)) {
            return false;
        }
        if (tDelegator.mTileEntity instanceof ITileEntityCoverable && ((ITileEntityCoverable)tDelegator.mTileEntity).getCoverData() != null && ((ITileEntityCoverable)tDelegator.mTileEntity).getCoverData().mBehaviours[tDelegator.mSideOfTileEntity] != null && ((ITileEntityCoverable)tDelegator.mTileEntity).getCoverData().mBehaviours[tDelegator.mSideOfTileEntity].interceptDisconnect(tDelegator.mSideOfTileEntity, this.mCovers)) {
            return false;
        }
        byte oConnections = this.mConnections;
        this.mConnections = (byte)(this.mConnections & ~CS.SBIT[aSide]);
        this.updateClientData();
        this.causeBlockUpdate();
        this.onConnectionChange(oConnections);
        this.checkCoverValidity();
        this.doEnetUpdate();
        if (this.hasMultiBlockMachineRelevantData()) {
            ITileEntityMachineBlockUpdateable.Util.causeMachineUpdate(this, false);
        }
        if (aNotify && tDelegator.mTileEntity instanceof ITileEntityConnector && CS.SIDES_VALID[tDelegator.mSideOfTileEntity] && UT.Code.haveOneCommonElement(((ITileEntityConnector)tDelegator.mTileEntity).getConnectorTypes(tDelegator.mSideOfTileEntity), this.getConnectorTypes(aSide))) {
            ((ITileEntityConnector)tDelegator.mTileEntity).disconnect(tDelegator.mSideOfTileEntity, false);
        }
        return true;
    }

    public void onConnectionChange(byte aPreviousConnections) {
    }

    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        return false;
    }
}

