/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.connectors;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.ITileEntityQuickObstructionCheck;
import gregapi.tileentity.connectors.ITileEntityRedstoneWire;
import gregapi.tileentity.connectors.TileEntityBase10ConnectorRendered;
import gregapi.tileentity.data.ITileEntityProgress;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.tileentity.machines.ITileEntitySwitchableMode;
import gregapi.util.UT;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRedstoneWire;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;

public class MultiTileEntityWireRedstoneInsulated
extends TileEntityBase10ConnectorRendered
implements ITileEntityQuickObstructionCheck,
ITileEntityRedstoneWire,
ITileEntityProgress,
ITileEntitySwitchableMode,
IMultiTileEntity.IMTE_GetComparatorInputOverride {
    public static final int REDSTONE_ID = -1;
    public long mRedstone = 0L;
    public long mLoss = 1L;
    public byte mRenderType = 0;
    public byte mReceived = (byte)6;
    public byte mMode = 0;
    public byte[] mVanillaSides = new byte[]{-1, -1, -1, -1, -1, -1, -1};
    public boolean mConnectedToNonWire = true;

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.mreceived")) {
            this.mReceived = aNBT.getByte("gt.mreceived");
        }
        if (aNBT.hasKey("gt.mredstone")) {
            this.mRedstone = aNBT.getByte("gt.mredstone");
        }
        if (aNBT.hasKey("gt.mode")) {
            this.mMode = aNBT.getByte("gt.mode");
        }
        if (aNBT.hasKey("gt.pipeloss")) {
            this.mLoss = Math.max(1L, aNBT.getLong("gt.pipeloss"));
        }
        if (aNBT.hasKey("gt.piperender")) {
            this.mRenderType = aNBT.getByte("gt.piperender");
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mMode != 0) {
            aNBT.setByte("gt.mode", this.mMode);
        }
        aNBT.setByte("gt.mreceived", this.mReceived);
        UT.NBT.setNumber(aNBT, "gt.mredstone", this.mRedstone);
    }

    @Override
    public void addToolTips(List<String> aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.range") + Integer.MAX_VALUE / this.mLoss);
        aList.add(LH.Chat.CYAN + LH.get("gt.lang.pipe.stats.bandwidth") + 1);
        super.addToolTips(aList, aStack, aF3_H);
    }

    @Override
    public void onTickFirst2(boolean aIsServerSide) {
        super.onTickFirst2(aIsServerSide);
        this.updateConnectionStatus();
    }

    @Override
    public void onConnectionChange(byte aPreviousConnections) {
        super.onConnectionChange(aPreviousConnections);
        this.updateConnectionStatus();
        if (this.updateRedstone(-1)) {
            ITileEntityRedstoneWire.Util.doRedstoneUpdate(this, -1);
        }
    }

    @Override
    public void onTick2(long aTimer, boolean aIsServerSide) {
        super.onTick2(aTimer, aIsServerSide);
        if (aIsServerSide) {
            for (byte i : CS.ALL_SIDES) {
                this.mVanillaSides[i] = -1;
            }
            if (this.mBlockUpdated) {
                this.updateConnectionStatus();
            }
            if (this.updateRedstone(-1)) {
                ITileEntityRedstoneWire.Util.doRedstoneUpdate(this, -1);
            }
        }
    }

    public long getRedstoneAtSide(byte aSide) {
        if (CS.SIDES_INVALID[aSide]) {
            return 0L;
        }
        DelegatorTileEntity<TileEntity> tDelegator = this.getAdjacentTileEntity(aSide);
        if (tDelegator.mTileEntity instanceof ITileEntityRedstoneWire) {
            return this.canAcceptRedstoneFromWire(aSide, -1) && ((ITileEntityRedstoneWire)tDelegator.mTileEntity).canEmitRedstoneToWire(tDelegator.mSideOfTileEntity, -1) ? ((ITileEntityRedstoneWire)tDelegator.mTileEntity).getRedstoneMinusLoss(tDelegator.mSideOfTileEntity, -1) : 0L;
        }
        if (!this.canAcceptRedstoneFromVanilla(aSide)) {
            return 0L;
        }
        if (CS.REDSTONE_SINKS.contains(tDelegator.getBlock())) {
            return 0L;
        }
        if (MD.TE.mLoaded && tDelegator.mTileEntity != null && ((TileEntity)tDelegator.mTileEntity).getClass().getName().startsWith("cofh.thermalexpansion.block.light")) {
            return 0L;
        }
        if (this.mVanillaSides[aSide] < 0) {
            this.mVanillaSides[aSide] = this.getRedstoneIncoming(aSide);
        }
        return Integer.MAX_VALUE * (long)this.mVanillaSides[aSide] - this.mLoss;
    }

    @Override
    public boolean updateRedstone(int aRedstoneID) {
        if (aRedstoneID != -1) {
            return false;
        }
        long oRedstone = this.mRedstone;
        long tRedstone = (long)this.mMode * Integer.MAX_VALUE - this.mLoss;
        byte oReceived = this.mReceived;
        this.mRedstone = this.getRedstoneAtSide(oReceived);
        if (this.mRedstone <= tRedstone) {
            this.mRedstone = tRedstone;
            this.mReceived = (byte)6;
        }
        for (byte tSide : CS.ALL_SIDES_VALID_BUT[oReceived]) {
            tRedstone = this.getRedstoneAtSide(tSide);
            if (tRedstone <= this.mRedstone) continue;
            this.mRedstone = tRedstone;
            this.mReceived = tSide;
        }
        if (this.mRedstone != oRedstone) {
            if (this.mConnectedToNonWire) {
                this.causeBlockUpdate();
            }
            return true;
        }
        return false;
    }

    public void updateConnectionStatus() {
        this.mConnectedToNonWire = false;
        for (byte tSide : CS.ALL_SIDES_VALID) {
            if (!this.canAcceptRedstoneFromVanilla(tSide) || this.getAdjacentTileEntity((byte)tSide).mTileEntity instanceof ITileEntityRedstoneWire) continue;
            this.mConnectedToNonWire = true;
        }
    }

    @Override
    public byte isProvidingWeakPower2(byte aSide) {
        if (!this.canEmitRedstoneToVanilla(aSide = CS.OPOS[aSide]) || this.mRedstone <= 0L) {
            return 0;
        }
        Block tBlock = this.getBlockAtSide(aSide);
        return UT.Code.bind4(UT.Code.divup(this.mRedstone, Integer.MAX_VALUE) - (long)(tBlock instanceof BlockRedstoneWire || tBlock.isNormalCube((IBlockAccess)this.worldObj, this.xCoord + CS.OFFX[aSide], this.yCoord + CS.OFFY[aSide], this.zCoord + CS.OFFZ[aSide]) ? 1 : 0));
    }

    @Override
    public byte isProvidingStrongPower2(byte aSide) {
        if (!this.canEmitRedstoneToVanilla(aSide = CS.OPOS[aSide]) || this.mRedstone <= 0L) {
            return 0;
        }
        Block tBlock = this.getBlockAtSide(aSide);
        return UT.Code.bind4(UT.Code.divup(this.mRedstone, Integer.MAX_VALUE) - (long)(tBlock instanceof BlockRedstoneWire || tBlock.isNormalCube((IBlockAccess)this.worldObj, this.xCoord + CS.OFFX[aSide], this.yCoord + CS.OFFY[aSide], this.zCoord + CS.OFFZ[aSide]) ? 1 : 0));
    }

    @Override
    public int getComparatorInputOverride(byte aSide) {
        return UT.Code.bind4(this.mRedstone / Integer.MAX_VALUE);
    }

    @Override
    public boolean canDrop(int aInventorySlot) {
        return false;
    }

    @Override
    public boolean isObstructingBlockAt(byte aSide) {
        return false;
    }

    public boolean canEmitRedstoneToVanilla(byte aSide) {
        return aSide != this.mReceived && this.connected(aSide) && !(this.getAdjacentTileEntity((byte)aSide).mTileEntity instanceof ITileEntityRedstoneWire);
    }

    public boolean canAcceptRedstoneFromVanilla(byte aSide) {
        return this.connected(aSide);
    }

    @Override
    public boolean canEmitRedstoneToWire(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 && this.connected(aSide);
    }

    @Override
    public boolean canAcceptRedstoneFromWire(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 && this.connected(aSide);
    }

    @Override
    public long getRedstoneLoss(int aRedstoneID) {
        return aRedstoneID == -1 ? this.mLoss : Integer.MAX_VALUE;
    }

    @Override
    public long getRedstoneValue(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 ? this.mRedstone : 0L;
    }

    @Override
    public long getRedstoneMinusLoss(byte aSide, int aRedstoneID) {
        return aRedstoneID == -1 ? this.mRedstone - this.mLoss : 0L;
    }

    @Override
    public boolean canConnect(byte aSide, DelegatorTileEntity<TileEntity> aDelegator) {
        return true;
    }

    @Override
    public long getProgressValue(byte aSide) {
        return 1000L * this.mRedstone / Integer.MAX_VALUE;
    }

    @Override
    public long getProgressMax(byte aSide) {
        return 16000L;
    }

    @Override
    public byte setStateMode(byte aMode) {
        this.mMode = aMode;
        return this.mMode;
    }

    @Override
    public byte getStateMode() {
        return this.mMode;
    }

    @Override
    public Collection<TagData> getConnectorTypes(byte aSide) {
        return TD.Connectors.WIRE_REDSTONE.AS_LIST;
    }

    @Override
    public String getFacingTool() {
        return "cutter";
    }

    @Override
    public ITexture getTextureSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureDefault.get((IIconContainer)Textures.BlockIcons.INSULATION_FULL, this.isPainted() ? this.mRGBa : UT.Code.getRGBInt(96L, 64L, 64L));
    }

    @Override
    public ITexture getTextureConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return BlockTextureMulti.get(BlockTextureDefault.get(this.mMaterial, this.getIconIndexConnected(aSide, aConnections, aDiameter, aRenderPass), this.mIsGlowing), BlockTextureDefault.get((IIconContainer)(aDiameter < 0.37f ? Textures.BlockIcons.INSULATION_TINY : (aDiameter < 0.49f ? Textures.BlockIcons.INSULATION_SMALL : (aDiameter < 0.74f ? Textures.BlockIcons.INSULATION_MEDIUM : (aDiameter < 0.99f ? Textures.BlockIcons.INSULATION_LARGE : Textures.BlockIcons.INSULATION_HUGE)))), this.isPainted() ? this.mRGBa : UT.Code.getRGBInt(96L, 64L, 64L)));
    }

    @Override
    public int getIconIndexSide(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public int getIconIndexConnected(byte aSide, byte aConnections, float aDiameter, int aRenderPass) {
        return OP.wire.mIconIndexBlock;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.connector.wire.redstone.insulated";
    }
}

