/*
 * Decompiled with CFR 0.152.
 */
package gregapi.tileentity.client;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregapi.random.IHasWorldAndCoords;
import gregapi.tileentity.ITileEntityUnloadable;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.ITickableSound;
import net.minecraft.util.ResourceLocation;

public interface ITileEntitySoundSource
extends ITileEntityUnloadable {
    @SideOnly(value=Side.CLIENT)
    public void startSound();

    @SideOnly(value=Side.CLIENT)
    public void stopSound();

    @SideOnly(value=Side.CLIENT)
    public static class SoundSourceTileEntity
    implements ITickableSound {
        public boolean mRunning = false;
        public float mSoundStrength;
        public float mSoundModulation;
        public final IHasWorldAndCoords mTileEntity;
        public final ResourceLocation mResource;

        public SoundSourceTileEntity(IHasWorldAndCoords aTileEntity, boolean aRunning, String aSoundName, float aSoundStrength, float aSoundModulation) {
            this.mTileEntity = aTileEntity;
            this.mResource = new ResourceLocation(aSoundName);
            this.mSoundStrength = aSoundStrength;
            this.mSoundModulation = aSoundModulation;
        }

        public ResourceLocation getPositionedSoundLocation() {
            return this.mResource;
        }

        public boolean canRepeat() {
            return this.mRunning;
        }

        public boolean isDonePlaying() {
            return !this.mRunning;
        }

        public int getRepeatDelay() {
            return 1;
        }

        public float getVolume() {
            return this.mSoundStrength;
        }

        public float getPitch() {
            return this.mSoundModulation;
        }

        public float getXPosF() {
            return this.mTileEntity == null ? 0.0f : (float)this.mTileEntity.getX() + 0.5f;
        }

        public float getYPosF() {
            return this.mTileEntity == null ? 0.0f : (float)this.mTileEntity.getY() + 0.5f;
        }

        public float getZPosF() {
            return this.mTileEntity == null ? 0.0f : (float)this.mTileEntity.getZ() + 0.5f;
        }

        public ISound.AttenuationType getAttenuationType() {
            return ISound.AttenuationType.LINEAR;
        }

        public void update() {
        }
    }
}

