/*
 * Decompiled with CFR 0.152.
 */
package gregapi.render;

import gregapi.data.CS;
import gregapi.util.UT;
import gregapi.util.WD;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

public interface ITexture {
    public void renderXPos(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderXNeg(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderYPos(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderYNeg(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderZPos(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public void renderZNeg(RenderBlocks var1, Block var2, int var3, int var4, int var5, int var6, boolean var7);

    public boolean isValidTexture();

    public static class Util {
        public static boolean OPTIFINE_LOADED = false;
        public static boolean GT_ALPHA_BLENDING = false;
        public static boolean MC_ALPHA_BLENDING = false;
        public static boolean IS_RENDERING_ALPHA = false;
        public static float OFFSET_X_POS = 0.0f;
        public static float OFFSET_X_NEG = 0.0f;
        public static float OFFSET_Y_POS = 0.0f;
        public static float OFFSET_Y_NEG = 0.0f;
        public static float OFFSET_Z_POS = 0.0f;
        public static float OFFSET_Z_NEG = 0.0f;
        public static float OFFSET_DEFAULT = 0.0f;
        public static float OFFSET_ADD = 1.0E-4f;
        public static float OFFSET_BREAK = 1.0E-4f;

        public static void startRendering(RenderBlocks aRenderer, Block aBlock, IBlockAccess aWorld, int aX, int aY, int aZ) {
            OFFSET_Z_NEG = aRenderer.hasOverrideBlockTexture() ? OFFSET_BREAK : OFFSET_DEFAULT;
            OFFSET_Z_POS = OFFSET_Z_NEG;
            OFFSET_Y_NEG = OFFSET_Z_NEG;
            OFFSET_Y_POS = OFFSET_Z_NEG;
            OFFSET_X_NEG = OFFSET_Z_NEG;
            OFFSET_X_POS = OFFSET_Z_NEG;
            if (aWorld != null) {
                if (aRenderer.hasOverrideBlockTexture()) {
                    if (aBlock.getRenderBlockPass() > 0) {
                        GL11.glDisable((int)3042);
                    }
                } else if (GT_ALPHA_BLENDING && aBlock.getRenderBlockPass() < 1) {
                    IS_RENDERING_ALPHA = true;
                    Tessellator.instance.draw();
                    Tessellator.instance.startDrawingQuads();
                    GL11.glEnable((int)3042);
                    GL11.glAlphaFunc((int)516, (float)0.1f);
                }
            }
        }

        public static void endRendering(RenderBlocks aRenderer, Block aBlock, IBlockAccess aWorld, int aX, int aY, int aZ) {
            if (aWorld != null && IS_RENDERING_ALPHA) {
                IS_RENDERING_ALPHA = false;
                Tessellator.instance.draw();
                Tessellator.instance.startDrawingQuads();
                GL11.glDisable((int)3042);
                GL11.glAlphaFunc((int)516, (float)0.1f);
            }
        }

        public static boolean renderSide(byte aSide, IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            if (aIcon == null) {
                return false;
            }
            switch (aSide) {
                case 0: {
                    return Util.renderYNeg(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 1: {
                    return Util.renderYPos(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 2: {
                    return Util.renderZNeg(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 3: {
                    return Util.renderZPos(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 4: {
                    return Util.renderXNeg(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
                case 5: {
                    return Util.renderXPos(aIcon, aRGBa, aAllowAlpha, aUseConstantBrightness, aEnableAO, aRenderer, aBlock, aX, aY, aZ, aBrightness, aChangedBlockBounds);
                }
            }
            return false;
        }

        public static boolean renderXPos(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.enableAO;
            if (!aEnableAO) {
                aRenderer.enableAO = false;
            }
            Util.prepareRenderXPos(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderXPos(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.enableAO = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderXNeg(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.enableAO;
            if (!aEnableAO) {
                aRenderer.enableAO = false;
            }
            Util.prepareRenderXNeg(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderXNeg(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.enableAO = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderYPos(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.enableAO;
            if (!aEnableAO) {
                aRenderer.enableAO = false;
            }
            Util.prepareRenderYPos(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderYPos(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.enableAO = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderYNeg(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.enableAO;
            if (!aEnableAO) {
                aRenderer.enableAO = false;
            }
            Util.prepareRenderYNeg(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderYNeg(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.enableAO = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderZPos(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.enableAO;
            if (!aEnableAO) {
                aRenderer.enableAO = false;
            }
            Util.prepareRenderZPos(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderZPos(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.enableAO = tAmbientOcclusion;
            return rReturn;
        }

        public static boolean renderZNeg(IIcon aIcon, short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, boolean aEnableAO, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness, boolean aChangedBlockBounds) {
            boolean tAmbientOcclusion = aRenderer.enableAO;
            if (!aEnableAO) {
                aRenderer.enableAO = false;
            }
            Util.prepareRenderZNeg(aRGBa, aAllowAlpha, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            boolean rReturn = Util.doRenderZNeg(aIcon, aRenderer, aBlock, aX, aY, aZ, aChangedBlockBounds);
            aRenderer.enableAO = tAmbientOcclusion;
            return rReturn;
        }

        public static void prepareRenderXPos(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.instance.setColorRGBA((int)((float)UT.Code.bind8(aRGBa[0]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.6f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.instance.setBrightness(aBrightness);
            if (aRenderer.enableAO) {
                Util.applyAmbientOcclusionXPos(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderXNeg(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.instance.setColorRGBA((int)((float)UT.Code.bind8(aRGBa[0]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.6f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.6f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.instance.setBrightness(aBrightness);
            if (aRenderer.enableAO) {
                Util.applyAmbientOcclusionXNeg(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderYPos(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.instance.setColorRGBA((int)((float)UT.Code.bind8(aRGBa[0]) * 1.0f), (int)((float)UT.Code.bind8(aRGBa[1]) * 1.0f), (int)((float)UT.Code.bind8(aRGBa[2]) * 1.0f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.instance.setBrightness(aBrightness);
            if (aRenderer.enableAO) {
                Util.applyAmbientOcclusionYPos(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderYNeg(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.instance.setColorRGBA((int)((float)UT.Code.bind8(aRGBa[0]) * 0.5f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.5f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.5f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.instance.setBrightness(aBrightness);
            if (aRenderer.enableAO) {
                Util.applyAmbientOcclusionYNeg(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderZPos(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.instance.setColorRGBA((int)((float)UT.Code.bind8(aRGBa[0]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.8f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.instance.setBrightness(aBrightness);
            if (aRenderer.enableAO) {
                Util.applyAmbientOcclusionZPos(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static void prepareRenderZNeg(short[] aRGBa, boolean aAllowAlpha, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRGBa == null) {
                aRGBa = CS.UNCOLOURED;
            }
            Tessellator.instance.setColorRGBA((int)((float)UT.Code.bind8(aRGBa[0]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[1]) * 0.8f), (int)((float)UT.Code.bind8(aRGBa[2]) * 0.8f), aAllowAlpha ? (int)UT.Code.bind8(aRGBa[3]) : 255);
            Tessellator.instance.setBrightness(aBrightness);
            if (aRenderer.enableAO) {
                Util.applyAmbientOcclusionZNeg(aRGBa, aUseConstantBrightness, aRenderer, aBlock, aX, aY, aZ, aBrightness);
            }
        }

        public static boolean doRenderXPos(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aChangedBlockBounds) {
                aRenderer.flipTexture = !aRenderer.flipTexture;
                aRenderer.field_152631_f = true;
            }
            if (aBlock.getRenderBlockPass() > 0) {
                double tOldValue = aRenderer.renderMaxX;
                aRenderer.renderMaxX = aRenderer.renderMaxX + (double)((float)(aRenderer.renderFromInside ? -1 : 1) * OFFSET_X_POS);
                aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.renderMaxX = tOldValue;
                OFFSET_X_POS += OFFSET_ADD;
            } else {
                aRenderer.renderFaceXPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            if (aChangedBlockBounds) {
                aRenderer.flipTexture = !aRenderer.flipTexture;
                aRenderer.field_152631_f = false;
            }
            return true;
        }

        public static boolean doRenderXNeg(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.getRenderBlockPass() > 0) {
                double tOldValue = aRenderer.renderMinX;
                aRenderer.renderMinX = aRenderer.renderMinX - (double)((float)(aRenderer.renderFromInside ? -1 : 1) * OFFSET_X_NEG);
                aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.renderMinX = tOldValue;
                OFFSET_X_NEG += OFFSET_ADD;
            } else {
                aRenderer.renderFaceXNeg(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            return true;
        }

        public static boolean doRenderYPos(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.getRenderBlockPass() > 0) {
                double tOldValue = aRenderer.renderMaxY;
                aRenderer.renderMaxY = aRenderer.renderMaxY + (double)((float)(aRenderer.renderFromInside ? -1 : 1) * OFFSET_Y_POS);
                aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.renderMaxY = tOldValue;
                OFFSET_Y_POS += OFFSET_ADD;
            } else {
                aRenderer.renderFaceYPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            return true;
        }

        public static boolean doRenderYNeg(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.getRenderBlockPass() > 0) {
                double tOldValue = aRenderer.renderMinY;
                aRenderer.renderMinY = aRenderer.renderMinY - (double)((float)(aRenderer.renderFromInside ? -1 : 1) * OFFSET_Y_NEG);
                Util.renderFixedNegativeYFacing(aIcon, aRenderer, aBlock, aX, aY, aZ);
                aRenderer.renderMinY = tOldValue;
                OFFSET_Y_NEG += OFFSET_ADD;
            } else {
                Util.renderFixedNegativeYFacing(aIcon, aRenderer, aBlock, aX, aY, aZ);
            }
            return true;
        }

        public static boolean doRenderZPos(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aBlock.getRenderBlockPass() > 0) {
                double tOldValue = aRenderer.renderMaxZ;
                aRenderer.renderMaxZ = aRenderer.renderMaxZ + (double)((float)(aRenderer.renderFromInside ? -1 : 1) * OFFSET_Z_POS);
                aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.renderMaxZ = tOldValue;
                OFFSET_Z_POS += OFFSET_ADD;
            } else {
                aRenderer.renderFaceZPos(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            return true;
        }

        public static boolean doRenderZNeg(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, boolean aChangedBlockBounds) {
            if (aChangedBlockBounds) {
                aRenderer.flipTexture = !aRenderer.flipTexture;
                aRenderer.field_152631_f = true;
            }
            if (aBlock.getRenderBlockPass() > 0) {
                double tOldValue = aRenderer.renderMinZ;
                aRenderer.renderMinZ = aRenderer.renderMinZ - (double)((float)(aRenderer.renderFromInside ? -1 : 1) * OFFSET_Z_NEG);
                aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
                aRenderer.renderMinZ = tOldValue;
                OFFSET_Z_NEG += OFFSET_ADD;
            } else {
                aRenderer.renderFaceZNeg(aBlock, (double)aX, (double)aY, (double)aZ, aIcon);
            }
            if (aChangedBlockBounds) {
                aRenderer.flipTexture = !aRenderer.flipTexture;
                aRenderer.field_152631_f = false;
            }
            return true;
        }

        public static void renderFixedNegativeYFacing(IIcon aIcon, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ) {
            if (aRenderer.hasOverrideBlockTexture()) {
                aIcon = aRenderer.overrideBlockTexture;
            }
            double tMaxX1 = aIcon.getInterpolatedU(aRenderer.renderMaxX * 16.0);
            double tMinX1 = aIcon.getInterpolatedU(aRenderer.renderMinX * 16.0);
            double tMaxZ1 = aIcon.getInterpolatedV(aRenderer.renderMaxZ * 16.0);
            double tMinZ1 = aIcon.getInterpolatedV(aRenderer.renderMinZ * 16.0);
            if (aRenderer.renderMinX < 0.0 || aRenderer.renderMaxX > 1.0) {
                tMinX1 = aIcon.getMinU();
                tMaxX1 = aIcon.getMaxU();
            }
            if (aRenderer.renderMinZ < 0.0 || aRenderer.renderMaxZ > 1.0) {
                tMaxZ1 = aIcon.getMinV();
                tMinZ1 = aIcon.getMaxV();
            }
            double tMaxX2 = tMaxX1;
            double tMinX2 = tMinX1;
            double tMaxZ2 = tMaxZ1;
            double tMinZ2 = tMinZ1;
            if (aRenderer.uvRotateBottom == 2) {
                tMinX1 = aIcon.getInterpolatedU(aRenderer.renderMinZ * 16.0);
                tMaxZ1 = aIcon.getInterpolatedV(16.0 - aRenderer.renderMaxX * 16.0);
                tMaxX1 = aIcon.getInterpolatedU(aRenderer.renderMaxZ * 16.0);
                tMinZ1 = aIcon.getInterpolatedV(16.0 - aRenderer.renderMinX * 16.0);
                tMaxZ2 = tMaxZ1;
                tMinZ2 = tMinZ1;
                tMaxX2 = tMinX1;
                tMinX2 = tMaxX1;
                tMaxZ1 = tMinZ1;
                tMinZ1 = tMaxZ2;
            } else if (aRenderer.uvRotateBottom == 1) {
                tMinX1 = aIcon.getInterpolatedU(16.0 - aRenderer.renderMaxZ * 16.0);
                tMaxZ1 = aIcon.getInterpolatedV(aRenderer.renderMinX * 16.0);
                tMaxX1 = aIcon.getInterpolatedU(16.0 - aRenderer.renderMinZ * 16.0);
                tMinZ1 = aIcon.getInterpolatedV(aRenderer.renderMaxX * 16.0);
                tMaxX2 = tMaxX1;
                tMinX2 = tMinX1;
                tMinX1 = tMaxX1;
                tMaxX1 = tMinX2;
                tMaxZ2 = tMinZ1;
                tMinZ2 = tMaxZ1;
            } else if (aRenderer.uvRotateBottom == 3) {
                tMinX1 = aIcon.getInterpolatedU(16.0 - aRenderer.renderMinX * 16.0);
                tMaxX1 = aIcon.getInterpolatedU(16.0 - aRenderer.renderMaxX * 16.0);
                tMaxZ1 = aIcon.getInterpolatedV(16.0 - aRenderer.renderMinZ * 16.0);
                tMinZ1 = aIcon.getInterpolatedV(16.0 - aRenderer.renderMaxZ * 16.0);
                tMaxX2 = tMaxX1;
                tMinX2 = tMinX1;
                tMaxZ2 = tMaxZ1;
                tMinZ2 = tMinZ1;
            }
            double tMinX3 = (double)aX + aRenderer.renderMinX;
            double tMaxX3 = (double)aX + aRenderer.renderMaxX;
            double tMinY3 = (double)aY + aRenderer.renderMinY;
            double tMinZ3 = (double)aZ + aRenderer.renderMinZ;
            double tMaxZ3 = (double)aZ + aRenderer.renderMaxZ;
            if (aRenderer.renderFromInside) {
                tMinX3 = (double)aX + aRenderer.renderMaxX;
                tMaxX3 = (double)aX + aRenderer.renderMinX;
            }
            if (aRenderer.enableAO) {
                Tessellator.instance.setColorOpaque_F(aRenderer.colorRedTopLeft, aRenderer.colorGreenTopLeft, aRenderer.colorBlueTopLeft);
                Tessellator.instance.setBrightness(aRenderer.brightnessTopLeft);
                Tessellator.instance.addVertexWithUV(tMinX3, tMinY3, tMaxZ3, tMinX2, tMinZ2);
                Tessellator.instance.setColorOpaque_F(aRenderer.colorRedBottomLeft, aRenderer.colorGreenBottomLeft, aRenderer.colorBlueBottomLeft);
                Tessellator.instance.setBrightness(aRenderer.brightnessBottomLeft);
                Tessellator.instance.addVertexWithUV(tMinX3, tMinY3, tMinZ3, tMinX1, tMaxZ1);
                Tessellator.instance.setColorOpaque_F(aRenderer.colorRedBottomRight, aRenderer.colorGreenBottomRight, aRenderer.colorBlueBottomRight);
                Tessellator.instance.setBrightness(aRenderer.brightnessBottomRight);
                Tessellator.instance.addVertexWithUV(tMaxX3, tMinY3, tMinZ3, tMaxX2, tMaxZ2);
                Tessellator.instance.setColorOpaque_F(aRenderer.colorRedTopRight, aRenderer.colorGreenTopRight, aRenderer.colorBlueTopRight);
                Tessellator.instance.setBrightness(aRenderer.brightnessTopRight);
                Tessellator.instance.addVertexWithUV(tMaxX3, tMinY3, tMaxZ3, tMaxX1, tMinZ1);
            } else {
                Tessellator.instance.addVertexWithUV(tMinX3, tMinY3, tMaxZ3, tMinX2, tMinZ2);
                Tessellator.instance.addVertexWithUV(tMinX3, tMinY3, tMinZ3, tMinX1, tMaxZ1);
                Tessellator.instance.addVertexWithUV(tMaxX3, tMinY3, tMinZ3, tMaxX2, tMaxZ2);
                Tessellator.instance.addVertexWithUV(tMaxX3, tMinY3, tMaxZ3, tMaxX1, tMinZ1);
            }
        }

        public static void applyAmbientOcclusionXPos(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.renderMaxX >= 1.0) {
                ++aX;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.aoLightValueScratchXYPN = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXZPN = aRenderer.blockAccess.getBlock(aX, aY, aZ - 1).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXZPP = aRenderer.blockAccess.getBlock(aX, aY, aZ + 1).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXYPP = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoBrightnessXYPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ);
            aRenderer.aoBrightnessXZPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ - 1);
            aRenderer.aoBrightnessXZPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ + 1);
            aRenderer.aoBrightnessXYPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ);
            boolean flag2 = aRenderer.blockAccess.getBlock(aX + 1, aY + 1, aZ).getCanBlockGrass();
            boolean flag3 = aRenderer.blockAccess.getBlock(aX + 1, aY - 1, aZ).getCanBlockGrass();
            boolean flag4 = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ + 1).getCanBlockGrass();
            boolean flag5 = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ - 1).getCanBlockGrass();
            if (!flag3 && !flag5) {
                aRenderer.aoLightValueScratchXYZPNN = aRenderer.aoLightValueScratchXZPN;
                aRenderer.aoBrightnessXYZPNN = aRenderer.aoBrightnessXZPN;
            } else {
                aRenderer.aoLightValueScratchXYZPNN = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ - 1);
            }
            if (!flag3 && !flag4) {
                aRenderer.aoLightValueScratchXYZPNP = aRenderer.aoLightValueScratchXZPP;
                aRenderer.aoBrightnessXYZPNP = aRenderer.aoBrightnessXZPP;
            } else {
                aRenderer.aoLightValueScratchXYZPNP = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ + 1);
            }
            if (!flag2 && !flag5) {
                aRenderer.aoLightValueScratchXYZPPN = aRenderer.aoLightValueScratchXZPN;
                aRenderer.aoBrightnessXYZPPN = aRenderer.aoBrightnessXZPN;
            } else {
                aRenderer.aoLightValueScratchXYZPPN = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ - 1);
            }
            if (!flag2 && !flag4) {
                aRenderer.aoLightValueScratchXYZPPP = aRenderer.aoLightValueScratchXZPP;
                aRenderer.aoBrightnessXYZPPP = aRenderer.aoBrightnessXZPP;
            } else {
                aRenderer.aoLightValueScratchXYZPPP = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ + 1);
            }
            if (aRenderer.renderMaxX >= 1.0) {
                --aX;
            }
            if (aRenderer.renderMaxX >= 1.0 || !WD.visOpq(aRenderer.blockAccess.getBlock(aX + 1, aY, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ);
            }
            f7 = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ).getAmbientOcclusionLightValue();
            f3 = (aRenderer.aoLightValueScratchXYPN + aRenderer.aoLightValueScratchXYZPNP + f7 + aRenderer.aoLightValueScratchXZPP) / 4.0f;
            f4 = (aRenderer.aoLightValueScratchXYZPNN + aRenderer.aoLightValueScratchXYPN + aRenderer.aoLightValueScratchXZPN + f7) / 4.0f;
            f5 = (aRenderer.aoLightValueScratchXZPN + f7 + aRenderer.aoLightValueScratchXYZPPN + aRenderer.aoLightValueScratchXYPP) / 4.0f;
            f6 = (f7 + aRenderer.aoLightValueScratchXZPP + aRenderer.aoLightValueScratchXYPP + aRenderer.aoLightValueScratchXYZPPP) / 4.0f;
            aRenderer.brightnessTopLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYPN, aRenderer.aoBrightnessXYZPNP, aRenderer.aoBrightnessXZPP, aBrightness);
            aRenderer.brightnessTopRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessXZPP, aRenderer.aoBrightnessXYPP, aRenderer.aoBrightnessXYZPPP, aBrightness);
            aRenderer.brightnessBottomRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessXZPN, aRenderer.aoBrightnessXYZPPN, aRenderer.aoBrightnessXYPP, aBrightness);
            aRenderer.brightnessBottomLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYZPNN, aRenderer.aoBrightnessXYPN, aRenderer.aoBrightnessXZPN, aBrightness);
            aRenderer.colorRedBottomRight = aRenderer.colorRedTopRight = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.6f;
            aRenderer.colorRedBottomLeft = aRenderer.colorRedTopRight;
            aRenderer.colorRedTopLeft = aRenderer.colorRedTopRight;
            aRenderer.colorGreenBottomRight = aRenderer.colorGreenTopRight = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.6f;
            aRenderer.colorGreenBottomLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorGreenTopLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorBlueBottomRight = aRenderer.colorBlueTopRight = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.6f;
            aRenderer.colorBlueBottomLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorBlueTopLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorRedTopLeft *= f3;
            aRenderer.colorGreenTopLeft *= f3;
            aRenderer.colorBlueTopLeft *= f3;
            aRenderer.colorRedBottomLeft *= f4;
            aRenderer.colorGreenBottomLeft *= f4;
            aRenderer.colorBlueBottomLeft *= f4;
            aRenderer.colorRedBottomRight *= f5;
            aRenderer.colorGreenBottomRight *= f5;
            aRenderer.colorBlueBottomRight *= f5;
            aRenderer.colorRedTopRight *= f6;
            aRenderer.colorGreenTopRight *= f6;
            aRenderer.colorBlueTopRight *= f6;
        }

        public static void applyAmbientOcclusionXNeg(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.renderMinX <= 0.0) {
                --aX;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.aoLightValueScratchXYNN = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXZNN = aRenderer.blockAccess.getBlock(aX, aY, aZ - 1).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXZNP = aRenderer.blockAccess.getBlock(aX, aY, aZ + 1).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXYNP = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoBrightnessXYNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ);
            aRenderer.aoBrightnessXZNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ - 1);
            aRenderer.aoBrightnessXZNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ + 1);
            aRenderer.aoBrightnessXYNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ);
            boolean flag2 = aRenderer.blockAccess.getBlock(aX - 1, aY + 1, aZ).getCanBlockGrass();
            boolean flag3 = aRenderer.blockAccess.getBlock(aX - 1, aY - 1, aZ).getCanBlockGrass();
            boolean flag4 = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ - 1).getCanBlockGrass();
            boolean flag5 = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ + 1).getCanBlockGrass();
            if (!flag4 && !flag3) {
                aRenderer.aoLightValueScratchXYZNNN = aRenderer.aoLightValueScratchXZNN;
                aRenderer.aoBrightnessXYZNNN = aRenderer.aoBrightnessXZNN;
            } else {
                aRenderer.aoLightValueScratchXYZNNN = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ - 1);
            }
            if (!flag5 && !flag3) {
                aRenderer.aoLightValueScratchXYZNNP = aRenderer.aoLightValueScratchXZNP;
                aRenderer.aoBrightnessXYZNNP = aRenderer.aoBrightnessXZNP;
            } else {
                aRenderer.aoLightValueScratchXYZNNP = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ + 1);
            }
            if (!flag4 && !flag2) {
                aRenderer.aoLightValueScratchXYZNPN = aRenderer.aoLightValueScratchXZNN;
                aRenderer.aoBrightnessXYZNPN = aRenderer.aoBrightnessXZNN;
            } else {
                aRenderer.aoLightValueScratchXYZNPN = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ - 1);
            }
            if (!flag5 && !flag2) {
                aRenderer.aoLightValueScratchXYZNPP = aRenderer.aoLightValueScratchXZNP;
                aRenderer.aoBrightnessXYZNPP = aRenderer.aoBrightnessXZNP;
            } else {
                aRenderer.aoLightValueScratchXYZNPP = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ + 1);
            }
            if (aRenderer.renderMinX <= 0.0) {
                ++aX;
            }
            if (aRenderer.renderMinX <= 0.0 || !WD.visOpq(aRenderer.blockAccess.getBlock(aX - 1, aY, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ);
            }
            f7 = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ).getAmbientOcclusionLightValue();
            f6 = (aRenderer.aoLightValueScratchXYNN + aRenderer.aoLightValueScratchXYZNNP + f7 + aRenderer.aoLightValueScratchXZNP) / 4.0f;
            f3 = (f7 + aRenderer.aoLightValueScratchXZNP + aRenderer.aoLightValueScratchXYNP + aRenderer.aoLightValueScratchXYZNPP) / 4.0f;
            f4 = (aRenderer.aoLightValueScratchXZNN + f7 + aRenderer.aoLightValueScratchXYZNPN + aRenderer.aoLightValueScratchXYNP) / 4.0f;
            f5 = (aRenderer.aoLightValueScratchXYZNNN + aRenderer.aoLightValueScratchXYNN + aRenderer.aoLightValueScratchXZNN + f7) / 4.0f;
            aRenderer.brightnessTopRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYNN, aRenderer.aoBrightnessXYZNNP, aRenderer.aoBrightnessXZNP, aBrightness);
            aRenderer.brightnessTopLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXZNP, aRenderer.aoBrightnessXYNP, aRenderer.aoBrightnessXYZNPP, aBrightness);
            aRenderer.brightnessBottomLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXZNN, aRenderer.aoBrightnessXYZNPN, aRenderer.aoBrightnessXYNP, aBrightness);
            aRenderer.brightnessBottomRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYZNNN, aRenderer.aoBrightnessXYNN, aRenderer.aoBrightnessXZNN, aBrightness);
            aRenderer.colorRedBottomRight = aRenderer.colorRedTopRight = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.6f;
            aRenderer.colorRedBottomLeft = aRenderer.colorRedTopRight;
            aRenderer.colorRedTopLeft = aRenderer.colorRedTopRight;
            aRenderer.colorGreenBottomRight = aRenderer.colorGreenTopRight = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.6f;
            aRenderer.colorGreenBottomLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorGreenTopLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorBlueBottomRight = aRenderer.colorBlueTopRight = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.6f;
            aRenderer.colorBlueBottomLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorBlueTopLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorRedTopLeft *= f3;
            aRenderer.colorGreenTopLeft *= f3;
            aRenderer.colorBlueTopLeft *= f3;
            aRenderer.colorRedBottomLeft *= f4;
            aRenderer.colorGreenBottomLeft *= f4;
            aRenderer.colorBlueBottomLeft *= f4;
            aRenderer.colorRedBottomRight *= f5;
            aRenderer.colorGreenBottomRight *= f5;
            aRenderer.colorBlueBottomRight *= f5;
            aRenderer.colorRedTopRight *= f6;
            aRenderer.colorGreenTopRight *= f6;
            aRenderer.colorBlueTopRight *= f6;
        }

        public static void applyAmbientOcclusionYPos(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.renderMaxY >= 1.0) {
                ++aY;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.aoBrightnessXYNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ);
            aRenderer.aoBrightnessXYPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ);
            aRenderer.aoBrightnessYZPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ - 1);
            aRenderer.aoBrightnessYZPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ + 1);
            aRenderer.aoLightValueScratchXYNP = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXYPP = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZPN = aRenderer.blockAccess.getBlock(aX, aY, aZ - 1).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZPP = aRenderer.blockAccess.getBlock(aX, aY, aZ + 1).getAmbientOcclusionLightValue();
            boolean flag2 = aRenderer.blockAccess.getBlock(aX + 1, aY + 1, aZ).getCanBlockGrass();
            boolean flag3 = aRenderer.blockAccess.getBlock(aX - 1, aY + 1, aZ).getCanBlockGrass();
            boolean flag4 = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ + 1).getCanBlockGrass();
            boolean flag5 = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ - 1).getCanBlockGrass();
            if (!flag5 && !flag3) {
                aRenderer.aoLightValueScratchXYZNPN = aRenderer.aoLightValueScratchXYNP;
                aRenderer.aoBrightnessXYZNPN = aRenderer.aoBrightnessXYNP;
            } else {
                aRenderer.aoLightValueScratchXYZNPN = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ - 1);
            }
            if (!flag5 && !flag2) {
                aRenderer.aoLightValueScratchXYZPPN = aRenderer.aoLightValueScratchXYPP;
                aRenderer.aoBrightnessXYZPPN = aRenderer.aoBrightnessXYPP;
            } else {
                aRenderer.aoLightValueScratchXYZPPN = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ - 1);
            }
            if (!flag4 && !flag3) {
                aRenderer.aoLightValueScratchXYZNPP = aRenderer.aoLightValueScratchXYNP;
                aRenderer.aoBrightnessXYZNPP = aRenderer.aoBrightnessXYNP;
            } else {
                aRenderer.aoLightValueScratchXYZNPP = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ + 1);
            }
            if (!flag4 && !flag2) {
                aRenderer.aoLightValueScratchXYZPPP = aRenderer.aoLightValueScratchXYPP;
                aRenderer.aoBrightnessXYZPPP = aRenderer.aoBrightnessXYPP;
            } else {
                aRenderer.aoLightValueScratchXYZPPP = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ + 1);
            }
            if (aRenderer.renderMaxY >= 1.0) {
                --aY;
            }
            if (aRenderer.renderMaxY >= 1.0 || !WD.visOpq(aRenderer.blockAccess.getBlock(aX, aY + 1, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ);
            }
            f7 = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ).getAmbientOcclusionLightValue();
            f6 = (aRenderer.aoLightValueScratchXYZNPP + aRenderer.aoLightValueScratchXYNP + aRenderer.aoLightValueScratchYZPP + f7) / 4.0f;
            f3 = (aRenderer.aoLightValueScratchYZPP + f7 + aRenderer.aoLightValueScratchXYZPPP + aRenderer.aoLightValueScratchXYPP) / 4.0f;
            f4 = (f7 + aRenderer.aoLightValueScratchYZPN + aRenderer.aoLightValueScratchXYPP + aRenderer.aoLightValueScratchXYZPPN) / 4.0f;
            f5 = (aRenderer.aoLightValueScratchXYNP + aRenderer.aoLightValueScratchXYZNPN + f7 + aRenderer.aoLightValueScratchYZPN) / 4.0f;
            aRenderer.brightnessTopRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYZNPP, aRenderer.aoBrightnessXYNP, aRenderer.aoBrightnessYZPP, aBrightness);
            aRenderer.brightnessTopLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZPP, aRenderer.aoBrightnessXYZPPP, aRenderer.aoBrightnessXYPP, aBrightness);
            aRenderer.brightnessBottomLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZPN, aRenderer.aoBrightnessXYPP, aRenderer.aoBrightnessXYZPPN, aBrightness);
            aRenderer.brightnessBottomRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYNP, aRenderer.aoBrightnessXYZNPN, aRenderer.aoBrightnessYZPN, aBrightness);
            aRenderer.colorRedBottomRight = aRenderer.colorRedTopRight = (float)UT.Code.bind8(aRGBa[0]) / 256.0f;
            aRenderer.colorRedBottomLeft = aRenderer.colorRedTopRight;
            aRenderer.colorRedTopLeft = aRenderer.colorRedTopRight;
            aRenderer.colorGreenBottomRight = aRenderer.colorGreenTopRight = (float)UT.Code.bind8(aRGBa[1]) / 256.0f;
            aRenderer.colorGreenBottomLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorGreenTopLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorBlueBottomRight = aRenderer.colorBlueTopRight = (float)UT.Code.bind8(aRGBa[2]) / 256.0f;
            aRenderer.colorBlueBottomLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorBlueTopLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorRedTopLeft *= f3;
            aRenderer.colorGreenTopLeft *= f3;
            aRenderer.colorBlueTopLeft *= f3;
            aRenderer.colorRedBottomLeft *= f4;
            aRenderer.colorGreenBottomLeft *= f4;
            aRenderer.colorBlueBottomLeft *= f4;
            aRenderer.colorRedBottomRight *= f5;
            aRenderer.colorGreenBottomRight *= f5;
            aRenderer.colorBlueBottomRight *= f5;
            aRenderer.colorRedTopRight *= f6;
            aRenderer.colorGreenTopRight *= f6;
            aRenderer.colorBlueTopRight *= f6;
        }

        public static void applyAmbientOcclusionYNeg(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.renderMinY <= 0.0) {
                --aY;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.aoBrightnessXYNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ);
            aRenderer.aoBrightnessYZNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ - 1);
            aRenderer.aoBrightnessYZNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ + 1);
            aRenderer.aoBrightnessXYPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ);
            aRenderer.aoLightValueScratchXYNN = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZNN = aRenderer.blockAccess.getBlock(aX, aY, aZ - 1).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZNP = aRenderer.blockAccess.getBlock(aX, aY, aZ + 1).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXYPN = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ).getAmbientOcclusionLightValue();
            boolean flag2 = aRenderer.blockAccess.getBlock(aX + 1, aY - 1, aZ).getCanBlockGrass();
            boolean flag3 = aRenderer.blockAccess.getBlock(aX - 1, aY - 1, aZ).getCanBlockGrass();
            boolean flag4 = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ + 1).getCanBlockGrass();
            boolean flag5 = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ - 1).getCanBlockGrass();
            if (!flag5 && !flag3) {
                aRenderer.aoLightValueScratchXYZNNN = aRenderer.aoLightValueScratchXYNN;
                aRenderer.aoBrightnessXYZNNN = aRenderer.aoBrightnessXYNN;
            } else {
                aRenderer.aoLightValueScratchXYZNNN = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ - 1);
            }
            if (!flag4 && !flag3) {
                aRenderer.aoLightValueScratchXYZNNP = aRenderer.aoLightValueScratchXYNN;
                aRenderer.aoBrightnessXYZNNP = aRenderer.aoBrightnessXYNN;
            } else {
                aRenderer.aoLightValueScratchXYZNNP = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ + 1);
            }
            if (!flag5 && !flag2) {
                aRenderer.aoLightValueScratchXYZPNN = aRenderer.aoLightValueScratchXYPN;
                aRenderer.aoBrightnessXYZPNN = aRenderer.aoBrightnessXYPN;
            } else {
                aRenderer.aoLightValueScratchXYZPNN = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ - 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ - 1);
            }
            if (!flag4 && !flag2) {
                aRenderer.aoLightValueScratchXYZPNP = aRenderer.aoLightValueScratchXYPN;
                aRenderer.aoBrightnessXYZPNP = aRenderer.aoBrightnessXYPN;
            } else {
                aRenderer.aoLightValueScratchXYZPNP = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ + 1).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ + 1);
            }
            if (aRenderer.renderMinY <= 0.0) {
                ++aY;
            }
            if (aRenderer.renderMinY <= 0.0 || !WD.visOpq(aRenderer.blockAccess.getBlock(aX, aY - 1, aZ))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ);
            }
            f7 = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ).getAmbientOcclusionLightValue();
            f3 = (aRenderer.aoLightValueScratchXYZNNP + aRenderer.aoLightValueScratchXYNN + aRenderer.aoLightValueScratchYZNP + f7) / 4.0f;
            f6 = (aRenderer.aoLightValueScratchYZNP + f7 + aRenderer.aoLightValueScratchXYZPNP + aRenderer.aoLightValueScratchXYPN) / 4.0f;
            f5 = (f7 + aRenderer.aoLightValueScratchYZNN + aRenderer.aoLightValueScratchXYPN + aRenderer.aoLightValueScratchXYZPNN) / 4.0f;
            f4 = (aRenderer.aoLightValueScratchXYNN + aRenderer.aoLightValueScratchXYZNNN + f7 + aRenderer.aoLightValueScratchYZNN) / 4.0f;
            aRenderer.brightnessTopLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYZNNP, aRenderer.aoBrightnessXYNN, aRenderer.aoBrightnessYZNP, aBrightness);
            aRenderer.brightnessTopRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZNP, aRenderer.aoBrightnessXYZPNP, aRenderer.aoBrightnessXYPN, aBrightness);
            aRenderer.brightnessBottomRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZNN, aRenderer.aoBrightnessXYPN, aRenderer.aoBrightnessXYZPNN, aBrightness);
            aRenderer.brightnessBottomLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYNN, aRenderer.aoBrightnessXYZNNN, aRenderer.aoBrightnessYZNN, aBrightness);
            aRenderer.colorRedBottomRight = aRenderer.colorRedTopRight = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.5f;
            aRenderer.colorRedBottomLeft = aRenderer.colorRedTopRight;
            aRenderer.colorRedTopLeft = aRenderer.colorRedTopRight;
            aRenderer.colorGreenBottomRight = aRenderer.colorGreenTopRight = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.5f;
            aRenderer.colorGreenBottomLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorGreenTopLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorBlueBottomRight = aRenderer.colorBlueTopRight = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.5f;
            aRenderer.colorBlueBottomLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorBlueTopLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorRedTopLeft *= f3;
            aRenderer.colorGreenTopLeft *= f3;
            aRenderer.colorBlueTopLeft *= f3;
            aRenderer.colorRedBottomLeft *= f4;
            aRenderer.colorGreenBottomLeft *= f4;
            aRenderer.colorBlueBottomLeft *= f4;
            aRenderer.colorRedBottomRight *= f5;
            aRenderer.colorGreenBottomRight *= f5;
            aRenderer.colorBlueBottomRight *= f5;
            aRenderer.colorRedTopRight *= f6;
            aRenderer.colorGreenTopRight *= f6;
            aRenderer.colorBlueTopRight *= f6;
        }

        public static void applyAmbientOcclusionZPos(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.renderMaxZ >= 1.0) {
                ++aZ;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.aoLightValueScratchXZNP = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXZPP = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZNP = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZPP = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoBrightnessXZNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ);
            aRenderer.aoBrightnessXZPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ);
            aRenderer.aoBrightnessYZNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ);
            aRenderer.aoBrightnessYZPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ);
            boolean flag2 = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ + 1).getCanBlockGrass();
            boolean flag3 = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ + 1).getCanBlockGrass();
            boolean flag4 = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ + 1).getCanBlockGrass();
            boolean flag5 = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ + 1).getCanBlockGrass();
            if (!flag3 && !flag5) {
                aRenderer.aoLightValueScratchXYZNNP = aRenderer.aoLightValueScratchXZNP;
                aRenderer.aoBrightnessXYZNNP = aRenderer.aoBrightnessXZNP;
            } else {
                aRenderer.aoLightValueScratchXYZNNP = aRenderer.blockAccess.getBlock(aX - 1, aY - 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY - 1, aZ);
            }
            if (!flag3 && !flag4) {
                aRenderer.aoLightValueScratchXYZNPP = aRenderer.aoLightValueScratchXZNP;
                aRenderer.aoBrightnessXYZNPP = aRenderer.aoBrightnessXZNP;
            } else {
                aRenderer.aoLightValueScratchXYZNPP = aRenderer.blockAccess.getBlock(aX - 1, aY + 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY + 1, aZ);
            }
            if (!flag2 && !flag5) {
                aRenderer.aoLightValueScratchXYZPNP = aRenderer.aoLightValueScratchXZPP;
                aRenderer.aoBrightnessXYZPNP = aRenderer.aoBrightnessXZPP;
            } else {
                aRenderer.aoLightValueScratchXYZPNP = aRenderer.blockAccess.getBlock(aX + 1, aY - 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPNP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY - 1, aZ);
            }
            if (!flag2 && !flag4) {
                aRenderer.aoLightValueScratchXYZPPP = aRenderer.aoLightValueScratchXZPP;
                aRenderer.aoBrightnessXYZPPP = aRenderer.aoBrightnessXZPP;
            } else {
                aRenderer.aoLightValueScratchXYZPPP = aRenderer.blockAccess.getBlock(aX + 1, aY + 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPPP = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY + 1, aZ);
            }
            if (aRenderer.renderMaxZ >= 1.0) {
                --aZ;
            }
            if (aRenderer.renderMaxZ >= 1.0 || !WD.visOpq(aRenderer.blockAccess.getBlock(aX, aY, aZ + 1))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ + 1);
            }
            f7 = aRenderer.blockAccess.getBlock(aX, aY, aZ + 1).getAmbientOcclusionLightValue();
            f3 = (aRenderer.aoLightValueScratchXZNP + aRenderer.aoLightValueScratchXYZNPP + f7 + aRenderer.aoLightValueScratchYZPP) / 4.0f;
            f6 = (f7 + aRenderer.aoLightValueScratchYZPP + aRenderer.aoLightValueScratchXZPP + aRenderer.aoLightValueScratchXYZPPP) / 4.0f;
            f5 = (aRenderer.aoLightValueScratchYZNP + f7 + aRenderer.aoLightValueScratchXYZPNP + aRenderer.aoLightValueScratchXZPP) / 4.0f;
            f4 = (aRenderer.aoLightValueScratchXYZNNP + aRenderer.aoLightValueScratchXZNP + aRenderer.aoLightValueScratchYZNP + f7) / 4.0f;
            aRenderer.brightnessTopLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXZNP, aRenderer.aoBrightnessXYZNPP, aRenderer.aoBrightnessYZPP, aBrightness);
            aRenderer.brightnessTopRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZPP, aRenderer.aoBrightnessXZPP, aRenderer.aoBrightnessXYZPPP, aBrightness);
            aRenderer.brightnessBottomRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZNP, aRenderer.aoBrightnessXYZPNP, aRenderer.aoBrightnessXZPP, aBrightness);
            aRenderer.brightnessBottomLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYZNNP, aRenderer.aoBrightnessXZNP, aRenderer.aoBrightnessYZNP, aBrightness);
            aRenderer.colorRedBottomRight = aRenderer.colorRedTopRight = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.8f;
            aRenderer.colorRedBottomLeft = aRenderer.colorRedTopRight;
            aRenderer.colorRedTopLeft = aRenderer.colorRedTopRight;
            aRenderer.colorGreenBottomRight = aRenderer.colorGreenTopRight = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.8f;
            aRenderer.colorGreenBottomLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorGreenTopLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorBlueBottomRight = aRenderer.colorBlueTopRight = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.8f;
            aRenderer.colorBlueBottomLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorBlueTopLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorRedTopLeft *= f3;
            aRenderer.colorGreenTopLeft *= f3;
            aRenderer.colorBlueTopLeft *= f3;
            aRenderer.colorRedBottomLeft *= f4;
            aRenderer.colorGreenBottomLeft *= f4;
            aRenderer.colorBlueBottomLeft *= f4;
            aRenderer.colorRedBottomRight *= f5;
            aRenderer.colorGreenBottomRight *= f5;
            aRenderer.colorBlueBottomRight *= f5;
            aRenderer.colorRedTopRight *= f6;
            aRenderer.colorGreenTopRight *= f6;
            aRenderer.colorBlueTopRight *= f6;
        }

        public static void applyAmbientOcclusionZNeg(short[] aRGBa, boolean aUseConstantBrightness, RenderBlocks aRenderer, Block aBlock, int aX, int aY, int aZ, int aBrightness) {
            if (aRenderer.renderMinZ <= 0.0) {
                --aZ;
            }
            float f3 = 0.0f;
            float f4 = 0.0f;
            float f5 = 0.0f;
            float f6 = 0.0f;
            float f7 = 1.0f;
            aRenderer.aoLightValueScratchXZNN = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZNN = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchYZPN = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoLightValueScratchXZPN = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ).getAmbientOcclusionLightValue();
            aRenderer.aoBrightnessXZNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY, aZ);
            aRenderer.aoBrightnessYZNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY - 1, aZ);
            aRenderer.aoBrightnessYZPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY + 1, aZ);
            aRenderer.aoBrightnessXZPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY, aZ);
            boolean flag2 = aRenderer.blockAccess.getBlock(aX + 1, aY, aZ - 1).getCanBlockGrass();
            boolean flag3 = aRenderer.blockAccess.getBlock(aX - 1, aY, aZ - 1).getCanBlockGrass();
            boolean flag4 = aRenderer.blockAccess.getBlock(aX, aY + 1, aZ - 1).getCanBlockGrass();
            boolean flag5 = aRenderer.blockAccess.getBlock(aX, aY - 1, aZ - 1).getCanBlockGrass();
            if (!flag3 && !flag5) {
                aRenderer.aoLightValueScratchXYZNNN = aRenderer.aoLightValueScratchXZNN;
                aRenderer.aoBrightnessXYZNNN = aRenderer.aoBrightnessXZNN;
            } else {
                aRenderer.aoLightValueScratchXYZNNN = aRenderer.blockAccess.getBlock(aX - 1, aY - 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY - 1, aZ);
            }
            if (!flag3 && !flag4) {
                aRenderer.aoLightValueScratchXYZNPN = aRenderer.aoLightValueScratchXZNN;
                aRenderer.aoBrightnessXYZNPN = aRenderer.aoBrightnessXZNN;
            } else {
                aRenderer.aoLightValueScratchXYZNPN = aRenderer.blockAccess.getBlock(aX - 1, aY + 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZNPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX - 1, aY + 1, aZ);
            }
            if (!flag2 && !flag5) {
                aRenderer.aoLightValueScratchXYZPNN = aRenderer.aoLightValueScratchXZPN;
                aRenderer.aoBrightnessXYZPNN = aRenderer.aoBrightnessXZPN;
            } else {
                aRenderer.aoLightValueScratchXYZPNN = aRenderer.blockAccess.getBlock(aX + 1, aY - 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPNN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY - 1, aZ);
            }
            if (!flag2 && !flag4) {
                aRenderer.aoLightValueScratchXYZPPN = aRenderer.aoLightValueScratchXZPN;
                aRenderer.aoBrightnessXYZPPN = aRenderer.aoBrightnessXZPN;
            } else {
                aRenderer.aoLightValueScratchXYZPPN = aRenderer.blockAccess.getBlock(aX + 1, aY + 1, aZ).getAmbientOcclusionLightValue();
                int n = aRenderer.aoBrightnessXYZPPN = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX + 1, aY + 1, aZ);
            }
            if (aRenderer.renderMinZ <= 0.0) {
                ++aZ;
            }
            if (aRenderer.renderMinZ <= 0.0 || !WD.visOpq(aRenderer.blockAccess.getBlock(aX, aY, aZ - 1))) {
                aBrightness = aUseConstantBrightness ? aBrightness : aBlock.getMixedBrightnessForBlock(aRenderer.blockAccess, aX, aY, aZ - 1);
            }
            f7 = aRenderer.blockAccess.getBlock(aX, aY, aZ - 1).getAmbientOcclusionLightValue();
            f3 = (aRenderer.aoLightValueScratchXZNN + aRenderer.aoLightValueScratchXYZNPN + f7 + aRenderer.aoLightValueScratchYZPN) / 4.0f;
            f4 = (f7 + aRenderer.aoLightValueScratchYZPN + aRenderer.aoLightValueScratchXZPN + aRenderer.aoLightValueScratchXYZPPN) / 4.0f;
            f5 = (aRenderer.aoLightValueScratchYZNN + f7 + aRenderer.aoLightValueScratchXYZPNN + aRenderer.aoLightValueScratchXZPN) / 4.0f;
            f6 = (aRenderer.aoLightValueScratchXYZNNN + aRenderer.aoLightValueScratchXZNN + aRenderer.aoLightValueScratchYZNN + f7) / 4.0f;
            aRenderer.brightnessTopLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessXZNN, aRenderer.aoBrightnessXYZNPN, aRenderer.aoBrightnessYZPN, aBrightness);
            aRenderer.brightnessBottomLeft = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZPN, aRenderer.aoBrightnessXZPN, aRenderer.aoBrightnessXYZPPN, aBrightness);
            aRenderer.brightnessBottomRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessYZNN, aRenderer.aoBrightnessXYZPNN, aRenderer.aoBrightnessXZPN, aBrightness);
            aRenderer.brightnessTopRight = aRenderer.getAoBrightness(aRenderer.aoBrightnessXYZNNN, aRenderer.aoBrightnessXZNN, aRenderer.aoBrightnessYZNN, aBrightness);
            aRenderer.colorRedBottomRight = aRenderer.colorRedTopRight = (float)UT.Code.bind8(aRGBa[0]) / 256.0f * 0.8f;
            aRenderer.colorRedBottomLeft = aRenderer.colorRedTopRight;
            aRenderer.colorRedTopLeft = aRenderer.colorRedTopRight;
            aRenderer.colorGreenBottomRight = aRenderer.colorGreenTopRight = (float)UT.Code.bind8(aRGBa[1]) / 256.0f * 0.8f;
            aRenderer.colorGreenBottomLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorGreenTopLeft = aRenderer.colorGreenTopRight;
            aRenderer.colorBlueBottomRight = aRenderer.colorBlueTopRight = (float)UT.Code.bind8(aRGBa[2]) / 256.0f * 0.8f;
            aRenderer.colorBlueBottomLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorBlueTopLeft = aRenderer.colorBlueTopRight;
            aRenderer.colorRedTopLeft *= f3;
            aRenderer.colorGreenTopLeft *= f3;
            aRenderer.colorBlueTopLeft *= f3;
            aRenderer.colorRedBottomLeft *= f4;
            aRenderer.colorGreenBottomLeft *= f4;
            aRenderer.colorBlueBottomLeft *= f4;
            aRenderer.colorRedBottomRight *= f5;
            aRenderer.colorGreenBottomRight *= f5;
            aRenderer.colorBlueBottomRight *= f5;
            aRenderer.colorRedTopRight *= f6;
            aRenderer.colorGreenTopRight *= f6;
            aRenderer.colorBlueTopRight *= f6;
        }
    }
}

