/*
 * Decompiled with CFR 0.152.
 */
package gregapi.recipes.maps;

import gregapi.data.CS;
import gregapi.data.FL;
import gregapi.data.OP;
import gregapi.data.TD;
import gregapi.oredict.OreDictItemData;
import gregapi.oredict.OreDictMaterialStack;
import gregapi.random.IHasWorldAndCoords;
import gregapi.recipes.Recipe;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class RecipeMapFurnaceFuel
extends Recipe.RecipeMap {
    public RecipeMapFurnaceFuel(Collection<Recipe> aRecipeList, String aUnlocalizedName, String aNameLocal, String aNameNEI, long aProgressBarDirection, long aProgressBarAmount, String aNEIGUIPath, long aInputItemsCount, long aOutputItemsCount, long aMinimalInputItems, long aInputFluidCount, long aOutputFluidCount, long aMinimalInputFluids, long aMinimalInputs, long aPower, String aNEISpecialValuePre, long aNEISpecialValueMultiplier, String aNEISpecialValuePost, boolean aShowVoltageAmperageInNEI, boolean aNEIAllowed, boolean aConfigAllowed, boolean aNeedsOutputs, boolean aCombinePower, boolean aUseBucketSizeIn, boolean aUseBucketSizeOut) {
        super(aRecipeList, aUnlocalizedName, aNameLocal + " (1 Smelt = 5000 GU)", aNameNEI, aProgressBarDirection, aProgressBarAmount, aNEIGUIPath, aInputItemsCount, aOutputItemsCount, aMinimalInputItems, aInputFluidCount, aOutputFluidCount, aMinimalInputFluids, aMinimalInputs, aPower, aNEISpecialValuePre, aNEISpecialValueMultiplier, aNEISpecialValuePost, false, aShowVoltageAmperageInNEI, aNEIAllowed, aConfigAllowed, aNeedsOutputs, aCombinePower, aUseBucketSizeIn, aUseBucketSizeOut);
    }

    @Override
    public Recipe findRecipe(IHasWorldAndCoords aTileEntity, Recipe aRecipe, boolean aNotUnificated, long aSize, ItemStack aSpecialSlot, FluidStack[] aFluids, ItemStack ... aInputs) {
        Recipe rRecipe = super.findRecipe(aTileEntity, aRecipe, aNotUnificated, aSize, aSpecialSlot, aFluids, aInputs);
        if (aInputs == null || aInputs.length < 1 || ST.invalid(aInputs[0]) || CS.GAPI_POST.mFinishedServerStarted <= 0) {
            return rRecipe;
        }
        if (rRecipe == null) {
            long tFuelValue = ST.fuel(aInputs[0]);
            OreDictItemData tData = OM.anydata_(aInputs[0]);
            if (tFuelValue > 0L && !FL.contains(aInputs[0], FL.Lava.make(0L), true) && !OM.materialcontains(tData, TD.Properties.EXPLOSIVE)) {
                ItemStack tContainer = ST.container(aInputs[0], true);
                if (tContainer == null) {
                    OreDictMaterialStack tMaterial = null;
                    if (tData != null) {
                        if (tData.mPrefix == OP.oreRaw) {
                            tMaterial = OM.stack(tData.mMaterial.mMaterial.mTargetBurning.mMaterial, tData.mMaterial.mMaterial.mTargetBurning.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier * (long)tData.mMaterial.mMaterial.mOreProcessingMultiplier * 2L);
                        } else if (tData.mPrefix == OP.blockRaw) {
                            tMaterial = OM.stack(tData.mMaterial.mMaterial.mTargetBurning.mMaterial, tData.mMaterial.mMaterial.mTargetBurning.mAmount * (long)tData.mMaterial.mMaterial.mOreMultiplier * (long)tData.mMaterial.mMaterial.mOreProcessingMultiplier * 20L);
                        } else {
                            for (OreDictMaterialStack aMaterial : tData.getAllMaterialStacks()) {
                                if (tMaterial == null || tMaterial.mAmount <= 0L) {
                                    tMaterial = OM.stack(aMaterial.mMaterial.mTargetBurning.mMaterial, UT.Code.units(aMaterial.mAmount, 648648000L, aMaterial.mMaterial.mTargetBurning.mAmount, false));
                                    continue;
                                }
                                if (tMaterial.mMaterial != aMaterial.mMaterial.mTargetBurning.mMaterial) continue;
                                tMaterial.mAmount += UT.Code.units(aMaterial.mAmount, 648648000L, aMaterial.mMaterial.mTargetBurning.mAmount, false);
                            }
                        }
                    }
                    if (tMaterial == null || tMaterial.mAmount <= 0L) {
                        rRecipe = new Recipe(false, false, true, ST.array(ST.amount(1L, aInputs[0])), null, null, null, null, null, tFuelValue * (long)CS.EU_PER_FURNACE_TICK, -1L, 0L);
                    } else {
                        for (int i = 1; i < 64; ++i) {
                            ItemStack tAshes = OM.dust(tMaterial.mMaterial, tMaterial.mAmount * (long)i);
                            if (!ST.valid(tAshes)) continue;
                            rRecipe = new Recipe(false, false, true, ST.array(ST.amount(i, aInputs[0])), ST.array(tAshes), null, null, null, null, tFuelValue * (long)i * (long)CS.EU_PER_FURNACE_TICK, -1L, 0L);
                            break;
                        }
                    }
                } else {
                    rRecipe = new Recipe(false, false, true, ST.array(ST.amount(1L, aInputs[0])), ST.array(tContainer), null, null, null, null, tFuelValue * (long)CS.EU_PER_FURNACE_TICK, -1L, 0L);
                }
                boolean bl = rRecipe.mCanBeBuffered = aInputs[0].getTagCompound() == null;
                if (rRecipe.mCanBeBuffered) {
                    this.addRecipe(rRecipe, false, false, true);
                }
            }
        }
        return rRecipe;
    }

    @Override
    public boolean containsInput(ItemStack aStack, IHasWorldAndCoords aTileEntity, ItemStack aSpecialSlot) {
        return null != this.findRecipe(null, null, true, Long.MAX_VALUE, null, CS.ZL_FS, aStack);
    }
}

