/*
 * Decompiled with CFR 0.152.
 */
package gregapi.random;

import gregapi.data.CS;
import gregapi.util.UT;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;

public class ExplosionGT
extends Explosion {
    private World mWorld;
    private Map field_77288_k = new HashMap();

    public static ExplosionGT explode(World aWorld, Entity aEntity, double aX, double aY, double aZ, float aPower, boolean aFlaming, boolean aSmoking) {
        ExplosionGT tExplosion = new ExplosionGT(aWorld, aEntity, aX, aY, aZ, aPower);
        tExplosion.isFlaming = aFlaming;
        tExplosion.isSmoking = aSmoking;
        if (ForgeEventFactory.onExplosionStart((World)aWorld, (Explosion)tExplosion)) {
            return tExplosion;
        }
        tExplosion.doExplosionA();
        if (aWorld instanceof WorldServer) {
            tExplosion.doExplosionB(false);
            if (!aSmoking) {
                tExplosion.affectedBlockPositions.clear();
            }
            for (EntityPlayer tPlayer : aWorld.playerEntities) {
                if (!(tPlayer.getDistanceSq(aX, aY, aZ) < 4096.0)) continue;
                ((EntityPlayerMP)tPlayer).playerNetServerHandler.sendPacket((Packet)new S27PacketExplosion(aX, aY, aZ, aPower, tExplosion.affectedBlockPositions, (Vec3)tExplosion.func_77277_b().get(tPlayer)));
            }
        } else {
            tExplosion.doExplosionB(true);
        }
        return tExplosion;
    }

    public ExplosionGT(World aWorld, Entity aEntity, double aX, double aY, double aZ, float aPower) {
        super(aWorld, aEntity, aX, aY, aZ, aPower);
        this.mWorld = aWorld;
    }

    public void doExplosionA() {
        float tSize = this.explosionSize;
        HashSet<ChunkPosition> tPositions = new HashSet<ChunkPosition>();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    double tIncX = (float)i / 7.5f - 1.0f;
                    double tIncY = (float)j / 7.5f - 1.0f;
                    double tIncZ = (float)k / 7.5f - 1.0f;
                    double tDist = Math.sqrt(tIncX * tIncX + tIncY * tIncY + tIncZ * tIncZ);
                    tIncX /= tDist;
                    tIncY /= tDist;
                    tIncZ /= tDist;
                    double tX = this.explosionX;
                    double tY = this.explosionY;
                    double tZ = this.explosionZ;
                    float tMul = 0.3f;
                    for (float tPow = tSize * (0.7f + this.mWorld.rand.nextFloat() * 0.6f); tPow > 0.0f; tPow -= tMul * 0.75f) {
                        int tFloorZ;
                        int tFloorY;
                        int tFloorX = UT.Code.roundDown(tX);
                        Block tBlock = this.mWorld.getBlock(tFloorX, tFloorY = UT.Code.roundDown(tY), tFloorZ = UT.Code.roundDown(tZ));
                        if (tBlock.getMaterial() != Material.air) {
                            float f3 = this.exploder != null ? this.exploder.func_145772_a((Explosion)this, this.mWorld, tFloorX, tFloorY, tFloorZ, tBlock) : tBlock.getExplosionResistance(this.exploder, this.mWorld, tFloorX, tFloorY, tFloorZ, this.explosionX, this.explosionY, this.explosionZ);
                            tPow -= (f3 + 0.3f) * tMul;
                        }
                        if (tPow > 0.0f && (this.exploder == null || this.exploder.func_145774_a((Explosion)this, this.mWorld, tFloorX, tFloorY, tFloorZ, tBlock, tPow))) {
                            tPositions.add(new ChunkPosition(tFloorX, tFloorY, tFloorZ));
                        }
                        tX += tIncX * (double)tMul;
                        tY += tIncY * (double)tMul;
                        tZ += tIncZ * (double)tMul;
                    }
                }
            }
        }
        this.affectedBlockPositions.addAll(tPositions);
        List tEntities = this.mWorld.getEntitiesWithinAABBExcludingEntity(this.exploder, AxisAlignedBB.getBoundingBox((double)UT.Code.roundDown(this.explosionX - (double)(tSize *= 2.0f) - 1.0), (double)UT.Code.roundDown(this.explosionY - (double)tSize - 1.0), (double)UT.Code.roundDown(this.explosionZ - (double)tSize - 1.0), (double)UT.Code.roundDown(this.explosionX + (double)tSize + 1.0), (double)UT.Code.roundDown(this.explosionY + (double)tSize + 1.0), (double)UT.Code.roundDown(this.explosionZ + (double)tSize + 1.0)));
        ForgeEventFactory.onExplosionDetonate((World)this.mWorld, (Explosion)this, (List)tEntities, (double)tSize);
        Vec3 tVec3 = Vec3.createVectorHelper((double)this.explosionX, (double)this.explosionY, (double)this.explosionZ);
        for (int i1 = 0; i1 < tEntities.size(); ++i1) {
            double tKnockZ;
            double tKnockY;
            double tKnockX;
            double tDist;
            Entity tEntity = (Entity)tEntities.get(i1);
            double tEntityDist = tEntity.getDistance(this.explosionX, this.explosionY, this.explosionZ) / (double)tSize;
            if (!(tEntityDist <= 1.0) || tEntity instanceof EntityWither || tEntity instanceof EntityDragon || tEntity instanceof EntityDragonPart || tEntity.getClass().getName().toLowerCase().contains("boss") || !((tDist = (double)MathHelper.sqrt_double((double)((tKnockX = tEntity.posX - this.explosionX) * tKnockX + (tKnockY = tEntity.posY + (double)tEntity.getEyeHeight() - this.explosionY) * tKnockY + (tKnockZ = tEntity.posZ - this.explosionZ) * tKnockZ))) > 0.0)) continue;
            tKnockX /= tDist;
            tKnockY /= tDist;
            tKnockZ /= tDist;
            double tKnockback = (1.0 - tEntityDist) * (double)this.mWorld.getBlockDensity(tVec3, tEntity.boundingBox);
            tEntity.attackEntityFrom(DamageSource.setExplosionSource((Explosion)this), (float)((int)((tKnockback * tKnockback + tKnockback) * 4.0 * (double)tSize + 1.0) * CS.TFC_DAMAGE_MULTIPLIER));
            double tBlastProtection = EnchantmentProtection.func_92092_a((Entity)tEntity, (double)tKnockback);
            tEntity.motionX += tKnockX * tBlastProtection;
            tEntity.motionY += tKnockY * tBlastProtection;
            tEntity.motionZ += tKnockZ * tBlastProtection;
            if (!(tEntity instanceof EntityPlayer)) continue;
            this.field_77288_k.put(tEntity, Vec3.createVectorHelper((double)(tKnockX * tKnockback), (double)(tKnockY * tKnockback), (double)(tKnockZ * tKnockback)));
        }
    }

    public void doExplosionB(boolean aEffects) {
        Block tBlock;
        this.mWorld.playSoundEffect(this.explosionX, this.explosionY, this.explosionZ, "random.explode", 4.0f, (1.0f + (this.mWorld.rand.nextFloat() - this.mWorld.rand.nextFloat()) * 0.2f) * 0.7f);
        this.mWorld.spawnParticle(this.explosionSize >= 2.0f && this.isSmoking ? "hugeexplosion" : "largeexplode", this.explosionX, this.explosionY, this.explosionZ, 1.0, 0.0, 0.0);
        if (this.isSmoking) {
            for (ChunkPosition tPos : this.affectedBlockPositions) {
                tBlock = this.mWorld.getBlock(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ);
                if (aEffects) {
                    double d0 = (float)tPos.chunkPosX + this.mWorld.rand.nextFloat();
                    double d1 = (float)tPos.chunkPosY + this.mWorld.rand.nextFloat();
                    double d2 = (float)tPos.chunkPosZ + this.mWorld.rand.nextFloat();
                    double d3 = d0 - this.explosionX;
                    double d4 = d1 - this.explosionY;
                    double d5 = d2 - this.explosionZ;
                    double d6 = MathHelper.sqrt_double((double)(d3 * d3 + d4 * d4 + d5 * d5));
                    d3 /= d6;
                    d4 /= d6;
                    d5 /= d6;
                    double d7 = 0.5 / (d6 / (double)this.explosionSize + 0.1);
                    this.mWorld.spawnParticle("explode", (d0 + this.explosionX) / 2.0, (d1 + this.explosionY) / 2.0, (d2 + this.explosionZ) / 2.0, d3 *= (d7 *= (double)(this.mWorld.rand.nextFloat() * this.mWorld.rand.nextFloat() + 0.3f)), d4 *= d7, d5 *= d7);
                    this.mWorld.spawnParticle("smoke", d0, d1, d2, d3, d4, d5);
                }
                if (tBlock.getMaterial() == Material.air) continue;
                if (tBlock.canDropFromExplosion((Explosion)this)) {
                    tBlock.dropBlockAsItemWithChance(this.mWorld, tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ, this.mWorld.getBlockMetadata(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ), 1.0f / this.explosionSize, 0);
                }
                tBlock.onBlockExploded(this.mWorld, tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ, (Explosion)this);
            }
        }
        if (this.isFlaming) {
            for (ChunkPosition tPos : this.affectedBlockPositions) {
                tBlock = this.mWorld.getBlock(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ);
                Block tAbove = this.mWorld.getBlock(tPos.chunkPosX, tPos.chunkPosY - 1, tPos.chunkPosZ);
                if (tBlock.getMaterial() != Material.air || !tAbove.func_149730_j() || CS.RNGSUS.nextInt(3) != 0) continue;
                this.mWorld.setBlock(tPos.chunkPosX, tPos.chunkPosY, tPos.chunkPosZ, (Block)Blocks.fire);
            }
        }
    }

    public Map func_77277_b() {
        return this.field_77288_k;
    }

    public EntityLivingBase getExplosivePlacedBy() {
        return this.exploder == null ? null : (this.exploder instanceof EntityTNTPrimed ? ((EntityTNTPrimed)this.exploder).getTntPlacedBy() : (this.exploder instanceof EntityLivingBase ? (EntityLivingBase)this.exploder : null));
    }
}

