/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.tools;

import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.data.MT;
import gregapi.data.OP;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.tools.IToolStats;
import gregapi.old.Textures;
import gregapi.oredict.OreDictMaterial;
import gregapi.render.IIconContainer;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;

public abstract class ToolStats
implements IToolStats {
    public static final Enchantment[] FORTUNE_ENCHANTMENT = new Enchantment[]{Enchantment.fortune};
    public static final Enchantment[] LOOTING_ENCHANTMENT = new Enchantment[]{Enchantment.looting};
    private long mMaterialAmount = 0L;

    @Override
    public int getToolDamagePerBlockBreak() {
        return 100;
    }

    @Override
    public int getToolDamagePerDropConversion() {
        return 100;
    }

    @Override
    public int getToolDamagePerContainerCraft() {
        return 100;
    }

    @Override
    public int getToolDamagePerEntityAttack() {
        return 100;
    }

    @Override
    public int getBaseQuality() {
        return 0;
    }

    @Override
    public int getHurtResistanceTime(int aOriginalHurtResistance, Entity aEntity) {
        return aOriginalHurtResistance;
    }

    @Override
    public float getBaseDamage() {
        return 1.0f;
    }

    @Override
    public float getSpeedMultiplier() {
        return 1.0f;
    }

    @Override
    public float getMaxDurabilityMultiplier() {
        return 1.0f;
    }

    @Override
    public float getExhaustionPerAttack(Entity aEntity) {
        return 0.3f;
    }

    @Override
    public String getMiningSound() {
        return null;
    }

    @Override
    public String getCraftingSound() {
        return null;
    }

    @Override
    public String getEntityHitSound() {
        return null;
    }

    @Override
    public String getBreakingSound() {
        return "random.break";
    }

    @Override
    public boolean canCollect() {
        return false;
    }

    @Override
    public boolean canBlock() {
        return false;
    }

    @Override
    public boolean canPenetrate() {
        return false;
    }

    @Override
    public boolean canBehead() {
        return false;
    }

    @Override
    public boolean isWrench() {
        return false;
    }

    @Override
    public boolean isCrowbar() {
        return false;
    }

    @Override
    public boolean isGrafter() {
        return false;
    }

    @Override
    public boolean isWeapon() {
        return false;
    }

    @Override
    public boolean isRangedWeapon() {
        return false;
    }

    @Override
    public boolean isMiningTool() {
        return true;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData) {
        return this.isMinableBlock(aBlock, aMetaData) ? 1.0f : 0.0f;
    }

    @Override
    public float getMiningSpeed(Block aBlock, byte aMetaData, float aDefault, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ) {
        return aDefault;
    }

    @Override
    public DamageSource getDamageSource(EntityLivingBase aPlayer, Entity aEntity) {
        return DamageSources.getCombatDamage(aPlayer instanceof EntityPlayer ? "player" : "mob", aPlayer, aEntity instanceof EntityLivingBase ? this.getDeathMessage(aPlayer, (EntityLivingBase)aEntity, aPlayer == null ? "Someone" : UT.Code.stringValidate(aPlayer.getCommandSenderName(), "Someone"), UT.Code.stringValidate(aEntity.getCommandSenderName(), "Someone")) : null, this.canBehead());
    }

    public IChatComponent getDeathMessage(EntityLivingBase aPlayer, EntityLivingBase aEntity, String aNamePlayer, String aNameEntity) {
        return DamageSources.getDeathMessage(aPlayer, (Entity)aEntity, aNamePlayer, aNameEntity, this.getDeathMessage());
    }

    public String getDeathMessage() {
        return "Why is there no custom Death Message for this Tool?";
    }

    @Override
    public int convertBlockDrops(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        return 0;
    }

    public boolean harvestGrass(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        if (aBlock == Blocks.tallgrass) {
            switch (aMetaData) {
                case 1: 
                case 2: {
                    aDrops.add(IL.Grass.get(1 + CS.RNGSUS.nextInt(1 + aFortune), new Object[0]));
                    return true;
                }
            }
            return false;
        }
        if (aBlock == Blocks.double_plant) {
            switch (aMetaData & 7) {
                case 2: 
                case 3: {
                    aDrops.add(IL.Grass.get(2 + CS.RNGSUS.nextInt(1 + aFortune) + CS.RNGSUS.nextInt(1 + aFortune), new Object[0]));
                    return true;
                }
            }
            return false;
        }
        if (IL.TF_Tall_Grass.equal(aBlock)) {
            switch (aMetaData) {
                case 10: {
                    aDrops.add(IL.Grass.get(1 + CS.RNGSUS.nextInt(1 + aFortune), new Object[0]));
                    return true;
                }
            }
            return false;
        }
        if (IL.AETHER_Tall_Grass.equal(aBlock)) {
            aDrops.add(IL.Grass.get(1 + CS.RNGSUS.nextInt(1 + aFortune), new Object[0]));
            return true;
        }
        if (MD.BoP.mLoaded && aBlock == ST.block(MD.BoP, "foliage")) {
            switch (aMetaData) {
                case 1: {
                    if (CS.RNGSUS.nextInt(4) <= aFortune) {
                        aDrops.add(IL.Grass.get(1L, new Object[0]));
                    }
                    return true;
                }
                case 2: {
                    if (CS.RNGSUS.nextInt(2) <= aFortune) {
                        aDrops.add(IL.Grass.get(1L, new Object[0]));
                    }
                    return true;
                }
                case 10: {
                    aDrops.add(IL.Grass.get(1 + CS.RNGSUS.nextInt(1 + aFortune), new Object[0]));
                    return true;
                }
                case 11: {
                    aDrops.add(IL.Grass.get(1 + CS.RNGSUS.nextInt(1 + aFortune), new Object[0]));
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public boolean harvestStick(List<ItemStack> aDrops, ItemStack aStack, EntityPlayer aPlayer, Block aBlock, long aAvailableDurability, int aX, int aY, int aZ, byte aMetaData, int aFortune, boolean aSilkTouch, BlockEvent.HarvestDropsEvent aEvent) {
        if (aBlock == Blocks.tallgrass) {
            switch (aMetaData) {
                case 0: {
                    aDrops.add(OP.stick.mat(MT.WOODS.Dead, (long)(1 + CS.RNGSUS.nextInt(2 + aFortune))));
                    return true;
                }
            }
            return false;
        }
        if (IL.TF_Tall_Grass.equal(aBlock)) {
            switch (aMetaData) {
                case 11: {
                    aDrops.add(IL.Stick.get(1 + CS.RNGSUS.nextInt(2 + aFortune), new Object[0]));
                    return true;
                }
            }
            return false;
        }
        if (aBlock == Blocks.deadbush) {
            aDrops.add(OP.stick.mat(MT.WOODS.Dead, (long)(1 + CS.RNGSUS.nextInt(2 + aFortune))));
            return true;
        }
        if (MD.BoP.mLoaded && aBlock == ST.block(MD.BoP, "foliage")) {
            switch (aMetaData) {
                case 4: {
                    aDrops.add(IL.Stick.get(1 + CS.RNGSUS.nextInt(2 + aFortune), new Object[0]));
                    return true;
                }
                case 8: {
                    aDrops.add(IL.Stick.get(1 + CS.RNGSUS.nextInt(2 + aFortune), new Object[0]));
                    return true;
                }
                case 9: {
                    aDrops.add(IL.Stick.get(1 + CS.RNGSUS.nextInt(2 + aFortune), new Object[0]));
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public ToolStats setMaterialAmount(long aMaterialAmount) {
        this.mMaterialAmount = aMaterialAmount;
        return this;
    }

    @Override
    public ItemStack getBrokenItem(ItemStack aStack) {
        return this.mMaterialAmount < 162162000L ? null : OP.scrapGt.mat(MultiItemTool.getPrimaryMaterial(aStack), (long)(1 + CS.RNGSUS.nextInt(1 + (int)(4L * this.mMaterialAmount / 648648000L))));
    }

    @Override
    public Enchantment[] getEnchantments(ItemStack aStack, OreDictMaterial aMaterial) {
        return CS.ZL_ENCHANTMENT;
    }

    @Override
    public int[] getEnchantmentLevels(ItemStack aStack, OreDictMaterial aMaterial) {
        return this.getEnchantmentLevels(aStack);
    }

    @Deprecated
    public int[] getEnchantmentLevels(ItemStack aStack) {
        return CS.ZL_INTEGER;
    }

    @Override
    public void onToolCrafted(ItemStack aStack, EntityPlayer aPlayer) {
        aPlayer.triggerAchievement((StatBase)AchievementList.openInventory);
        aPlayer.triggerAchievement((StatBase)AchievementList.mineWood);
        aPlayer.triggerAchievement((StatBase)AchievementList.buildWorkBench);
    }

    @Override
    public void onStatsAddedToTool(MultiItemTool aItem, int aID) {
    }

    @Override
    public float getNormalDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        return aOriginalDamage;
    }

    @Override
    public float getMagicDamageAgainstEntity(float aOriginalDamage, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        return aOriginalDamage;
    }

    @Override
    public void afterDealingDamage(float aNormalDamage, float aMagicDamage, int aFireAspect, boolean aCriticalHit, Entity aEntity, ItemStack aStack, EntityPlayer aPlayer) {
        int tKnockback;
        if (aEntity instanceof EntityLivingBase && aFireAspect > 0) {
            aEntity.setFire(aFireAspect * 4);
        }
        if ((tKnockback = (aPlayer.isSprinting() ? 1 : 0) + (aEntity instanceof EntityLivingBase ? EnchantmentHelper.getKnockbackModifier((EntityLivingBase)aPlayer, (EntityLivingBase)((EntityLivingBase)aEntity)) : 0)) > 0) {
            aEntity.addVelocity((double)(-MathHelper.sin((float)((float)((double)aPlayer.rotationYaw * Math.PI / 180.0))) * (float)tKnockback) * 0.5, 0.1, (double)(MathHelper.cos((float)((float)((double)aPlayer.rotationYaw * Math.PI / 180.0))) * (float)tKnockback) * 0.5);
            aPlayer.motionX *= 0.6;
            aPlayer.motionZ *= 0.6;
            aPlayer.setSprinting(false);
        }
        if (aCriticalHit) {
            aPlayer.onCriticalHit(aEntity);
        }
        if (aMagicDamage > 0.0f) {
            aPlayer.onEnchantmentCritical(aEntity);
        }
        if (aNormalDamage + aMagicDamage >= 18.0f) {
            aPlayer.triggerAchievement((StatBase)AchievementList.overkill);
        }
        aPlayer.setLastAttacker(aEntity);
        if (aEntity instanceof EntityLivingBase) {
            UT.Enchantments.applyBullshitA((EntityLivingBase)aEntity, (Entity)aPlayer, aStack);
        }
        UT.Enchantments.applyBullshitB((EntityLivingBase)aPlayer, aEntity, aStack);
        if (aEntity instanceof EntityLivingBase) {
            aPlayer.addStat(StatList.damageDealtStat, Math.round((aNormalDamage + aMagicDamage) * 10.0f));
        }
        aEntity.hurtResistantTime = Math.max(1, this.getHurtResistanceTime(aEntity.hurtResistantTime, aEntity));
        UT.Entities.exhaust(aPlayer, this.getExhaustionPerAttack(aEntity));
    }

    @Override
    public void afterBreaking(ItemStack aStack, EntityPlayer aPlayer) {
        UT.Entities.applyPotion((Entity)aPlayer, Potion.weakness, 300, 2, false);
        UT.Entities.applyPotion((Entity)aPlayer, Potion.digSlowdown, 1200, 2, false);
    }

    public IIconContainer getIcon(boolean aIsToolHead, ItemStack aStack) {
        return Textures.ItemIcons.VOID;
    }

    public short[] getRGBa(boolean aIsToolHead, ItemStack aStack) {
        return null;
    }

    @Override
    public int getRenderPasses() {
        return 4;
    }

    @Override
    public IIcon getIcon(ItemStack aStack, int aRenderPass) {
        switch (aRenderPass) {
            case 0: {
                return this.getIcon(false, aStack).getIcon(0);
            }
            case 1: {
                return this.getIcon(false, aStack).getIcon(1);
            }
            case 2: {
                return this.getIcon(true, aStack).getIcon(0);
            }
            case 3: {
                return this.getIcon(true, aStack).getIcon(1);
            }
        }
        return null;
    }

    @Override
    public short[] getRGBa(ItemStack aStack, int aRenderPass) {
        switch (aRenderPass) {
            case 0: {
                return this.getRGBa(false, aStack);
            }
            case 1: {
                return CS.UNCOLOURED;
            }
            case 2: {
                return this.getRGBa(true, aStack);
            }
            case 3: {
                return CS.UNCOLOURED;
            }
        }
        return CS.UNCOLOURED;
    }
}

