/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.food;

import gregapi.damage.DamageSources;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.data.MD;
import gregapi.item.multiitem.food.IFoodStat;
import gregapi.player.EntityFoodTracker;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class FoodStat
implements IFoodStat {
    private final int mFoodLevel;
    private final int mAlcohol;
    private final int mCaffeine;
    private final int mDehydration;
    private final int mSugar;
    private final int mFat;
    private final int mRadiation;
    private final int[] mPotionEffects;
    private final float mSaturation;
    private final float mHydration;
    private final float mTemperature;
    private final float mTemperatureEffect;
    private final EnumAction mAction;
    private final ItemStack mEmptyContainer;
    private final boolean mAlwaysEdible;
    private final boolean mInvisibleParticles;
    private final boolean mIsRotten;
    public boolean mExplosive = false;
    public boolean mMilk = false;
    public boolean mExtinguish = false;
    public boolean mUseAPC = true;
    public boolean mAutoDetectEmpty = false;
    public int mRebreathe = 0;

    public FoodStat(int aFoodLevel, float aSaturation, float aHydration, float aTemperature, float aTemperatureEffect, int aAlcohol, int aCaffeine, int aDehydration, int aSugar, int aFat, int aRadiation, EnumAction aAction, ItemStack aEmptyContainer, boolean aAlwaysEdible, boolean aInvisibleParticles, boolean aIsRotten, boolean aAutoDetectEmpty, int ... aPotionEffects) {
        this.mFoodLevel = aFoodLevel;
        this.mSaturation = aSaturation;
        this.mHydration = aHydration;
        this.mTemperature = aTemperature;
        this.mTemperatureEffect = aTemperatureEffect;
        this.mAlcohol = aAlcohol;
        this.mCaffeine = aCaffeine;
        this.mDehydration = aDehydration;
        this.mSugar = aSugar;
        this.mFat = aFat;
        this.mRadiation = aRadiation;
        this.mAction = aAction == null ? EnumAction.eat : aAction;
        this.mPotionEffects = aPotionEffects;
        this.mEmptyContainer = ST.copy(aEmptyContainer);
        this.mInvisibleParticles = aInvisibleParticles;
        this.mAlwaysEdible = aAlwaysEdible;
        this.mAutoDetectEmpty = aAutoDetectEmpty;
        this.mIsRotten = aIsRotten;
    }

    public FoodStat(int aFoodLevel, float aSaturation, float aHydration, float aTemperature, float aTemperatureEffect, int aAlcohol, int aCaffeine, int aDehydration, int aSugar, int aFat, EnumAction aAction, ItemStack aEmptyContainer, boolean aAlwaysEdible, boolean aInvisibleParticles, boolean aIsRotten, boolean aAutoDetectEmpty, int ... aPotionEffects) {
        this(aFoodLevel, aSaturation, aHydration, aTemperature, aTemperatureEffect, aAlcohol, aCaffeine, aDehydration, aSugar, aFat, 0, aAction, aEmptyContainer, aAlwaysEdible, aInvisibleParticles, aIsRotten, aAutoDetectEmpty, aPotionEffects);
    }

    public FoodStat(int aFoodLevel, float aSaturation, float aHydration, float aTemperature, float aTemperatureEffect, EnumAction aAction, ItemStack aEmptyContainer, boolean aAlwaysEdible, boolean aInvisibleParticles, boolean aIsRotten, boolean aAutoDetectEmpty, int ... aPotionEffects) {
        this(aFoodLevel, aSaturation, aHydration, aTemperature, aTemperatureEffect, 0, 0, 0, 0, 0, 0, aAction, aEmptyContainer, aAlwaysEdible, aInvisibleParticles, aIsRotten, aAutoDetectEmpty, aPotionEffects);
    }

    public FoodStat setExplosive() {
        this.mExplosive = true;
        return this;
    }

    public FoodStat setExtinguish() {
        this.mExtinguish = true;
        return this;
    }

    public FoodStat setRebreathe(int aRebreathe) {
        this.mRebreathe = aRebreathe;
        return this;
    }

    public FoodStat setMilk() {
        this.mMilk = true;
        return this;
    }

    @Override
    public int getFoodLevel(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mFoodLevel;
    }

    @Override
    public float getSaturation(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mSaturation;
    }

    @Override
    public float getHydration(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mHydration;
    }

    @Override
    public float getTemperature(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mTemperature;
    }

    @Override
    public float getTemperatureEffect(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mTemperatureEffect;
    }

    @Override
    public void onEaten(Item aItem, ItemStack aStack, EntityPlayer aPlayer, boolean aConsumeItem) {
        this.onEaten(aItem, aStack, aPlayer, aConsumeItem, true);
    }

    @Override
    public void onEaten(Item aItem, ItemStack aStack, EntityPlayer aPlayer, boolean aConsumeItem, boolean aMakeSound) {
        if (aConsumeItem && !UT.Entities.hasInfiniteItems(aPlayer)) {
            --aStack.stackSize;
            ItemStack tStack = OM.get(ST.copy(this.mEmptyContainer));
            if (tStack == null && this.mAutoDetectEmpty) {
                tStack = ST.container(aStack, false);
            }
            ST.give((Entity)aPlayer, tStack, false);
        }
        if (aMakeSound) {
            aPlayer.worldObj.playSoundAtEntity((Entity)aPlayer, "random.burp", 0.5f, CS.RNGSUS.nextFloat() * 0.1f + 0.9f);
        }
        if (!aPlayer.worldObj.isRemote) {
            EntityFoodTracker tTracker;
            if (this.mExtinguish) {
                aPlayer.extinguish();
            }
            if (this.mRebreathe > 0) {
                aPlayer.setAir(aPlayer.getAir() + this.mRebreathe);
            }
            if (this.mMilk) {
                aPlayer.curePotionEffects(ST.make(Items.milk_bucket, 1L, 0L));
            }
            for (int i = 3; i < this.mPotionEffects.length; i += 4) {
                if (CS.RNGSUS.nextInt(100) >= this.mPotionEffects[i]) continue;
                UT.Entities.applyPotion((Entity)aPlayer, this.mPotionEffects[i - 3], this.mPotionEffects[i - 2], this.mPotionEffects[i - 1], this.mInvisibleParticles);
            }
            if (this.mExplosive) {
                aPlayer.worldObj.newExplosion((Entity)aPlayer, aPlayer.posX, aPlayer.posY, aPlayer.posZ, 4.0f, true, true);
                aPlayer.attackEntityFrom(DamageSources.getExplodingDamage(), Float.MAX_VALUE);
            }
            if ((tTracker = EntityFoodTracker.get((Entity)aPlayer)) != null) {
                if (this.mAlcohol != 0) {
                    tTracker.changeAlcohol(this.mAlcohol);
                }
                if (this.mCaffeine != 0) {
                    tTracker.changeCaffeine(this.mCaffeine);
                }
                if (this.mDehydration != 0) {
                    tTracker.changeDehydration(this.mDehydration);
                }
                if (this.mSugar != 0) {
                    tTracker.changeSugar(this.mSugar);
                }
                if (this.mFat != 0) {
                    tTracker.changeFat(this.mFat);
                }
                if (this.mRadiation != 0) {
                    tTracker.changeRadiation(this.mRadiation);
                }
            }
        }
    }

    @Override
    public EnumAction getFoodAction(Item aItem, ItemStack aStack) {
        return this.mAction;
    }

    @Override
    public boolean alwaysEdible(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mAlwaysEdible;
    }

    @Override
    public boolean isRotten(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return this.mIsRotten;
    }

    @Override
    public boolean useAppleCoreFunctionality(Item aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return MD.APC.mLoaded && this.mUseAPC;
    }

    @Override
    public void addAdditionalToolTips(Item aItem, List<String> aList, ItemStack aStack, boolean aF3_H) {
        String tString;
        if (!this.useAppleCoreFunctionality(aItem, aStack, null) && (this.mFoodLevel > 0 || this.mSaturation > 0.0f)) {
            aList.add(LH.Chat.RED + "Food: " + this.mFoodLevel + " - Saturation: " + this.mSaturation);
        }
        if (UT.Code.stringValid(tString = (this.mTemperature >= 313.0f ? "Hot" + (this.mHydration == 0.0f ? "" : " - ") : (this.mTemperature >= 311.0f ? "Warm" + (this.mHydration == 0.0f ? "" : " - ") : (this.mTemperature <= 307.0f ? "Very Cold" + (this.mHydration == 0.0f ? "" : " - ") : (this.mTemperature <= 309.0f ? "Cold" + (this.mHydration == 0.0f ? "" : " - ") : "")))) + (this.mHydration > 0.0f ? "Hydration: " + this.mHydration : (this.mHydration < 0.0f ? "Dehydration: " + -this.mHydration : ""))) && MD.ENVM.mLoaded) {
            aList.add(LH.Chat.RED + tString);
        }
        if (this.mExplosive) {
            aList.add(LH.Chat.DRED + "smells like explosives");
        }
        if (this.mIsRotten) {
            aList.add(LH.Chat.DRED + "smells rotten");
        }
    }
}

