/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.energy;

import gregapi.code.HashSetNoNulls;
import gregapi.code.TagData;
import gregapi.data.CS;
import gregapi.data.TD;
import gregapi.item.IItemEnergy;
import gregapi.util.ST;
import gregapi.util.UT;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EnergyStat
implements IItemEnergy {
    public long mSize;
    public long mAmountIN;
    public long mAmountOUT;
    public long mCapacity;
    public boolean mCanCharge;
    public boolean mCanDecharge;
    public TagData mType;
    public ItemStack mEmptyItem;
    public ItemStack mHalfItem;
    public ItemStack mFullItem;

    public EnergyStat(TagData aEnergyType, long aCapacity, long aSize, long aAmountIN, long aAmountOUT, boolean aCanCharge, boolean aCanDecharge, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        this.mSize = aSize;
        this.mAmountIN = Math.max(1L, aAmountIN);
        this.mAmountOUT = Math.max(1L, aAmountOUT);
        this.mCapacity = aCapacity;
        this.mType = aEnergyType;
        this.mCanCharge = aCanCharge;
        this.mCanDecharge = aCanDecharge;
        this.mEmptyItem = aEmptyItem;
        this.mHalfItem = aHalfItem;
        this.mFullItem = aFullItem;
    }

    public static IItemEnergy makeREBattery(TagData aEnergyType, long aCapacity, long aSize, long aAmountIN, long aAmountOUT, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmountIN, aAmountOUT, true, true, aEmptyItem, aHalfItem, aFullItem);
    }

    public static IItemEnergy makeREBattery(TagData aEnergyType, long aCapacity, long aSize, long aAmountIN, long aAmountOUT, ItemStack aItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmountIN, aAmountOUT, true, true, aItem, aItem, aItem);
    }

    public static IItemEnergy makeREBattery(TagData aEnergyType, long aCapacity, long aSize, long aAmount, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmount, aAmount, true, true, aEmptyItem, aHalfItem, aFullItem);
    }

    public static IItemEnergy makeREBattery(TagData aEnergyType, long aCapacity, long aSize, long aAmount, ItemStack aItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmount, aAmount, true, true, aItem, aItem, aItem);
    }

    public static IItemEnergy makeSUBattery(TagData aEnergyType, long aCapacity, long aSize, long aAmount, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmount, aAmount, false, true, aEmptyItem, aHalfItem, aFullItem);
    }

    public static IItemEnergy makeSUBattery(TagData aEnergyType, long aCapacity, long aSize, long aAmount, ItemStack aItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmount, aAmount, false, true, aItem, aItem, aItem);
    }

    public static IItemEnergy makeTool(TagData aEnergyType, long aCapacity, long aSize, long aAmount, ItemStack aEmptyItem, ItemStack aHalfItem, ItemStack aFullItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmount, aAmount, true, false, aEmptyItem, aHalfItem, aFullItem);
    }

    public static IItemEnergy makeTool(TagData aEnergyType, long aCapacity, long aSize, long aAmount, ItemStack aItem) {
        return new EnergyStat(aEnergyType, aCapacity, aSize, aAmount, aAmount, true, false, aItem, aItem, aItem);
    }

    @Override
    public long doEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoInject) {
        long rAmount;
        if (aAmount < 1L || this.mAmountIN < 1L) {
            return 0L;
        }
        if (!this.canEnergyInjection(aEnergyType, aStack, aSize = Math.abs(aSize))) {
            return 0L;
        }
        long tStored = this.getEnergyStored(this.mType, aStack);
        if (tStored >= this.mCapacity) {
            return 0L;
        }
        for (rAmount = Math.min(this.mAmountIN, aAmount); rAmount > 1L && tStored + rAmount * aSize > this.mCapacity; --rAmount) {
        }
        if (aDoInject) {
            this.setEnergyStored(this.mType, aStack, tStored + rAmount * aSize);
        }
        return rAmount;
    }

    @Override
    public long doEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize, long aAmount, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoExtract) {
        long rAmount;
        if (aAmount < 1L || this.mAmountOUT < 1L) {
            return 0L;
        }
        if (!this.canEnergyExtraction(aEnergyType, aStack, aSize = Math.abs(aSize))) {
            return 0L;
        }
        long tStored = this.getEnergyStored(this.mType, aStack);
        if (tStored < aSize) {
            return 0L;
        }
        for (rAmount = Math.min(this.mAmountOUT, aAmount); rAmount > 1L && tStored - rAmount * aSize < 0L; --rAmount) {
        }
        if (aDoExtract) {
            this.setEnergyStored(this.mType, aStack, tStored - rAmount * aSize);
        }
        return rAmount;
    }

    public ItemStack rechargeFromPlayer(TagData aEnergyType, ItemStack aStack, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ) {
        if (CS.COMPAT_EU_ITEM == null || !this.mCanCharge || aPlayer == null || aPlayer.worldObj.isRemote || aEnergyType != this.mType || aEnergyType != TD.Energy.EU) {
            return aStack;
        }
        long tMinInput = this.getEnergySizeInputMin(aEnergyType, aStack);
        long tCapacity = this.getEnergyCapacity(aEnergyType, aStack);
        boolean temp = false;
        try {
            for (int i = 1; i < 5; ++i) {
                long tContent = this.getEnergyStored(aEnergyType, aStack);
                if (tContent >= tCapacity) {
                    return aStack;
                }
                ItemStack tArmor = aPlayer.getEquipmentInSlot(i);
                if (tArmor == aStack || ST.invalid(tArmor) || !CS.COMPAT_EU_ITEM.is(tArmor) || CS.VMAX[CS.COMPAT_EU_ITEM.tier(tArmor)] < tMinInput || !CS.COMPAT_EU_ITEM.provider(tArmor)) continue;
                this.setEnergyStored(aEnergyType, aStack, tContent + CS.COMPAT_EU_ITEM.decharge(tArmor, tCapacity - tContent, true));
                temp = true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace(CS.ERR);
        }
        if (temp) {
            ST.update((Entity)aPlayer);
        }
        return aStack;
    }

    @Override
    public boolean useEnergy(TagData aEnergyType, ItemStack aStack, long aEnergyAmount, EntityLivingBase aPlayer, IInventory aInventory, World aWorld, int aX, int aY, int aZ, boolean aDoUse) {
        if (aPlayer instanceof EntityPlayer && ((EntityPlayer)aPlayer).capabilities.isCreativeMode) {
            return true;
        }
        if (aEnergyType != this.mType && aEnergyType != null) {
            return false;
        }
        this.rechargeFromPlayer(this.mType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
        long tStored = this.getEnergyStored(this.mType, aStack);
        if (tStored >= aEnergyAmount) {
            if (aDoUse) {
                this.setEnergyStored(this.mType, aStack, tStored - aEnergyAmount);
                this.rechargeFromPlayer(this.mType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
            }
            return true;
        }
        if (aDoUse) {
            this.setEnergyStored(this.mType, aStack, 0L);
            this.rechargeFromPlayer(this.mType, aStack, aPlayer, aInventory, aWorld, aX, aY, aZ);
        }
        return false;
    }

    @Override
    public ItemStack setEnergyStored(TagData aEnergyType, ItemStack aStack, long aAmount) {
        if (aEnergyType != this.mType && aEnergyType != null || ST.size(aStack) <= 0) {
            return aStack;
        }
        NBTTagCompound tNBT = aStack.getTagCompound();
        if (tNBT == null) {
            tNBT = UT.NBT.make();
        } else {
            tNBT.removeTag("gt.energy");
        }
        if (aAmount > 0L) {
            if (aAmount >= this.mCapacity) {
                if (this.mFullItem != null) {
                    ST.set(aStack, this.mFullItem, false, false);
                }
            } else if (this.mHalfItem != null) {
                ST.set(aStack, this.mHalfItem, false, false);
            }
            UT.NBT.setNumber(tNBT, "gt.energy", aAmount);
        } else if (this.mEmptyItem == null) {
            --aStack.stackSize;
        } else {
            ST.set(aStack, this.mEmptyItem, false, false);
        }
        UT.NBT.set(aStack, tNBT);
        return ST.update_(aStack);
    }

    @Override
    public long getEnergyStored(TagData aEnergyType, ItemStack aStack) {
        if (aEnergyType != this.mType && aEnergyType != null) {
            return 0L;
        }
        NBTTagCompound tNBT = aStack.getTagCompound();
        return tNBT == null ? 0L : tNBT.getLong("gt.energy");
    }

    @Override
    public long getEnergyCapacity(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mCapacity : 0L;
    }

    @Override
    public long getEnergySizeInputMin(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? (this.mSize <= 8L ? 1L : this.mSize / 2L) : 0L;
    }

    @Override
    public long getEnergySizeOutputMin(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? (this.mSize <= 8L ? 1L : this.mSize / 2L) : 0L;
    }

    @Override
    public long getEnergySizeInputRecommended(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSize : 0L;
    }

    @Override
    public long getEnergySizeOutputRecommended(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSize : 0L;
    }

    @Override
    public long getEnergySizeInputMax(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSize * 2L : 0L;
    }

    @Override
    public long getEnergySizeOutputMax(TagData aEnergyType, ItemStack aStack) {
        return aEnergyType == this.mType || aEnergyType == null ? this.mSize * 2L : 0L;
    }

    @Override
    public Collection<TagData> getEnergyTypes(ItemStack aStack) {
        return new HashSetNoNulls<TagData>(false, this.mType);
    }

    @Override
    public boolean isEnergyType(TagData aEnergyType, ItemStack aStack, boolean aEmitting) {
        return (aEnergyType == this.mType || aEnergyType == null) && (aEmitting ? this.mCanDecharge : this.mCanCharge);
    }

    @Override
    public boolean canEnergyInjection(TagData aEnergyType, ItemStack aStack, long aSize) {
        return this.mCanCharge && (aEnergyType == this.mType || aEnergyType == null) && aStack.stackSize == 1 && aSize <= this.getEnergySizeInputMax(aEnergyType, aStack) && aSize >= this.getEnergySizeInputMin(aEnergyType, aStack);
    }

    @Override
    public boolean canEnergyExtraction(TagData aEnergyType, ItemStack aStack, long aSize) {
        return this.mCanDecharge && (aEnergyType == this.mType || aEnergyType == null) && aStack.stackSize == 1 && aSize <= this.getEnergySizeOutputMax(aEnergyType, aStack) && aSize >= this.getEnergySizeOutputMin(aEnergyType, aStack);
    }
}

