/*
 * Decompiled with CFR 0.152.
 */
package gregapi.item.multiitem.behaviors;

import gregapi.data.LH;
import gregapi.item.multiitem.MultiItem;
import gregapi.item.multiitem.MultiItemTool;
import gregapi.item.multiitem.behaviors.IBehavior;
import gregapi.util.UT;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class Behavior_TripwireCutting
extends IBehavior.AbstractBehaviorDefault {
    private final int mCosts;

    public Behavior_TripwireCutting(int aCosts) {
        this.mCosts = aCosts;
    }

    @Override
    public boolean onItemUseFirst(MultiItem aItem, ItemStack aStack, EntityPlayer aPlayer, World aWorld, int aX, int aY, int aZ, byte aSide, float hitX, float hitY, float hitZ) {
        if (aPlayer.worldObj.isRemote) {
            return false;
        }
        if (aWorld.getBlock(aX, aY, aZ) == Blocks.tripwire) {
            if (((MultiItemTool)aItem).doDamage(aStack, this.mCosts, (EntityLivingBase)aPlayer, false)) {
                int aMeta = aWorld.getBlockMetadata(aX, aY, aZ) | 8;
                aWorld.setBlockMetadataWithNotify(aX, aY, aZ, aMeta, 4);
                if (Blocks.tripwire.removedByPlayer(aWorld, aPlayer, aX, aY, aZ, true)) {
                    Blocks.tripwire.onBlockDestroyedByPlayer(aWorld, aX, aY, aZ, aMeta);
                    Blocks.tripwire.harvestBlock(aWorld, aPlayer, aX, aY, aZ, aMeta);
                    UT.Sounds.send("mob.sheep.shear", aWorld, aX, aY, aZ);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public List<String> getAdditionalToolTips(MultiItem aItem, List<String> aList, ItemStack aStack) {
        aList.add(LH.get("gt.behaviour.tripwirecutting"));
        return aList;
    }

    static {
        LH.add("gt.behaviour.tripwirecutting", "Can cut Tripwires by Rightclick");
    }
}

