/*
 * Decompiled with CFR 0.152.
 */
package gregapi.compat.industrialcraft;

import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gregapi.block.IBlockPlacable;
import gregapi.code.ItemStackContainer;
import gregapi.code.ItemStackSet;
import gregapi.compat.CompatBase;
import gregapi.compat.industrialcraft.ICompatIC2;
import gregapi.config.ConfigCategories;
import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.cover.covers.CoverTextureCanvas;
import gregapi.data.CS;
import gregapi.data.IL;
import gregapi.data.MD;
import gregapi.util.OM;
import gregapi.util.ST;
import gregapi.util.UT;
import gregapi.util.WD;
import ic2.api.crops.Crops;
import ic2.api.event.RetextureEvent;
import ic2.api.reactor.IReactorComponent;
import ic2.api.recipe.IRecipeInput;
import ic2.api.recipe.RecipeInputItemStack;
import ic2.api.recipe.RecipeInputOreDict;
import ic2.api.recipe.RecipeOutput;
import ic2.api.recipe.Recipes;
import ic2.api.tile.ExplosionWhitelist;
import ic2.core.IC2;
import ic2.core.Ic2Items;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;

public class CompatIC2
extends CompatBase
implements ICompatIC2 {
    private ItemStackSet<ItemStackContainer> mToBlacklist = ST.hashset(new ItemStack[0]);

    public CompatIC2() {
        this.valuable(Blocks.glowstone, 0, 1);
        this.valuable(Blocks.soul_sand, 0, 1);
        if (Recipes.scrapboxDrops == null) {
            // empty if block
        }
        if (Recipes.recyclerBlacklist == null) {
            // empty if block
        }
        if (Recipes.recyclerWhitelist == null) {
            // empty if block
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public void onPostLoad(FMLPostInitializationEvent aEvent) {
        for (IBlockPlacable tOre : CS.BlocksGT.stoneToSmallOres.values()) {
            this.valuable((Block)tOre, 2);
        }
        for (IBlockPlacable tOre : CS.BlocksGT.stoneToNormalOres.values()) {
            this.valuable((Block)tOre, 3);
        }
        for (IBlockPlacable tOre : CS.BlocksGT.stoneToBrokenOres.values()) {
            this.valuable((Block)tOre, 3);
        }
        if (this.mToBlacklist != null) {
            for (ItemStackContainer tStack : this.mToBlacklist) {
                Recipes.recyclerBlacklist.add((IRecipeInput)this.makeInput(tStack.toStack()));
            }
            this.mToBlacklist.clear();
            this.mToBlacklist = null;
        }
        if (MD.AA.mLoaded) {
            Crops.instance.registerBaseSeed(ST.make(MD.AA, "itemCoffeeBeans", 1L, 32767L), Crops.instance.getCropCard("IC2", "Coffee"), 1, 1, 1, 1);
        }
    }

    @Override
    public void onServerStarted(FMLServerStartedEvent aEvent) {
        if (MD.AA.mLoaded) {
            Ic2Items.coffeeBeans = ST.make(MD.AA, "itemCoffeeBeans", 1L, 0L);
        }
    }

    @SubscribeEvent
    public void onRetextureEvent(RetextureEvent aEvent) {
        CoverData tData;
        TileEntity tTileEntity = WD.te(aEvent.world, aEvent.x, aEvent.y, aEvent.z, true);
        if (tTileEntity instanceof ITileEntityCoverable && (tData = ((ITileEntityCoverable)tTileEntity).getCoverData()) != null && tData.mBehaviours[aEvent.side] instanceof CoverTextureCanvas) {
            if (tData.mNBTs[aEvent.side] == null) {
                tData.mNBTs[aEvent.side] = UT.NBT.make();
            }
            tData.mNBTs[aEvent.side].setInteger("gt.canvas.block", Block.getIdFromBlock((Block)aEvent.referencedBlock));
            tData.mNBTs[aEvent.side].setInteger("gt.canvas.meta", aEvent.referencedMeta);
            tData.mBehaviours[aEvent.side].onCoverPlaced((byte)aEvent.side, tData, null, tData.getCoverItem((byte)aEvent.side));
            aEvent.applied = true;
        }
    }

    @Override
    public boolean valuable(Block aBlock, int aMeta, int aValue) {
        if (aBlock == null || aBlock == CS.NB) {
            return false;
        }
        IC2.addValuableOre((IRecipeInput)((IRecipeInput)this.makeInput(ST.make(aBlock, 1L, (long)UT.Code.bind4(aMeta)))), (int)Math.max(1, aValue));
        return true;
    }

    @Override
    public boolean valuable(Block aBlock, int aValue) {
        if (aBlock == null || aBlock == CS.NB) {
            return false;
        }
        for (int i = 0; i < 16; i = (int)((byte)(i + 1))) {
            this.valuable(aBlock, i, aValue);
        }
        return true;
    }

    @Override
    public ItemStack recycler(ItemStack aInput, int aScrapChance) {
        if (aInput == null || aScrapChance != 0 || Recipes.recyclerBlacklist.contains(aInput)) {
            return null;
        }
        return Recipes.recyclerWhitelist.isEmpty() || Recipes.recyclerWhitelist.contains(aInput) ? IL.IC2_Scrap.get(1L, new Object[0]) : null;
    }

    @Override
    public ItemStack scrapbox(ItemStack aBox) {
        return Recipes.scrapboxDrops.getDrop(aBox, false);
    }

    @Override
    public boolean scrapbox(float aChance, ItemStack aOutput) {
        if (ST.invalid(aOutput) || aChance <= 0.0f) {
            return false;
        }
        aOutput = OM.get_(aOutput);
        aOutput.stackSize = 1;
        if ((aChance = (float)CS.ConfigsGT.RECIPES.get((Object)ConfigCategories.Machines.scrapboxdrops, aOutput, (double)aChance)) <= 0.0f) {
            return false;
        }
        Recipes.scrapboxDrops.addDrop(ST.copy(aOutput), aChance);
        return true;
    }

    @Override
    public boolean blacklist(ItemStack aBlacklisted) {
        if (ST.invalid(aBlacklisted)) {
            return false;
        }
        if (Recipes.recyclerBlacklist == null) {
            this.mToBlacklist.add(aBlacklisted);
        } else {
            Recipes.recyclerBlacklist.add((IRecipeInput)this.makeInput(aBlacklisted));
        }
        return true;
    }

    @Override
    public boolean isExplosionWhitelisted(Block aBlock) {
        return aBlock != null && aBlock != CS.NB && ExplosionWhitelist.isBlockWhitelisted((Block)aBlock);
    }

    @Override
    public void addToExplosionWhitelist(Block aBlock) {
        if (aBlock != null && aBlock != CS.NB) {
            ExplosionWhitelist.addWhitelistedBlock((Block)aBlock);
        }
    }

    @Override
    public Object makeInput(ItemStack aStack) {
        return new RecipeInputItemStack(ST.copy(aStack), aStack.stackSize);
    }

    @Override
    public Object makeInput(String aOreDict, long aAmount) {
        return new RecipeInputOreDict(aOreDict, (int)UT.Code.bindStack(aAmount));
    }

    @Override
    public Object makeOutput(NBTTagCompound aNBT, ItemStack ... aStacks) {
        return new RecipeOutput(aNBT, aStacks);
    }

    @Override
    public boolean isReactorItem(ItemStack aStack) {
        try {
            return ST.valid(aStack) && aStack.getItem() instanceof IReactorComponent;
        }
        catch (Throwable throwable) {
            return false;
        }
    }
}

