/*
 * Decompiled with CFR 0.152.
 */
package gregapi.compat.computercraft;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.lua.ILuaContext;
import dan200.computercraft.api.lua.LuaException;
import dan200.computercraft.api.peripheral.IComputerAccess;
import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.peripheral.IPeripheralProvider;
import gregapi.compat.CompatBase;
import gregapi.compat.computercraft.ICompatCC;
import gregapi.computer.IComputerizable;
import gregapi.computer.ICoverComputerizable;
import gregapi.computer.ITileEntityComputerizable;
import gregapi.cover.CoverData;
import gregapi.cover.ITileEntityCoverable;
import gregapi.data.CS;
import gregapi.tileentity.delegate.DelegatorTileEntity;
import gregapi.util.WD;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class CompatCC
extends CompatBase
implements ICompatCC,
IPeripheralProvider {
    public CompatCC() {
        ComputerCraftAPI.registerPeripheralProvider((IPeripheralProvider)this);
    }

    public IPeripheral getPeripheral(World aWorld, int aX, int aY, int aZ, int aSide) {
        CoverData tData;
        DelegatorTileEntity<TileEntity> aDelegator = WD.te(aWorld, aX, aY, aZ, (byte)aSide, false);
        if (CS.SIDES_VALID[aDelegator.mSideOfTileEntity] && aDelegator.mTileEntity instanceof ITileEntityCoverable && (tData = ((ITileEntityCoverable)aDelegator.mTileEntity).getCoverData()) != null && tData.mBehaviours[aDelegator.mSideOfTileEntity] instanceof ICoverComputerizable) {
            return new ComputerizablePeripheral((ICoverComputerizable)tData.mBehaviours[aDelegator.mSideOfTileEntity], aDelegator);
        }
        return aDelegator.mTileEntity instanceof ITileEntityComputerizable ? new ComputerizablePeripheral((ITileEntityComputerizable)aDelegator.mTileEntity, aDelegator) : null;
    }

    public static class ComputerizablePeripheral
    implements IPeripheral {
        public final IComputerizable mComputerizable;
        public final String mType;
        public final DelegatorTileEntity<TileEntity> mDelegator;

        public ComputerizablePeripheral(IComputerizable aComputerizable, DelegatorTileEntity<TileEntity> aDelegator) {
            this.mComputerizable = aComputerizable;
            this.mDelegator = aDelegator;
            this.mType = aComputerizable.getComputerizableName(this.mDelegator);
        }

        public String getType() {
            return this.mType;
        }

        public String[] getMethodNames() {
            return this.mComputerizable.allComputerizableMethods(this.mDelegator);
        }

        public Object[] callMethod(IComputerAccess aComputer, ILuaContext aContext, int aFunctionIndex, Object[] aArguments) throws LuaException, InterruptedException {
            return this.mComputerizable.callComputerizableMethod(this.mDelegator, aFunctionIndex, aArguments);
        }

        public void attach(IComputerAccess aComputer) {
        }

        public void detach(IComputerAccess aComputer) {
        }

        public boolean equals(IPeripheral aOther) {
            return aOther == this || aOther instanceof ComputerizablePeripheral && ((ComputerizablePeripheral)aOther).mComputerizable == this.mComputerizable && this.mDelegator.equalSideTileEntityAndCoords(((ComputerizablePeripheral)aOther).mDelegator);
        }
    }
}

