/*
 * Decompiled with CFR 0.152.
 */
package gregapi.block.multitileentity.example;

import gregapi.block.multitileentity.IMultiTileEntity;
import gregapi.block.multitileentity.MultiTileEntityContainer;
import gregapi.data.CS;
import gregapi.data.LH;
import gregapi.old.Textures;
import gregapi.render.BlockTextureDefault;
import gregapi.render.BlockTextureMulti;
import gregapi.render.IIconContainer;
import gregapi.render.ITexture;
import gregapi.tileentity.notick.TileEntityBase05Paintable;
import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class MultiTileEntityBunkerBlock
extends TileEntityBase05Paintable
implements IMultiTileEntity.IMTE_GetPlayerRelativeBlockHardness,
IMultiTileEntity.IMTE_AddToolTips,
IMultiTileEntity.IMTE_OnPlaced {
    public static IIconContainer sColored = new Textures.BlockIcons.CustomIcon("bunker/block/colored");
    public static IIconContainer sOverlay = new Textures.BlockIcons.CustomIcon("bunker/block/overlay");

    @Override
    public void readFromNBT2(NBTTagCompound aNBT) {
        super.readFromNBT2(aNBT);
        if (aNBT.hasKey("gt.owner") && !CS.OWNERSHIP_RESET) {
            this.mOwner = UUID.fromString(aNBT.getString("gt.owner"));
        }
    }

    @Override
    public void writeToNBT2(NBTTagCompound aNBT) {
        super.writeToNBT2(aNBT);
        if (this.mOwner != null) {
            aNBT.setString("gt.owner", this.mOwner.toString());
        }
    }

    public void addToolTips(List aList, ItemStack aStack, boolean aF3_H) {
        aList.add(LH.Chat.ORANGE + LH.get("gt.lang.owner.controlled"));
    }

    @Override
    public boolean onPlaced(ItemStack aStack, EntityPlayer aPlayer, MultiTileEntityContainer aMTEContainer, World aWorld, int aX, int aY, int aZ, byte aSide, float aHitX, float aHitY, float aHitZ) {
        if (aPlayer != null && !CS.OWNERSHIP_RESET) {
            this.mOwner = aPlayer.getUniqueID();
        }
        return true;
    }

    @Override
    public ITexture getTexture2(Block aBlock, int aRenderPass, byte aSide, boolean[] aShouldSideBeRendered) {
        return aShouldSideBeRendered[aSide] ? BlockTextureMulti.get(BlockTextureDefault.get(sColored, this.mRGBa), BlockTextureDefault.get(sOverlay)) : null;
    }

    @Override
    public String getTileEntityName() {
        return "gt.multitileentity.bunker.block";
    }
}

